/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.screen;

import com.ximad.bubble_birds_2.audio.SoundSystem;
import com.ximad.bubble_birds_2.engine.Application;
import com.ximad.bubble_birds_2.engine.CustomButton;
import com.ximad.bubble_birds_2.engine.UiScreen;
import com.ximad.bubble_birds_2.res.ImagesResources;
import com.ximad.bubble_birds_2.screen.HomeScreen;
import javax.microedition.lcdui.Graphics;

public class AboutScreen
extends UiScreen {
    private static AboutScreen instance;
    private CustomButton linkButton;
    private CustomButton emailButton;
    private CustomButton backButton;

    public AboutScreen() {
        this.init();
    }

    public void init() {
        int width = 360;
        int height = 640;
        this.linkButton = new CustomButton(ImagesResources.aboutLinkOff, ImagesResources.aboutLinkOn, null, null){

            protected void touchAction() {
                AboutScreen.this.openLink();
            }
        };
        this.emailButton = new CustomButton(ImagesResources.aboutEmailOff, ImagesResources.aboutEmailOn, null, null){

            protected void touchAction() {
                AboutScreen.this.openEmail();
            }
        };
        this.backButton = new CustomButton(ImagesResources.settingsBackOff, ImagesResources.settingsBackOn, null, null){

            protected void touchAction() {
                AboutScreen.this.returnToMenu();
            }
        };
        this.add(this.backButton, 144, 556);
        this.add(this.linkButton, 138, 292);
        this.add(this.emailButton, 132, 480);
    }

    private void openLink() {
        this.playButtonSound();
        try {
            Application.getInstance().platformRequest("http://store.ovi.com/publisher/XIMAD");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void openEmail() {
        this.playButtonSound();
        try {
            Application.getInstance().platformRequest("mailto:support@ximad.com");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void returnToMenu() {
        this.playButtonSound();
        Application.setScreen(HomeScreen.getInstance());
    }

    public void onPaint(Graphics g) {
        ImagesResources.aboutBg.draw(g, 0, 0);
        super.onPaint(g);
    }

    public static AboutScreen getInstance() {
        if (instance == null) {
            instance = new AboutScreen();
        }
        return instance;
    }

    private void playButtonSound() {
        try {
            SoundSystem.SOUND_BUTTON.play();
        }
        catch (Error error) {
            // empty catch block
        }
    }
}

