/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.screen;

import com.ximad.bubble_birds_2.audio.SoundSystem;
import com.ximad.bubble_birds_2.engine.Application;
import com.ximad.bubble_birds_2.engine.CustomButton;
import com.ximad.bubble_birds_2.engine.UiScreen;
import com.ximad.bubble_birds_2.game.DataManager;
import com.ximad.bubble_birds_2.res.ImagesResources;
import com.ximad.bubble_birds_2.screen.GamePopupScreen;
import com.ximad.bubble_birds_2.screen.HomeScreen;
import javax.microedition.lcdui.Graphics;

public class SettingsScreen
extends UiScreen {
    private static SettingsScreen instance;
    private CustomButton soundButton;
    private CustomButton speedButton;
    private CustomButton clearScoreboardButton;
    private CustomButton backButton;

    public SettingsScreen() {
        this.init();
        this.setSettingsState();
    }

    public void init() {
        this.speedButton = new CustomButton(ImagesResources.settingsLowOff, ImagesResources.settingsLowOn, null, null){

            protected void touchAction() {
                SettingsScreen.this.speedButtonAction();
            }
        };
        switch (DataManager.getGameSpeed()) {
            case 1: {
                this.speedButton.setOnImage(ImagesResources.settingsMediumOn);
                this.speedButton.setOffImage(ImagesResources.settingsMediumOff);
                break;
            }
            case 2: {
                this.speedButton.setOnImage(ImagesResources.settingsHighOn);
                this.speedButton.setOffImage(ImagesResources.settingsHighOff);
            }
        }
        this.clearScoreboardButton = new CustomButton(ImagesResources.settingsClearScoreboardOff, ImagesResources.settingsClearScoreboardOn, null, null){

            protected void touchAction() {
                SettingsScreen.this.clearButtonAction();
            }
        };
        this.soundButton = new CustomButton(ImagesResources.settingsYesOff, ImagesResources.settingsYesOn, null, null){

            protected void touchAction() {
                SettingsScreen.this.soundButtonAction();
            }
        };
        this.backButton = new CustomButton(ImagesResources.settingsBackOff, ImagesResources.settingsBackOn, null, null){

            protected void touchAction() {
                SettingsScreen.this.returnToMenu();
            }
        };
        int width = 360;
        int height = 640;
        this.add(this.soundButton, 156, 262);
        this.add(this.speedButton, 135, 333);
        this.add(this.clearScoreboardButton, 105, 371);
        this.add(this.backButton, 144, 556);
    }

    public void onPaint(Graphics g) {
        ImagesResources.settingsBg.draw(g, 0, 0);
        super.onPaint(g);
    }

    private void speedButtonAction() {
        this.playButtonSound();
        int curr_speed = DataManager.getGameSpeed();
        switch (curr_speed) {
            case 0: {
                DataManager.setGameSpeed(1);
                this.speedButton.setOffImage(ImagesResources.settingsMediumOff);
                this.speedButton.setOnImage(ImagesResources.settingsMediumOn);
                break;
            }
            case 1: {
                DataManager.setGameSpeed(2);
                this.speedButton.setOffImage(ImagesResources.settingsHighOff);
                this.speedButton.setOnImage(ImagesResources.settingsHighOn);
                break;
            }
            case 2: {
                DataManager.setGameSpeed(0);
                this.speedButton.setOffImage(ImagesResources.settingsLowOff);
                this.speedButton.setOnImage(ImagesResources.settingsLowOn);
            }
        }
    }

    private void soundButtonAction() {
        DataManager.changeSoundState();
        if (DataManager.getSoundState()) {
            this.playButtonSound();
            DataManager.setSoundState(false);
            SoundSystem.SOUND_MAIN_THEME.stop();
            this.soundButton.setOffImage(ImagesResources.settingsNoOff);
            this.soundButton.setOnImage(ImagesResources.settingsNoOn);
        } else {
            DataManager.setSoundState(true);
            SoundSystem.SOUND_MAIN_THEME.play();
            this.soundButton.setOffImage(ImagesResources.settingsYesOff);
            this.soundButton.setOnImage(ImagesResources.settingsYesOn);
        }
    }

    private void clearButtonAction() {
        this.playButtonSound();
        Application.setScreen(GamePopupScreen.getInstance(6));
    }

    private void setSettingsState() {
        switch (DataManager.getGameSpeed()) {
            case 0: {
                this.speedButton.setOffImage(ImagesResources.settingsLowOff);
                this.speedButton.setOnImage(ImagesResources.settingsLowOn);
                break;
            }
            case 1: {
                this.speedButton.setOffImage(ImagesResources.settingsMediumOff);
                this.speedButton.setOnImage(ImagesResources.settingsMediumOn);
                break;
            }
            case 2: {
                this.speedButton.setOffImage(ImagesResources.settingsHighOff);
                this.speedButton.setOnImage(ImagesResources.settingsHighOn);
            }
        }
        if (DataManager.getSoundState()) {
            this.soundButton.setOffImage(ImagesResources.settingsYesOff);
            this.soundButton.setOnImage(ImagesResources.settingsYesOn);
        } else {
            this.soundButton.setOffImage(ImagesResources.settingsNoOff);
            this.soundButton.setOnImage(ImagesResources.settingsNoOn);
        }
    }

    private void returnToMenu() {
        this.playButtonSound();
        Application.setScreen(HomeScreen.getInstance());
    }

    public static SettingsScreen getInstance() {
        if (instance == null) {
            instance = new SettingsScreen();
        }
        return instance;
    }

    private void playButtonSound() {
        try {
            SoundSystem.SOUND_BUTTON.play();
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public void onVolumeChange() {
        if (DataManager.getSoundState() || DataManager.getCurrentSoundLvl() == 0) {
            this.soundButton.setOffImage(ImagesResources.settingsNoOff);
            this.soundButton.setOnImage(ImagesResources.settingsNoOn);
        } else {
            this.soundButton.setOffImage(ImagesResources.settingsYesOff);
            this.soundButton.setOnImage(ImagesResources.settingsYesOn);
        }
    }
}

