/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.component;

import com.ximad.bubble_birds_2.Consts;
import com.ximad.bubble_birds_2.audio.SoundSystem;
import com.ximad.bubble_birds_2.component.imgAnimated;
import com.ximad.bubble_birds_2.component.imgConst;
import com.ximad.bubble_birds_2.component.imgSimple;
import com.ximad.bubble_birds_2.engine.Bitmap;
import com.ximad.bubble_birds_2.game.DataManager;
import com.ximad.bubble_birds_2.res.ImagesResources;
import com.ximad.bubble_birds_2.utils.Utils;

public class imAgination {
    private static final int INITIAL_CAPACITY = 5;
    private static final int INITIAL_IMG_CAPACITY = 64;
    private static final int INITIAL_ROWS_COUNT = 30;
    public Bitmap pure_background;
    public imgSimple[] imgElements;
    public int imgElementsCount;
    public int[][] allRows;
    public int allRowsCount;
    private int bump_element = 0;
    private float bump_coef = 0.0f;
    private float bump_step = 0.0f;
    private boolean bump = false;
    private int[] blowupChain;
    private int blowupChainCount;
    private boolean verifyDropFlag = false;
    private String dropChainString;
    private int y_min;
    private int y_max;
    private int y_0;
    private int y_verify;
    private float speed_coef;
    public imgAnimated[] animation;
    public int animationCount;
    public imgConst[] constElement;
    public int constElementCount;
    public imgConst[] constBackElement;
    public int constBackElementCount;
    private int bullet_curr_type = 1;
    private int bullet_next_type;
    private Bitmap[] bulletFrames;
    private int currBulletFrame = 0;
    private int bullet_speed;
    private float bullet_angle;
    private boolean needBullet = false;
    public int dy = 0;
    private float real_dy = 0.0f;
    public int bullet_dx = 0;
    public int bullet_dy = 0;
    private float bullet_real_dx = 0.0f;
    private float bullet_real_dy = 0.0f;
    private float bullet_step_x = 0.0f;
    private float bullet_step_y = 0.0f;
    private float sight_angle = 0.0f;
    private float score_mlt = 1.0f;
    private boolean mlt_flag = false;
    public int gameState;
    public static int STATE_PLAY = 0;
    public static int STATE_WIN = 1;
    public static int STATE_LOSE = 2;
    public static int STATE_PAUSE = 3;
    public static int STATE_ABORT = 4;
    private int[] environs;
    private int environsCount;
    private int[] tmpChain;
    private int tmpChainCount;
    private int z;
    boolean[] colors = new boolean[7];
    static final boolean[] ALL_COLORS = new boolean[]{true, true, true, true, true, true, true};
    static final boolean[] NO_COLORS = new boolean[]{false, false, false, false, false, false, false};
    private int[] neighbours = new int[6];
    private int[] neighbours4 = new int[4];
    private int[] elts = new int[12];

    public imAgination(Bitmap bg) {
        this.bullet_next_type = Utils.random(0, 99) < 20 ? Utils.random(13, 15) : Utils.random(1, 7);
        this.bullet_speed = 16 + DataManager.getGameSpeed() * 2 + 2;
        this.pure_background = bg;
        this.init();
    }

    private void init() {
        this.imgElements = new imgSimple[64];
        this.imgElementsCount = 0;
        this.blowupChain = new int[64];
        this.blowupChainCount = 0;
        this.animation = new imgAnimated[64];
        this.animationCount = 0;
        this.constBackElement = new imgConst[5];
        this.constBackElementCount = 0;
        this.constElement = new imgConst[5];
        this.constElementCount = 0;
        this.constBackElement = new imgConst[5];
        this.constBackElementCount = 0;
        this.allRows = new int[30][];
        this.allRowsCount = 0;
        this.environs = new int[30];
        this.environsCount = 0;
        this.tmpChain = new int[30];
        this.tmpChainCount = 0;
        this.gameState = STATE_PLAY;
    }

    public void initMinMaxY(int y0, int y_ver) {
        this.y_0 = y0;
        this.y_min = y_ver;
        this.y_max = 0;
        this.y_verify = y_ver;
    }

    public void addRow(int[] row) {
        if (this.allRowsCount == this.allRows.length) {
            int[][] tmp = new int[this.allRowsCount + 5][];
            System.arraycopy(this.allRows, 0, tmp, 0, this.allRowsCount);
            this.allRows = tmp;
        }
        this.allRows[this.allRowsCount++] = row;
    }

    private boolean addToRow(int row, int column, int index) {
        if (row < 0) {
            row = 0;
        }
        if (column < 0) {
            column = 0;
        } else if (column > 8) {
            column = 8;
        }
        if (row >= this.allRowsCount) {
            int[] newRow = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, this.allRows[this.allRowsCount - 1][9] + 38, 0};
            if (this.allRowsCount == this.allRows.length) {
                int[][] tmp = new int[this.allRowsCount + 5][];
                System.arraycopy(this.allRows, 0, tmp, 0, this.allRowsCount);
                this.allRows = tmp;
            }
            this.allRows[this.allRowsCount++] = newRow;
        }
        if (this.allRows[row][column] == -1) {
            this.allRows[row][column] = index;
            this.allRows[row][10] = this.allRows[row][10] + 1;
            return true;
        }
        return false;
    }

    private void addToRow(int index) {
        int row = Math.abs((this.allRows[0][9] - this.getImgByNmb((int)index).getImgPoint().y) / 38);
        int padding = 0;
        if (row % 2 != 0) {
            padding = 19;
        }
        int column = (this.getImgByNmb((int)index).getImgPoint().x - padding) / 38;
        if (row >= this.allRowsCount) {
            int[] newRow = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, this.getImgByNmb((int)index).getImgPoint().y, 0};
            if (this.allRowsCount == this.allRows.length) {
                int[][] tmp = new int[this.allRowsCount + 5][];
                System.arraycopy(this.allRows, 0, tmp, 0, this.allRowsCount);
                this.allRows = tmp;
            }
            this.allRows[this.allRowsCount++] = newRow;
        }
        this.allRows[row][column] = index;
        int[] nArray = this.allRows[row];
        nArray[10] = nArray[10] + 1;
    }

    private void removeFromRow(int row, int column) {
        this.allRows[row][column] = -1;
        int[] nArray = this.allRows[row];
        nArray[10] = nArray[10] - 1;
    }

    private void removeFromRow(int id) {
        int row = Math.abs((this.allRows[0][9] - this.getImgByNmb((int)id).getImgPoint().y) / 38);
        int padding = 0;
        if (row % 2 != 0) {
            padding = 19;
        }
        int column = (this.getImgByNmb((int)id).getImgPoint().x - padding) / 38;
        this.allRows[row][column] = -1;
        int[] nArray = this.allRows[row];
        nArray[10] = nArray[10] - 1;
    }

    public void addElement(int type, Bitmap new_img, int x, int y) {
        int newImgWidth = new_img.getWidth();
        int newImgHeight = new_img.getHeight();
        if (this.imgElementsCount == this.imgElements.length) {
            imgSimple[] tmp = new imgSimple[this.imgElementsCount + 5];
            System.arraycopy(this.imgElements, 0, tmp, 0, this.imgElementsCount);
            this.imgElements = tmp;
        }
        this.imgElements[this.imgElementsCount++] = new imgSimple(type, new_img, x, y, 0.0f);
    }

    public void addBird(int type, int x, int y) {
        if (type >= 20) {
            this.addElement(type, ImagesResources.birds_freeze[type - 20][4], x, y);
        } else {
            this.addElement(type, ImagesResources.birds[type - 1], x, y);
        }
    }

    public void addAnimation(Bitmap[] frms, int x, int y) {
        if (this.animationCount == this.animation.length) {
            imgAnimated[] tmp = new imgAnimated[this.animationCount + 5];
            System.arraycopy(this.animation, 0, tmp, 0, this.imgElementsCount);
            this.animation = tmp;
        }
        this.animation[this.animationCount++] = new imgAnimated(frms, x, y);
    }

    public void addAnimation(Bitmap frm, int x, int y, int x1, int y1, int time) {
        if (this.animationCount == this.animation.length) {
            imgAnimated[] tmp = new imgAnimated[this.animationCount + 5];
            System.arraycopy(this.animation, 0, tmp, 0, this.imgElementsCount);
            this.animation = tmp;
        }
        this.animation[this.animationCount++] = new imgAnimated(frm, x, y, x1, y1, time);
    }

    public void addAnimation(Bitmap[] frm, int x, int y, int x1, int y1, int time) {
        if (this.animationCount == this.animation.length) {
            imgAnimated[] tmp = new imgAnimated[this.animationCount + 5];
            System.arraycopy(this.animation, 0, tmp, 0, this.imgElementsCount);
            this.animation = tmp;
        }
        this.animation[this.animationCount++] = new imgAnimated(frm, x, y, x1, y1, time);
    }

    public void addAnimation(Bitmap[] frm, int x, int y, int x1, int y1) {
        if (this.animationCount == this.animation.length) {
            imgAnimated[] tmp = new imgAnimated[this.animationCount + 5];
            System.arraycopy(this.animation, 0, tmp, 0, this.imgElementsCount);
            this.animation = tmp;
        }
        this.animation[this.animationCount++] = new imgAnimated(frm, x, y, x1, y1);
    }

    public void addConstElement(Bitmap[] lbls, int number, int x, int y, int alignment, boolean foreground) {
        if (foreground) {
            if (this.constElementCount == this.constElement.length) {
                imgConst[] tmp = new imgConst[this.constElementCount + 5];
                System.arraycopy(this.constElement, 0, tmp, 0, this.constElementCount);
                this.constElement = tmp;
            }
            this.constElement[this.constElementCount++] = new imgConst(lbls, number, x, y, alignment);
        } else {
            if (this.constBackElementCount == this.constBackElement.length) {
                imgConst[] tmp = new imgConst[this.constBackElementCount + 5];
                System.arraycopy(this.constBackElement, 0, tmp, 0, this.constBackElementCount);
                this.constBackElement = tmp;
            }
            this.constBackElement[this.constBackElementCount++] = new imgConst(lbls, number, x, y, alignment);
        }
    }

    public void addConstElement(int number, int x, int y, int alignment, boolean foreground) {
        if (foreground) {
            if (this.constElementCount == this.constElement.length) {
                imgConst[] tmp = new imgConst[this.constElementCount + 5];
                System.arraycopy(this.constElement, 0, tmp, 0, this.constElementCount);
                this.constElement = tmp;
            }
            this.constElement[this.constElementCount++] = new imgConst(number, x, y, alignment);
        } else {
            if (this.constBackElementCount == this.constBackElement.length) {
                imgConst[] tmp = new imgConst[this.constBackElementCount + 5];
                System.arraycopy(this.constBackElement, 0, tmp, 0, this.constBackElementCount);
                this.constBackElement = tmp;
            }
            this.constBackElement[this.constBackElementCount++] = new imgConst(number, x, y, alignment);
        }
    }

    public void addConstElement(Bitmap lbl, int number, int x, int y, int alignment, boolean foreground) {
        if (foreground) {
            if (this.constElementCount == this.constElement.length) {
                imgConst[] tmp = new imgConst[this.constElementCount + 5];
                System.arraycopy(this.constElement, 0, tmp, 0, this.constElementCount);
                this.constElement = tmp;
            }
            this.constElement[this.constElementCount++] = new imgConst(lbl, number, x, y, alignment);
        } else {
            if (this.constBackElementCount == this.constBackElement.length) {
                imgConst[] tmp = new imgConst[this.constBackElementCount + 5];
                System.arraycopy(this.constBackElement, 0, tmp, 0, this.constBackElementCount);
                this.constBackElement = tmp;
            }
            this.constBackElement[this.constBackElementCount++] = new imgConst(lbl, number, x, y, alignment);
        }
    }

    public void addConstElement(Bitmap lbl, int x, int y, boolean foreground) {
        if (foreground) {
            if (this.constElementCount == this.constElement.length) {
                imgConst[] tmp = new imgConst[this.constElementCount + 5];
                System.arraycopy(this.constElement, 0, tmp, 0, this.constElementCount);
                this.constElement = tmp;
            }
            this.constElement[this.constElementCount++] = new imgConst(lbl, x, y);
        } else {
            if (this.constBackElementCount == this.constBackElement.length) {
                imgConst[] tmp = new imgConst[this.constBackElementCount + 5];
                System.arraycopy(this.constBackElement, 0, tmp, 0, this.constBackElementCount);
                this.constBackElement = tmp;
            }
            this.constBackElement[this.constBackElementCount++] = new imgConst(lbl, x, y);
        }
    }

    public void removeElement(int id) {
        imgSimple tmp_img = null;
        if (id >= 0 && this.imgElements.length > id) {
            tmp_img = this.imgElements[id];
        }
        if (tmp_img == null) {
            return;
        }
        if (tmp_img.get_type() == 12) {
            this.gameState = STATE_WIN;
        }
        this.removeFromRow(id);
        if (id >= this.imgElementsCount) {
            imgSimple[] tmp = new imgSimple[id + 5];
            System.arraycopy(this.imgElements, 0, tmp, 0, this.imgElementsCount);
            this.imgElements = tmp;
            this.imgElementsCount = id + 1;
        }
        this.imgElements[id] = null;
    }

    public void removeElement(int row, int column) {
        imgSimple tmp_img = null;
        int id = this.allRows[row][column];
        tmp_img = this.getImgByNmb(id);
        if (tmp_img == null) {
            return;
        }
        if (tmp_img.get_type() == 12) {
            this.gameState = STATE_WIN;
        }
        this.removeFromRow(row, column);
        if (id >= this.imgElementsCount) {
            imgSimple[] tmp = new imgSimple[id + 5];
            System.arraycopy(this.imgElements, 0, tmp, 0, this.imgElementsCount);
            this.imgElements = tmp;
            this.imgElementsCount = id + 1;
        }
        this.imgElements[id] = null;
    }

    public void setForce(int id, float force, float angle) {
        imgSimple tmp_image = null;
        tmp_image = this.getImgByNmb(id);
        if (tmp_image == null) {
            return;
        }
        tmp_image.setForce(force, angle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Step() {
        int i;
        int i2;
        this.bump = false;
        this.bump_element = 0;
        if (this.bump_step < this.bump_coef) {
            this.bump_coef = (float)((double)this.bump_coef - 0.1);
            if (this.bump_step >= this.bump_coef) {
                this.bump_step = 0.0f;
                this.bump_coef = 0.0f;
            }
        } else if (this.bump_step > this.bump_coef) {
            this.bump_coef = (float)((double)this.bump_coef + 0.3);
            if (this.bump_step <= this.bump_coef) {
                this.bump_step = 0.0f;
            }
        }
        if (this.needBullet) {
            this.addBullet();
            this.needBullet = false;
        }
        if (this.verifyDropFlag) {
            this.buildDropChain();
        }
        boolean bubble_hit = false;
        this.speed_coef = this.y_max < -38 ? (float)(-1 * (this.y_max + 38)) : 0.0f;
        this.blowupChainCount = 0;
        int death = 0;
        int boom = 0;
        int ice = 0;
        int drop = 0;
        int stone = 0;
        int blowup_chain = 0;
        int drop_chain = 0;
        this.moveBitmapByNmb(0);
        this.y_max = this.y_0;
        imAgination imAgination2 = this;
        synchronized (imAgination2) {
            int rows = this.allRowsCount;
            if (rows > 0) {
                for (i2 = 0; i2 < rows; ++i2) {
                    int j;
                    if (this.allRows[i2][10] <= 0) {
                        for (j = i2; j < this.allRowsCount; ++j) {
                            this.allRows[j] = null;
                        }
                        this.allRowsCount = i2;
                        break;
                    }
                    if (this.allRowsCount == 0) {
                        this.gameState = STATE_WIN;
                        break;
                    }
                    this.y_max = this.allRows[i2][9] + this.dy;
                    for (j = 0; j < 9; ++j) {
                        if (this.allRows[i2][j] == -1) continue;
                        if (this.verifyDropFlag) {
                            imgSimple tmpImage = this.getImgByNmb(this.allRows[i2][j]);
                            if (tmpImage == null) {
                                this.allRows[i2][j] = -1;
                                continue;
                            }
                            if (!tmpImage.getEltState()) {
                                if (tmpImage.get_type() != 15) {
                                    if (tmpImage.get_type() >= 20) {
                                        this.addAnimation(ImagesResources.bird_blowups[0], tmpImage.getImgPoint().x, tmpImage.getImgPoint().y + this.dy, tmpImage.getImgPoint().x + Utils.random(0, 10) - 5, tmpImage.getImgPoint().y + this.dy + Utils.random(0, 10) - 5, 60);
                                        ++ice;
                                    } else {
                                        this.addAnimation(ImagesResources.bird_blowups[tmpImage.get_type() - 1], tmpImage.getImgPoint().x, tmpImage.getImgPoint().y + this.dy, tmpImage.getImgPoint().x + Utils.random(0, 10) - 5, tmpImage.getImgPoint().y + this.dy + Utils.random(0, 10) - 5, 60);
                                        if (tmpImage.get_type() == 10) {
                                            DataManager.levelData.setCurrMoney(DataManager.levelData.getCurrMoney() + 1);
                                            ++death;
                                        } else if (tmpImage.get_type() == 12) {
                                            this.gameState = STATE_WIN;
                                            ++death;
                                        } else if (tmpImage.get_type() == 11) {
                                            ++ice;
                                        } else if (tmpImage.get_type() == 8) {
                                            ++stone;
                                        } else {
                                            ++death;
                                        }
                                    }
                                } else {
                                    this.addAnimation(ImagesResources.bomb_blowup, tmpImage.getImgPoint().x - 32, tmpImage.getImgPoint().y + this.dy - 16);
                                    ++boom;
                                }
                                this.removeElement(i2, j);
                                ++blowup_chain;
                                continue;
                            }
                            if (this.dropChainString != null && !this.dropChainString.equals("") && this.allRows[i2][9] > this.y_min && this.dropChainString.indexOf(", " + this.allRows[i2][j] + ",") != -1) {
                                if (tmpImage.get_type() != 8) {
                                    if (tmpImage.get_type() == 12) {
                                        this.gameState = STATE_WIN;
                                    }
                                    if (tmpImage.get_type() >= 20) {
                                        this.addAnimation(ImagesResources.bird_blowups[0], tmpImage.getImgPoint().x, tmpImage.getImgPoint().y + this.dy, tmpImage.getImgPoint().x + Utils.random(0, 10) - 5, tmpImage.getImgPoint().y + this.dy + Utils.random(0, 10) - 5, 60);
                                        ++ice;
                                    } else {
                                        this.addAnimation(ImagesResources.bird_blowups[tmpImage.get_type() - 1], tmpImage.getImgPoint().x, tmpImage.getImgPoint().y + this.dy, tmpImage.getImgPoint().x + Utils.random(0, 10) - 5, tmpImage.getImgPoint().y + this.dy + Utils.random(0, 10) - 5, 60);
                                        if (tmpImage.get_type() == 11) {
                                            ++ice;
                                        } else {
                                            ++death;
                                        }
                                    }
                                } else {
                                    this.addAnimation(tmpImage.get_bitmap(), tmpImage.getImgPoint().x, tmpImage.getImgPoint().y + this.dy, tmpImage.getImgPoint().x, tmpImage.getImgPoint().y + this.dy + 640, 400);
                                    ++drop;
                                }
                                this.removeElement(i2, j);
                                ++drop_chain;
                                continue;
                            }
                            this.moveBitmapByNmb(this.allRows[i2][j]);
                            continue;
                        }
                        this.moveBitmapByNmb(this.allRows[i2][j]);
                    }
                    if (!(Math.abs((float)this.allRows[i2][9] + this.real_dy - 557.0f - this.bullet_real_dy) <= 38.0f) || this.gameState != STATE_PLAY) continue;
                    int padding = 0;
                    if (i2 % 2 != 0) {
                        padding = 19;
                    }
                    for (int j2 = 0; j2 < 9; ++j2) {
                        int[] tmp;
                        int tmp_index = this.allRows[i2][j2];
                        if (tmp_index == -1 || !(Math.abs((float)(padding + j2 * 38 - 168) - this.bullet_real_dx) <= 38.0f) || !this.verifyColliding(tmp_index)) continue;
                        if (this.bullet_dx == 0 && this.bullet_dy == 0) {
                            this.gameState = STATE_LOSE;
                            return;
                        }
                        if (this.bump_element == tmp_index || this.bump_element == -1) continue;
                        if (this.getImgByNmb(tmp_index).get_type() == 9 || this.getImgByNmb(tmp_index).get_type() == 10) {
                            this.getImgByNmb(tmp_index).setEltState(false);
                            if (this.blowupChainCount == this.blowupChain.length) {
                                tmp = new int[this.blowupChainCount + 5];
                                System.arraycopy(this.blowupChain, 0, tmp, 0, this.blowupChainCount);
                                this.blowupChain = tmp;
                            }
                            this.blowupChain[this.blowupChainCount++] = tmp_index;
                            this.verifyDropFlag = true;
                            bubble_hit = true;
                            if (this.getImgByNmb((int)tmp_index).getImgPoint().y <= this.y_verify) {
                                this.y_verify = this.getImgByNmb((int)tmp_index).getImgPoint().y - 38;
                            }
                        } else if (this.getImgByNmb(tmp_index).get_type() == 12) {
                            this.getImgByNmb(tmp_index).setEltState(false);
                            if (this.blowupChainCount == this.blowupChain.length) {
                                tmp = new int[this.blowupChainCount + 5];
                                System.arraycopy(this.blowupChain, 0, tmp, 0, this.blowupChainCount);
                                this.blowupChain = tmp;
                            }
                            this.blowupChain[this.blowupChainCount++] = tmp_index;
                        } else {
                            this.bump = true;
                            if (Math.abs((float)(this.getImgByNmb((int)tmp_index).getImgPoint().x - 168) - this.bullet_real_dx) + Math.abs((float)(this.getImgByNmb((int)tmp_index).getImgPoint().y + this.dy - 557) - this.bullet_real_dy) <= Math.abs((float)(this.getImgByNmb((int)this.bump_element).getImgPoint().x - 168) - this.bullet_real_dx) + Math.abs((float)(this.getImgByNmb((int)this.bump_element).getImgPoint().y + this.dy - 557) - this.bullet_real_dy)) {
                                this.bump_element = tmp_index;
                            }
                        }
                        if (this.bump) continue;
                        this.bump = true;
                        this.bump_element = -1;
                    }
                }
            } else {
                this.gameState = STATE_WIN;
            }
            if (death + boom != 0) {
                this.bump_step -= -0.16f * (float)(12 + this.blowupChainCount / 4 + this.dropChainString.length() / 4);
                DataManager.stopSound();
                if (boom == 0) {
                    if (drop > 0) {
                        SoundSystem.SOUND_DEATH_STONE.play();
                    } else if (ice > 0) {
                        SoundSystem.SOUND_DEATH_ICE.play();
                    } else if (death < 3) {
                        SoundSystem.SOUND_DEATH.play();
                    } else if (death < 5) {
                        SoundSystem.SOUND_DEATH_3.play();
                    } else {
                        SoundSystem.SOUND_DEATH_5.play();
                    }
                } else if (stone > 0) {
                    SoundSystem.SOUND_BOMB_STONE.play();
                } else if (ice > 0) {
                    SoundSystem.SOUND_BOMB_ICE.play();
                } else if (death == 0) {
                    SoundSystem.SOUND_BOMB.play();
                } else if (death == 1) {
                    SoundSystem.SOUND_BOMB_1.play();
                } else if (death == 2) {
                    SoundSystem.SOUND_BOMB_2.play();
                } else if (death == 3) {
                    SoundSystem.SOUND_BOMB_3.play();
                } else {
                    SoundSystem.SOUND_BOMB_5.play();
                }
            }
            if (this.verifyDropFlag) {
                this.verifyDropFlag = false;
                this.dropChainString = "";
            }
            if (bubble_hit) {
                this.verifyDropFlag = true;
            }
            if (this.mlt_flag) {
                if (blowup_chain > 2) {
                    if ((double)this.score_mlt <= 5.3) {
                        this.score_mlt = (float)((double)this.score_mlt + 0.3);
                    }
                    if (Utils.round(this.score_mlt) == 2) {
                        this.addAnimation(ImagesResources.scoreMlt2, 73, 555, 73, 535 - Utils.random(0, 10), 500);
                    }
                    if (Utils.round(this.score_mlt) == 3) {
                        this.addAnimation(ImagesResources.scoreMlt3, 73, 555, 73, 535 - Utils.random(0, 10), 500);
                    }
                    if (Utils.round(this.score_mlt) == 4) {
                        this.addAnimation(ImagesResources.scoreMlt4, 73, 555, 73, 535 - Utils.random(0, 10), 500);
                    }
                    if (Utils.round(this.score_mlt) == 5) {
                        this.addAnimation(ImagesResources.scoreMlt5, 73, 555, 73, 535 - Utils.random(0, 10), 500);
                    }
                } else {
                    this.score_mlt = 1.0f;
                }
                this.mlt_flag = false;
            }
            this.moveBitmapByNmb(this.imgElementsCount - 1);
            if (this.bump) {
                this.mlt_flag = true;
                if (this.bump_element != -1) {
                    int rnd_type;
                    int i3;
                    float column;
                    int ex_bullet_id = this.imgElementsCount - 1;
                    imgSimple ex_bullet = this.imgElements[ex_bullet_id];
                    ex_bullet.set_bitmap(ImagesResources.birds[ex_bullet.get_type() - 1]);
                    float x_new = 168.0f + this.bullet_real_dx - this.bullet_step_x;
                    float y_new = 557.0f + this.bullet_real_dy - this.bullet_step_y;
                    float row = Math.abs(y_new - (float)this.y_0 - this.real_dy) / 38.0f;
                    int padding = 0;
                    if (row % 2.0f != 0.0f) {
                        padding = 19;
                    }
                    if ((column = (x_new - (float)padding) / 38.0f) > 8.0f) {
                        column = 8.0f;
                    }
                    if (column < 0.0f) {
                        column = 0.0f;
                    }
                    int[] free_neighbors = this.getAllFree(this.bump_element);
                    float tmp_d = 100.0f;
                    int tmp_index = -1;
                    for (i3 = 0; i3 < 6; ++i3) {
                        if (free_neighbors[i3 * 2] == -2 || !((double)tmp_d > Math.abs((double)column - (double)free_neighbors[i3 * 2 + 1] * 1.0) + Math.abs((double)row - (double)free_neighbors[i3 * 2] * 1.0))) continue;
                        tmp_d = (float)Math.abs((double)column - (double)free_neighbors[i3 * 2 + 1] * 1.0) + (float)Math.abs((double)row - (double)free_neighbors[i3 * 2] * 1.0);
                        tmp_index = i3 * 2;
                    }
                    row = (float)free_neighbors[tmp_index] * 1.0f;
                    column = (float)free_neighbors[tmp_index + 1] * 1.0f;
                    padding = 0;
                    if (row % 2.0f != 0.0f) {
                        padding = 19;
                    }
                    this.addToRow((int)row, (int)column, ex_bullet_id);
                    ex_bullet.setImgPoint((int)column * 38 + padding, this.allRows[(int)row][9]);
                    if (ex_bullet.get_type() == 14) {
                        this.getAllNeighbours(ex_bullet_id);
                        rnd_type = Utils.random(1, 7);
                        boolean type_set = false;
                        for (int i4 = 0; i4 < 6; ++i4) {
                            if ((rnd_type += i4) > 6) {
                                rnd_type = 1;
                            }
                            type_set = true;
                            for (int j = 0; j < 6; ++j) {
                                if (this.neighbours[j] <= -1 || rnd_type != this.getImgByNmb(this.neighbours[j]).get_type()) continue;
                                type_set = false;
                                break;
                            }
                            if (!type_set) continue;
                            ex_bullet.set_bitmap(ImagesResources.birds[rnd_type - 1]);
                            ex_bullet.set_type(rnd_type);
                            break;
                        }
                    }
                    if (this.getImgByNmb(this.bump_element).get_type() == 11 && ex_bullet.get_type() != 15 && ex_bullet.get_type() != 13) {
                        SoundSystem.SOUND_FREEZE.play();
                        ex_bullet.set_bitmap(ImagesResources.birds_freeze[ex_bullet.get_type() - 1][ImagesResources.birds_freeze[ex_bullet.get_type() - 1].length - 1]);
                        ex_bullet.setAnimation(ImagesResources.birds_freeze[ex_bullet.get_type() - 1]);
                        ex_bullet.set_type(ex_bullet.get_type() + 20);
                    }
                    if (ex_bullet.get_type() == 13) {
                        if (this.getImgByNmb(this.bump_element).get_type() == 8 || this.getImgByNmb(this.bump_element).get_type() == 11 || this.getImgByNmb(this.bump_element).get_type() >= 20) {
                            rnd_type = this.getImgByNmb(this.bump_element).get_type() >= 20 ? this.getImgByNmb(this.bump_element).get_type() - 20 : Consts.TYPES[Utils.random(0, 6)];
                            this.getImgByNmb(this.bump_element).set_bitmap(ImagesResources.birds[rnd_type - 1]);
                            this.getImgByNmb(this.bump_element).set_type(rnd_type);
                            ex_bullet.set_bitmap(ImagesResources.birds[rnd_type - 1]);
                            ex_bullet.set_type(rnd_type);
                        } else {
                            ex_bullet.set_type(this.getImgByNmb(this.bump_element).get_type());
                            ex_bullet.set_bitmap(this.getImgByNmb(this.bump_element).get_bitmap());
                        }
                    }
                    if (ex_bullet.get_type() == 15) {
                        this.getAllNeighbours(ex_bullet_id);
                        if (this.blowupChainCount == this.blowupChain.length) {
                            int[] tmp = new int[this.blowupChainCount + 5];
                            System.arraycopy(this.blowupChain, 0, tmp, 0, this.blowupChainCount);
                            this.blowupChain = tmp;
                        }
                        this.blowupChain[this.blowupChainCount++] = ex_bullet_id;
                        for (i3 = 0; i3 < 6; ++i3) {
                            if (this.neighbours[i3] <= -1) continue;
                            this.getImgByNmb(this.neighbours[i3]).setEltState(false);
                            if (this.blowupChainCount == this.blowupChain.length) {
                                int[] tmp = new int[this.blowupChainCount + 5];
                                System.arraycopy(this.blowupChain, 0, tmp, 0, this.blowupChainCount);
                                this.blowupChain = tmp;
                            }
                            this.blowupChain[this.blowupChainCount++] = this.neighbours[i3];
                            if (this.getImgByNmb((int)this.neighbours[i3]).getImgPoint().y > this.y_verify) continue;
                            this.y_verify = this.getImgByNmb((int)this.neighbours[i3]).getImgPoint().y - 38;
                        }
                        ex_bullet.setEltState(false);
                        this.getImgByNmb(this.bump_element).setEltState(false);
                        this.verifyDropFlag = true;
                        if (ex_bullet.getImgPoint().y <= this.y_verify) {
                            this.y_verify = ex_bullet.getImgPoint().y - 38;
                        }
                    }
                    ex_bullet.setForce(this.getImgByNmb(this.bump_element).getForce(), 1.5707964f);
                    if (ex_bullet.get_type() != 15) {
                        this.buildBlowupChain(this.imgElementsCount - 1);
                    }
                    if (this.blowupChainCount < 3 && !this.verifyDropFlag) {
                        this.blowupChainCount = 0;
                    } else {
                        this.verifyDropFlag = true;
                    }
                    this.needBullet = true;
                } else {
                    this.verifyDropFlag = true;
                }
            } else {
                this.blowupChainCount = 0;
            }
        }
        if (this.constBackElementCount != 0) {
            for (i = 0; i < this.constBackElementCount; ++i) {
                imgConst tmpConst = this.constBackElement[i];
                if (tmpConst.getEltState()) continue;
                System.arraycopy(this.constBackElement, i + 1, this.constBackElement, i, this.constBackElementCount - (i + 1));
                this.constBackElement[--this.constBackElementCount] = null;
                --i;
            }
        }
        int scores = 0;
        if (drop_chain > 0) {
            scores = drop_chain == 1 ? 10 : (drop_chain * 2 - 3) * 10;
        }
        if (blowup_chain > 0) {
            scores = blowup_chain == 1 ? ++scores : (scores += blowup_chain * 2 - 3);
        }
        if (scores != 0) {
            DataManager.levelData.setCurrScore(DataManager.levelData.getCurrScore() + (scores *= Utils.round(this.score_mlt)));
        }
        if (this.constElementCount != 0) {
            for (i2 = 0; i2 < this.constElementCount; ++i2) {
                imgConst tmpConst = this.constElement[i2];
                if (!this.constElement[i2].getEltState()) {
                    System.arraycopy(this.constElement, i2 + 1, this.constElement, i2, this.constElementCount - (i2 + 1));
                    this.constElement[--this.constElementCount] = null;
                    --i2;
                    continue;
                }
                if (i2 == 1 && tmpConst.getNumber() != DataManager.levelData.getCurrMoney()) {
                    tmpConst.setNumber(DataManager.levelData.getCurrMoney());
                }
                if (i2 == 2 && tmpConst.getNumber() != DataManager.levelData.getLivesNmb()) {
                    tmpConst.setNumber(DataManager.levelData.getLivesNmb());
                }
                if (i2 != 3 || tmpConst.getNumber() == DataManager.levelData.getCurrScore()) continue;
                tmpConst.setNumber(DataManager.levelData.getCurrScore());
            }
        }
        if (this.animationCount != 0) {
            for (i = 0; i < this.animationCount; ++i) {
                if (this.animation[i].get_frame(System.currentTimeMillis()) != null) continue;
                System.arraycopy(this.animation, i + 1, this.animation, i, this.animationCount - (i - 1));
                this.animation[--this.animationCount] = null;
                --i;
            }
        }
    }

    public void moveBitmapByNmb(int nmb) {
        boolean isBullet;
        imgSimple img = this.getImgByNmb(nmb);
        if (img == null) {
            return;
        }
        boolean bl = isBullet = nmb == this.imgElementsCount - 1;
        if (!isBullet) {
            if (nmb == 0) {
                this.real_dy += img.getStepY();
                if (this.bump_coef != 0.0f) {
                    this.real_dy -= this.bump_coef;
                }
                this.real_dy += this.speed_coef;
                if (this.dy != Utils.round(this.real_dy)) {
                    this.dy = Utils.round(this.real_dy);
                }
            }
        } else {
            this.bullet_real_dx += img.getStepX();
            this.bullet_real_dy += img.getStepY();
            this.bullet_step_x = img.getStepX();
            this.bullet_step_y = img.getStepY();
            if (this.bullet_dx != Utils.round(this.bullet_real_dx) || this.bullet_dy != Utils.round(this.bullet_real_dy)) {
                this.bullet_dx = Utils.round(this.bullet_real_dx);
                this.bullet_dy = Utils.round(this.bullet_real_dy);
            }
        }
        int w = img.get_real_width();
        int h = img.get_real_height();
        int x = img.getImgPoint().x;
        int y = img.getImgPoint().y;
        if (isBullet) {
            x += this.bullet_dx;
            y += this.bullet_dy;
        } else if ((y += this.dy) >= 509 && img.get_type() != 9 && img.get_type() != 10) {
            this.gameState = STATE_LOSE;
        }
        if (x <= -1 * w || x >= 360 || y <= -1 * h || y >= 640) {
            if (isBullet && (x <= 0 || x > 360 - w)) {
                img.setForce(img.getForce(), (float)Math.PI - img.getAngle());
                this.switchFrame();
            }
        } else {
            if (nmb != 0 && !isBullet && img.get_type() < 13 && Utils.random(0, 1000) < 2 && !img.getAnimationState()) {
                img.setAnimation(ImagesResources.birds_glout[img.get_type() - 1]);
            }
            int img_x = 0;
            boolean img_y = false;
            if (x < 0) {
                img_x = x;
            } else if (x + w > 360) {
                img_x = 720 - x - w;
            }
            if (isBullet && img_x != 0) {
                img.setForce(img.getForce(), (float)Math.PI - img.getAngle());
                this.switchFrame();
            }
        }
        if (isBullet && y <= this.y_0 + this.dy) {
            int row = 0;
            int column = Utils.round(((float)img.getImgPoint().x + this.bullet_real_dx) / 38.0f);
            if (column > 8) {
                column = 8;
            }
            int x_init = column * 38;
            int y_init = this.y_0;
            img.set_bitmap(ImagesResources.birds[img.get_type() - 1]);
            img.setImgPoint(x_init, y_init);
            this.addToRow(row, column, nmb);
            img.setForce(this.getImgByNmb(0).getForce(), 1.5707964f);
            if (img.get_type() == 15 || img.get_type() == 14 || img.get_type() == 13) {
                x_init = img.getImgPoint().x;
                y_init = img.getImgPoint().y;
                this.neighbours4[0] = this.allRows.length > 0 && this.allRows[0] != null && this.allRows[0].length > column - 1 ? this.allRows[0][column - 1] : -2;
                this.neighbours4[1] = this.allRows.length > 1 && this.allRows[1] != null && this.allRows[1].length > column - 1 ? this.allRows[1][column - 1] : -2;
                this.neighbours4[2] = this.allRows.length > 1 && this.allRows[1] != null && this.allRows[1].length > column ? this.allRows[1][column] : -2;
                this.neighbours4[3] = this.allRows.length > 0 && this.allRows[0] != null && this.allRows[0].length > column + 1 ? this.allRows[0][column + 1] : -2;
                if (img.get_type() == 14) {
                    System.arraycopy(ALL_COLORS, 0, this.colors, 0, 7);
                } else {
                    System.arraycopy(NO_COLORS, 0, this.colors, 0, 7);
                }
                for (int i = 0; i < 4; ++i) {
                    if (this.neighbours4[i] <= -1) continue;
                    if (img.get_type() == 15) {
                        this.getImgByNmb(this.neighbours4[i]).setEltState(false);
                        if (this.blowupChainCount == this.blowupChain.length) {
                            int[] tmp = new int[this.blowupChainCount + 5];
                            System.arraycopy(this.blowupChain, 0, tmp, 0, this.blowupChainCount);
                            this.blowupChain = tmp;
                        }
                        this.blowupChain[this.blowupChainCount++] = this.neighbours4[i];
                        continue;
                    }
                    if (img.get_type() == 14) {
                        if (this.getImgByNmb(this.neighbours4[i]).get_type() > 7) continue;
                        try {
                            this.colors[this.getImgByNmb((int)this.neighbours4[i]).get_type() - 1] = false;
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if (img.get_type() != 13 || this.getImgByNmb(this.neighbours4[i]).get_type() > 7) continue;
                    this.colors[this.getImgByNmb((int)this.neighbours4[i]).get_type() - 1] = true;
                }
                if (img.get_type() == 15) {
                    img.setEltState(false);
                    this.verifyDropFlag = true;
                } else {
                    int colorsCount = 0;
                    for (int i = 0; i < 7; ++i) {
                        if (!this.colors[i]) continue;
                        ++colorsCount;
                    }
                    if (colorsCount != 0) {
                        int rnd_type = Utils.random(0, colorsCount - 1);
                        int new_type = 0;
                        int j = -1;
                        for (int i = 0; i < 7; ++i) {
                            if (this.colors[i]) {
                                ++j;
                            }
                            if (j != rnd_type) continue;
                            new_type = i;
                            break;
                        }
                        img.set_type(new_type + 1);
                        img.set_bitmap(ImagesResources.birds[new_type]);
                    } else {
                        int new_type = Utils.random(0, 6);
                        img.set_type(new_type + 1);
                        img.set_bitmap(ImagesResources.birds[new_type]);
                    }
                }
            }
            this.needBullet = true;
        }
    }

    public void addBullet() {
        this.bullet_dx = 0;
        this.bullet_dy = 0;
        this.bullet_real_dx = 0.0f;
        this.bullet_real_dy = 0.0f;
        this.bullet_curr_type = this.bullet_next_type;
        this.addElement(this.bullet_curr_type, ImagesResources.birds[this.bullet_curr_type - 1], 168, 557);
        if (Utils.random(0, 99) < 20) {
            this.bullet_next_type = Utils.random(13, 15);
            this.constBackElement[0].setLogo(ImagesResources.eggs[this.bullet_next_type - 6]);
        } else {
            this.bullet_next_type = Utils.random(1, 7);
            this.constBackElement[0].setLogo(ImagesResources.eggs[this.bullet_next_type - 1]);
        }
    }

    public int getElementNumber() {
        return this.imgElementsCount;
    }

    private imgSimple getImgByNmb(int nmb) {
        if (nmb > -1 && nmb < this.imgElementsCount) {
            return this.imgElements[nmb];
        }
        return null;
    }

    private boolean verifyColliding(int nmb_1) {
        int radius2;
        if (nmb_1 == this.imgElementsCount - 1) {
            return false;
        }
        imgSimple img_1 = this.imgElements[nmb_1];
        imgSimple img_2 = this.imgElements[this.imgElementsCount - 1];
        float x2 = (float)img_2.getImgPoint().x + this.bullet_real_dx;
        float x1 = img_1.getImgPoint().x;
        float d_x = x2 - x1;
        float y2 = (float)img_2.getImgPoint().y + this.bullet_real_dy;
        float y1 = (float)img_1.getImgPoint().y + this.real_dy;
        float d_y = y2 - y1;
        int radius1 = img_1.get_real_width() / 2;
        float radii = (float)radius1 * 1.0f + (float)(radius2 = img_2.get_real_width() / 2) * 1.0f;
        return d_x * d_x + d_y * d_y <= radii * radii;
    }

    private void buildBlowupChain(int nmb) {
        int i;
        this.blowupChainCount = 1;
        this.blowupChain[0] = nmb;
        for (i = 0; i < this.blowupChainCount; ++i) {
            this.getAllNeighbours(this.blowupChain[i]);
            for (int j = 0; j < 6; ++j) {
                boolean contains;
                if (this.neighbours[j] <= -1 || this.getImgByNmb(this.neighbours[j]).get_type() != this.getImgByNmb(this.blowupChain[i]).get_type()) continue;
                int k = 0;
                for (contains = false; k < this.blowupChainCount && !contains; contains |= this.blowupChain[k] == this.neighbours[j], ++k) {
                }
                if (contains) continue;
                if (this.blowupChainCount == this.blowupChain.length) {
                    int[] tmp = new int[this.blowupChainCount + 5];
                    System.arraycopy(this.blowupChain, 0, tmp, 0, this.blowupChainCount);
                    this.blowupChain = tmp;
                }
                this.blowupChain[this.blowupChainCount++] = this.neighbours[j];
            }
        }
        if (this.blowupChainCount >= 3) {
            this.imgElements[nmb].setEltState(false);
            for (i = 0; i < this.blowupChainCount; ++i) {
                imgSimple tmp_img = this.imgElements[this.blowupChain[i]];
                tmp_img.setEltState(false);
                if (tmp_img.getImgPoint().y > this.y_verify) continue;
                this.y_verify = tmp_img.getImgPoint().y - 38;
            }
        }
    }

    private void buildDropChain() {
        int i;
        if (this.y_verify < this.y_min && this.y_min > this.y_0) {
            int rows = this.allRowsCount;
            for (i = rows - 1; i >= 0; --i) {
                if (i == 0) {
                    this.y_verify = this.y_0;
                }
                if (this.allRows[i][9] >= this.y_verify || this.allRows[i][10] != 9) continue;
                this.y_verify = this.allRows[i][9];
                break;
            }
            this.y_min = this.y_verify;
        }
        if (this.y_min < this.y_0) {
            this.y_min = this.y_0;
            this.y_verify = this.y_0;
        }
        this.environsCount = 0;
        int lng = this.blowupChainCount;
        for (i = 0; i < lng; ++i) {
            this.getAllNeighbours(this.blowupChain[i]);
            for (int j = 0; j < 6; ++j) {
                if (this.neighbours[j] <= -1) continue;
                this.z = 0;
                while (this.z < this.environsCount && this.environs[this.z] != this.neighbours[j]) {
                    ++this.z;
                }
                if (this.z != this.environsCount || !this.getImgByNmb(this.neighbours[j]).getEltState()) continue;
                if (this.environsCount == this.environs.length) {
                    int[] tmp = new int[this.environsCount + 5];
                    System.arraycopy(this.environs, 0, tmp, 0, this.environsCount);
                    this.environs = tmp;
                }
                this.environs[this.environsCount++] = this.neighbours[j];
            }
        }
        this.dropChainString = "";
        String unDropChainString = "";
        this.tmpChainCount = 0;
        boolean undrop = false;
        while (this.environsCount > 0) {
            undrop = false;
            this.tmpChainCount = 1;
            this.tmpChain[0] = this.environs[0];
            --this.environsCount;
            System.arraycopy(this.environs, 1, this.environs, 0, this.environsCount);
            for (int i2 = 0; i2 < this.tmpChainCount; ++i2) {
                int index = this.tmpChain[i2];
                if (this.getImgByNmb((int)index).getImgPoint().y <= this.y_min || unDropChainString.indexOf(", " + index + ",") != -1) {
                    undrop = true;
                    unDropChainString = unDropChainString + ", " + this.tmpChain.toString().substring(1, this.tmpChain.toString().length() - 1) + ",";
                    break;
                }
                if (this.dropChainString.indexOf(", " + index + ",") != -1) {
                    this.dropChainString = this.dropChainString + ", " + this.tmpChain.toString().substring(1, this.tmpChain.toString().length() - 1) + ",";
                    break;
                }
                this.getAllNeighbours(index);
                for (int j = 0; j < 6; ++j) {
                    if (this.neighbours[j] <= -1 || !this.imgElements[this.neighbours[j]].getEltState()) continue;
                    this.z = 0;
                    while (this.z < this.tmpChainCount && this.tmpChain[this.z] != this.neighbours[j]) {
                        ++this.z;
                    }
                    if (this.z != this.tmpChainCount) continue;
                    if (this.tmpChainCount == this.tmpChain.length) {
                        int[] tmp = new int[this.tmpChainCount + 5];
                        System.arraycopy(this.tmpChain, 0, tmp, 0, this.tmpChainCount);
                        this.tmpChain = tmp;
                    }
                    this.z = this.tmpChainCount;
                    while (this.z > i2 + 1) {
                        this.tmpChain[this.z] = this.tmpChain[this.z - 1];
                        --this.z;
                    }
                    this.tmpChain[i2 + 1] = this.neighbours[j];
                    ++this.tmpChainCount;
                    this.z = 0;
                    while (this.z < this.environsCount && this.environs[this.z] != this.neighbours[j]) {
                        ++this.z;
                    }
                    if (this.z < this.environsCount) {
                        System.arraycopy(this.environs, this.z + 1, this.environs, this.z, this.environsCount - (this.z + 1));
                    }
                    if (this.getImgByNmb((int)this.neighbours[j]).getImgPoint().y <= this.y_min || unDropChainString.indexOf(", " + this.neighbours[j] + ",") != -1) {
                        undrop = true;
                        break;
                    }
                    if (this.dropChainString.indexOf(", " + this.neighbours[j] + ",") != -1) break;
                }
                if (!undrop) continue;
                this.z = 0;
                while (this.z < this.tmpChainCount) {
                    unDropChainString = unDropChainString + ", " + this.tmpChain[this.z];
                    ++this.z;
                }
                unDropChainString = unDropChainString + ",";
                break;
            }
            if (undrop) continue;
            this.z = 0;
            while (this.z < this.tmpChainCount) {
                this.dropChainString = this.dropChainString + ", " + this.tmpChain[this.z];
                ++this.z;
            }
            this.dropChainString = this.dropChainString + ",";
            this.dropChainString = this.dropChainString + ", " + this.tmpChain.toString().substring(1, this.tmpChain.toString().length() - 1) + ",";
        }
    }

    public float getSightAngle() {
        return this.sight_angle;
    }

    public void setSightAngle(float new_angle) {
        this.sight_angle = new_angle;
    }

    public void launchBird(float x, float y) {
        if (this.bullet_real_dx != 0.0f || this.bullet_real_dy != 0.0f) {
            return;
        }
        this.sight_angle = 4.712389f - Utils.atan((x - 168.0f - 19.0f) / (y - 557.0f - 19.0f));
        this.rotateBullet();
        this.getImgByNmb(this.imgElementsCount - 1).set_bitmap(this.bulletFrames[0]);
        this.currBulletFrame = 0;
        this.getImgByNmb(this.imgElementsCount - 1).setForce(this.bullet_speed, this.sight_angle);
        this.bullet_angle = this.sight_angle;
        SoundSystem.SOUND_SHOOT_LAUNCH[Utils.random(0, 6)].play();
    }

    private void rotateBullet() {
        this.bulletFrames = new Bitmap[2];
        imgSimple currBullet = this.imgElements[this.imgElementsCount - 1];
        Bitmap tmp_bmp = currBullet.get_type() < 13 ? ImagesResources.fly[currBullet.get_type() - 1] : ImagesResources.fly[currBullet.get_type() - 6];
        float angRad_1 = (float)((double)this.sight_angle + 1.5707963267948966);
        float angRad_2 = (float)(4.71238898038469 - (double)this.sight_angle);
        this.bulletFrames[0] = tmp_bmp.rotateImage(angRad_1);
        this.bulletFrames[1] = tmp_bmp.rotateImage(angRad_2);
    }

    public void switchFrame() {
        if (this.bulletFrames[0] == null || this.bulletFrames[1] == null) {
            this.rotateBullet();
        }
        if (this.currBulletFrame == 1) {
            this.currBulletFrame = 0;
            this.imgElements[this.imgElementsCount - 1].set_bitmap(this.bulletFrames[0]);
        } else {
            this.currBulletFrame = 1;
            this.imgElements[this.imgElementsCount - 1].set_bitmap(this.bulletFrames[1]);
        }
        SoundSystem.SOUND_SHOOT_LAUNCH[Utils.random(0, SoundSystem.SOUND_SHOOT_LAUNCH.length - 1)].play();
    }

    private int[] getAllNeighbours(int id) {
        int[] elts = this.neighbours;
        int row = Math.abs((this.allRows[0][9] - this.getImgByNmb((int)id).getImgPoint().y) / 38);
        int padding = 0;
        if (row % 2 != 0) {
            padding = 19;
        }
        int column = (this.getImgByNmb((int)id).getImgPoint().x - padding) / 38;
        padding = padding == 0 ? -1 : 1;
        elts[0] = row - 1 < 0 || row - 1 >= this.allRows.length || this.allRows[row - 1] == null || column >= this.allRows[row - 1].length ? -2 : this.allRows[row - 1][column];
        elts[1] = column + padding > 8 || column + padding < 0 || row - 1 < 0 || row - 1 >= this.allRows.length || this.allRows[row - 1] == null || column + padding >= this.allRows[row - 1].length ? -2 : this.allRows[row - 1][column + padding];
        elts[2] = column + 1 > 8 || row >= this.allRows.length || this.allRows[row] == null || column + 1 >= this.allRows[row].length ? -2 : this.allRows[row][column + 1];
        elts[3] = row + 1 >= this.allRows.length || this.allRows[row + 1] == null || column >= this.allRows[row + 1].length ? -2 : this.allRows[row + 1][column];
        elts[4] = column + padding > 8 || column + padding < 0 || row + 1 >= this.allRows.length || this.allRows[row + 1] == null || column + padding >= this.allRows[row + 1].length ? -2 : this.allRows[row + 1][column + padding];
        elts[5] = column - 1 < 0 || row >= this.allRows.length || this.allRows[row] == null || column - 1 >= this.allRows[row].length ? -2 : this.allRows[row][column - 1];
        return elts;
    }

    private int[] getAllFree(int id) {
        int tmp_elt;
        int row = Math.abs((this.allRows[0][9] - this.getImgByNmb((int)id).getImgPoint().y) / 38);
        int padding = 0;
        if (row % 2 != 0) {
            padding = 19;
        }
        int column = (this.getImgByNmb((int)id).getImgPoint().x - padding) / 38;
        padding = padding == 0 ? -1 : 1;
        if (row - 1 >= 0 && this.allRows.length > row - 1 && this.allRows[row - 1] != null && this.allRows[row - 1].length > column) {
            tmp_elt = this.allRows[row - 1][column];
            if (tmp_elt == -1) {
                this.elts[0] = row - 1;
                this.elts[1] = column;
            } else {
                this.elts[0] = -2;
                this.elts[1] = -2;
            }
        } else {
            this.elts[0] = row - 1;
            this.elts[1] = column;
        }
        if (column + padding > 8 || column + padding < 0) {
            this.elts[2] = -2;
            this.elts[3] = -2;
        } else if (row - 1 >= 0 && this.allRows.length > row - 1 && this.allRows[row - 1] != null && this.allRows[row - 1].length > column + padding) {
            tmp_elt = this.allRows[row - 1][column + padding];
            if (tmp_elt == -1) {
                this.elts[2] = row - 1;
                this.elts[3] = column + padding;
            } else {
                this.elts[2] = -2;
                this.elts[3] = -2;
            }
        } else {
            this.elts[2] = row - 1;
            this.elts[3] = column + padding;
        }
        if (column + 1 > 8) {
            this.elts[4] = -2;
            this.elts[5] = -2;
        } else if (this.allRows.length > row && this.allRows[row] != null && this.allRows[row].length > column + 1) {
            tmp_elt = this.allRows[row][column + 1];
            if (tmp_elt == -1) {
                this.elts[4] = row;
                this.elts[5] = column + 1;
            } else {
                this.elts[4] = -2;
                this.elts[5] = -2;
            }
        } else {
            this.elts[4] = row;
            this.elts[5] = column + 1;
        }
        if (this.allRows.length > row + 1 && this.allRows[row + 1] != null && this.allRows[row + 1].length > column) {
            tmp_elt = this.allRows[row + 1][column];
            if (tmp_elt == -1) {
                this.elts[6] = row + 1;
                this.elts[7] = column;
            } else {
                this.elts[6] = -2;
                this.elts[7] = -2;
            }
        } else {
            this.elts[6] = row + 1;
            this.elts[7] = column;
        }
        if (column + padding > 8 || column + padding < 0) {
            this.elts[8] = -2;
            this.elts[9] = -2;
        } else if (this.allRows.length > row + 1 && this.allRows[row + 1] != null && this.allRows[row + 1].length > column + padding) {
            tmp_elt = this.allRows[row + 1][column + padding];
            if (tmp_elt == -1) {
                this.elts[8] = row + 1;
                this.elts[9] = column + padding;
            } else {
                this.elts[8] = -2;
                this.elts[9] = -2;
            }
        } else {
            this.elts[8] = row + 1;
            this.elts[9] = column + padding;
        }
        if (column - 1 < 0) {
            this.elts[10] = -2;
            this.elts[11] = -2;
        } else if (column - 1 >= 0 && this.allRows.length > row && this.allRows[row] != null && this.allRows[row].length > column - 1) {
            tmp_elt = this.allRows[row][column - 1];
            if (tmp_elt == -1) {
                this.elts[10] = row;
                this.elts[11] = column - 1;
            } else {
                this.elts[10] = -2;
                this.elts[11] = -2;
            }
        } else {
            this.elts[10] = row;
            this.elts[11] = column - 1;
        }
        return this.elts;
    }

    public void setGameState(int new_state) {
        this.gameState = new_state;
    }

    public void SaveGame() {
        String level_map = "";
        int rows = this.allRowsCount;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < 9; ++j) {
                level_map = this.allRows[i][j] != -1 ? level_map + this.getImgByNmb(this.allRows[i][j]).get_type() + "|" : level_map + "42|";
            }
        }
        DataManager.levelData.setElements(level_map);
        DataManager.levelData.setYMin(this.y_min);
        DataManager.levelData.setY0(this.y_0);
        DataManager.levelData.setYVer(this.y_verify);
        DataManager.levelData.setBulletCurr(this.bullet_curr_type);
        DataManager.levelData.setBulletNext(this.bullet_next_type);
        DataManager.levelData.setDy(this.dy);
        DataManager.levelData.setRealDy(this.real_dy);
        DataManager.levelData.setSightAngle(this.getSightAngle());
        DataManager.levelData.setScoreMlt(this.score_mlt);
        DataManager.saveLevel();
    }

    public void LoadGame() {
        this.imgElementsCount = 0;
        this.allRowsCount = 0;
        this.blowupChainCount = 0;
        this.constElementCount = 0;
        this.constBackElementCount = 0;
        this.environsCount = 0;
        this.tmpChainCount = 0;
        this.y_min = DataManager.levelData.getYMin();
        this.y_0 = DataManager.levelData.getY0();
        this.y_verify = DataManager.levelData.getYVer();
        this.addConstElement(ImagesResources.eggs[0], 149, 550, false);
        this.addConstElement(ImagesResources.nest[DataManager.levelData.getBgIndex()], 132, 569, true);
        this.addConstElement(0, 267, 590, 1, true);
        this.addConstElement(5, 48, 590, 2, true);
        this.addConstElement(0, 165, 591, 3, true);
        this.dy = DataManager.levelData.getDy();
        this.real_dy = DataManager.levelData.getRealDy();
        this.sight_angle = DataManager.levelData.getSightAngle();
        this.score_mlt = DataManager.levelData.getScoreMlt();
        float birdSpeed = (float)(DataManager.getGameSpeed() + 2) / 10.0f;
        this.addElement(0, ImagesResources.game_seiling, 0, this.y_0 - ImagesResources.game_seiling.getHeight());
        this.setForce(0, birdSpeed, 1.5707964f);
        String[] lvl_map = Utils.stringToWords(DataManager.levelData.getElements());
        int rows = lvl_map.length / 9;
        for (int i = 0; i < rows; ++i) {
            int[] newRow = new int[14];
            int cnt = 0;
            int padding = 0;
            if (i % 2 != 0) {
                padding = 19;
            }
            for (int j = 0; j < 9; ++j) {
                int img_type = Integer.parseInt(lvl_map[i * 9 + j]);
                if (img_type != 42) {
                    this.addBird(img_type, padding + j * 38, this.y_0 + i * 38);
                    newRow[j] = this.imgElementsCount - 1;
                    this.setForce(newRow[j], birdSpeed, 1.5707964f);
                    ++cnt;
                    continue;
                }
                newRow[j] = -1;
            }
            newRow[10] = cnt;
            newRow[9] = this.y_0 + i * 38;
            if (this.allRowsCount == this.allRows.length) {
                int[][] tmp = new int[this.allRowsCount + 5][];
                System.arraycopy(this.allRows, 0, tmp, 0, this.allRowsCount);
                this.allRows = tmp;
            }
            this.allRows[this.allRowsCount++] = newRow;
        }
        this.bullet_next_type = DataManager.levelData.getBulletCurr();
        this.addBullet();
        this.bullet_curr_type = DataManager.levelData.getBulletCurr();
        this.bullet_next_type = DataManager.levelData.getBulletNext();
        if (this.bullet_next_type > 7) {
            this.constBackElement[0].setLogo(ImagesResources.eggs[this.bullet_next_type - 6]);
        } else {
            this.constBackElement[0].setLogo(ImagesResources.eggs[this.bullet_next_type - 1]);
        }
    }
}

