/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.screen;

import com.ximad.bubble_birds_2.audio.SoundSystem;
import com.ximad.bubble_birds_2.component.CustomIntButton;
import com.ximad.bubble_birds_2.component.CustomIntField;
import com.ximad.bubble_birds_2.component.LevelButtonsBox;
import com.ximad.bubble_birds_2.engine.Application;
import com.ximad.bubble_birds_2.engine.CustomButton;
import com.ximad.bubble_birds_2.engine.UiScreen;
import com.ximad.bubble_birds_2.game.DataManager;
import com.ximad.bubble_birds_2.res.ImagesResources;
import com.ximad.bubble_birds_2.screen.GamePopupScreen;
import com.ximad.bubble_birds_2.screen.GameScreen;
import com.ximad.bubble_birds_2.screen.HomeScreen;
import com.ximad.bubble_birds_2.utils.Utils;
import javax.microedition.lcdui.Graphics;

public class ShopScreen
extends UiScreen {
    private static ShopScreen instance;
    private CustomIntButton[] levelButtons;
    private CustomButton backButton;
    private CustomButton buyLifeButton;
    private CustomIntField moneyField;
    private LevelButtonsBox itemsList;

    public ShopScreen() {
        this.init();
    }

    public void init() {
        this.itemsList = new LevelButtonsBox(233, 312, 5);
        this.backButton = new CustomButton(ImagesResources.settingsBackOff, ImagesResources.settingsBackOn, null, null){

            protected void touchAction() {
                ShopScreen.this.playButtonSound();
                ShopScreen.this.backButtonAction();
            }
        };
        if (DataManager.levelData.getAllMoney() >= 100) {
            this.buyLifeButton = new CustomButton(ImagesResources.shopBuyLifeOff, ImagesResources.shopBuyLifeOn, null, null){

                protected void touchAction() {
                    ShopScreen.this.playButtonSound();
                    ShopScreen.this.buyLifeAction();
                }
            };
        } else {
            this.buyLifeButton = new CustomButton(ImagesResources.shopBuyLifeDis, ImagesResources.shopBuyLifeDis, null, null){

                protected void touchAction() {
                    ShopScreen.this.playButtonSound();
                    ShopScreen.this.buyLifeAction();
                }
            };
            this.buyLifeButton.setEnabled(false);
        }
        this.levelButtons = new CustomIntButton[100];
        for (int i = 0; i < 100; ++i) {
            final int _i_copy = i;
            if (DataManager.levelData.getPassedLvl().indexOf("|" + (i + 1) + "|") != -1) {
                this.levelButtons[i] = new CustomIntButton(ImagesResources.shopLvlOpenOff, ImagesResources.shopLvlOpenOn, i + 1, ImagesResources.font_green){

                    protected void touchAction() {
                        ShopScreen.this.playButtonSound();
                        ShopScreen.this.lvlButtonAction(_i_copy);
                    }
                };
            } else if (DataManager.levelData.getAllMoney() >= (int)(15.0f + Utils.pow((float)(i + 1), 1.5f))) {
                this.levelButtons[i] = new CustomIntButton(ImagesResources.shopLvlCloseOff, ImagesResources.shopLvlCloseOn, i + 1, ImagesResources.font_yellow){

                    protected void touchAction() {
                        ShopScreen.this.playButtonSound();
                        ShopScreen.this.lvlButtonAction(_i_copy);
                    }
                };
            } else {
                this.levelButtons[i] = new CustomIntButton(ImagesResources.shopLvlBlockOff, ImagesResources.shopLvlBlockOff, i + 1, ImagesResources.font_yellow){

                    protected void touchAction() {
                        ShopScreen.this.playButtonSound();
                        ShopScreen.this.lvlButtonAction(_i_copy);
                    }
                };
                this.levelButtons[i].setEnabled(false);
            }
            this.levelButtons[i].setDigitOffsetY(6);
        }
        int dx = 52;
        int dy = 62;
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.itemsList.add(this.levelButtons[i * 5 + j]);
            }
        }
        this.moneyField = new CustomIntField(DataManager.levelData.getAllMoney(), 226, 487, ImagesResources.font_coins);
        int width = 360;
        int height = 640;
        this.add(this.moneyField, 0, 0);
        this.add(this.backButton, 11, 553);
        this.add(this.buyLifeButton, 246, 502);
        this.add(this.itemsList, 70, 170);
    }

    private void backButtonAction() {
        DataManager.game_flag = false;
        DataManager.shop_flag = true;
        Application.setScreen(HomeScreen.getInstance());
    }

    private void buyLifeAction() {
        Application.setScreen(GamePopupScreen.getInstance(8, 0, 100));
    }

    private void lvlButtonAction(int btnIndex) {
        if (DataManager.levelData.getPassedLvl().indexOf("|" + (btnIndex + 1) + "|") != -1) {
            DataManager.levelData.setCurrLvl(btnIndex + 1);
            Application.setScreen(GameScreen.getInstance(btnIndex + 1));
        } else if (DataManager.levelData.getAllMoney() >= (int)(15.0f + Utils.pow((float)(btnIndex + 1), 1.5f))) {
            Application.setScreen(GamePopupScreen.getInstance(7, btnIndex + 1, (int)(15.0f + Utils.pow((float)(btnIndex + 1), 1.5f))));
        }
    }

    public void onPaint(Graphics g) {
        ImagesResources.shopBg.draw(g, 0, 0);
        super.onPaint(g);
    }

    public static ShopScreen getInstance() {
        if (instance == null) {
            instance = new ShopScreen();
        } else {
            instance.refreshButtons();
        }
        return instance;
    }

    private void playButtonSound() {
        try {
            SoundSystem.SOUND_BUTTON.play();
        }
        catch (Error error) {
            // empty catch block
        }
    }

    private void refreshButtons() {
        if (DataManager.levelData.getAllMoney() >= 100) {
            this.buyLifeButton.setOffImage(ImagesResources.shopBuyLifeOff);
            this.buyLifeButton.setOnImage(ImagesResources.shopBuyLifeOn);
            this.buyLifeButton.setEnabled(true);
        } else {
            this.buyLifeButton.setOffImage(ImagesResources.shopBuyLifeDis);
            this.buyLifeButton.setOnImage(ImagesResources.shopBuyLifeDis);
            this.buyLifeButton.setEnabled(false);
        }
        this.moneyField.set_int(DataManager.levelData.getAllMoney());
        for (int i = 0; i < 100; ++i) {
            if (DataManager.levelData.getPassedLvl().indexOf("|" + (i + 1) + "|") != -1) {
                this.levelButtons[i].setOffImage(ImagesResources.shopLvlOpenOff);
                this.levelButtons[i].setOnImage(ImagesResources.shopLvlOpenOn);
                this.levelButtons[i].setFont(ImagesResources.font_green);
                this.levelButtons[i].setEnabled(true);
                continue;
            }
            if (DataManager.levelData.getAllMoney() >= (int)(15.0f + Utils.pow((float)(i + 1), 1.5f))) {
                this.levelButtons[i].setOffImage(ImagesResources.shopLvlCloseOff);
                this.levelButtons[i].setOnImage(ImagesResources.shopLvlCloseOff);
                this.levelButtons[i].setFont(ImagesResources.font_yellow);
                this.levelButtons[i].setEnabled(true);
                continue;
            }
            this.levelButtons[i].setOffImage(ImagesResources.shopLvlBlockOff);
            this.levelButtons[i].setOnImage(ImagesResources.shopLvlBlockOff);
            this.levelButtons[i].setFont(ImagesResources.font_yellow);
            this.levelButtons[i].setEnabled(false);
        }
    }
}

