/*
 * Decompiled with CFR 0.152.
 */
package com.linkyun.tools;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class MusicPlayer {
    public static boolean m_bSound = false;
    private static int m_nSoundVolumeIndex = 5;
    private static Player m_Player = null;
    private static VolumeControl vc = null;
    public static String m_sSoundName = "";

    private MusicPlayer() {
    }

    public static int getSoundVolume() {
        return m_nSoundVolumeIndex;
    }

    public static void setMusicVolume(int VolumeIndex) {
        if (!m_bSound) {
            return;
        }
        if ((VolumeIndex = m_nSoundVolumeIndex + VolumeIndex) < 0 || VolumeIndex > 10) {
            return;
        }
        m_nSoundVolumeIndex = VolumeIndex;
        if (vc != null) {
            vc.setLevel(VolumeIndex * 10);
        }
    }

    private static void createMusic(String sSoundName, int nLoopCnt) {
        MusicPlayer.stopMusic();
        String sSoundType = "audio/midi";
        if (sSoundName.indexOf(".wav") > -1) {
            sSoundType = "audio/x-wav";
        }
        if (sSoundName.indexOf(".mp3") > -1) {
            sSoundType = "audio/mpeg";
        } else if (sSoundType.indexOf(".amr") > -1) {
            sSoundType = "audio/amr";
        }
        try {
            m_Player = Manager.createPlayer((InputStream)"".getClass().getResourceAsStream(sSoundName), (String)sSoundType);
            m_Player.realize();
            m_Player.prefetch();
            vc = (VolumeControl)m_Player.getControl("VolumeControl");
            m_Player.setLoopCount(nLoopCnt);
            m_Player.start();
        }
        catch (IOException ex) {
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
        m_sSoundName = sSoundName;
    }

    public static void playMusic(String sSoundName, int nLoopCnt) {
        if (!m_bSound) {
            return;
        }
        if (sSoundName.equals(m_sSoundName)) {
            try {
                if (m_Player != null) {
                    if (m_Player.getState() == 300) {
                        m_Player.setMediaTime(-1L);
                    }
                    m_Player.start();
                    return;
                }
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
        MusicPlayer.createMusic(sSoundName, nLoopCnt);
    }

    public static void pauseMusic() {
        if (m_Player == null) {
            return;
        }
        try {
            m_Player.stop();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public static void stopMusic() {
        vc = null;
        if (m_Player == null) {
            return;
        }
        try {
            m_Player.stop();
            m_Player.close();
            m_Player = null;
            m_sSoundName = "";
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public static int checkMusicState() {
        if (m_Player == null) {
            return 999;
        }
        return m_Player.getState();
    }
}

