/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class MySound
implements Runnable {
    public static final String[] soundName = new String[]{"/sound/menu.mid", "/sound/levelup.mid"};
    public Player[] playerArr = new Player[soundName.length];
    private int prevPlayerNo;
    private MyCanvas canvas;
    private Vector soundVector;
    private boolean flag;
    static long soundDuration = 0L;
    static long soundStartTime = 0L;

    MySound(MyCanvas canvas) {
        this.canvas = canvas;
        this.soundVector = new Vector(11);
        this.loadSounds();
    }

    public void loadSounds() {
        try {
            for (int i = 0; i < this.playerArr.length; ++i) {
                System.out.println(">>" + i);
                InputStream localInputStream = super.getClass().getResourceAsStream(soundName[i]);
                Player localPlayer = Manager.createPlayer((InputStream)localInputStream, (String)"audio/midi");
                localPlayer.setLoopCount(1);
                localPlayer.realize();
                this.playerArr[i] = localPlayer;
            }
            this.prevPlayerNo = -1;
            this.flag = true;
            MyCanvas.soundOn = true;
            Thread localThread = new Thread(this);
            localThread.setPriority(1);
            localThread.start();
        }
        catch (Exception localException2) {
            System.out.println("err in jdMethod_new localException2>>" + localException2);
            MyCanvas.soundOn = false;
            for (int j = 0; j < this.playerArr.length; ++j) {
                this.playerArr[j] = null;
            }
            this.prevPlayerNo = -1;
        }
    }

    public synchronized void sound0() {
        if (MyCanvas.soundOn) {
            this.soundVector.addElement(new Integer(0));
            super.notify();
        }
    }

    public synchronized void sound1() {
        if (MyCanvas.soundOn) {
            this.soundVector.addElement(new Integer(1));
            super.notify();
        }
    }

    public synchronized void sound2() {
        if (MyCanvas.soundOn) {
            this.soundVector.addElement(new Integer(2));
            super.notify();
        }
    }

    public synchronized void sound3() {
        if (MyCanvas.soundOn) {
            this.soundVector.addElement(new Integer(3));
            super.notify();
        }
    }

    public synchronized void sound4() {
        if (MyCanvas.soundOn) {
            this.soundVector.addElement(new Integer(4));
            super.notify();
        }
    }

    public synchronized void sound5() {
        if (MyCanvas.soundOn) {
            this.soundVector.addElement(new Integer(5));
            super.notify();
        }
    }

    public synchronized void sound6() {
        if (MyCanvas.soundOn) {
            this.soundVector.addElement(new Integer(6));
            super.notify();
        }
    }

    private void PlaySound(int paramInt) {
        if (System.currentTimeMillis() < soundStartTime + soundDuration) {
            return;
        }
        if (this.playerArr[paramInt] != null) {
            try {
                if (this.prevPlayerNo != -1) {
                    this.playerArr[this.prevPlayerNo].stop();
                }
                try {
                    this.playerArr[paramInt].setMediaTime(0L);
                }
                catch (Exception localException1) {
                    System.out.println("err in PlaySound localException1>>" + localException1);
                }
                soundDuration = this.playerArr[paramInt].getDuration() / 1000L;
                soundStartTime = System.currentTimeMillis();
                if (paramInt == 0) {
                    this.playerArr[paramInt].setLoopCount(-1);
                }
                this.playerArr[paramInt].start();
                this.prevPlayerNo = paramInt;
            }
            catch (Exception localException2) {
                System.out.println("err in PlaySound localException2>>" + localException2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Integer localInteger = null;
        while (true) {
            MySound mySound = this;
            synchronized (mySound) {
                try {
                    while (this.flag && this.soundVector.isEmpty()) {
                        super.wait();
                    }
                    if (!this.flag) {
                        return;
                    }
                    localInteger = (Integer)this.soundVector.firstElement();
                    this.soundVector.removeElementAt(0);
                }
                catch (InterruptedException localInterruptedException) {
                    System.out.println("err in run localInterruptedException>>" + localInterruptedException);
                }
            }
            if (this.soundVector.size() > 3) {
                this.clearSounds();
            }
            this.PlaySound(localInteger);
        }
    }

    public synchronized void stopSound(int i) {
        if (this.soundVector != null) {
            this.soundVector.removeAllElements();
        }
        this.flag = false;
        super.notify();
    }

    public synchronized void stopSound1(int i) {
        try {
            if (this.playerArr[i] != null && this.playerArr[i].getState() == 400) {
                this.playerArr[i].stop();
            }
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    private Player CreatePlayer(String s, String s1) {
        Player player = null;
        try {
            InputStream inputstream = this.getClass().getResourceAsStream(s);
            player = Manager.createPlayer((InputStream)inputstream, (String)s1);
            player.setLoopCount(1);
            player.realize();
        }
        catch (Exception e) {
            System.out.println("err iin CreatePlayer>>>" + e);
        }
        return player;
    }

    public synchronized void clearSounds() {
        try {
            soundStartTime = 0L;
            soundDuration = 0L;
            for (int i = 0; i < this.playerArr.length; ++i) {
                if (this.playerArr[i].getState() != 400) continue;
                this.playerArr[i].stop();
            }
            this.soundVector.removeAllElements();
            super.notify();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

