/*
 * Decompiled with CFR 0.152.
 */
package sheet;

import java.util.EmptyStackException;
import java.util.Stack;
import sheet.Calculator;
import sheet.CellCalc$IntegerStack;
import sheet.Operand;
import sheet.Operation;

public final class CellCalc {
    private static final short STACK_DEPTH = 10;
    private static final short SYM_DATA = 1;
    private static final short SYM_OPEN_BR = 2;
    private static final short SYM_CLOSE_BR = 3;
    private static final short SYM_DELIMITER = 4;
    private static final short SYM_OPERATION = 5;
    private static final short SYM_STRING = 6;
    private static final short SYM_COMMA = 7;
    private static final short PUSH_NO = 0;
    private static final short PUSH_OPERATION = 1;
    private static final short PUSH_DATA = 2;
    private static final short PUSH_FUNCTION = 3;
    private static final Operation[] OPS = new Operation[]{new Operation(0, 0, 4, '+'), new Operation(1, 0, 4, '-'), new Operation(2, 2, 2, '+'), new Operation(3, 2, 2, '-'), new Operation(4, 2, 3, '*'), new Operation(5, 2, 3, '/'), new Operation(6, 3, 5, '\u0000')};
    private Calculator callBack;
    private CellCalc$IntegerStack operations = new CellCalc$IntegerStack(null);
    private Stack operands = new Stack();
    private String expression;
    private short last_push;
    private short fargs;

    public CellCalc(Calculator calculator) {
        this.callBack = calculator;
    }

    private static short symbolType(char c) {
        switch (c) {
            case '(': {
                return 2;
            }
            case ')': {
                return 3;
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return 4;
            }
            case '*': 
            case '+': 
            case '-': 
            case '/': {
                return 5;
            }
            case '\"': {
                return 6;
            }
            case ',': {
                return 7;
            }
        }
        return 1;
    }

    private boolean execute(boolean bl, int n) throws RuntimeException {
        short s;
        try {
            s = this.operations.pop();
        }
        catch (EmptyStackException emptyStackException) {
            return false;
        }
        if (s == 7) {
            if (bl) {
                this.operations.push(s);
            }
            return false;
        }
        if (n > CellCalc.OPS[s].priority) {
            this.operations.push(s);
            return false;
        }
        switch (CellCalc.OPS[s].type) {
            case 2: {
                try {
                    Operand operand = (Operand)this.operands.pop();
                    Operand operand2 = (Operand)this.operands.pop();
                    this.operands.push(this.callBack.oper(s, operand2, operand));
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw illegalArgumentException;
                }
                catch (RuntimeException runtimeException) {
                    throw new IllegalArgumentException(Operation.OPNAME[s] + " ops are wrong");
                }
            }
            case 3: {
                Operand[] operandArray = new Operand[this.fargs];
                short s2 = 0;
                while (s2 < this.fargs) {
                    operandArray[this.fargs - s2 - 1] = (Operand)this.operands.pop();
                    s2 = (short)(s2 + 1);
                }
                this.fargs = 0;
                this.operands.push(this.callBack.call(Operand.getName((Operand)this.operands.pop()), operandArray));
                break;
            }
            default: {
                this.operands.push(this.callBack.oper(s, (Operand)this.operands.pop(), null));
            }
        }
        return true;
    }

    private short pushOperand(short s, short s2) throws IllegalArgumentException {
        if (s != s2) {
            Operand operand = null;
            if (this.last_push == 3) {
                operand = new CellCalc(this.callBack).calculate(this.expression, s, s2);
                this.operands.push(operand);
                this.fargs = (short)(this.fargs + 1);
            } else {
                operand = new Operand(this.expression.substring(s, s2));
                this.operands.push(operand);
                this.last_push = (short)2;
            }
        }
        return (short)(s2 + 1);
    }

    public Operand calculate(String string, short s, short s2) throws IllegalArgumentException {
        short s3 = s;
        short s4 = s;
        int n = 0;
        while (!this.operands.empty()) {
            this.operands.pop();
        }
        this.operations.clear();
        this.last_push = 0;
        this.expression = string;
        while (s3 < s2) {
            char c = string.charAt(s3);
            switch (CellCalc.symbolType(c)) {
                case 2: {
                    if (this.last_push == 3) {
                        n = (short)(n + 1);
                        break;
                    }
                    s4 = this.pushOperand(s4, s3);
                    if (this.last_push == 2) {
                        this.operations.push((short)6);
                        this.last_push = (short)3;
                        this.fargs = 0;
                        n = 1;
                        break;
                    }
                    this.operations.push((short)7);
                    this.last_push = 1;
                    break;
                }
                case 3: {
                    if (this.last_push == 3) {
                        n = (short)(n - 1);
                    }
                    if (n != 0) break;
                    s4 = this.pushOperand(s4, s3);
                    while (this.execute(false, 0)) {
                        this.last_push = (short)2;
                    }
                    break;
                }
                case 7: {
                    if (n != true) break;
                    s4 = this.pushOperand(s4, s3);
                    break;
                }
                case 6: {
                    if (s3 != s4) {
                        throw new IllegalArgumentException("\" inside text");
                    }
                    while ((s3 = (short)(s3 + 1)) < s2 && CellCalc.symbolType(string.charAt(s3)) != 6) {
                    }
                    if (s3 < s2) {
                        s3 = (short)(s3 + 1);
                        s4 = this.pushOperand(s4, s3);
                        short s5 = s3;
                        s3 = (short)(s5 - 1);
                        s4 = s5;
                        break;
                    }
                    throw new IllegalArgumentException("No ending \"");
                }
                case 4: {
                    if (this.last_push == 3) break;
                    s4 = this.pushOperand(s4, s3);
                    break;
                }
                case 5: {
                    if (this.last_push == 3) break;
                    s4 = this.pushOperand(s4, s3);
                    short s6 = Operation.find(OPS, c, this.last_push != 2);
                    try {
                        while (this.execute(true, CellCalc.OPS[s6].priority)) {
                            this.last_push = (short)2;
                        }
                        this.operations.push(s6);
                        this.last_push = 1;
                        if (CellCalc.OPS[s6].type != 1) break;
                        while (this.execute(true, CellCalc.OPS[s6].priority)) {
                            this.last_push = (short)2;
                        }
                        break;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new IllegalArgumentException("Bad " + String.valueOf(c));
                    }
                }
            }
            s3 = (short)(s3 + 1);
        }
        this.pushOperand(s4, s3);
        while (this.execute(true, 0)) {
        }
        if (!this.operations.isEmpty()) {
            throw new IllegalArgumentException(Operation.OPNAME[this.operations.pop()] + " doesn't have a match");
        }
        return this.callBack.oper((short)0, (Operand)this.operands.pop(), null);
    }
}

