/*
 * Decompiled with CFR 0.152.
 */
package sheet;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import sheet.Backable;
import sheet.Cell;
import sheet.CellResize;
import sheet.Quitable;
import sheet.SheetShow$1;
import sheet.SheetShow$10;
import sheet.SheetShow$11;
import sheet.SheetShow$12;
import sheet.SheetShow$13;
import sheet.SheetShow$2;
import sheet.SheetShow$4;
import sheet.SheetShow$8;
import sheet.SheetShow$9;
import sheet.Table;

final class SheetShow
extends Canvas
implements CommandListener,
Backable {
    private static final short TBL_WIDTH = 10;
    private static final short TBL_HEIGHT = 9;
    private static final short M_CELL_DATA = 0;
    private static final short M_CELL_FORMAT = 1;
    private static final short M_RECALC = 2;
    private static final short M_FILE = 3;
    private static final short M_CANCEL = 4;
    private static final short M_HELP = 5;
    private static final short M_E_COLOUR = 6;
    private static final short M_E_ALIGN = 7;
    private static final short MCD_EDIT = 0;
    private static final short MCD_CLEAR = 1;
    private static final short MCD_COPY = 2;
    private static final short MCD_PASTE = 3;
    private static final short MCD_BACK = 4;
    private static final short MCF_SIZE = 0;
    private static final short MCF_COLOUR = 1;
    private static final short MCF_ALIGN = 2;
    private static final short MCF_BACK = 3;
    private static final short MFM_NEW = 0;
    private static final short MFM_LOAD = 1;
    private static final short MFM_SAVE = 2;
    private static final short MFM_EXIT = 3;
    private static final short MFM_BACK = 4;
    private static final Command[] COMMANDS = new Command[]{new Command("\u0414\u0430\u043d\u043d\u044b\u0435 \u044f\u0447\u0435\u0439\u043a\u0438", 1, 0), new Command("\u0424\u043e\u0440\u043c\u0430\u0442 \u044f\u0447\u0435\u0439\u043a\u0438", 1, 1), new Command("\u041f\u043e\u0432\u0442\u043e\u0440\u043d\u043e \u0432\u044b\u0447\u0438\u0441\u043b\u0438\u0442\u044c", 1, 2), new Command("\u0424\u0430\u0439\u043b", 1, 3), new Command("\u041e\u0442\u043c\u0435\u043d\u0430", 3, 4), new Command("\u041f\u043e\u043c\u043e\u0449\u044c", 5, 5)};
    private static final List[] MENUS = new List[]{new List("\u0414\u0430\u043d\u043d\u044b\u0435 \u044f\u0447\u0435\u0439\u043a\u0438", 3, new String[]{"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u044f\u0447\u0435\u0439\u043a\u0443", "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u044f\u0447\u0435\u0439\u043a\u0443", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c", "\u041d\u0430\u0437\u0430\u0434 \u043a \u043b\u0438\u0441\u0442\u0443"}, null), new List("\u0424\u043e\u0440\u043c\u0430\u0442 \u044f\u0447\u0435\u0439\u043a\u0438", 3, new String[]{"\u0420\u0430\u0437\u043c\u0435\u0440 \u044f\u0447\u0435\u0439\u043a\u0438", "\u0426\u0432\u0435\u0442 \u044f\u0447\u0435\u0439\u043a\u0438", "\u0412\u044b\u0440\u0430\u0432\u043d\u0438\u0432\u0430\u043d\u0438\u0435 \u044f\u0447\u0435\u0439\u043a\u0438", "\u041d\u0430\u0437\u0430\u0434 \u043a \u043b\u0438\u0441\u0442\u0443"}, null), null, new List("\u0424\u0430\u0439\u043b", 3, new String[]{"\u041d\u043e\u0432\u044b\u0439 \u043b\u0438\u0441\u0442", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", "\u0412\u044b\u0445\u043e\u0434", "\u041d\u0430\u0437\u0430\u0434 \u043a \u043b\u0438\u0441\u0442\u0443"}, null), null, null};
    private static final Command okCommand = new Command("\u041e\u043a", 4, 1);
    private static final Command cancelCommand = new Command("\u041e\u0442\u043c\u0435\u043d\u0430", 3, 1);
    private static int appWidth;
    private static int appHeight;
    private static Display display;
    private static Quitable winQuit;
    private Table data;
    private Cell clipBoard;
    private boolean moved;

    public SheetShow() {
        int n = 0;
        while (n < COMMANDS.length) {
            this.addCommand(COMMANDS[n]);
            ++n;
        }
        appWidth = this.getWidth();
        appHeight = this.getHeight();
        this.data = this.newSheet();
        this.moved = true;
        try {
            Class.forName("sheet.Cell");
            Class.forName("sheet.Operation");
            Class.forName("sheet.CellCalc");
            Class.forName("sheet.CellCalc$IntegerStack");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void show(Display display, Quitable quitable) {
        winQuit = quitable;
        SheetShow.display = display;
        this.show();
    }

    public void show() {
        display.setCurrent((Displayable)this);
        this.setCommandListener(this);
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, appWidth, appHeight);
        this.data.paint(graphics, appWidth, appHeight, 0);
    }

    private void actualSave(String string) {
        try {
            this.data.save(string);
            this.show();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Alert alert = new Alert("\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u0430\u0439\u043b\u0430", illegalArgumentException.getMessage(), null, AlertType.ERROR);
            display.setCurrent(alert, (Displayable)this);
        }
    }

    private void actualLoad(String string) {
        try {
            Table table;
            this.data = table = Table.load(string);
            if (this.data != null) {
                this.data.calculate();
            }
            this.show();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Alert alert = new Alert("\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u0430\u0439\u043b\u0430", illegalArgumentException.getMessage(), null, AlertType.ERROR);
            display.setCurrent(alert, (Displayable)this);
        }
    }

    private void showWait(String string, Runnable runnable) {
        SheetShow$1 sheetShow$1 = new SheetShow$1(this, string, runnable);
        display.setCurrent((Displayable)sheetShow$1);
    }

    private void save(Runnable runnable) {
        TextBox textBox = new TextBox("\u0412\u0432\u0435\u0441\u0442\u0438 \u0438\u043c\u044f \u043b\u0438\u0441\u0442\u0430", this.data.getName(), 32, 4);
        textBox.setCommandListener((CommandListener)new SheetShow$2(this, runnable));
        textBox.addCommand(okCommand);
        textBox.addCommand(cancelCommand);
        display.setCurrent((Displayable)textBox);
    }

    private void load() {
        SheetShow sheetShow = this;
        this.showWait("\u0427\u0442\u0435\u043d\u0438\u0435...", new SheetShow$4(this, (Displayable)sheetShow));
    }

    private void checkModified(Runnable runnable) {
        if (this.data.isChanged()) {
            Command command = new Command("\u0414\u0430", 1, 1);
            Command command2 = new Command("\u041d\u0435\u0442", 1, 1);
            Form form = new Form("\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435");
            form.append((Item)new StringItem(null, "\u0414\u0430\u043d\u043d\u044b\u0435 \u0431\u044b\u043b\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u044b. \u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c?"));
            form.setCommandListener((CommandListener)new SheetShow$8(this, command, runnable, command2));
            form.addCommand(command);
            form.addCommand(command2);
            form.addCommand(cancelCommand);
            display.setCurrent((Displayable)form);
        } else {
            runnable.run();
        }
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 1: {
                this.data.moveCursor(1);
                this.moved = true;
                break;
            }
            case 6: {
                this.data.moveCursor(2);
                this.moved = true;
                break;
            }
            case 2: {
                this.data.moveCursor(3);
                this.moved = true;
                break;
            }
            case 5: {
                this.data.moveCursor(4);
                this.moved = true;
                break;
            }
            case 8: {
                Cell cell = this.data.getCurrentCell(false);
                Alert alert = cell != null ? new Alert(cell.getName() + " \u0434\u0435\u0442\u0430\u043b\u0438", cell.getDetails(), null, null) : new Alert(" \u0414\u0435\u0442\u0430\u043b\u0438", "\u042d\u0442\u0430 \u044f\u0447\u0435\u0439\u043a\u0430 \u043f\u0443\u0441\u0442\u0430", null, null);
                this.moved = true;
                alert.setTimeout(-2);
                display.setCurrent(alert, (Displayable)this);
                break;
            }
            default: {
                if (n == -12) {
                    this.menuAction((short)3, (short)3);
                    this.moved = true;
                    break;
                }
                if (n == 35) {
                    this.data.getCurrentCell(true).edit(null, this, display);
                    break;
                }
                if (n == 42 && this.moved) {
                    n = 61;
                    this.data.getCurrentCell(true).edit(String.valueOf((char)n), this, display);
                    this.data.moveCursor(2);
                    break;
                }
                if (n == 42) {
                    n = 8;
                }
                this.moved = !this.data.getCurrentCell(true).appendChar((char)n, this.moved);
            }
        }
        this.repaint();
    }

    private void setSubmenu(Displayable displayable, short s) {
        SheetShow sheetShow = this;
        displayable.setCommandListener((CommandListener)new SheetShow$9(this, sheetShow, s));
    }

    public void commandAction(Command command, Displayable displayable) {
        short s = (short)command.getPriority();
        this.moved = true;
        if (MENUS[s] != null) {
            this.setSubmenu((Displayable)MENUS[s], s);
            display.setCurrent((Displayable)MENUS[s]);
        } else {
            this.menuAction(s, (short)0);
        }
    }

    private Table newSheet() {
        Font font = Font.getFont((int)64, (int)0, (int)8);
        short s = (short)font.stringWidth("0000");
        short s2 = (short)(font.getHeight() + 1);
        this.clipBoard = null;
        return new Table(10, 9, s, s2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void menuAction(short s, short s2) {
        switch (s) {
            case 2: {
                this.showWait("\u0412\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435...", new SheetShow$10(this));
                return;
            }
            case 4: {
                this.show();
                return;
            }
            case 0: {
                switch (s2) {
                    case 0: {
                        this.data.getCurrentCell(true).edit(null, this, display);
                        return;
                    }
                    case 1: {
                        this.data.clearCurrentCell();
                        this.show();
                        return;
                    }
                    case 2: {
                        this.clipBoard = this.data.getCurrentCell(false);
                        this.show();
                        return;
                    }
                    case 3: {
                        if (this.clipBoard != null) {
                            this.data.getCurrentCell(true).paste(this.clipBoard);
                        }
                    }
                    case 4: {
                        this.show();
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 1: {
                switch (s2) {
                    case 0: {
                        CellResize cellResize = new CellResize(this.data, this);
                        display.setCurrent((Displayable)cellResize);
                        return;
                    }
                    case 1: {
                        List list = new List("\u0426\u0432\u0435\u0442 \u044f\u0447\u0435\u0439\u043a\u0438", 3, Cell.colors, null);
                        this.setSubmenu((Displayable)list, (short)6);
                        display.setCurrent((Displayable)list);
                        return;
                    }
                    case 2: {
                        List list = new List("\u0412\u044b\u0440\u0430\u0432\u043d\u0438\u0432\u0430\u043d\u0438\u0435 \u044f\u0447\u0435\u0439\u043a\u0438", 3, Cell.aligns, null);
                        this.setSubmenu((Displayable)list, (short)7);
                        display.setCurrent((Displayable)list);
                        return;
                    }
                    case 3: {
                        this.show();
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 5: {
                Alert alert = new Alert("\u041f\u043e\u043c\u043e\u0449\u044c \u043f\u043e \u043b\u0438\u0441\u0442\u0443", "This is a small spreadsheet application capable of simple integer and string operations. You can find some hints in the Formula help (accessible from the formula editor).\n- To enter a numeric value, simply type the number ('*' serves as a backspace).\n- To enter a formula, press '*' key, then the formula editor will be opened with '=' pre-entered.\n- To simply edit a cell formula, press '#'.\n- Left softkey shows the full cell data.\n---\nMC, 2001\r\n(translated to rus by Sany4 SF)", null, null);
                alert.setTimeout(-2);
                display.setCurrent(alert, (Displayable)this);
                return;
            }
            case 3: {
                switch (s2) {
                    case 0: {
                        this.checkModified(new SheetShow$11(this));
                        return;
                    }
                    case 1: {
                        this.checkModified(new SheetShow$12(this));
                        return;
                    }
                    case 2: {
                        this.save(null);
                        return;
                    }
                    case 3: {
                        this.checkModified(new SheetShow$13(this));
                        return;
                    }
                    case 4: {
                        this.show();
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 6: {
                this.data.getCurrentCell(true).setColor(s2);
                this.show();
                return;
            }
            case 7: {
                this.data.getCurrentCell(true).setAlign(s2);
                this.show();
            }
        }
    }

    static Display access$000() {
        return display;
    }

    static Command access$100() {
        return okCommand;
    }

    static void access$300(SheetShow sheetShow, String string) {
        sheetShow.actualSave(string);
    }

    static void access$500(SheetShow sheetShow, String string, Runnable runnable) {
        sheetShow.showWait(string, runnable);
    }

    static void access$800(SheetShow sheetShow, String string) {
        sheetShow.actualLoad(string);
    }

    static Command access$1100() {
        return cancelCommand;
    }

    static void access$1200(SheetShow sheetShow, Runnable runnable) {
        sheetShow.save(runnable);
    }

    static Table access$1300(SheetShow sheetShow) {
        return sheetShow.data;
    }

    static Table access$1302(SheetShow sheetShow, Table table) {
        sheetShow.data = table;
        return sheetShow.data;
    }

    static Table access$1400(SheetShow sheetShow) {
        return sheetShow.newSheet();
    }

    static void access$1500(SheetShow sheetShow) {
        sheetShow.load();
    }

    static Quitable access$1600() {
        return winQuit;
    }
}

