/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.animation;

import dk.progressivemedia.rflib.system.PMTimer;
import dk.progressivemedia.skeleton.math.AABB;
import dk.progressivemedia.skeleton.movieplayer.Movie;
import dk.progressivemedia.skeleton.point.Point;

public class Animation {
    private int IDLE_MOVIE = 0;
    private long mTimeStamp;
    private short[] mMovieNames;
    private int mNofMovies;
    private int mCurrentMovieId;
    private int mOffscreenMovieId;
    private boolean mbVisible;
    private Movie mCurrentMovie;
    private Movie mOffscreenMovie;
    private Movie mRemoveMovie;
    private Point mWorldPos;
    private Point mDimensions;
    private Point mDefaultCameraPos;
    private AABB mAABB;
    private int mState;
    private int mDrawingTarget;
    private int mAngle;
    private static final int STATE_IDLE = 0;
    private static final int STATE_LOAD = 1;
    public static final int DRAW_BOTH = 0;
    public static final int DRAW_ONLY_MAIN = 1;
    public static final int DRAW_ONLY_TOP = 2;

    public Animation(short s) {
        this.mMovieNames = new short[1];
        this.mMovieNames[0] = s;
        this.Init(this.mMovieNames);
    }

    public Animation(short[] sArray) {
        this.Init(sArray);
    }

    private void Init(short[] sArray) {
        this.mState = 0;
        this.mDrawingTarget = 0;
        this.mWorldPos = new Point();
        this.mDimensions = new Point();
        this.mAABB = new AABB();
        this.mbVisible = true;
        this.mAngle = 0;
        this.mCurrentMovieId = -1;
        this.mMovieNames = sArray;
        this.mNofMovies = sArray.length;
        this.mCurrentMovieId = this.IDLE_MOVIE;
        this.mCurrentMovie = Movie.load(this.mMovieNames[this.mCurrentMovieId]);
        this.mCurrentMovie.loadGfx();
        this.mDefaultCameraPos = new Point();
        this.mTimeStamp = PMTimer.tick();
    }

    public void setTarget(int n) {
        this.mDrawingTarget = n;
    }

    public void setMovie(int n) {
        if (n >= 0 && n < this.mNofMovies && n != this.mCurrentMovieId) {
            if (this.mState == 1) {
                // empty if block
            }
            this.mOffscreenMovie = Movie.load(this.mMovieNames[n]);
            this.mOffscreenMovie.loadGfx();
            this.mOffscreenMovieId = n;
            this.mState = 1;
        }
    }

    public int getMovie() {
        return this.mCurrentMovieId;
    }

    public void update() {
        long l = PMTimer.tick();
        int n = (int)(l - this.mTimeStamp);
        this.update(n);
    }

    public void update(int n) {
        if (this.mRemoveMovie != null) {
            this.mRemoveMovie = null;
        }
        switch (this.mState) {
            case 0: {
                this.mCurrentMovie.update(n);
                break;
            }
            case 1: {
                this.mRemoveMovie = this.mCurrentMovie;
                this.mCurrentMovie = this.mOffscreenMovie;
                this.mCurrentMovieId = this.mOffscreenMovieId;
                this.mState = 0;
            }
        }
        this.updateAABB();
        this.mTimeStamp = PMTimer.tick();
    }

    public void drawScaled(int n) {
        int n2 = this.mWorldPos.X;
        int n3 = this.mWorldPos.Y;
        this.mCurrentMovie.draw(n2, n3, n);
    }

    public void draw() {
        this.draw(this.mDefaultCameraPos, 0);
    }

    public void draw(Point point) {
        this.draw(point, 0);
    }

    public void draw(Point point, int n) {
        if (this.mbVisible) {
            int n2 = this.mWorldPos.X - point.X;
            int n3 = this.mWorldPos.Y - point.Y;
            if ((n += this.mAngle) < 0) {
                n = -n;
                n += 180;
            }
            this.mCurrentMovie.draw(n2, n3, n %= 360);
        }
    }

    public void gotoTick(int n) {
        this.mCurrentMovie.gotoTick(n);
        if (this.mOffscreenMovie != null) {
            this.mOffscreenMovie.gotoTick(n);
        }
    }

    public void setDimensions(int n, int n2) {
        this.mDimensions.X = n;
        this.mDimensions.Y = n2;
        this.updateAABB();
    }

    public void setDimensions(Point point) {
        this.mDimensions.Value(point);
        this.updateAABB();
    }

    public Point getDimensions() {
        return this.mDimensions;
    }

    public Point getPos() {
        return this.mWorldPos;
    }

    public void setPos(int n, int n2) {
        this.mWorldPos.X = n;
        this.mWorldPos.Y = n2;
        this.updateAABB();
    }

    public void setPos(Point point) {
        this.mWorldPos.Value(point);
        this.updateAABB();
    }

    public int getAngle() {
        return this.mAngle;
    }

    public void setAngle(int n) {
        this.mAngle = n;
    }

    public AABB getAABB() {
        return this.mAABB;
    }

    public boolean isInside(Point point) {
        boolean bl = this.mAABB.mMinX < point.X && this.mAABB.mMaxX > point.X && this.mAABB.mMinY < point.Y && this.mAABB.mMaxY > point.Y;
        return bl;
    }

    public boolean isInside(Animation animation) {
        boolean bl = this.mAABB.intersects(animation.getAABB());
        return bl;
    }

    public boolean isInside(AABB aABB) {
        boolean bl = this.mAABB.intersects(aABB);
        return bl;
    }

    public boolean isDone() {
        return this.mCurrentMovie.isDone();
    }

    public void setVisible(boolean bl) {
        this.mbVisible = bl;
    }

    private void updateAABB() {
        this.mAABB.mMinX = this.mWorldPos.X - (this.mDimensions.X >> 1);
        this.mAABB.mMinY = this.mWorldPos.Y - (this.mDimensions.Y >> 1);
        this.mAABB.mMaxX = this.mWorldPos.X + (this.mDimensions.X >> 1);
        this.mAABB.mMaxY = this.mWorldPos.Y + (this.mDimensions.Y >> 1);
    }
}

