/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class ExitArea {
    private static final int HALF_WIDTH = 20;
    private static final int HALF_HEIGHT = 40;
    private static final int HALF_WIDTH_FP = 0x140000;
    private static final int HALF_HEIGHT_FP = 0x280000;
    private static final int HEIGHT_FP = 0x500000;
    private Vector2 mPosition;
    private Movie mAnimExit;

    public ExitArea(Vector2 vector2) {
        this.mPosition = vector2;
        if (Defines.mWorldFinalLookup[GameState.mLevel]) {
            switch (Defines.mWorldLookup[GameState.mLevel]) {
                case 0: {
                    this.mAnimExit = Movie.load((short)2540);
                    break;
                }
                case 1: {
                    this.mAnimExit = Movie.load((short)14735);
                    break;
                }
                case 2: {
                    this.mAnimExit = Movie.load((short)10670);
                    break;
                }
                case 3: {
                    this.mAnimExit = Movie.load((short)22857);
                    break;
                }
                case 4: {
                    this.mAnimExit = Movie.load((short)18792);
                }
            }
        } else {
            switch (Defines.mWorldLookup[GameState.mLevel]) {
                case 0: {
                    this.mAnimExit = Movie.load((short)-15364);
                    break;
                }
                case 1: {
                    this.mAnimExit = Movie.load((short)-3169);
                    break;
                }
                case 2: {
                    this.mAnimExit = Movie.load((short)-7234);
                    break;
                }
                case 3: {
                    this.mAnimExit = Movie.load((short)-27815);
                    break;
                }
                case 4: {
                    this.mAnimExit = Movie.load((short)-31880);
                }
            }
        }
        this.mAnimExit.loadGfx();
        this.mAnimExit.update(Timer.mDt);
    }

    public void draw(Vector2 vector2) {
        long l = (long)this.mPosition.mX * 5L >> 1;
        long l2 = (long)vector2.mX * 5L >> 1;
        int n = (int)((l >> 16) - (l2 >> 16));
        int n2 = 100;
        long l3 = (long)this.mPosition.mY * 5L >> 1;
        long l4 = (long)vector2.mY * 5L >> 1;
        int n3 = (int)((l3 >> 16) - (l4 >> 16));
        int n4 = 200;
        if (Camera.isInside(n - (n2 >> 1), n3 - (n4 >> 1), n2, n4)) {
            this.mAnimExit.draw(n, n3);
        }
    }

    public boolean collision(int n, int n2, int n3, int n4) {
        int n5 = this.mPosition.mX - 0x140000;
        int n6 = this.mPosition.mX + 0x140000;
        int n7 = this.mPosition.mY - 0x500000;
        int n8 = this.mPosition.mY;
        return n3 >= n5 && n <= n6 && n4 >= n7 && n2 <= n8;
    }
}

