/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.pixeline;

import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.game.SurfaceIntersectionResult;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.game.pixeline.PixelineData;
import dk.progressivemedia.skeleton.game.pixeline.PixelineState;
import dk.progressivemedia.skeleton.game.pixeline.PixelineStateBraking;
import dk.progressivemedia.skeleton.game.pixeline.PixelineStateDying;
import dk.progressivemedia.skeleton.game.pixeline.PixelineStateIdle;
import dk.progressivemedia.skeleton.game.pixeline.PixelineStateJumping;
import dk.progressivemedia.skeleton.game.pixeline.PixelineStateRunning;
import dk.progressivemedia.skeleton.game.pixeline.PixelineStateSlippery;
import dk.progressivemedia.skeleton.game.pixeline.PixelineStateWinning;
import dk.progressivemedia.skeleton.game.pixeline.PixelineViewController;
import dk.progressivemedia.skeleton.math.AABB;
import dk.progressivemedia.skeleton.math.Vector2;

public class PixelineStateController {
    private PixelineData mData;
    private PixelineViewController mView;
    public static final int STATE_VOID = -1;
    public static final int STATE_IDLE = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_BRAKING = 2;
    public static final int STATE_JUMPING = 3;
    public static final int STATE_DYING = 4;
    public static final int STATE_WINNING = 5;
    private int mActiveStateID;
    private PixelineState mActiveState;
    private PixelineStateIdle mStateIdle;
    private PixelineStateRunning mStateRunning;
    private PixelineStateSlippery mStateSlippery;
    private PixelineStateBraking mStateBraking;
    private PixelineStateJumping mStateJumping;
    private PixelineStateDying mStateDying;
    private PixelineStateWinning mStateWinning;
    private AABB mTileAABB;
    private static final int EVENT_QUEUE_SIZE = 32;
    private static final int EVENT_VOID = -1;
    public static final int EVENT_CHANGE_TOTEM = 0;
    public static final int EVENT_TIMER = 1;
    public static final int EVENT_WAIT_ANIM = 2;
    public static final int EVENT_WAIT_ANIM_RESET_STATE = 3;
    public static final int EVENT_ENABLE_INVULNERABILITY = 4;
    public static final int EVENT_DISABLE_INVULNERABILITY = 5;
    public static final int EVENT_ENABLE_BLINK = 6;
    public static final int EVENT_DISABLE_BLINK = 7;
    private int mNumEvents;
    private int[] mEventQueue;
    private int[] mEventParams;
    private int mEventType;
    private int mEventParam;

    public PixelineStateController(PixelineData pixelineData, PixelineViewController pixelineViewController, Vector2 vector2) {
        this.mData = pixelineData;
        this.mView = pixelineViewController;
        this.mData.setPosition(vector2);
        this.mData.setPositionPrev(vector2);
        this.mStateIdle = new PixelineStateIdle(pixelineData, pixelineViewController, this);
        this.mStateRunning = new PixelineStateRunning(pixelineData, pixelineViewController, this);
        this.mStateSlippery = new PixelineStateSlippery(pixelineData, pixelineViewController, this);
        this.mStateBraking = new PixelineStateBraking(pixelineData, pixelineViewController, this);
        this.mStateJumping = new PixelineStateJumping(pixelineData, pixelineViewController, this);
        this.mStateDying = new PixelineStateDying(pixelineData, pixelineViewController, this);
        this.mStateWinning = new PixelineStateWinning(pixelineData, pixelineViewController, this);
        this.mTileAABB = new AABB();
        this.mActiveStateID = -1;
        this.mNumEvents = 0;
        this.mEventQueue = new int[32];
        this.mEventParams = new int[32];
        for (int i = 0; i < 32; ++i) {
            this.mEventQueue[i] = -1;
            this.mEventParams[i] = 0;
        }
        this.mEventType = -1;
        this.mEventParam = 0;
        this.setInitialState();
    }

    public void update() {
        Vector2 vector2 = this.mData.getPositionRef();
        Vector2 vector22 = this.mData.getVelocityRef();
        Vector2 vector23 = this.mData.getDimensionRef();
        World world = this.mData.getWorldRef();
        this.mData.setPositionPrev(vector2);
        int n = vector23.mX >> 1;
        this.updateEvent();
        this.mActiveState.update();
        if (this.mData.isOnGround()) {
            Surface surface = this.mData.getSurfaceRef();
            if (!surface.getSolidity()) {
                this.requestStateChange(3);
            } else {
                int n2 = this.mData.getSurfaceIndex();
                int n3 = this.mData.getSurfaceOffset();
                int n4 = vector23.mX >> 1;
                n3 += vector22.mX;
                int n5 = n - n4;
                if (n2 == 0) {
                    if ((n3 -= n5) < 0) {
                        this.requestStateChange(3);
                    } else if (n3 > n4) {
                        this.mData.setSurfacePosition(++n2, n3 -= n4);
                    } else {
                        this.mData.setSurfacePosition(n2, n3);
                    }
                } else if (n2 == surface.getNumSegments() - 1) {
                    if ((n3 += n5) < 0) {
                        this.mData.setSurfacePosition(n2, n3 += surface.getSegmentLength(--n2));
                    } else if (n3 > n4) {
                        this.requestStateChange(3);
                    } else {
                        this.mData.setSurfacePosition(n2, n3);
                    }
                } else if (n3 < 0) {
                    n3 = --n2 == 0 ? (n3 += n4) : (n3 += surface.getSegmentLength(n2));
                    this.mData.setSurfacePosition(n2, n3);
                } else if (n3 > surface.getSegmentLength(n2)) {
                    this.mData.setSurfacePosition(n2, n3 -= surface.getSegmentLength(++n2 - 1));
                } else {
                    this.mData.setSurfacePosition(n2, n3);
                }
                surface.getSurfacePosition(n2, n3, vector23.mX >> 1, vector2);
                boolean bl = false;
                boolean bl2 = false;
                int n6 = vector2.mX - (vector23.mX >> 1);
                int n7 = vector2.mY - (vector23.mY >> 1);
                if (world.collisionTest(n6, n7, this.mTileAABB)) {
                    this.mData.setSurfacePosition(n2, n3 += this.mTileAABB.mMaxX - n6);
                    surface.getSurfacePosition(n2, n3, vector23.mX >> 1, vector2);
                    vector22.mX = 0;
                    bl = true;
                }
                if (!bl && world.collisionTest(n6 = vector2.mX - (vector23.mX >> 1), n7 = vector2.mY - vector23.mY, this.mTileAABB)) {
                    this.mData.setSurfacePosition(n2, n3 += this.mTileAABB.mMaxX - n6);
                    surface.getSurfacePosition(n2, n3, vector23.mX >> 1, vector2);
                    vector22.mX = 0;
                    bl = true;
                }
                if (world.collisionTest(n6 = vector2.mX + (vector23.mX >> 1), n7 = vector2.mY - (vector23.mY >> 1), this.mTileAABB)) {
                    this.mData.setSurfacePosition(n2, n3 -= n6 - this.mTileAABB.mMinX);
                    surface.getSurfacePosition(n2, n3, vector23.mX >> 1, vector2);
                    vector22.mX = 0;
                    bl2 = true;
                }
                if (!bl2 && world.collisionTest(n6 = vector2.mX + (vector23.mX >> 1), n7 = vector2.mY - vector23.mY, this.mTileAABB)) {
                    this.mData.setSurfacePosition(n2, n3 -= n6 - this.mTileAABB.mMinX);
                    surface.getSurfacePosition(n2, n3, vector23.mX >> 1, vector2);
                    vector22.mX = 0;
                    bl2 = true;
                }
                int n8 = world.getWorldMinX();
                int n9 = world.getWorldMaxX();
                n6 = vector2.mX - (vector23.mX >> 1);
                if (n6 < n8) {
                    this.mData.setSurfacePosition(n2, n3 += n8 - n6);
                    surface.getSurfacePosition(n2, n3, vector23.mX >> 1, vector2);
                    vector22.mX = 0;
                }
                if ((n6 = vector2.mX + (vector23.mX >> 1)) > n9) {
                    this.mData.setSurfacePosition(n2, n3 -= n6 - n9);
                    surface.getSurfacePosition(n2, n3, vector23.mX >> 1, vector2);
                    vector22.mX = 0;
                }
            }
        }
        if (this.mActiveStateID != 4 && vector2.mY - vector23.mY > world.getWorldMaxY()) {
            this.requestStateChange(4);
            this.mData.setHealth(0);
            SoundBuffer.play(5, 1000);
            GameState.mLives = (byte)(GameState.mLives - 1);
            world.handleEvent((byte)21);
        }
    }

    public void requestStateChange(int n) {
        if (this.mActiveStateID == 4) {
            return;
        }
        this.mActiveState.exit();
        this.mActiveStateID = n;
        switch (n) {
            case 0: {
                this.mActiveState = this.mStateIdle;
                this.mData.setOnGround(true);
                break;
            }
            case 1: {
                Surface surface = this.mData.getSurfaceRef();
                this.mActiveState = !surface.getSlippery() ? this.mStateRunning : this.mStateSlippery;
                this.mData.setOnGround(true);
                break;
            }
            case 2: {
                this.mActiveState = this.mStateBraking;
                this.mData.setOnGround(true);
                break;
            }
            case 3: {
                this.mActiveState = this.mStateJumping;
                this.mData.setOnGround(false);
                break;
            }
            case 4: {
                this.mActiveState = this.mStateDying;
                this.mData.setOnGround(false);
                break;
            }
            case 5: {
                this.mActiveState = this.mStateWinning;
                this.mData.setOnGround(true);
            }
        }
        this.mActiveState.enter();
    }

    public void requestTotemTransition(int n) {
        if (this.eventsDone()) {
            this.pushEvent(0, n);
        }
    }

    private void setInitialState() {
        Vector2 vector2 = this.mData.getPositionRef();
        Vector2 vector22 = this.mData.getDimensionRef();
        SurfaceIntersectionResult surfaceIntersectionResult = new SurfaceIntersectionResult();
        World world = this.mData.getWorldRef();
        world.intersectionTest(vector2.mX, vector2.mY, 0, 0x100000, vector22.mX >> 1, surfaceIntersectionResult);
        if (surfaceIntersectionResult.mSurface != null) {
            this.mData.setSurface(surfaceIntersectionResult.mSurface, surfaceIntersectionResult.mSegmentIndex, surfaceIntersectionResult.mLengthOffset);
            Surface surface = surfaceIntersectionResult.mSurface;
            surface.getSurfacePosition(surfaceIntersectionResult.mSegmentIndex, surfaceIntersectionResult.mLengthOffset, vector22.mX >> 1, vector2);
            this.mActiveStateID = 0;
            this.mActiveState = this.mStateIdle;
            this.mActiveState.enter();
            this.mData.setOnGround(true);
        } else {
            this.mActiveStateID = 3;
            this.mActiveState = this.mStateJumping;
            this.mActiveState.enter();
            this.mData.setOnGround(false);
        }
    }

    public void pushEvent(int n, int n2) {
        this.mEventQueue[this.mNumEvents] = n;
        this.mEventParams[this.mNumEvents] = n2;
        ++this.mNumEvents;
    }

    public void clearEvents() {
        this.mEventType = -1;
        this.mNumEvents = 0;
    }

    private void updateEvent() {
        if (this.mEventType == -1) {
            this.eatEvent();
        } else {
            switch (this.mEventType) {
                case 1: {
                    this.mEventParam -= Timer.mDt;
                    if (this.mEventParam > 0) break;
                    this.mEventType = -1;
                    break;
                }
                case 2: {
                    if (!this.mView.isAnimDone(this.mEventParam)) break;
                    this.mEventType = -1;
                    break;
                }
                case 3: {
                    if (!this.mView.isAnimDone(this.mEventParam)) break;
                    this.mActiveState.enter();
                    this.mEventType = -1;
                }
            }
        }
    }

    private void eatEvent() {
        boolean bl = false;
        while (this.mNumEvents > 0 && !bl) {
            this.mEventType = this.mEventQueue[0];
            this.mEventParam = this.mEventParams[0];
            --this.mNumEvents;
            for (int i = 0; i < 31; ++i) {
                this.mEventQueue[i] = this.mEventQueue[i + 1];
                this.mEventParams[i] = this.mEventParams[i + 1];
            }
            switch (this.mEventType) {
                case 0: {
                    Vector2 vector2 = this.mData.getPositionRef();
                    Vector2 vector22 = this.mData.getDimensionRef();
                    World world = this.mData.getWorldRef();
                    int n = 0;
                    switch (this.mEventParam) {
                        case 0: {
                            n = 0x1F0000;
                            break;
                        }
                        case 1: {
                            n = 983040;
                            break;
                        }
                        case 2: {
                            n = 0x1F0000;
                            break;
                        }
                        case 3: {
                            n = 0x1F0000;
                        }
                    }
                    int n2 = vector2.mX;
                    int n3 = vector2.mY - n;
                    if (world.collisionTest(n2, n3, this.mTileAABB)) {
                        SoundBuffer.play(42, 200);
                    } else {
                        this.mData.totemTransition(this.mEventParam);
                        this.mView.totemTransition(this.mEventParam, true);
                        SoundBuffer.play(14, 200);
                    }
                    this.mActiveState.enter();
                    this.mEventType = -1;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 3: {
                    this.mView.setAnimState(this.mEventParam, true);
                    this.mEventParam = this.mView.getAnimTick();
                    bl = true;
                    break;
                }
                case 2: {
                    this.mView.setAnimState(this.mEventParam, true);
                    this.mEventParam = this.mView.getAnimTick();
                    bl = true;
                    break;
                }
                case 4: {
                    this.mData.setInvulnerability(true);
                    this.mEventType = -1;
                    break;
                }
                case 5: {
                    this.mData.setInvulnerability(false);
                    this.mEventType = -1;
                    break;
                }
                case 6: {
                    this.mView.setBlinkActive(true, this.mEventParam);
                    this.mEventType = -1;
                    break;
                }
                case 7: {
                    this.mView.setBlinkActive(false, 0);
                    this.mEventType = -1;
                }
            }
        }
    }

    public boolean eventsDone() {
        return this.mNumEvents <= 0 && this.mEventType == -1;
    }
}

