/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.GMGmovieplayer;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.rflib.util.PMTrigonometry;

public class GMGMovieItem {
    private static final int CONVERSION_SCALE = PMMath.DIV(65536, 0x888888);
    public static final int MODEL = 0;
    public static final int X = 1;
    public static final int Y = 2;
    public static final int SCALE = 3;
    public static final int ROT = 4;
    public static final int MIRROR = 5;
    public static final int DRAW = 6;
    public static final int ORDER = 7;
    public static final int ALPHA = 8;
    public static final int SCALE_H = 9;
    public static final int SCALE_V = 10;
    private short mModel;
    private short mX;
    private short mY;
    private int mScale;
    private int mScaleH;
    private int mScaleV;
    private short mRotation;
    private boolean mMirror;
    private boolean mVisible;
    private short mAlpha;

    public void draw(int n, int n2, boolean bl, int n3, int n4, int n5, int n6) {
        if (this.mVisible) {
            int n7;
            int n8;
            int n9 = (!bl ? this.mX : -this.mX) * CONVERSION_SCALE;
            int n10 = this.mY * CONVERSION_SCALE;
            int n11 = this.mScaleH << 4;
            int n12 = this.mScaleV << 4;
            if (n5 != 65536) {
                n9 = PMMath.MUL(n9, n5);
                n11 = PMMath.MUL(n5, n11);
            }
            if (n6 != 65536) {
                n10 = PMMath.MUL(n10, n6);
                n12 = PMMath.MUL(n6, n12);
            }
            int n13 = n8 = !bl ? this.mRotation : 360 - this.mRotation;
            if (n3 != 0) {
                if (n3 >= 360) {
                    n3 %= 360;
                }
                n7 = PMTrigonometry.sin(n3);
                int n14 = PMTrigonometry.cos(n3);
                int n15 = n + (PMMath.MUL(n9, n14) - PMMath.MUL(n10, n7) >> 16);
                int n16 = n2 + (PMMath.MUL(n9, n7) + PMMath.MUL(n10, n14) >> 16);
                n9 = n15;
                n10 = n16;
                if ((n8 += n3) > 360) {
                    n8 %= 360;
                }
            } else {
                n9 = n + (n9 >> 16);
                n10 = n2 + (n10 >> 16);
            }
            n7 = this.mAlpha;
            if (n4 < 65536) {
                n7 = PMMath.MUL(PMMath.DIV(this.mAlpha, 255), n4) * 255 >> 16;
            }
            PMImageManager.draw(this.mModel, n9, n10, bl ? !this.mMirror : this.mMirror, n8, n7, n11, n12);
        }
    }

    public void setValue(int n, short s) {
        switch (n) {
            case 0: {
                this.mModel = s;
                break;
            }
            case 1: {
                this.mX = s;
                break;
            }
            case 2: {
                this.mY = s;
                break;
            }
            case 3: {
                this.mScaleH = this.mScale = s & 0xFFFF;
                this.mScaleV = this.mScale;
                break;
            }
            case 4: {
                if (s >= 360 || s < 0) {
                    s = (short)((s + 36000) % 360);
                }
                this.mRotation = s;
                break;
            }
            case 5: {
                this.mMirror = s == 1;
                break;
            }
            case 6: {
                this.mVisible = s == 1;
                break;
            }
            case 8: {
                this.mAlpha = s;
                break;
            }
            case 9: {
                this.mScaleH = s & 0xFFFF;
                break;
            }
            case 10: {
                this.mScaleV = s & 0xFFFF;
            }
        }
    }

    public GMGMovieItem() {
        this.reset();
    }

    public void reset() {
        this.mModel = 0;
        this.mX = 0;
        this.mY = 0;
        this.mScaleH = this.mScale = 4096;
        this.mScaleV = this.mScale;
        this.mRotation = 0;
        this.mMirror = false;
        this.mVisible = true;
        this.mAlpha = (short)255;
    }
}

