/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.audio.PMAudio;

public class MusicBuffer {
    private static final int STATE_STOPPED = 0;
    private static final int STATE_WAITING = 1;
    private static final int STATE_PLAYING = 2;
    private static int mState;
    private static int mMusicID;
    private static int mSessionID;
    private static boolean mMuted;
    private static int mVolume;
    public static int DEFAULT_MUSIC_VOLUMEN;

    public static void init() {
        mState = 0;
        mMusicID = -1;
        mSessionID = -1;
        mMuted = false;
        mVolume = 0;
    }

    public static void update() {
        if (mState == 1 && mMusicID != -1 && mSessionID == -1 && !PMAudio.isPlaying(mMusicID, -1)) {
            PMAudio.play(mMusicID, -1);
            mSessionID = mMusicID;
            int n = mVolume;
            n = mVolume * 10 / 255;
            if (PMAudio.getVolume(mSessionID) != (mMuted ? 0 : n)) {
                PMAudio.setVolume(mSessionID, mMuted ? 0 : n);
            }
            mState = 2;
        }
        if (mState == 2 && mMusicID != -1 && mSessionID != -1 && !PMAudio.isPlaying(mMusicID, -1)) {
            PMAudio.play(mMusicID, -1);
            mSessionID = mMusicID;
        }
    }

    public static void play(int n) {
        if (mState == 2) {
            MusicBuffer.stop();
        }
        mMusicID = n;
        mState = 1;
    }

    public static void stop() {
        if (mState == 2 && mSessionID >= 0) {
            PMAudio.stop(mSessionID);
            PMAudio.unload(mSessionID);
            PMAudio.update();
        }
        mMusicID = -1;
        mSessionID = -1;
        mState = 0;
    }

    public static void setVolume(int n) {
        int n2 = mVolume = n;
        n2 = mVolume * 10 / 255;
        if (mSessionID >= 0) {
            PMAudio.setVolume(mSessionID, mMuted ? 0 : n2);
        }
    }

    public static int getVolume() {
        return mVolume;
    }

    public static void setMuted(boolean bl) {
        if (bl && !mMuted && mSessionID != -1) {
            PMAudio.stop(mSessionID);
        }
        mMuted = bl;
        int n = mVolume;
        n = mVolume * 10 / 255;
        if (mSessionID >= 0) {
            PMAudio.setVolume(mSessionID, mMuted ? 0 : n);
        }
    }

    public static boolean isMuted() {
        return mMuted;
    }

    static {
        DEFAULT_MUSIC_VOLUMEN = 255;
    }
}

