/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.math.Vector2;

public class Enemy1Data {
    public static final int DIRECTION_LEFT = 0;
    public static final int DIRECTION_RIGHT = 1;
    private int mDirection = 1;
    private World mWorld;
    private Vector2 mPosition;
    private Vector2 mPositionPrev;
    private Vector2 mDimension;
    private Vector2 mVelocity;
    private Surface mSurface;
    private int mSurfaceIndex;
    private int mSurfaceOffset;
    private int mWalkSpeed;
    private boolean mTurnAtEdge;
    public static final int ENEMY_STATE_ALIVE = 0;
    public static final int ENEMY_STATE_DEAD = 1;
    public static final int ENEMY_STATE_DISABLED = 2;
    private int mState;

    public Enemy1Data(World world) {
        this.mWorld = world;
        this.mPosition = new Vector2();
        this.mPositionPrev = new Vector2();
        this.mDimension = new Vector2(PMMath.FP(15), PMMath.FP(10));
        this.mVelocity = new Vector2();
        this.mSurface = null;
        this.mSurfaceIndex = 0;
        this.mSurfaceOffset = 0;
        this.mWalkSpeed = 50000;
        this.mTurnAtEdge = true;
        this.mState = 0;
    }

    public int getDirection() {
        return this.mDirection;
    }

    public void setDirection(int n) {
        this.mDirection = n;
    }

    public World getWorldRef() {
        return this.mWorld;
    }

    public Vector2 getPositionRef() {
        return this.mPosition;
    }

    public Vector2 getPositionPrevRef() {
        return this.mPositionPrev;
    }

    public void setPosition(Vector2 vector2) {
        this.mPosition.set(vector2);
    }

    public void setPosition(int n, int n2) {
        this.mPosition.set(n, n2);
    }

    public void setPositionPrev(Vector2 vector2) {
        this.mPositionPrev.set(vector2);
    }

    public void setPositionPrev(int n, int n2) {
        this.mPositionPrev.set(n, n2);
    }

    public Vector2 getDimensionRef() {
        return this.mDimension;
    }

    public void setDimension(Vector2 vector2) {
        this.mDimension.set(vector2);
    }

    public Vector2 getVelocityRef() {
        return this.mVelocity;
    }

    public void setVelocity(Vector2 vector2) {
        this.mVelocity.set(vector2);
    }

    public void setSurface(Surface surface, int n, int n2) {
        this.mSurface = surface;
        this.mSurfaceIndex = n;
        this.mSurfaceOffset = n2;
    }

    public void setSurfacePosition(int n, int n2) {
        this.mSurfaceIndex = n;
        this.mSurfaceOffset = n2;
    }

    public Surface getSurfaceRef() {
        return this.mSurface;
    }

    public int getSurfaceIndex() {
        return this.mSurfaceIndex;
    }

    public int getSurfaceOffset() {
        return this.mSurfaceOffset;
    }

    public int getWalkSpeed() {
        return this.mWalkSpeed * 64 / 33 * Timer.mDt >> 6;
    }

    public boolean getTurnAtEdge() {
        return this.mTurnAtEdge;
    }

    public void setState(int n) {
        this.mState = n;
    }

    public boolean isAlive() {
        return this.mState == 0;
    }

    public boolean isEnabled() {
        return this.mState != 2;
    }
}

