/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.game.enemies.Enemy2Data;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class Enemy2View {
    protected Enemy2Data mData;
    public static final int STATE_ANIM_RUN = 0;
    public static final int STATE_ANIM_ANTICIPATE = 1;
    public static final int STATE_ANIM_JUMP = 2;
    public static final int STATE_ANIM_FALL = 3;
    public static final int STATE_ANIM_LAND = 4;
    public static final int STATE_ANIM_DIE = 5;
    private int mAnimState;
    private Movie mAnimRun;
    private Movie mAnimAnticipate;
    private Movie mAnimJump;
    private Movie mAnimLand;

    public Enemy2View(Enemy2Data enemy2Data) {
        this.mData = enemy2Data;
        this.mAnimRun = Movie.load((short)23013);
        this.mAnimRun.loadGfx();
        this.mAnimAnticipate = Movie.load((short)-21534);
        this.mAnimAnticipate.loadGfx();
        this.mAnimJump = Movie.load((short)-25923);
        this.mAnimJump.loadGfx();
        this.mAnimLand = Movie.load((short)-17119);
        this.mAnimLand.loadGfx();
        PMImageManager.load(35);
    }

    public void update() {
        switch (this.mAnimState) {
            case 0: {
                this.mAnimRun.update(Timer.mDt);
                break;
            }
            case 1: {
                this.mAnimAnticipate.update(Timer.mDt);
                break;
            }
            case 2: {
                this.mAnimJump.update(Timer.mDt);
                break;
            }
            case 4: {
                this.mAnimLand.update(Timer.mDt);
            }
        }
    }

    public void draw(Vector2 vector2) {
        Vector2 vector22 = this.mData.getPositionRef();
        Vector2 vector23 = this.mData.getDimensionRef();
        long l = (long)vector22.mX * 5L >> 2;
        long l2 = (long)vector2.mX * 5L >> 2;
        int n = (int)((l >> 16) - (l2 >> 16));
        int n2 = 20;
        long l3 = (long)vector22.mY * 5L >> 2;
        long l4 = (long)vector2.mY * 5L >> 2;
        int n3 = (int)((l3 >> 16) - (l4 >> 16));
        int n4 = 20;
        if (Camera.isInside(n - (n2 >> 1), n3 - n4, n2, n4)) {
            switch (this.mAnimState) {
                case 0: {
                    this.mAnimRun.draw(n, n3);
                    break;
                }
                case 1: {
                    this.mAnimAnticipate.draw(n, n3);
                    break;
                }
                case 2: {
                    this.mAnimJump.draw(n, n3);
                    break;
                }
                case 3: {
                    PMImageManager.draw(36, n, n3);
                    break;
                }
                case 4: {
                    this.mAnimLand.draw(n, n3);
                    break;
                }
                case 5: {
                    PMImageManager.draw(35, n, n3);
                }
            }
        }
    }

    public void setAnimState(int n) {
        this.mAnimState = n;
        this.mAnimRun.gotoTick(0);
        this.mAnimAnticipate.gotoTick(0);
        this.mAnimJump.gotoTick(0);
        this.mAnimLand.gotoTick(0);
    }
}

