/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.skeleton.game.enemies.Enemy4Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy4State;
import dk.progressivemedia.skeleton.game.enemies.Enemy4StateDieing;
import dk.progressivemedia.skeleton.game.enemies.Enemy4StateIdling;
import dk.progressivemedia.skeleton.game.enemies.Enemy4StateShooting;
import dk.progressivemedia.skeleton.game.enemies.Enemy4View;
import dk.progressivemedia.skeleton.game.enemies.FruitBomb;
import dk.progressivemedia.skeleton.math.Vector2;

public class Enemy4StateController {
    private Enemy4Data mData;
    private Enemy4View mView;
    public static final int STATE_IDLING = 0;
    public static final int STATE_SHOOTING = 1;
    public static final int STATE_DIEING = 2;
    private int mActiveStateID;
    private Enemy4State mActiveState;
    private Enemy4StateIdling mStateIdling;
    private Enemy4StateShooting mStateShooting;
    private Enemy4StateDieing mStateDieing;

    public Enemy4StateController(Enemy4Data enemy4Data, Enemy4View enemy4View) {
        this.mData = enemy4Data;
        this.mView = enemy4View;
        this.mStateIdling = new Enemy4StateIdling(enemy4Data, enemy4View, this);
        this.mStateShooting = new Enemy4StateShooting(enemy4Data, enemy4View, this);
        this.mStateDieing = new Enemy4StateDieing(enemy4Data, enemy4View, this);
        this.mActiveStateID = 0;
        this.mActiveState = this.mStateIdling;
        this.mActiveState.enter();
    }

    public void update() {
        this.mActiveState.update();
    }

    public void requestStateChange(int n) {
        this.mActiveState.exit();
        this.mActiveStateID = n;
        switch (n) {
            case 0: {
                this.mActiveState = this.mStateIdling;
                break;
            }
            case 1: {
                this.mActiveState = this.mStateShooting;
                break;
            }
            case 2: {
                this.mActiveState = this.mStateDieing;
            }
        }
        this.mActiveState.enter();
    }

    public void fireBomb() {
        Vector2 vector2 = this.mData.getPositionRef();
        FruitBomb fruitBomb = this.mData.getBombRef();
        switch (this.mData.getDirection()) {
            case 0: {
                fruitBomb.fire(-1, vector2.mX - 524288, vector2.mY - 0x170000);
                break;
            }
            case 1: {
                fruitBomb.fire(1, vector2.mX + 524288, vector2.mY - 0x170000);
            }
        }
    }
}

