/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.skeleton.SoundBufferPositional;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.enemies.Enemy6Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy6State;
import dk.progressivemedia.skeleton.game.enemies.Enemy6StateController;
import dk.progressivemedia.skeleton.game.enemies.Enemy6View;
import dk.progressivemedia.skeleton.math.Vector2;

public class Enemy6StateSpiked
extends Enemy6State {
    private int mAnticipateTimer;
    private int mSpikedTimer;

    public Enemy6StateSpiked(Enemy6Data enemy6Data, Enemy6View enemy6View, Enemy6StateController enemy6StateController) {
        this.mData = enemy6Data;
        this.mView = enemy6View;
        this.mController = enemy6StateController;
    }

    public void enter() {
        this.mView.setAnimState(1);
        this.mAnticipateTimer = 1500;
        this.mSpikedTimer = 2000;
    }

    public void exit() {
        this.mData.setDeadly(false);
    }

    public void update() {
        if (this.mAnticipateTimer > 0) {
            this.mAnticipateTimer -= Timer.mDt;
            if (this.mAnticipateTimer <= 0) {
                this.mView.setAnimState(2);
                this.mData.setDeadly(true);
                Vector2 vector2 = this.mData.getPositionRef();
                SoundBufferPositional.play(28, 200, vector2.mX, vector2.mY);
            }
        }
        if (this.mAnticipateTimer <= 0 && this.mSpikedTimer > 0) {
            this.mSpikedTimer -= Timer.mDt;
            if (this.mSpikedTimer <= 0) {
                this.mView.setAnimState(3);
            }
        }
        if (this.mAnticipateTimer <= 0 && this.mSpikedTimer <= 0 && this.mView.isRetractDone()) {
            this.mController.requestStateChange(0);
        }
    }
}

