/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.menu;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.rflib.graphics.PMFont;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.system.PMStateManager;
import dk.progressivemedia.rflib.system.PMSystem;
import dk.progressivemedia.rflib.util.PMLocale;
import dk.progressivemedia.rflib.util.PMText;
import dk.progressivemedia.skeleton.ButtonPulser;
import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.Dialog;
import dk.progressivemedia.skeleton.GMGmovieplayer.GMGMovie;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.SaveGameHelper;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.TransitionEffect;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.script.Script;

public class StateSlotSelection {
    private static int[] mBarImgs = new int[]{1109, 1110, 1111, 1112, 1113, 1114};
    private static int[] mBarSelectedImgs = new int[]{1115, 1116, 1117, 1118, 1119, 1120};
    public static int saveBoxWidth = 1109;
    private static int mSelectedButton = 0;
    private static ButtonPulser mButtonPulser = new ButtonPulser();
    public static final int STATE_SWIPE_IN = 0;
    public static final int STATE_SLOT_SELECT = 1;
    public static final int STATE_OUTRO = 2;
    public static final int STATE_SWIPE_OUT = 3;
    public static int mState = 0;
    private static final int NUM_SLOTS = 3;
    public static final int SLOT_STATE_IDLE = 0;
    public static final int SLOT_STATE_MOVING_OUT = 1;
    public static final int SLOT_STATE_EXPANDED = 2;
    public static final int SLOT_STATE_MOVING_IN = 3;
    public static final int SLOT_STATE_TRANSITION_TO_GMG = 4;
    public static int mSlotState = 0;
    private static int mSlotWidth;
    private static int mSlotHeight;
    private static final int SLOT_DELETE_WIDTH = 30;
    private static final int SLOT_DELETE_HEIGHT = 26;
    private static final int SLOT_Y_POS = 60;
    private static final int SLOT_SPACING = 2;
    private static final int SLOT_ID_SIZE_X = 21;
    private static final int TEXT_OFFSET_Y = 8;
    private static final int LIVES_SPACING = 18;
    private static final int DELETE_GAME_TEXT_OFFSET_Y = 91;
    private static final int CONFIRM_BUTTONS_OFFSET_Y = 126;
    private static final int CONFIRM_BUTTONS_SPACING_X = 25;
    private static final int CONFIRM_BUTTON_WIDTH = 49;
    private static final int CONFIRM_BUTTON_HEIGHT = 41;
    private static final int PRESSED_OFFSET = 2;
    private static int mSelectedSlot;
    private static boolean mSlotsInUse;
    private static int[] mSlotCorrectPosX;
    private static int[] mSlotCorrectPosY;
    private static int[] mSlotPosX;
    private static int[] mSlotPosY;
    private static int[] mSlotOffsetX;
    private static int[] mSlotOffsetY;
    private static int[] mSlotDeltaPosX;
    private static int[] mSlotDeltaPosY;
    private static int mInterp;
    private static boolean[] mSlotPressed;
    private static boolean[] mDeletePressed;
    private static boolean mYesPressed;
    private static boolean mNoPressed;
    private static String mTextNewgame;
    private static String mTextDeleteGame;
    private static String mTextYes;
    private static String mTextNo;
    private static String[] mTextProgression;
    private static String[] mTextLives;
    private static int[] mTextProgressionWidth;
    private static int[] mProgressionWidth;
    private static short[] mScriptIDs;
    private static boolean mFromGame;
    private static Script mActiveScript;
    private static Script[] mScripts;
    public static GMGMovie gmgLogoMovie;
    public static int gmgParam;

    public static void init(int n) {
        int n2;
        Main.counter = 0;
        PMFile.loadScreen = true;
        PMImageManager.load(1108, 16);
        PMImageManager.load(5);
        mSlotWidth = PMImageManager.getWidth(mBarImgs[PMLocale.get()]);
        mSlotHeight = PMImageManager.getHeight(mBarImgs[PMLocale.get()]);
        mFromGame = n != 0;
        TransitionEffect.init(false);
        mState = 0;
        mTextNewgame = PMText.getText(262144);
        mTextDeleteGame = PMText.getText(262146);
        mTextYes = PMText.getText(262147);
        mTextNo = PMText.getText(262148);
        mTextProgression = new String[3];
        mTextLives = new String[3];
        mTextProgressionWidth = new int[3];
        mProgressionWidth = new int[3];
        for (n2 = 0; n2 < 3; ++n2) {
            int n3 = SaveGameHelper.slotLevel(n2);
            if (n3 >= 23) {
                n3 = 22;
            }
            int n4 = Defines.mWorldLookup[n3];
            n3 = Defines.mLevelLookup[n3];
            StateSlotSelection.mTextProgression[n2] = "" + ++n4 + "-" + ++n3;
            StateSlotSelection.mTextLives[n2] = "" + SaveGameHelper.slotLives(n2);
            StateSlotSelection.mTextProgressionWidth[n2] = PMFont.stringWidth(mTextProgression[n2], 0);
            StateSlotSelection.mProgressionWidth[n2] = mTextProgressionWidth[n2] + PMFont.stringWidth(mTextLives[n2], 0) + 18 + 13 + 19;
        }
        StateSlotSelection.calculateCorrectPositions();
        mSelectedSlot = -1;
        mSlotState = 0;
        for (n2 = 0; n2 < 3; ++n2) {
            StateSlotSelection.mSlotPosX[n2] = mSlotCorrectPosX[n2];
            StateSlotSelection.mSlotPosY[n2] = mSlotCorrectPosY[n2];
            StateSlotSelection.mSlotDeltaPosX[n2] = 0;
            StateSlotSelection.mSlotDeltaPosY[n2] = 0;
            StateSlotSelection.mSlotOffsetX[n2] = 0;
            StateSlotSelection.mSlotOffsetY[n2] = 0;
            StateSlotSelection.mSlotPressed[n2] = false;
            StateSlotSelection.mDeletePressed[n2] = false;
        }
        mYesPressed = false;
        mNoPressed = false;
        mInterp = 0;
        mActiveScript = null;
        mScripts = new Script[mScriptIDs.length];
        for (n2 = 0; n2 < mScriptIDs.length; ++n2) {
            StateSlotSelection.mScripts[n2] = Script.load(mScriptIDs[n2]);
        }
        Timer.initTimer();
        Dialog.init(1, 0);
        mSelectedButton = 0;
        PMAudio.load(4, "sfxMainMenuDelete", 6, 2666);
        PMAudio.load(1, "sfxMainMenuNew", 6, 538);
        PMAudio.load(2, "sfxMainMenuLoad", 6, 5954);
        PMFile.loadScreen = false;
    }

    public static void deinit() {
        for (int i = 0; i < mScripts.length; ++i) {
            Script cfr_ignored_0 = mScripts[i];
            Script.unload();
            StateSlotSelection.mScripts[i] = null;
        }
        mScripts = null;
        Dialog.deinit();
        PMAudio.deInitAudio();
        PMImageManager.unloadAll();
        Main.counter = 0;
        PMImageManager.unload(1108, 16);
    }

    private static void handleInput() {
        switch (mSlotState) {
            case 0: {
                int n;
                if (Dialog.isActive()) break;
                boolean bl = false;
                boolean bl2 = false;
                for (n = 0; n < 3; ++n) {
                    StateSlotSelection.mSlotPressed[n] = mSelectedButton == n && InputProxy.isHeldOK();
                }
                if (InputProxy.isReleasedOK() || InputProxy.isReleasedFire()) {
                    mSelectedSlot = mSelectedButton;
                    bl = true;
                } else if (InputProxy.isReleasedFire2()) {
                    if (SaveGameHelper.slotInUse(mSelectedButton)) {
                        mSelectedSlot = mSelectedButton;
                        bl2 = true;
                    }
                } else if (InputProxy.isPressedUp()) {
                    if (--mSelectedButton < 0) {
                        mSelectedButton = 2;
                    }
                    mButtonPulser.reset();
                } else if (InputProxy.isPressedDown()) {
                    if (++mSelectedButton >= 3) {
                        mSelectedButton = 0;
                    }
                    mButtonPulser.reset();
                }
                if (bl) {
                    StateSlotSelection.stopScript();
                    if (SaveGameHelper.slotInUse(mSelectedSlot)) {
                        SoundBuffer.play(1, 500);
                        mActiveScript = mScripts[3];
                        mActiveScript.rewind();
                    } else {
                        SoundBuffer.play(2, 500);
                        mActiveScript = mScripts[2];
                        mActiveScript.rewind();
                    }
                    mState = 2;
                    break;
                }
                if (!bl2) break;
                for (n = 0; n < 3; ++n) {
                    StateSlotSelection.mSlotOffsetX[n] = 0;
                    StateSlotSelection.mSlotOffsetY[n] = 0;
                    if (n == mSelectedSlot) {
                        StateSlotSelection.mSlotDeltaPosX[n] = mSlotPosX[0] - mSlotPosX[n];
                        StateSlotSelection.mSlotDeltaPosY[n] = mSlotPosY[0] - mSlotPosY[n];
                        continue;
                    }
                    StateSlotSelection.mSlotDeltaPosX[n] = 320;
                    StateSlotSelection.mSlotDeltaPosY[n] = 0;
                }
                mInterp = 0;
                mSlotState = 1;
                SoundBuffer.play(4, 500);
                break;
            }
            case 2: {
                if (Dialog.isActive()) break;
                boolean bl = false;
                boolean bl3 = false;
                mYesPressed |= InputProxy.isHeldOK() && mSelectedButton == 0;
                mNoPressed |= InputProxy.isHeldOK() && mSelectedButton == 1;
                if (InputProxy.isReleasedOK() || InputProxy.isReleasedFire()) {
                    if (mSelectedButton == 0) {
                        bl3 = true;
                    } else if (mSelectedButton == 1) {
                        bl = true;
                    }
                } else if (InputProxy.isPressedLeft() || InputProxy.isPressedRight()) {
                    mSelectedButton = mSelectedButton == 0 ? 1 : 0;
                    mButtonPulser.reset();
                } else if (InputProxy.isPressedCancel() || InputProxy.isPressedBack()) {
                    bl = true;
                }
                if (bl3) {
                    StateSlotSelection.stopScript();
                    SaveGameHelper.deleteSlot(mSelectedSlot);
                    StateSlotSelection.calculateCorrectPositions();
                    for (int i = 0; i < 3; ++i) {
                        StateSlotSelection.mSlotOffsetX[i] = 0;
                        StateSlotSelection.mSlotOffsetY[i] = 0;
                        StateSlotSelection.mSlotDeltaPosX[i] = mSlotCorrectPosX[i] - mSlotPosX[i];
                        StateSlotSelection.mSlotDeltaPosY[i] = mSlotCorrectPosY[i] - mSlotPosY[i];
                    }
                    mInterp = 0;
                    mSlotState = 3;
                    SoundBuffer.play(4, 500);
                    break;
                }
                if (!bl) break;
                StateSlotSelection.stopScript();
                for (int i = 0; i < 3; ++i) {
                    StateSlotSelection.mSlotOffsetX[i] = 0;
                    StateSlotSelection.mSlotOffsetY[i] = 0;
                    StateSlotSelection.mSlotDeltaPosX[i] = mSlotCorrectPosX[i] - mSlotPosX[i];
                    StateSlotSelection.mSlotDeltaPosY[i] = mSlotCorrectPosY[i] - mSlotPosY[i];
                }
                mInterp = 0;
                mSlotState = 3;
                SoundBuffer.play(4, 500);
            }
        }
    }

    private static void draw() {
        int n;
        int n2;
        int n3 = 65536;
        PMImageManager.draw(1108, 0, 0, false, 0, 255, n3, 65536);
        if (PMStateManager.currentState == 1) {
            n2 = 0;
            if (mSlotState != 2) {
                n = 214;
                PMImageManager.draw(495, 26, 214);
            }
        }
        block4: for (n2 = 0; n2 < 3; ++n2) {
            int n4;
            int n5;
            n = mSlotPosX[n2] + mSlotOffsetX[n2] + (mSlotPressed[n2] ? 2 : 0);
            int n6 = mSlotPosY[n2] + mSlotOffsetY[n2] + (mSlotPressed[n2] ? 2 : 0);
            int n7 = 65536;
            int n8 = PMLocale.get();
            boolean bl = false;
            if (InputProxy.hasKeyInput() && mSelectedButton == n2 && mSlotState == 0 && mState == 1 && !Dialog.isActive()) {
                n7 = mButtonPulser.getScale();
                bl = true;
            }
            if (mSelectedButton == n2 && mSlotState != 2) {
                PMImageManager.draw(mBarSelectedImgs[n8], n, n6);
            } else {
                PMImageManager.draw(mBarImgs[n8], n, n6);
            }
            int n9 = (n -= mSlotWidth >> 1) + 10;
            int n10 = n6 - 8;
            PMCanvas.PMGraphics_drawString(n9, n10, "" + (n2 + 1), 0);
            if (SaveGameHelper.slotInUse(n2)) {
                n5 = n + 21 + ((mSlotWidth - 21 >> 1) - (mProgressionWidth[n2] >> 1));
                n4 = n6;
                PMCanvas.PMGraphics_drawString(n5, n4 - 8, mTextProgression[n2], 0);
                PMImageManager.draw(473, n5 += mTextProgressionWidth[n2] + 18, n4);
                PMImageManager.draw(478, n5 += 9, n4);
                PMCanvas.PMGraphics_drawString(n5 += 13, n4 - 8, mTextLives[n2], 0);
            } else {
                PMCanvas.PMGraphics_drawString(n + 21, n6 - 8, mTextNewgame, 0);
            }
            switch (mSlotState) {
                case 0: {
                    continue block4;
                }
                case 2: {
                    n5 = 160;
                    n4 = n5 - (PMFont.stringWidth(mTextDeleteGame, 0) >> 1);
                    int n11 = n5 - 25 + (mYesPressed ? 2 : 0);
                    int n12 = 126 + (mYesPressed ? 2 : 0);
                    int n13 = n5 + 25 + (mNoPressed ? 2 : 0);
                    int n14 = 126 + (mNoPressed ? 2 : 0);
                    int n15 = 65536;
                    int n16 = 65536;
                    int n17 = 1121;
                    int n18 = 1121;
                    if (mSelectedButton == 0) {
                        n15 = mButtonPulser.getScale();
                        n17 = 1122;
                    }
                    if (mSelectedButton == 1) {
                        n16 = mButtonPulser.getScale();
                        n18 = 1122;
                    }
                    if (!Dialog.isActive()) {
                        if (mSelectedButton == 0 && InputProxy.hasKeyInput()) {
                            n15 = mButtonPulser.getScale();
                            n17 = 1122;
                        }
                        if (mSelectedButton == 1 && InputProxy.hasKeyInput()) {
                            n16 = mButtonPulser.getScale();
                            n18 = 1122;
                        }
                    }
                    PMCanvas.PMGraphics_drawString(n4, 91, mTextDeleteGame, 0);
                    PMImageManager.draw(n17, n11, n12, n15);
                    PMCanvas.PMGraphics_drawString(n11 - (PMFont.stringWidth(mTextYes, 0) >> 1), n12 - 8, mTextYes, 0);
                    PMImageManager.draw(n18, n13, n14, n16);
                    PMCanvas.PMGraphics_drawString(n13 - (PMFont.stringWidth(mTextNo, 0) >> 1), n14 - 8, mTextNo, 0);
                }
            }
        }
        Dialog.draw();
    }

    public static void update() {
        Timer.updateTimer();
        StateSlotSelection.draw();
        switch (mState) {
            case 4: {
                break;
            }
            case 0: {
                if (TransitionEffect.update()) {
                    if (!mFromGame) {
                        mActiveScript = mSlotsInUse ? mScripts[1] : mScripts[0];
                        mActiveScript.rewind();
                    }
                    mState = 1;
                }
                TransitionEffect.draw();
                break;
            }
            case 1: {
                if (mActiveScript != null) {
                    if (mActiveScript.update(Timer.mDt)) {
                        mActiveScript = null;
                    }
                    mButtonPulser.reset();
                }
                Dialog.update();
                switch (mSlotState) {
                    case 1: {
                        if ((mInterp += 5957 * Timer.mDt >> 6) >= 65536) {
                            StateSlotSelection.stopScript();
                            for (int i = 0; i < 3; ++i) {
                                int n = i;
                                mSlotPosX[n] = mSlotPosX[n] + mSlotOffsetX[i];
                                int n2 = i;
                                mSlotPosY[n2] = mSlotPosY[n2] + mSlotOffsetY[i];
                                StateSlotSelection.mSlotOffsetX[i] = 0;
                                StateSlotSelection.mSlotOffsetY[i] = 0;
                            }
                            mSlotState = 2;
                            mSelectedButton = 1;
                            break;
                        }
                        StateSlotSelection.updateMoveAnimation();
                        break;
                    }
                    case 3: {
                        if ((mInterp += 5957 * Timer.mDt >> 6) >= 65536) {
                            mSlotState = 0;
                            mSelectedSlot = -1;
                            for (int i = 0; i < 3; ++i) {
                                int n = i;
                                mSlotPosX[n] = mSlotPosX[n] + mSlotOffsetX[i];
                                int n3 = i;
                                mSlotPosY[n3] = mSlotPosY[n3] + mSlotOffsetY[i];
                                StateSlotSelection.mSlotOffsetX[i] = 0;
                                StateSlotSelection.mSlotOffsetY[i] = 0;
                            }
                            mSelectedButton = 0;
                            break;
                        }
                        StateSlotSelection.updateMoveAnimation();
                        break;
                    }
                    case 0: 
                    case 2: {
                        mButtonPulser.update(Timer.mDt);
                        StateSlotSelection.handleInput();
                    }
                }
                break;
            }
            case 2: {
                Dialog.update();
                if (mActiveScript != null) {
                    if (!mActiveScript.update(Timer.mDt)) break;
                    mActiveScript = null;
                    break;
                }
                if (Dialog.isActive()) break;
                TransitionEffect.init(true);
                mState = 3;
                SaveGameHelper.loadSlot(mSelectedSlot);
                GameState.mSelectedSlotID = mSelectedSlot;
                break;
            }
            case 3: {
                if (TransitionEffect.update()) {
                    boolean bl = true;
                    if (GameState.mSelectedSlotID == 2) {
                        // empty if block
                    }
                    if (SaveGameHelper.slotInUse(mSelectedSlot)) {
                        bl = false;
                    }
                    if (bl) {
                        GameState.mPlayCutscene = 1;
                        PMStateManager.set(4, 0);
                    } else {
                        PMStateManager.set(2, 0);
                    }
                    if (!SaveGameHelper.slotInUse(mSelectedSlot)) {
                        SaveGameHelper.saveSlot();
                    }
                }
                TransitionEffect.draw();
            }
        }
        PMSystem.nextFrame();
    }

    private static void updateMoveAnimation() {
        for (int i = 0; i < 3; ++i) {
            StateSlotSelection.mSlotOffsetX[i] = MathUtil.smoothStep(mInterp, mSlotDeltaPosX[i]);
            StateSlotSelection.mSlotOffsetY[i] = MathUtil.smoothStep(mInterp, mSlotDeltaPosY[i]);
        }
    }

    private static void calculateOverlay() {
    }

    private static void calculateCorrectPositions() {
        int n;
        mSlotsInUse = false;
        for (n = 0; n < 3; ++n) {
            if (!SaveGameHelper.slotInUse(n)) continue;
            mSlotsInUse = true;
        }
        for (n = 0; n < 3; ++n) {
            StateSlotSelection.mSlotCorrectPosX[n] = 160;
            if (mSlotsInUse) {
                int n2 = n;
                mSlotCorrectPosX[n2] = mSlotCorrectPosX[n2] - 15;
            }
            StateSlotSelection.mSlotCorrectPosY[n] = 60 + n * (mSlotHeight + 2);
        }
    }

    private static void stopScript() {
        if (mActiveScript != null) {
            mActiveScript.stop();
            mActiveScript = null;
        }
    }

    static {
        mSelectedSlot = -1;
        mSlotCorrectPosX = new int[3];
        mSlotCorrectPosY = new int[3];
        mSlotPosX = new int[3];
        mSlotPosY = new int[3];
        mSlotOffsetX = new int[3];
        mSlotOffsetY = new int[3];
        mSlotDeltaPosX = new int[3];
        mSlotDeltaPosY = new int[3];
        mInterp = 0;
        mSlotPressed = new boolean[3];
        mDeletePressed = new boolean[3];
        mScriptIDs = new short[]{-11793, -7796, -28309, -24312};
        gmgParam = 0;
    }
}

