/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.movement;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.movement.MovementTable;

public class Movement {
    private int[] mLookupTable;
    private int mSize;
    private int mStep;
    private int mLength;
    private int mValue;

    public Movement(int n) {
        this.mLookupTable = MovementTable.CreateTable(n, 2);
        this.mLength = n;
        this.mStep = n;
        this.mSize = 0;
        this.mValue = 0;
    }

    public Movement(int n, int n2) {
        this.mLookupTable = MovementTable.CreateTable(n, n2);
        this.mLength = n;
        this.mStep = n;
        this.mSize = 0;
        this.mValue = 0;
    }

    public void move(int n) {
        this.mStep = 0;
        this.mSize = n;
    }

    public int Value() {
        return this.mValue;
    }

    public void update() {
        ++this.mStep;
        this.mValue = this.mStep < this.mLength ? PMMath.MUL(this.mSize, this.mLookupTable[this.mStep]) : 0;
    }
}

