/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.snippets.list;

public class List {
    static int DEFAULT_SIZE = 4;
    static int DEFAULT_GROW = 4;
    private Object[] mData;
    private int mIndex;
    private int mSize;

    public List() {
        this.mData = new Object[DEFAULT_SIZE];
        this.mIndex = -1;
        this.mSize = 0;
    }

    public List(int n) {
        this.mData = new Object[n];
        this.mIndex = -1;
        this.mSize = 0;
    }

    public void add(Object object) {
        ++this.mIndex;
        ++this.mSize;
        if (this.mIndex >= this.mData.length) {
            Object[] objectArray = new Object[this.mData.length + DEFAULT_GROW];
            for (int i = 0; i < this.mData.length; ++i) {
                objectArray[i] = this.mData[i];
                this.mData[i] = null;
            }
            this.mData = null;
            this.mData = objectArray;
        }
        this.mData[this.mIndex] = object;
    }

    public void insertAt(int n, Object object) {
        ++this.mIndex;
        ++this.mSize;
        if (this.mIndex >= this.mData.length) {
            Object[] objectArray = new Object[this.mData.length + DEFAULT_GROW];
            for (int i = 0; i < this.mData.length; ++i) {
                objectArray[i] = this.mData[i];
                this.mData[i] = null;
            }
            this.mData = null;
            this.mData = objectArray;
        }
        for (int i = this.mIndex; i > n; --i) {
            this.mData[i] = this.mData[i - 1];
        }
        this.mData[n] = object;
    }

    public void removeElementAt(int n) {
        this.mData[n] = null;
        for (int i = n; i < this.mSize - 1; ++i) {
            this.mData[i] = this.mData[i + 1];
        }
        --this.mIndex;
        --this.mSize;
    }

    public void clear() {
        this.mIndex = -1;
        this.mSize = 0;
        for (int i = 0; i < this.mData.length; ++i) {
            this.mData[i] = null;
        }
    }

    public Object elementAt(int n) {
        return this.mData[n];
    }

    public void setElementAt(int n, Object object) {
        this.mData[n] = object;
    }

    public boolean isEmpty() {
        return this.mSize == 0;
    }

    public int size() {
        return this.mSize;
    }
}

