/*
 * Decompiled with CFR 0.152.
 */
package Banks;

import Services.CFile;
import Services.CServices;
import Sprites.CMask;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class CImage {
    public short handle;
    public short width;
    public short height;
    public short xSpot;
    public short ySpot;
    public short xAP;
    public short yAP;
    public short useCount;
    public Image img;
    public CMask mask = null;
    public CMask maskPlatform = null;

    public void loadHandle(CFile cFile) {
        this.handle = cFile.readAShort();
        cFile.skipBytes(12);
    }

    public void load(CFile cFile) {
        this.handle = cFile.readAShort();
        this.width = cFile.readAShort();
        this.height = cFile.readAShort();
        this.xSpot = cFile.readAShort();
        this.ySpot = cFile.readAShort();
        this.xAP = cFile.readAShort();
        this.yAP = cFile.readAShort();
        String string = CServices.formatDiscName(this.handle, ".png");
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream != null) {
            try {
                int n;
                int n2 = inputStream.available();
                byte[] byArray = new byte[n2];
                for (int i = 0; i < n2 && (n = inputStream.read(byArray, i, n2 - i)) >= 0; i += n) {
                }
                inputStream.close();
                if (n2 > 256) {
                    n2 = 256;
                }
                byte by = (byte)(this.handle & 0xFF ^ 0xCD);
                for (int i = 0; i < n2; ++i) {
                    byArray[i] = (byte)(byArray[i] ^ by);
                    by = (byte)((by & 0x80) != 0 ? (by << 1) + 1 : by << 1);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                this.img = Image.createImage((InputStream)byteArrayInputStream);
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public CMask getMask(int n) {
        if ((n & CMask.GCMF_PLATFORM) == 0) {
            if (this.mask == null) {
                this.mask = new CMask();
                this.mask.createMask(this.img, n);
                this.mask.xSpot = this.xSpot;
                this.mask.ySpot = this.ySpot;
            }
            return this.mask;
        }
        if (this.maskPlatform == null) {
            this.maskPlatform = new CMask();
            this.maskPlatform.createMask(this.img, n);
            this.maskPlatform.xSpot = this.xSpot;
            this.maskPlatform.ySpot = this.ySpot;
        }
        return this.maskPlatform;
    }
}

