/*
 * Decompiled with CFR 0.152.
 */
package framework.menu;

import framework.Globals;
import framework.graphics.SimpleSprite;
import framework.graphics.TextRenderer;
import javax.microedition.lcdui.Graphics;

public class MenuControl {
    public static final byte NOT_TAB = -1;
    public static final int TEXTBOX = 1;
    public static final int LABEL = 2;
    public static final int CHECKBOX = 3;
    public static final int BUTTON = 4;
    public static final int IMAGE = 5;
    public static final int SCROLLBOX = 6;
    public static final int EDITABLE_TEXT_BOX = 7;
    public static final int EDITABLE_PASSWORD_BOX = 8;
    public static final int EDITABLE_PHONE_NUMBER_BOX = 9;
    public static final int EDITABLE_LOGIN_TEXT_BOX = 10;
    public static final int EDITABLE_EMAIL_TEXT_BOX = 11;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 4;
    public static final int TOP = 8;
    public static final int MIDDLE = 16;
    public static final int BOTTOM = 32;
    public int state;
    public int tabOrder;
    public int width;
    public int height;
    public int lineCount = 1;
    public int currentLine = 0;
    public int visibleLines = 0;
    public int relativeX;
    public int relativeY;
    public boolean isVisible;
    public int type;
    public int textAlignment;
    public int textPadding;
    public int anchor;
    public StringBuffer text;
    public StringBuffer editableText;
    public StringBuffer tempEditableText;
    public int cursorPosition;
    public boolean lock;
    public boolean onlyNumericKeys;
    public boolean loginInput;
    public boolean emailValidation;
    public static final int EDITING_ON = 10;
    public static final int EDITING_OFF = 20;
    public int status;
    public StringBuffer infoText;
    public int pozXEditedText;
    public int pozYEditedText;
    public int textPozXEditedText;
    public int textPozYEditedText;
    int infoPositionY;
    int infoTextTotalLinesCount;
    int editableControlBackgroundInfoHeight;
    public SimpleSprite image;
    public SimpleSprite fontNormal;
    public SimpleSprite fontHighLighted;
    public SimpleSprite fontHighLighted2;
    public int spriteTransformation = 0;
    public int pozX;
    public int pozY;
    public int textPozX;
    public int textPozY;
    private boolean centerBoxText;

    public void calculatePositions(int menuFormOffsetX, int menuFormOffsetY, TextRenderer renderer) {
        this.pozX = menuFormOffsetX + this.relativeX;
        this.pozY = menuFormOffsetY + this.relativeY;
        this.setTextPozX(menuFormOffsetX + this.relativeX);
        this.setTextPozY(menuFormOffsetY + this.relativeY);
        if (this.isVisible && (this.getType() == 4 || this.getType() == 2 || this.getType() == 3 || this.getType() == 7 || this.getType() == 8 || this.getType() == 9)) {
            if (this.getText() != null) {
                if ((this.anchor & 1) != 0) {
                    if ((this.textAlignment & 1) != 0) {
                        this.setTextPozX(this.getTextPozX() - (this.width >> 1) + this.textPadding);
                    } else if ((this.textAlignment & 2) != 0) {
                        this.setTextPozX(this.getTextPozX() - (renderer.getStringWidth(this.getText().length() / this.lineCount) >> 1));
                    } else if ((this.textAlignment & 4) != 0) {
                        this.setTextPozX(this.getTextPozX() + (this.width >> 1) - renderer.getStringWidth(this.getText().length() / this.lineCount) - this.textPadding);
                    }
                } else if ((this.anchor & 4) != 0) {
                    if ((this.textAlignment & 1) != 0) {
                        this.setTextPozX(this.getTextPozX() + this.textPadding);
                    } else if ((this.textAlignment & 2) != 0) {
                        this.setTextPozX(this.getTextPozX() + (this.width - renderer.getStringWidth(this.getText().length() / this.lineCount) >> 1));
                    } else if ((this.textAlignment & 4) != 0) {
                        this.setTextPozX(this.getTextPozX() + this.width - renderer.getStringWidth(this.getText().length() / this.lineCount) - this.textPadding);
                    }
                } else if ((this.anchor & 8) != 0) {
                    if ((this.textAlignment & 1) != 0) {
                        this.setTextPozX(this.getTextPozX() - this.width + this.textPadding);
                    } else if ((this.textAlignment & 2) != 0) {
                        this.setTextPozX(this.getTextPozX() - (this.width >> 1) - (renderer.getStringWidth(this.getText().length()) >> 1));
                    } else if ((this.textAlignment & 4) != 0) {
                        this.setTextPozX(this.getTextPozX() - renderer.getStringWidth(this.getText().length() / this.lineCount));
                    }
                }
                if ((this.anchor & 2) != 0) {
                    if ((this.textAlignment & 8) != 0) {
                        this.setTextPozY(this.getTextPozY() - (this.height >> 1) + this.textPadding);
                    } else if ((this.textAlignment & 0x10) != 0) {
                        this.setTextPozY(this.getTextPozY() - (renderer.getStringHeight(this.lineCount) >> 1));
                    } else if ((this.textAlignment & 0x20) != 0) {
                        this.setTextPozY(this.getTextPozY() + (this.height >> 1) - (renderer.getStringHeight(this.lineCount) >> 1));
                    }
                } else if ((this.anchor & 0x10) != 0) {
                    if ((this.textAlignment & 8) != 0) {
                        this.setTextPozY(this.getTextPozY() + this.textPadding);
                    } else if ((this.textAlignment & 0x10) != 0) {
                        this.setTextPozY(this.getTextPozY() + (this.height - renderer.getStringHeight(this.lineCount) >> 1));
                    } else if ((this.textAlignment & 0x20) != 0) {
                        this.setTextPozY(this.getTextPozY() + this.height - renderer.getStringHeight(this.lineCount) - this.textPadding);
                    }
                } else if ((this.anchor & 0x20) != 0) {
                    if ((this.textAlignment & 8) != 0) {
                        this.setTextPozY(this.getTextPozY() - this.height + this.textPadding);
                    } else if ((this.textAlignment & 0x10) != 0) {
                        this.setTextPozY(this.getTextPozY() - (this.height + renderer.getStringHeight(this.lineCount) >> 1));
                    } else if ((this.textAlignment & 0x20) != 0) {
                        this.setTextPozY(this.getTextPozY() - renderer.getStringHeight(this.lineCount) - this.textPadding);
                    }
                }
            }
        } else if (this.getType() == 1 || this.getType() == 6) {
            if ((this.anchor & 1) != 0) {
                this.setTextPozX(this.getTextPozX() - (this.width >> 1) + this.textPadding);
            } else if ((this.anchor & 4) != 0) {
                this.setTextPozX(this.getTextPozX() + this.textPadding);
            } else if ((this.anchor & 8) != 0) {
                this.setTextPozX(this.getTextPozX() - this.width + this.textPadding);
            }
            if ((this.anchor & 2) != 0) {
                if ((this.textAlignment & 8) != 0) {
                    this.setTextPozY(this.getTextPozY() - (this.height >> 1) + this.textPadding);
                } else if ((this.textAlignment & 0x10) != 0) {
                    this.setTextPozY(this.getTextPozY() - (renderer.getStringHeight(this.lineCount) >> 1));
                } else if ((this.textAlignment & 0x20) != 0) {
                    this.setTextPozY(this.getTextPozY() + (this.height >> 1) - (renderer.getStringHeight(this.lineCount) >> 1));
                }
            } else if ((this.anchor & 0x10) != 0) {
                if ((this.textAlignment & 8) != 0) {
                    this.setTextPozY(this.getTextPozY() + this.textPadding);
                } else if ((this.textAlignment & 0x10) != 0) {
                    this.setTextPozY(this.getTextPozY() + (this.height - renderer.getStringHeight(this.lineCount) >> 1));
                } else if ((this.textAlignment & 0x20) != 0) {
                    this.setTextPozY(this.getTextPozY() + this.height - renderer.getStringHeight(this.lineCount) - this.textPadding);
                }
            } else if ((this.anchor & 0x20) != 0) {
                if ((this.textAlignment & 8) != 0) {
                    this.setTextPozY(this.getTextPozY() - this.height + this.textPadding);
                } else if ((this.textAlignment & 0x10) != 0) {
                    this.setTextPozY(this.getTextPozY() - (this.height + renderer.getStringHeight(this.lineCount) >> 1));
                } else if ((this.textAlignment & 0x20) != 0) {
                    this.setTextPozY(this.getTextPozY() - renderer.getStringHeight(this.lineCount) - this.textPadding);
                }
            }
        }
    }

    public void calculatePositions(int menuFormOffsetX, int menuFormOffsetY, TextRenderer renderer, StringBuffer editedText) {
        this.setTextPozXEditedText(menuFormOffsetX + this.relativeX);
        this.setTextPozYEditedText(menuFormOffsetY + this.relativeY);
        if (this.isVisible && (this.getType() == 7 || this.getType() == 8 || this.getType() == 9) && editedText != null) {
            if ((this.anchor & 1) != 0) {
                if ((this.textAlignment & 1) != 0) {
                    this.setTextPozXEditedText(this.getTextPozXEditedText() - (this.width >> 1) + this.textPadding);
                } else if ((this.textAlignment & 2) != 0) {
                    this.setTextPozXEditedText(this.getTextPozXEditedText() - (renderer.getStringWidth(editedText.length() / this.lineCount) >> 1));
                } else if ((this.textAlignment & 4) != 0) {
                    this.setTextPozXEditedText(this.getTextPozXEditedText() + (this.width >> 1) - renderer.getStringWidth(editedText.length() / this.lineCount) - this.textPadding);
                }
            } else if ((this.anchor & 4) != 0) {
                if ((this.textAlignment & 1) != 0) {
                    this.setTextPozXEditedText(this.getTextPozXEditedText() + this.textPadding);
                } else if ((this.textAlignment & 2) != 0) {
                    this.setTextPozXEditedText(this.getTextPozXEditedText() + (this.width - renderer.getStringWidth(editedText.length() / this.lineCount) >> 1));
                } else if ((this.textAlignment & 4) != 0) {
                    this.setTextPozXEditedText(this.getTextPozXEditedText() + this.width - renderer.getStringWidth(editedText.length() / this.lineCount) - this.textPadding);
                }
            } else if ((this.anchor & 8) != 0) {
                if ((this.textAlignment & 1) != 0) {
                    this.setTextPozXEditedText(this.getTextPozXEditedText() - this.width + this.textPadding);
                } else if ((this.textAlignment & 2) != 0) {
                    this.setTextPozXEditedText(this.getTextPozXEditedText() - (this.width >> 1) - (renderer.getStringWidth(editedText.length()) >> 1));
                } else if ((this.textAlignment & 4) != 0) {
                    this.setTextPozXEditedText(this.getTextPozXEditedText() - renderer.getStringWidth(editedText.length() / this.lineCount));
                }
            }
            if ((this.anchor & 2) != 0) {
                if ((this.textAlignment & 8) != 0) {
                    this.setTextPozYEditedText(this.getTextPozYEditedText() - (this.height >> 1) + this.textPadding);
                } else if ((this.textAlignment & 0x10) != 0) {
                    this.setTextPozYEditedText(this.getTextPozYEditedText() - (renderer.getStringHeight(this.lineCount) >> 1));
                } else if ((this.textAlignment & 0x20) != 0) {
                    this.setTextPozYEditedText(this.getTextPozYEditedText() + (this.height >> 1) - (renderer.getStringHeight(this.lineCount) >> 1));
                }
            } else if ((this.anchor & 0x10) != 0) {
                if ((this.textAlignment & 8) != 0) {
                    this.setTextPozYEditedText(this.getTextPozYEditedText() + this.textPadding);
                } else if ((this.textAlignment & 0x10) != 0) {
                    this.setTextPozYEditedText(this.getTextPozYEditedText() + (this.height - renderer.getStringHeight(this.lineCount) >> 1));
                } else if ((this.textAlignment & 0x20) != 0) {
                    this.setTextPozYEditedText(this.getTextPozYEditedText() + this.height - renderer.getStringHeight(this.lineCount) - this.textPadding);
                }
            } else if ((this.anchor & 0x20) != 0) {
                if ((this.textAlignment & 8) != 0) {
                    this.setTextPozYEditedText(this.getTextPozYEditedText() - this.height + this.textPadding);
                } else if ((this.textAlignment & 0x10) != 0) {
                    this.setTextPozYEditedText(this.getTextPozYEditedText() - (this.height + renderer.getStringHeight(this.lineCount) >> 1));
                } else if ((this.textAlignment & 0x20) != 0) {
                    this.setTextPozYEditedText(this.getTextPozYEditedText() - renderer.getStringHeight(this.lineCount) - this.textPadding);
                }
            }
        }
    }

    public void draw(Graphics graphics, TextRenderer renderer) {
        if (this.isVisible && (this.getType() == 4 || this.getType() == 2 || this.getType() == 3)) {
            if (this.image != null) {
                this.image.paintWithAnchor(graphics, this.pozX, this.pozY, this.state, this.spriteTransformation, this.anchor);
            }
            if (this.getText() != null) {
                switch (this.state) {
                    case 0: {
                        renderer.setCurrentFont(this.fontNormal);
                        break;
                    }
                    case 1: {
                        renderer.setCurrentFont(this.fontHighLighted);
                        break;
                    }
                    case 2: {
                        renderer.setCurrentFont(this.fontHighLighted2);
                    }
                }
                renderer.renderText(graphics, this.getTextPozX(), this.getTextPozY(), this.getText());
                renderer.setCurrentFont(this.fontNormal);
            }
        } else if (this.isVisible && this.getType() == 5) {
            if (this.image != null) {
                this.image.paintWithAnchor(graphics, this.pozX, this.pozY, this.state, this.spriteTransformation, this.anchor);
            }
        } else if (this.isVisible && (this.getType() == 6 || this.getType() == 1)) {
            if (this.image != null) {
                this.image.paintWithAnchor(graphics, this.pozX, this.pozY, this.state, this.spriteTransformation, this.anchor);
            }
            if (this.getText() != null) {
                switch (this.state) {
                    case 0: {
                        renderer.setCurrentFont(this.fontNormal);
                        break;
                    }
                    case 1: {
                        renderer.setCurrentFont(this.fontHighLighted);
                        break;
                    }
                    case 2: {
                        renderer.setCurrentFont(this.fontHighLighted2);
                    }
                }
                boolean bl = this.centerBoxText = (this.textAlignment & 2) != 0;
                if (this.currentLine + this.visibleLines <= this.lineCount && this.currentLine >= 0) {
                    renderer.renderTextWordBreak(graphics, this.getTextPozX(), this.getTextPozY(), this.width, this.height, this.currentLine, this.getText(), this.centerBoxText);
                } else if (this.currentLine + this.visibleLines > this.lineCount) {
                    this.currentLine = this.lineCount - this.visibleLines;
                    renderer.renderTextWordBreak(graphics, this.getTextPozX(), this.getTextPozY(), this.width, this.height, this.currentLine, this.getText(), this.centerBoxText);
                } else if (this.currentLine < 0) {
                    renderer.renderTextWordBreak(graphics, this.getTextPozX(), this.getTextPozY(), this.width, this.height, 0, this.getText(), this.centerBoxText);
                    this.currentLine = 0;
                }
                renderer.setCurrentFont(this.fontNormal);
            }
            this.drawBackgroundInfoText(graphics, renderer);
        } else if (this.isVisible && (this.getType() == 7 || this.getType() == 9)) {
            if (this.getText() != null) {
                switch (this.state) {
                    case 0: {
                        renderer.setCurrentFont(this.fontNormal);
                        break;
                    }
                    case 1: {
                        renderer.setCurrentFont(this.fontHighLighted);
                        break;
                    }
                    case 2: {
                        renderer.setCurrentFont(this.fontHighLighted2);
                    }
                }
                this.calculatePositions(this.lineCount, this.lineCount, renderer, this.editableText);
                this.lock = this.status == 10;
                try {
                    renderer.renderEditableText(graphics, this.getTextPozX(), this.getTextPozY(), this.getTextPozXEditedText(), this.getTextPozYEditedText() + renderer.getCurrentFont().getFrameHeight(), this.getText(), this.editableText, this.lock, this.cursorPosition, false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                renderer.setCurrentFont(this.fontNormal);
            }
            this.drawBackgroundInfoText(graphics, renderer);
        } else if (this.isVisible && this.getType() == 8) {
            if (this.getText() != null) {
                switch (this.state) {
                    case 0: {
                        renderer.setCurrentFont(this.fontNormal);
                        break;
                    }
                    case 1: {
                        renderer.setCurrentFont(this.fontHighLighted);
                        break;
                    }
                    case 2: {
                        renderer.setCurrentFont(this.fontHighLighted2);
                    }
                }
                this.calculatePositions(this.lineCount, this.lineCount, renderer, this.editableText);
                this.lock = this.status == 10;
                try {
                    renderer.renderEditableText(graphics, this.getTextPozX(), this.getTextPozY(), this.getTextPozXEditedText(), this.getTextPozYEditedText() + renderer.getCurrentFont().getFrameHeight(), this.getText(), this.editableText, this.lock, this.cursorPosition, true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                renderer.setCurrentFont(this.fontNormal);
            }
            this.drawBackgroundInfoText(graphics, renderer);
        }
    }

    public void drawBackgroundInfoText(Graphics graphics, TextRenderer renderer) {
        if (this.getInfoText() != null) {
            try {
                this.infoPositionY = this.getTextPozYEditedText() + renderer.getCurrentFont().getFrameHeight() * 2 + 5;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            graphics.setColor(153, 204, 255);
            this.editableControlBackgroundInfoHeight = this.infoTextTotalLinesCount * renderer.lineSpacing + Globals.editableControlBackgroundInfoHeightOffsetY;
            graphics.fillRoundRect(Globals.editableControlBackgroundInfoTextOffsetX / 2, this.infoPositionY, Globals.editableControlBackgroundInfoWidth, this.editableControlBackgroundInfoHeight, 15, 15);
            graphics.setColor(0, 0, 0);
            graphics.drawRoundRect(Globals.editableControlBackgroundInfoTextOffsetX / 2, this.infoPositionY, Globals.editableControlBackgroundInfoWidth, this.editableControlBackgroundInfoHeight, 15, 15);
            renderer.renderTextWordBreak(graphics, Globals.editableControlBackgroundInfoTextOffsetX / 2, this.infoPositionY + this.editableControlBackgroundInfoHeight / 2 - this.infoTextTotalLinesCount * renderer.lineSpacing / 2, Globals.editableControlBackgroundInfoWidth, this.editableControlBackgroundInfoHeight, 0, this.getInfoText(), true);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getType() {
        return this.type;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public StringBuffer getText() {
        return this.text;
    }

    public void setText(StringBuffer text) {
        this.text = text;
    }

    public int getTextPozX() {
        return this.textPozX;
    }

    public void setTextPozX(int textPozX) {
        this.textPozX = textPozX;
    }

    public int getTextPozY() {
        return this.textPozY;
    }

    public void setTextPozY(int textPozY) {
        this.textPozY = textPozY;
    }

    public int getPozXEditedText() {
        return this.pozXEditedText;
    }

    public void setPozXEditedText(int pozXEditedText) {
        this.pozXEditedText = pozXEditedText;
    }

    public int getPozYEditedText() {
        return this.pozYEditedText;
    }

    public void setPozYEditedText(int pozYEditedText) {
        this.pozYEditedText = pozYEditedText;
    }

    public int getTextPozXEditedText() {
        return this.textPozXEditedText;
    }

    public void setTextPozXEditedText(int textPozXEditedText) {
        this.textPozXEditedText = textPozXEditedText;
    }

    public int getTextPozYEditedText() {
        return this.textPozYEditedText;
    }

    public void setTextPozYEditedText(int textPozYEditedText) {
        this.textPozYEditedText = textPozYEditedText;
    }

    public StringBuffer getInfoText() {
        return this.infoText;
    }

    public void setInfoText(StringBuffer info) {
        this.infoText = info;
        this.infoTextTotalLinesCount = info != null ? TextRenderer.getInstance().getWordBreakLinesCount(Globals.editableControlBackgroundInfoWidth, 320, this.getInfoText(), true) : 1;
    }
}

