/*
 * Decompiled with CFR 0.152.
 */
package framework.profiling;

import framework.graphics.TextRenderer;
import framework.profiling.ProfilerData;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class Profiler {
    private static final int PROFILING_DURATION = 5000;
    private static Hashtable profilerDatas = new Hashtable();
    private static Vector excludedProfilerDatas = new Vector();
    private static int profilingDuration = 5000;
    private static int profilingTimer;
    public static long totalDuration;

    public static void start(String name) {
        ProfilerData profilerData = null;
        if (!profilerDatas.containsKey(name)) {
            profilerData = new ProfilerData(name);
            profilerDatas.put(name, profilerData);
        } else {
            profilerData = (ProfilerData)profilerDatas.get(name);
        }
        if (!Profiler.vectorContains(excludedProfilerDatas, name)) {
            profilerData.startTimer();
        }
    }

    public static void stop(String name) {
        ProfilerData profilerData = (ProfilerData)profilerDatas.get(name);
        if (!Profiler.vectorContains(excludedProfilerDatas, name)) {
            profilerData.stopTimer();
        }
    }

    public static void includeProfiler(String name) {
        excludedProfilerDatas.removeElement(name);
    }

    public static void excludeProfiler(String name) {
        if (!Profiler.vectorContains(excludedProfilerDatas, name)) {
            excludedProfilerDatas.addElement(name);
        }
    }

    public static void removeProfiler(String name) {
        profilerDatas.remove(name);
    }

    public static void setProfilingDuration(int profilingDuration) {
        Profiler.profilingDuration = profilingDuration;
    }

    public static void render(Graphics g, int x, int y) {
        int collectionSize = profilerDatas.size();
        int fontHeight = TextRenderer.getInstance().getStringHeight(1);
        Enumeration e = profilerDatas.elements();
        while (e.hasMoreElements()) {
            ProfilerData profilerData = (ProfilerData)e.nextElement();
            if (Profiler.vectorContains(excludedProfilerDatas, profilerData.name)) continue;
            profilerData.render(g, x, y);
            y += fontHeight;
        }
    }

    public static void resetAll() {
        totalDuration = 0L;
        Enumeration e = profilerDatas.elements();
        while (e.hasMoreElements()) {
            ProfilerData profilerData = (ProfilerData)e.nextElement();
            if (Profiler.vectorContains(excludedProfilerDatas, profilerData.name)) continue;
            profilerData.resetAccDuration();
        }
    }

    private static boolean vectorContains(Vector vector, Object object) {
        if (vector == null) {
            return false;
        }
        int collectionSize = vector.size();
        for (int i = 0; i < collectionSize; ++i) {
            Object obj = vector.elementAt(i);
            if (!(obj == null ? object == null : obj.equals(object))) continue;
            return true;
        }
        return false;
    }

    static {
        totalDuration = 0L;
    }
}

