/*
 * Decompiled with CFR 0.152.
 */
package gs.common;

import gs.exceptions.BoundedStringException;

public class BoundedString {
    private String str;

    public BoundedString() {
        this.str = "";
    }

    public BoundedString(String str) throws BoundedStringException {
        if (str.length() > 64) {
            throw new BoundedStringException("string size out of bounds: " + str.length() + " > " + 64);
        }
        this.str = str;
    }

    public String toString() {
        return this.str;
    }

    public BoundedString concat(String str) throws BoundedStringException {
        return new BoundedString(this.str + str);
    }

    public BoundedString concat(BoundedString bstr) throws BoundedStringException {
        return new BoundedString(this.str + bstr.str);
    }

    public BoundedString concat(Integer i) throws BoundedStringException {
        return new BoundedString(this.str + i.toString());
    }

    public byte[] getBytes() {
        return this.str.getBytes();
    }

    public static BoundedString empty() {
        return new BoundedString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BoundedString) {
            return this.str.equals(((BoundedString)obj).str);
        }
        return false;
    }

    public int hashCode() {
        return this.str.hashCode();
    }
}

