/*
 * Decompiled with CFR 0.152.
 */
package gs.client;

import gs.common.BoundedString;
import gs.common.Constants;
import gs.common.datapackets.EventDataPacket;
import gs.common.datapackets.FinalGameStateDataPacket;
import gs.common.datapackets.GameStateDataPacket;
import gs.common.datapackets.IDataStringConvertible;
import gs.common.datapackets.InfoBoardMessageDataPacket;
import gs.common.datapackets.MessageDataPacket;
import gs.common.datapackets.PacketQueue;
import gs.common.datapackets.PulseDataPacket;
import gs.common.datapackets.QueryDataPacket;
import gs.common.datapackets.QueryResponseDataPacket;
import gs.common.enumerations.EventType;
import gs.common.enumerations.GameType;
import gs.common.enumerations.PacketType;
import gs.common.enumerations.QueryType;
import gs.common.gsconnectors.IGSConnector;
import gs.common.gsid.GSStringId;
import gs.common.gsid.IGSId;
import gs.common.info.IEventInfo;
import gs.common.info.IGameInstanceInfo;
import gs.common.info.IInfoBoardMessageInfo;
import gs.common.info.IMessageInfo;
import gs.common.info.IPlayerInfo;
import gs.common.info.IPlayerStateInfo;
import gs.common.info.IQueryResponseInfo;
import gs.common.info.IRankingInfo;
import gs.common.info.IScoreInfo;
import gs.common.utils.DataPacketUtil;
import gs.common.utils.ObjectUtil;
import gs.common.utils.SHAUtil;
import gs.exceptions.ConnectorException;
import gs.exceptions.GSException;
import java.util.Date;
import java.util.Vector;

public abstract class ClientInterface {
    protected PacketQueue gameStateQueue;
    protected Boolean queueGameStates;
    protected PacketQueue messageQueue;
    protected Boolean queueMessages;
    protected PacketQueue eventQueue;
    protected Boolean queueEvents;
    protected PacketQueue infoBoardQueue;
    protected Boolean queueInfoBoard;
    protected PacketQueue responseQueue;
    protected Boolean queueQueryResponses;
    protected String serverIp;
    protected int serverPort;
    protected IPlayerInfo myInfo;
    protected IGSConnector connector;
    protected Short gameType;
    protected IGSId mobileId;
    protected Short mobileIdPolicy;
    protected Boolean firstLogin;
    protected String appVersion;

    public ClientInterface() {
        this.gameType = GameType.Test;
        this.serverIp = "94.23.94.20";
        this.serverPort = Constants.DEFAULT_GATEWAY_PORT;
        this.eventQueue = new PacketQueue();
        this.gameStateQueue = new PacketQueue();
        this.messageQueue = new PacketQueue();
        this.responseQueue = new PacketQueue();
        this.infoBoardQueue = new PacketQueue();
        this.myInfo = null;
        this.connector = null;
        this.mobileId = null;
        this.firstLogin = Boolean.TRUE;
        this.appVersion = "unknown";
        this.queueAllPackets(Boolean.TRUE);
    }

    public ClientInterface(Short gameType, String serverIp, int serverPort, String appVersion) {
        this.gameType = gameType;
        this.serverIp = serverIp;
        this.serverPort = serverPort;
        this.eventQueue = new PacketQueue();
        this.gameStateQueue = new PacketQueue();
        this.messageQueue = new PacketQueue();
        this.responseQueue = new PacketQueue();
        this.infoBoardQueue = new PacketQueue();
        this.myInfo = null;
        this.connector = null;
        this.mobileId = null;
        this.firstLogin = Boolean.TRUE;
        this.appVersion = appVersion;
        this.queueAllPackets(Boolean.TRUE);
    }

    protected void setMyInfo(IPlayerInfo myInfo) {
        this.myInfo = myInfo;
        this.notifyMeUpdateState();
    }

    public void reset() throws GSException {
        if (this.connector.isConnected().equals(Boolean.TRUE)) {
            this.connector.closeConnection();
        }
        this.myInfo = null;
        this.eventQueue.clear();
        this.gameStateQueue.clear();
        this.messageQueue.clear();
        this.responseQueue.clear();
        this.infoBoardQueue.clear();
    }

    public void connect() throws GSException {
        if (this.connector.isConnected().equals(Boolean.TRUE)) {
            throw new ConnectorException("Already connected. Please close previous connection first.");
        }
        this.connector.connect(this.getServerIp(), this.getServerPort());
    }

    public void closeConnection() throws GSException {
        this.connector.closeConnection();
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String val) {
        this.serverIp = val;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int val) {
        this.serverPort = val;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String version) {
        this.appVersion = version;
    }

    public Boolean getQueueGameStates() {
        return this.queueGameStates;
    }

    public Boolean getQueueMessages() {
        return this.queueMessages;
    }

    public Boolean getQueueEvents() {
        return this.queueEvents;
    }

    public Boolean getQueueQueryResponses() {
        return this.queueQueryResponses;
    }

    public Boolean getQueueInfoBoard() {
        return this.queueInfoBoard;
    }

    public void setQueueGameStates(Boolean val) {
        this.queueGameStates = val;
    }

    public void setQueueMessages(Boolean val) {
        this.queueMessages = val;
    }

    public void setQueueEvents(Boolean val) {
        this.queueEvents = val;
    }

    public void setQueueQueryResponses(Boolean val) {
        this.queueQueryResponses = val;
    }

    public void setQueueInfoBoard(Boolean val) {
        this.queueInfoBoard = val;
    }

    public void log(String message) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(ObjectUtil.dateToString(new Date()));
        sb.append("] ");
        sb.append(message);
        System.out.println(sb);
    }

    public abstract void retreiveMobileId() throws GSException;

    public void notifyRetreiveMobileId(IGSId mobileId) {
        this.mobileId = mobileId;
    }

    public abstract void queryUserForMobileId();

    public void finishedQueryUserForMobileId(String mobileId) {
        this.notifyRetreiveMobileId(new GSStringId(mobileId));
    }

    public IGSId getMobileId() {
        return this.mobileId;
    }

    public Short getMobileIdPolicy() {
        return this.mobileIdPolicy;
    }

    public void setMobileIdPolicy(Short mobileIdPolicy) {
        this.mobileIdPolicy = mobileIdPolicy;
    }

    public void queueAllPackets(Boolean val) {
        this.queueGameStates = val;
        this.queueMessages = val;
        this.queueEvents = val;
        this.queueQueryResponses = val;
        this.queueInfoBoard = val;
    }

    public void authenticate(BoundedString login, BoundedString password) throws GSException {
        Vector<Object> params = new Vector<Object>();
        if (BoundedString.empty().equals(login)) {
            params.addElement(new BoundedString("guest"));
        } else {
            params.addElement(login);
        }
        if (BoundedString.empty().equals(password)) {
            params.addElement(new BoundedString("guest"));
        } else {
            password = new BoundedString(SHAUtil.coding(password.toString()));
            params.addElement(password);
        }
        if (this.mobileId != null) {
            params.addElement(this.mobileId);
        } else {
            params.addElement("");
        }
        params.addElement(this.getGameType());
        params.addElement(this.firstLogin);
        params.addElement(this.appVersion);
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.Authentication, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyAuthenticate();

    public void register(BoundedString login, BoundedString password, BoundedString email) throws GSException {
        if (BoundedString.empty().equals(login) || BoundedString.empty().equals(password) || BoundedString.empty().equals(email)) {
            throw new GSException("Incomplete registration data");
        }
        password = new BoundedString(SHAUtil.coding(password.toString()));
        Vector<Object> params = new Vector<Object>();
        params.addElement(login);
        params.addElement(password);
        params.addElement(email);
        if (this.mobileId != null) {
            params.addElement(this.mobileId);
        } else {
            params.addElement("");
        }
        QueryDataPacket dp = new QueryDataPacket(QueryType.Registration, params);
        this.connector.send(dp);
    }

    public abstract void notifyRegister();

    public void recoverPassword(BoundedString login) throws GSException {
        if (BoundedString.empty().equals(login)) {
            throw new GSException("Invalid login");
        }
        Vector<Object> params = new Vector<Object>();
        params.addElement(login);
        if (this.mobileId != null) {
            params.addElement(this.mobileId);
        } else {
            params.addElement("");
        }
        QueryDataPacket dp = new QueryDataPacket(QueryType.PasswordRecovery, params);
        this.connector.send(dp);
    }

    public abstract void notifyRecoverPassword();

    public void changePassword(BoundedString oldPassword, BoundedString newPassword) throws GSException {
        if (BoundedString.empty().equals(oldPassword) || BoundedString.empty().equals(newPassword)) {
            throw new GSException("One of the passwords is empty");
        }
        Vector<Object> params = new Vector<Object>();
        params.addElement(new BoundedString(SHAUtil.coding(oldPassword.toString())));
        params.addElement(new BoundedString(SHAUtil.coding(newPassword.toString())));
        if (this.mobileId != null) {
            params.addElement(this.mobileId);
        } else {
            params.addElement("");
        }
        QueryDataPacket dp = new QueryDataPacket(QueryType.ChangePassword, params);
        this.connector.send(dp);
    }

    public abstract void notifyChangePassword();

    public void accountActivate() throws GSException {
        Vector<Object> params = new Vector<Object>();
        if (this.mobileId != null) {
            params.addElement(this.mobileId);
        } else {
            params.addElement("");
        }
        params.addElement(this.getGameType());
        QueryDataPacket dp = new QueryDataPacket(QueryType.ServerAccountActivate, params);
        this.connector.send(dp);
    }

    public abstract void notifyAccountActivate();

    public void accountDeactivate() throws GSException {
        Vector<Object> params = new Vector<Object>();
        if (this.mobileId != null) {
            params.addElement(this.mobileId);
        } else {
            params.addElement("");
        }
        params.addElement(this.getGameType());
        QueryDataPacket dp = new QueryDataPacket(QueryType.ServerAccountDeactivate, params);
        this.connector.send(dp);
    }

    public abstract void notifyAccountDeactivate();

    public void accountIsActive() throws GSException {
        QueryDataPacket dp = new QueryDataPacket(QueryType.ServerAccountIsActive, new Vector());
        this.connector.send(dp);
    }

    public abstract void notifyAccountIsActive(Boolean var1, Date var2);

    public void userSingleChanged() throws GSException {
        Vector<Object> params = new Vector<Object>();
        if (this.mobileId != null) {
            params.addElement(this.mobileId);
        } else {
            params.addElement("");
        }
        params.addElement(this.getGameType());
        QueryDataPacket dp = new QueryDataPacket(QueryType.ServerUserSingleCharged, params);
        this.connector.send(dp);
    }

    public abstract void notifyUserSingleCharged();

    public void tellFriendAboutOMPG(BoundedString phoneNumber) throws GSException {
        Vector<Object> params = new Vector<Object>();
        params.addElement(phoneNumber);
        if (this.mobileId != null) {
            params.addElement(this.mobileId);
        } else {
            params.addElement("");
        }
        QueryDataPacket dp = new QueryDataPacket(QueryType.ServerTellFriendAboutOMPG, params);
        this.connector.send(dp);
    }

    public abstract void notifyTellFriendAboutOMPG();

    public void serverGetTime() throws GSException {
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.ServerGetTime, new Vector());
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyServerGetTime(Date var1);

    public void serverGetTextMessageInfo(Short mobileTextMessageType) throws GSException {
        Vector<Short> params = new Vector<Short>();
        params.addElement(mobileTextMessageType);
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.ServerGetTextMessageInfo, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyServerGetTextMessageInfo(BoundedString var1, String var2);

    public void serverGetNewAppVersionUrl() throws GSException {
        Vector<Short> params = new Vector<Short>();
        params.addElement(this.gameType);
        QueryDataPacket dp = new QueryDataPacket(QueryType.ServerGetNewAppVersionUrl, params);
        this.connector.send(dp);
    }

    public abstract void notifyServerGetNewAppVersionUrl(String var1);

    public void serverListRooms(Short gt) throws GSException {
        Vector<Short> params = new Vector<Short>();
        params.addElement(gt);
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.ServerListRooms, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyServerListRooms(Vector var1);

    public void serverListBuddies() throws GSException {
        Vector params = new Vector();
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.ServerListBuddies, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyServerListBuddies(Vector var1);

    public void serverGetRanking(Integer from, Integer to, Boolean contest) throws GSException {
        Vector<Comparable<Boolean>> params = new Vector<Comparable<Boolean>>();
        params.addElement(contest);
        params.addElement(from);
        params.addElement(to);
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.ServerGetRankingFromTo, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyServerGetRanking(Vector var1);

    public void serverGetRankingForPlayer(IGSId playerId, Boolean contest) throws GSException {
        Vector<Object> params = new Vector<Object>();
        params.addElement(contest);
        params.addElement(playerId);
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.ServerGetRankingPlayer, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyServerGetRankingForPlayer(IRankingInfo var1, Integer var2);

    public void serverGetRankingSize(Boolean contest) throws GSException {
        Vector<Boolean> params = new Vector<Boolean>();
        params.addElement(contest);
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.ServerGetRankingSize, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyServerGetRankingSize(Integer var1);

    public void serverGetInfoBoardMessages() throws GSException {
        Vector params = new Vector();
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.ServerGetInfoBoardMessages, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyServerGetInfoBoradMessages();

    public void serverGetInfoBoardMessageCount() throws GSException {
        Vector params = new Vector();
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.ServerGetInfoBoardMessageCount, params);
        this.connector.send(queryDataPacket);
    }

    public void serverDeleteInfoBoardMessage(IGSId messageId) throws GSException {
        Vector<IGSId> params = new Vector<IGSId>();
        params.addElement(messageId);
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.ServerDeleteInfoBoardMessage, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyServerDeleteInfoBoardMessage();

    public abstract void notifyServerGetInfoBoardMessageCount(Integer var1);

    public void invitationSend(IGSId playerId) throws GSException {
        Vector<IGSId> params = new Vector<IGSId>();
        params.addElement(playerId);
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.InvitationSend, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyInvitationSend();

    public void invitationAccept(IGSId playerId) throws GSException {
        Vector<IGSId> params = new Vector<IGSId>();
        params.addElement(playerId);
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.InvitationAccept, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyInvitationAccept(Vector var1);

    public void roomEnter(Integer roomNo) throws GSException {
        Vector<Integer> params = new Vector<Integer>();
        params.addElement(roomNo);
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.RoomEnter, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyRoomEnter();

    public void roomLeave() throws GSException {
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.RoomLeave, new Vector());
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyRoomLeave();

    public void roomListGames() throws GSException {
        Vector<Integer> params = new Vector<Integer>();
        params.addElement(this.myInfo.getStateInfo().getRoomNumber());
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.RoomListGames, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyRoomListGames(Vector var1);

    public void roomSwitch(Integer roomNo) throws GSException {
        Vector<Integer> params = new Vector<Integer>();
        params.addElement(this.myInfo.getStateInfo().getRoomNumber());
        params.addElement(roomNo);
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.RoomSwitch, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyRoomSwitch();

    public void roomListPlayers() throws GSException {
        Vector<Integer> params = new Vector<Integer>();
        params.addElement(this.myInfo.getStateInfo().getRoomNumber());
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.RoomListPlayers, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyRoomListPlayers(Vector var1);

    public void gameListPlayers(IGSId gameId) throws GSException {
        if (gameId == null) {
            throw new GSException("Invalid game Id");
        }
        Vector<IGSId> params = new Vector<IGSId>();
        params.addElement(gameId);
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.GameListPlayers, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyGameListPlayers(Vector var1);

    public void gameJoin(IGSId gameId) throws GSException {
        Vector<IGSId> params = new Vector<IGSId>();
        params.addElement(gameId);
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.GameJoin, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyGameJoin(Vector var1);

    public void gameHost(BoundedString name) throws GSException {
        Vector<Object> params = new Vector<Object>();
        params.addElement(this.gameType);
        if (name == null) {
            params.addElement("newGame");
        } else {
            params.addElement(name);
        }
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.GameHost, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyGameHost(IGameInstanceInfo var1, IPlayerInfo var2);

    public void gameAutoJoin() throws GSException {
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.GameAutoJoin, new Vector());
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyGameAutoJoin(IGameInstanceInfo var1, Vector var2);

    public void gameLeave() throws GSException {
        Vector params = new Vector();
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.GameLeave, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyGameLeave();

    public void gameReady() throws GSException {
        Vector params = new Vector();
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.GameReady, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyGameReady();

    public void gameKickPlayer(IGSId playerId) {
    }

    public abstract void notifyGameKickPlayer();

    public void buddyAdd(IGSId playerId) {
    }

    public abstract void notifyBuddyAdd();

    public void buddyDelete(IGSId playerId) {
    }

    public abstract void notifyBuddyDelete();

    public void buddyFind(BoundedString name) {
    }

    public abstract void notifyBuddyFind(IPlayerInfo var1);

    public void meUpdateState() throws GSException {
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.MeGetState, new Vector());
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyMeUpdateState();

    public Integer meGetRoomNumber() throws GSException {
        if (this.myInfo == null) {
            throw new GSException("Player info not acquired");
        }
        if (this.myInfo.getStateInfo() == null || !(this.myInfo.getStateInfo() instanceof IPlayerStateInfo)) {
            throw new GSException("Player info invaid");
        }
        return this.myInfo.getStateInfo().getRoomNumber();
    }

    public IGSId meGetGameId() throws GSException {
        if (this.myInfo == null) {
            throw new GSException("Player info not acquired");
        }
        if (this.myInfo.getStateInfo() == null || !(this.myInfo.getStateInfo() instanceof IPlayerStateInfo)) {
            throw new GSException("Player info invaid");
        }
        return this.myInfo.getStateInfo().getGameId();
    }

    public Boolean meGetIsGameOwner() throws GSException {
        if (this.myInfo == null) {
            throw new GSException("Player info not acquired");
        }
        if (this.myInfo.getStateInfo() == null || !(this.myInfo.getStateInfo() instanceof IPlayerStateInfo)) {
            throw new GSException("Player info invaid");
        }
        return this.myInfo.getStateInfo().isOwner();
    }

    public Short meGetStatus() throws GSException {
        if (this.myInfo == null) {
            throw new GSException("Player info not acquired");
        }
        if (this.myInfo.getStateInfo() == null || !(this.myInfo.getStateInfo() instanceof IPlayerStateInfo)) {
            throw new GSException("Player info invaid");
        }
        return this.myInfo.getStateInfo().getStatus();
    }

    public IGSId meGetId() throws GSException {
        if (this.myInfo == null) {
            throw new GSException("Player info not acquired");
        }
        return this.myInfo.getId();
    }

    public BoundedString meGetName() throws GSException {
        if (this.myInfo == null) {
            throw new GSException("Player info not acquired");
        }
        return this.myInfo.getName();
    }

    public void meSetName(BoundedString name) throws GSException {
        Vector<BoundedString> params = new Vector<BoundedString>();
        params.addElement(name);
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.MeSetName, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyMeSetName();

    public Boolean meIsGameOwner() throws GSException {
        if (this.myInfo == null) {
            throw new GSException("Player info not acquired");
        }
        if (this.myInfo.getStateInfo() == null || this.myInfo.getStateInfo() instanceof IPlayerStateInfo) {
            throw new GSException("Player info invaid");
        }
        return this.myInfo.getStateInfo().isOwner();
    }

    public void meSetGameOwner(IGSId newOwnerId) throws GSException {
        Vector<IGSId> params = new Vector<IGSId>();
        params.addElement(newOwnerId);
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.GameSetOwner, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyMeSetGameOwner();

    public abstract void notifyRoomPlayerJoined(IPlayerInfo var1);

    public abstract void notifyQueryFailed(Short var1, String var2);

    public abstract void notifyRoomPlayerLeft(IGSId var1);

    public abstract void notifyRoomGameCreated(IGameInstanceInfo var1);

    public abstract void notifyRoomGameTerminated(IGSId var1);

    public abstract void notifyRoomGameStatusChanged(IGameInstanceInfo var1);

    public abstract void notifyGamePlayerJoined(IPlayerInfo var1);

    public abstract void notifyGamePlayerLeft(IGSId var1);

    public abstract void notifyGamePlayerDisconnected(IPlayerInfo var1);

    public abstract void notifyGamePlayerReconnected(IPlayerInfo var1);

    public abstract void notifyGamePlayerKicked(IGSId var1);

    public abstract void notifyGamePlayerReady(IPlayerInfo var1);

    public abstract void notifyGamePlayerStateChanged(IPlayerInfo var1);

    public abstract void notifyGameOwnerChanged(IPlayerInfo var1);

    public abstract void notifyGameStarted();

    public abstract void notifyGameEnded(IScoreInfo var1);

    public abstract void notifyGameStateArrived(String var1);

    public abstract void notifyInfoBoardMessageArrived(IInfoBoardMessageInfo var1);

    public abstract void notifyInvitationArrived(IPlayerInfo var1, IGameInstanceInfo var2);

    public abstract void notifyInvitationAccepted(IGSId var1);

    public abstract void notifyMessageArrived(IMessageInfo var1);

    public abstract void notifyBuddyJoined(IPlayerInfo var1);

    public abstract void notifyBuddyLeft(IGSId var1);

    public abstract void notifyBuddyStateChanged(IPlayerInfo var1);

    public void sendGameState(String gameStateString) throws GSException {
        this.connector.send(new GameStateDataPacket(this.meGetGameId(), gameStateString));
    }

    public void sendFinalGameState(String gameStateString, IScoreInfo scoreInfo) throws GSException {
        this.connector.send(new FinalGameStateDataPacket(this.meGetGameId(), scoreInfo, gameStateString));
    }

    public void sendMessage(Vector receiverIds, Short messageType) throws GSException {
        if (this.myInfo == null) {
            throw new GSException("");
        }
        this.connector.send(new MessageDataPacket(this.myInfo.getId(), messageType, receiverIds));
    }

    public String popGameStateString() throws GSException {
        if (this.gameStateQueue.size() == 0) {
            return null;
        }
        IDataStringConvertible obj = this.gameStateQueue.dequeue();
        if (obj instanceof GameStateDataPacket) {
            return ((GameStateDataPacket)obj).getGameStateString();
        }
        throw new GSException("ClientInterface.popGameState: enqueued object is not a game state");
    }

    public int gameStateCount() {
        return this.gameStateQueue.size();
    }

    public IMessageInfo popMessage() throws GSException {
        if (this.messageQueue.size() == 0) {
            return null;
        }
        IDataStringConvertible obj = this.messageQueue.dequeue();
        if (obj instanceof IMessageInfo) {
            return (IMessageInfo)((Object)obj);
        }
        throw new GSException("ClientInterface.popMessage: enqueued object is not of type IMessageInfo");
    }

    public int messageCount() {
        return this.messageQueue.size();
    }

    public IEventInfo popEvent() throws GSException {
        if (this.eventQueue.size() == 0) {
            return null;
        }
        IDataStringConvertible obj = this.eventQueue.dequeue();
        if (obj instanceof IEventInfo) {
            return (IEventInfo)((Object)obj);
        }
        throw new GSException("ClientInterface.popEvent: enqueued object is not of type IEventInfo");
    }

    public int eventCount() {
        return this.eventQueue.size();
    }

    public IQueryResponseInfo popQueryResponse() throws GSException {
        if (this.responseQueue.size() == 0) {
            return null;
        }
        IDataStringConvertible obj = this.responseQueue.dequeue();
        if (obj instanceof IQueryResponseInfo) {
            return (IQueryResponseInfo)((Object)obj);
        }
        throw new GSException("ClientInterface.popQueryResponse: enqueued object is not of type IQueryResponseInfo");
    }

    public int queryResponseCount() {
        return this.responseQueue.size();
    }

    public Short getGameType() {
        return this.gameType;
    }

    public synchronized void receivedData(Object received) throws GSException {
        block73: {
            try {
                IDataStringConvertible dp = DataPacketUtil.parseDataPacket((String)received);
                if (PacketType.Pulse.equals(dp.getPacketType())) {
                    this.log("Got pulse data packet");
                    this.connector.send(new PulseDataPacket());
                    this.log("Sent pulse data packet");
                    break block73;
                }
                if (PacketType.QueryResponse.equals(dp.getPacketType())) {
                    if (Boolean.TRUE.equals(this.queueQueryResponses)) {
                        this.responseQueue.enqueue(dp);
                    }
                    QueryResponseDataPacket qresponse = (QueryResponseDataPacket)dp;
                    Short responseType = qresponse.getResponseType();
                    if (Boolean.FALSE.equals(qresponse.getQuerySucceded())) {
                        this.notifyQueryFailed(responseType, (String)qresponse.getParams().elementAt(0));
                        break block73;
                    }
                    if (QueryType.MeGetState.equals(responseType)) {
                        this.log("QueryResponse MeGetState");
                        this.setMyInfo((IPlayerInfo)qresponse.getParams().elementAt(0));
                        this.notifyMeUpdateState();
                        break block73;
                    }
                    if (QueryType.ServerListRooms.equals(responseType)) {
                        this.log("QueryResponse ServerListRooms");
                        this.notifyServerListRooms(qresponse.getParams());
                        break block73;
                    }
                    if (QueryType.ServerListBuddies.equals(responseType)) {
                        this.log("QueryResponse ServerListBuddies");
                        this.notifyServerListBuddies(qresponse.getParams());
                        break block73;
                    }
                    if (QueryType.RoomListGames.equals(responseType)) {
                        this.log("QueryResponse RoomListGames");
                        this.notifyRoomListGames(qresponse.getParams());
                        break block73;
                    }
                    if (QueryType.RoomListPlayers.equals(responseType)) {
                        this.log("QueryResponse RoomListPlayers");
                        this.notifyRoomListPlayers(qresponse.getParams());
                        break block73;
                    }
                    if (QueryType.RoomEnter.equals(responseType)) {
                        this.log("QueryResponse RoomEnter");
                        this.setMyInfo((IPlayerInfo)qresponse.getParams().elementAt(0));
                        this.notifyRoomEnter();
                        break block73;
                    }
                    if (QueryType.RoomLeave.equals(responseType)) {
                        this.log("QueryResponse RoomLeave");
                        this.setMyInfo((IPlayerInfo)qresponse.getParams().elementAt(0));
                        this.notifyRoomLeave();
                        break block73;
                    }
                    if (QueryType.RoomSwitch.equals(responseType)) {
                        this.log("QueryResponse RoomSwitch");
                        this.setMyInfo((IPlayerInfo)qresponse.getParams().elementAt(0));
                        this.notifyRoomSwitch();
                        break block73;
                    }
                    if (QueryType.GameJoin.equals(responseType)) {
                        this.log("QueryResponse GameJoin");
                        this.setMyInfo((IPlayerInfo)qresponse.getParams().elementAt(0));
                        Vector allPlayers = (Vector)qresponse.getParams().elementAt(1);
                        this.notifyGameJoin(allPlayers);
                        break block73;
                    }
                    if (QueryType.GameAutoJoin.equals(responseType)) {
                        this.log("QueryResponse GameAutoJoin");
                        IGameInstanceInfo gameInfo = (IGameInstanceInfo)qresponse.getParams().elementAt(0);
                        Vector allPlayers = (Vector)qresponse.getParams().elementAt(1);
                        for (int i = 0; i < allPlayers.size(); ++i) {
                            if (!((Object)((IPlayerInfo)allPlayers.elementAt(i)).getId()).equals(this.meGetId())) continue;
                            this.setMyInfo((IPlayerInfo)allPlayers.elementAt(i));
                        }
                        this.notifyGameAutoJoin(gameInfo, allPlayers);
                        break block73;
                    }
                    if (QueryType.GameLeave.equals(responseType)) {
                        this.log("QueryResponse GameLeave");
                        this.setMyInfo((IPlayerInfo)qresponse.getParams().elementAt(0));
                        this.notifyGameLeave();
                        break block73;
                    }
                    if (QueryType.GameReady.equals(responseType)) {
                        this.log("QueryResponse GameReady");
                        this.setMyInfo((IPlayerInfo)qresponse.getParams().elementAt(0));
                        this.notifyGameReady();
                        break block73;
                    }
                    if (QueryType.GameSetOwner.equals(responseType)) {
                        this.log("QueryResponse GameSetOwner");
                        this.setMyInfo((IPlayerInfo)qresponse.getParams().elementAt(0));
                        this.notifyMeSetGameOwner();
                        break block73;
                    }
                    if (QueryType.GameHost.equals(responseType)) {
                        this.log("QueryResponse GameHost");
                        IGameInstanceInfo gameInfo = (IGameInstanceInfo)qresponse.getParams().elementAt(0);
                        this.setMyInfo((IPlayerInfo)qresponse.getParams().elementAt(1));
                        this.notifyGameHost(gameInfo, this.myInfo);
                        break block73;
                    }
                    if (QueryType.MeSetName.equals(responseType)) {
                        this.log("QueryResponse MeSetName");
                        this.setMyInfo((IPlayerInfo)qresponse.getParams().elementAt(0));
                        this.notifyMeSetName();
                        break block73;
                    }
                    if (QueryType.InvitationSend.equals(responseType)) {
                        this.log("QueryResponse InvitationSend");
                        this.notifyInvitationSend();
                        break block73;
                    }
                    if (QueryType.InvitationAccept.equals(responseType)) {
                        this.log("QueryResponse InvitationAccept");
                        this.setMyInfo((IPlayerInfo)qresponse.getParams().elementAt(0));
                        this.notifyInvitationAccept((Vector)qresponse.getParams().elementAt(1));
                        break block73;
                    }
                    if (QueryType.Authentication.equals(responseType)) {
                        this.log("QueryResponse Authenticate");
                        this.setMyInfo((IPlayerInfo)qresponse.getParams().elementAt(0));
                        if (Boolean.TRUE.equals(this.firstLogin)) {
                            this.firstLogin = Boolean.FALSE;
                        }
                        this.notifyAuthenticate();
                        break block73;
                    }
                    if (QueryType.Registration.equals(responseType)) {
                        this.log("QueryResponse Register");
                        this.notifyRegister();
                        break block73;
                    }
                    if (QueryType.PasswordRecovery.equals(responseType)) {
                        this.log("QueryResponse PasswordRecovery");
                        this.notifyRecoverPassword();
                        break block73;
                    }
                    if (QueryType.ChangePassword.equals(responseType)) {
                        this.log("QueryResponse ChangePassword");
                        this.notifyChangePassword();
                        break block73;
                    }
                    if (QueryType.ServerGetRankingFromTo.equals(responseType)) {
                        this.log("QueryResponse ServerGetRankingFromTo");
                        this.notifyServerGetRanking(qresponse.getParams());
                        break block73;
                    }
                    if (QueryType.ServerGetRankingPlayer.equals(responseType)) {
                        this.log("QueryResponse ServerGetRankingPlayer");
                        this.notifyServerGetRankingForPlayer((IRankingInfo)qresponse.getParams().elementAt(0), (Integer)qresponse.getParams().elementAt(1));
                        break block73;
                    }
                    if (QueryType.ServerGetRankingSize.equals(responseType)) {
                        this.log("QueryResponse ServerGetRankingSize");
                        this.notifyServerGetRankingSize((Integer)qresponse.getParams().elementAt(0));
                        break block73;
                    }
                    if (QueryType.ServerChangeMobileId.equals(responseType)) {
                        this.log("QueryResponse ServerChangeMobileId");
                        this.notifyServerChangeMobileid();
                        break block73;
                    }
                    if (QueryType.GameListPlayers.equals(responseType)) {
                        this.log("QueryResponse GameListPlayers");
                        this.notifyGameListPlayers(qresponse.getParams());
                        break block73;
                    }
                    if (QueryType.ServerGetInfoBoardMessages.equals(responseType)) {
                        this.log("QueryResponse ServerGetInfoBoardMessages");
                        this.notifyServerGetInfoBoradMessages();
                        break block73;
                    }
                    if (QueryType.ServerGetInfoBoardMessageCount.equals(responseType)) {
                        this.log("QueryResponse ServerGetInfoBoardMessageCount");
                        this.notifyServerGetInfoBoardMessageCount((Integer)qresponse.getParams().elementAt(0));
                        break block73;
                    }
                    if (QueryType.ServerDeleteInfoBoardMessage.equals(responseType)) {
                        this.log("QueryResponse ServerDeleteInfoBoardMessage");
                        this.notifyServerDeleteInfoBoardMessage();
                        break block73;
                    }
                    if (QueryType.ServerAccountActivate.equals(responseType)) {
                        this.log("QueryResponse ServerAccountActivate");
                        this.notifyAccountActivate();
                        break block73;
                    }
                    if (QueryType.ServerAccountDeactivate.equals(responseType)) {
                        this.log("QueryResponse ServerAccountDeactivate");
                        this.notifyAccountDeactivate();
                        break block73;
                    }
                    if (QueryType.ServerGetTime.equals(responseType)) {
                        this.log("QueryResponse ServerGetTime");
                        this.notifyServerGetTime((Date)qresponse.getParams().elementAt(0));
                        break block73;
                    }
                    if (QueryType.ServerGetTextMessageInfo.equals(responseType)) {
                        this.log("QueryResponse ServerGetTextMessageInfo");
                        this.notifyServerGetTextMessageInfo((BoundedString)qresponse.getParams().elementAt(0), (String)qresponse.getParams().elementAt(1));
                        break block73;
                    }
                    if (QueryType.ServerGetNewAppVersionUrl.equals(responseType)) {
                        this.log("QueryResponse ServerGetNewAppVersionUrl");
                        this.notifyServerGetNewAppVersionUrl((String)qresponse.getParams().elementAt(0));
                        break block73;
                    }
                    if (QueryType.ServerTellFriendAboutOMPG.equals(responseType)) {
                        this.log("QueryResponse ServerTellFriendAboutOMPG");
                        this.notifyTellFriendAboutOMPG();
                        break block73;
                    }
                    if (QueryType.ServerAccountIsActive.equals(responseType)) {
                        this.log("QueryResponse ServerAccountIsActive");
                        Boolean isActive = (Boolean)qresponse.getParams().elementAt(0);
                        Date expirationDate = (Date)qresponse.getParams().elementAt(1);
                        this.notifyAccountIsActive(isActive, expirationDate);
                        break block73;
                    }
                    if (QueryType.ServerUserSingleCharged.equals(responseType)) {
                        this.log("QueryResponse ServerUserSingleCharged");
                        this.notifyUserSingleCharged();
                        break block73;
                    }
                    throw new GSException("Client interface.receivedData: unsupported query response type");
                }
                if (PacketType.Message.equals(dp.getPacketType())) {
                    if (Boolean.TRUE.equals(this.queueMessages)) {
                        this.messageQueue.enqueue(dp);
                    }
                    this.notifyMessageArrived((MessageDataPacket)dp);
                    break block73;
                }
                if (PacketType.Event.equals(dp.getPacketType())) {
                    EventDataPacket event;
                    Short eventType;
                    if (Boolean.TRUE.equals(this.queueEvents)) {
                        this.eventQueue.enqueue(dp);
                    }
                    if (EventType.RoomPlayerJoined.equals(eventType = (event = (EventDataPacket)dp).getEventType())) {
                        this.log("Event RoomPlayerJoined");
                        this.notifyRoomPlayerJoined((IPlayerInfo)event.getParams().elementAt(0));
                        break block73;
                    }
                    if (EventType.RoomPlayerLeft.equals(eventType)) {
                        this.log("Event RoomPlayerLeft");
                        this.notifyRoomPlayerLeft((IGSId)event.getParams().elementAt(0));
                        break block73;
                    }
                    if (EventType.RoomGameCreated.equals(eventType)) {
                        this.log("Event RoomGameCreated");
                        this.notifyRoomGameCreated((IGameInstanceInfo)event.getParams().elementAt(0));
                        break block73;
                    }
                    if (EventType.RoomGameTerminated.equals(eventType)) {
                        this.log("Event RoomGameTerminated");
                        this.notifyRoomGameTerminated((IGSId)event.getParams().elementAt(0));
                        break block73;
                    }
                    if (EventType.RoomGameStateChanged.equals(eventType)) {
                        this.log("Event RoomGameStateChanged");
                        this.notifyRoomGameStatusChanged((IGameInstanceInfo)event.getParams().elementAt(0));
                        break block73;
                    }
                    if (EventType.GamePlayerJoined.equals(eventType)) {
                        this.log("Event GamePlayerJoined");
                        this.notifyGamePlayerJoined((IPlayerInfo)event.getParams().elementAt(0));
                        break block73;
                    }
                    if (EventType.GamePlayerLeft.equals(eventType)) {
                        this.log("Event GamePlayerLeft");
                        this.notifyGamePlayerLeft((IGSId)event.getParams().elementAt(0));
                        break block73;
                    }
                    if (EventType.GamePlayerDisconnected.equals(eventType)) {
                        this.log("Event GamePlayerDisconnected");
                        this.notifyGamePlayerDisconnected((IPlayerInfo)event.getParams().elementAt(0));
                        break block73;
                    }
                    if (EventType.GamePlayerReconnected.equals(eventType)) {
                        this.log("Event GamePlayerReconnected");
                        this.notifyGamePlayerReconnected((IPlayerInfo)event.getParams().elementAt(0));
                        break block73;
                    }
                    if (EventType.GamePlayerKicked.equals(eventType)) {
                        this.log("Event GamePlayerKicked");
                        this.notifyGamePlayerKicked((IGSId)event.getParams().elementAt(0));
                        break block73;
                    }
                    if (EventType.GamePlayerReady.equals(eventType)) {
                        this.log("Event GamePlayerReady");
                        this.notifyGamePlayerReady((IPlayerInfo)event.getParams().elementAt(0));
                        break block73;
                    }
                    if (EventType.GamePlayerStateChanged.equals(eventType)) {
                        this.log("Event GamePlayerStateChanged");
                        this.notifyGamePlayerStateChanged((IPlayerInfo)event.getParams().elementAt(0));
                        break block73;
                    }
                    if (EventType.GameOwnerChanged.equals(eventType)) {
                        this.log("Event GameOwnerChanged");
                        this.notifyGameOwnerChanged((IPlayerInfo)event.getParams().elementAt(0));
                        break block73;
                    }
                    if (EventType.GameStarted.equals(eventType)) {
                        this.log("Event GameStarted");
                        this.notifyGameStarted();
                        break block73;
                    }
                    if (EventType.GameEnded.equals(eventType)) {
                        this.log("Event GameEnded");
                        this.notifyGameEnded((IScoreInfo)event.getParams().elementAt(0));
                        break block73;
                    }
                    if (EventType.RoomPlayerStateChanged.equals(eventType)) {
                        this.log("Event RoomPlayerStateChanged");
                        this.notifyRoomPlayerStateChanged((IPlayerInfo)event.getParams().elementAt(0));
                        break block73;
                    }
                    if (EventType.InvitationArrived.equals(eventType)) {
                        this.log("Event InvitationArrived");
                        IGameInstanceInfo gi = (IGameInstanceInfo)event.getParams().elementAt(1);
                        if (this.gameType.equals(gi.getType())) {
                            this.notifyInvitationArrived((IPlayerInfo)event.getParams().elementAt(0), gi);
                        }
                        break block73;
                    }
                    if (EventType.InvitationAccepted.equals(eventType)) {
                        this.log("Event InvitationAccepted");
                        this.notifyInvitationAccepted((IGSId)event.getParams().elementAt(0));
                        break block73;
                    }
                    throw new GSException("Client interface.receivedData: unsupported event type");
                }
                if (PacketType.GameState.equals(dp.getPacketType())) {
                    if (Boolean.TRUE.equals(this.queueGameStates)) {
                        this.gameStateQueue.enqueue(dp);
                    }
                    this.notifyGameStateArrived(((GameStateDataPacket)dp).getGameStateString());
                    break block73;
                }
                if (PacketType.InfoBoardMessage.equals(dp.getPacketType())) {
                    if (Boolean.TRUE.equals(this.queueInfoBoard)) {
                        this.infoBoardQueue.enqueue(dp);
                    }
                    this.notifyInfoBoardMessageArrived((InfoBoardMessageDataPacket)dp);
                    break block73;
                }
                throw new GSException("Received packet of invalid type.");
            }
            catch (GSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new GSException(e.getMessage());
            }
        }
    }

    public abstract void connectionTerminated();

    public abstract void notifyRoomPlayerStateChanged(IPlayerInfo var1);

    public void setGameType(Short gameType) {
        this.gameType = gameType;
    }

    public void serverChangeMobileId(BoundedString login, BoundedString password) throws GSException {
        Vector<Object> params = new Vector<Object>();
        password = new BoundedString(SHAUtil.coding(password.toString()));
        params.addElement(login);
        params.addElement(password);
        if (this.mobileId != null) {
            params.addElement(this.mobileId);
        } else {
            params.addElement("");
        }
        QueryDataPacket queryDataPacket = new QueryDataPacket(QueryType.ServerChangeMobileId, params);
        this.connector.send(queryDataPacket);
    }

    public abstract void notifyServerChangeMobileid();
}

