/*
 * Decompiled with CFR 0.152.
 */
package gs.common.datapackets;

import gs.common.datapackets.GameStateDataPacket;
import gs.common.datapackets.subpackets.ScoreInfo;
import gs.common.enumerations.PacketType;
import gs.common.gsid.IGSId;
import gs.common.info.IScoreInfo;
import gs.common.utils.CollectionUtil;
import gs.common.utils.DataPacketUtil;
import gs.common.utils.GSIdUtil;
import gs.common.utils.ObjectUtil;
import gs.exceptions.PacketConversionException;
import java.util.Vector;

public class FinalGameStateDataPacket
extends GameStateDataPacket {
    private static final int NUMPACKETFIELDS = 3;
    private IScoreInfo scoreInfo;

    public FinalGameStateDataPacket() {
        this.gameId = null;
        this.scoreInfo = null;
    }

    public FinalGameStateDataPacket(IGSId gameId, IScoreInfo scoreInfo, String gameStateString) {
        super(gameId, gameStateString);
        this.scoreInfo = scoreInfo;
    }

    public IScoreInfo getScoreInfo() {
        return this.scoreInfo;
    }

    public String toDataString() throws PacketConversionException {
        if (this.scoreInfo == null || this.gameId == null || this.gameStateStr == null) {
            throw new PacketConversionException("FinalGameStateDataPacket to data string: packet not initialized");
        }
        String result = DataPacketUtil.objectToDataString(this.getPacketType());
        result = result + DataPacketUtil.mainDPSeperator();
        result = result + DataPacketUtil.objectToDataString(this.gameId);
        result = result + DataPacketUtil.mainDPSeperator();
        result = result + DataPacketUtil.objectToDataString(this.gameStateStr);
        result = result + DataPacketUtil.mainDPSeperator();
        result = result + DataPacketUtil.objectToDataString(this.scoreInfo);
        return result;
    }

    public void parseDataString(String dataStr) throws PacketConversionException {
        Vector mainSplit = CollectionUtil.splitString(dataStr, DataPacketUtil.mainDPSeperator());
        try {
            if (!PacketType.FinalGameState.equals(ObjectUtil.shortFromString((String)mainSplit.elementAt(0))) || mainSplit.size() != 4) {
                throw new PacketConversionException("invalid packet type");
            }
            this.gameId = GSIdUtil.parseFromString((String)mainSplit.elementAt(1));
            this.gameStateStr = (String)mainSplit.elementAt(2);
            ScoreInfo si = new ScoreInfo();
            si.parseDataString((String)mainSplit.elementAt(3));
            this.scoreInfo = si;
        }
        catch (Exception ex) {
            throw new PacketConversionException("error while parsing FinalGameStateDataPacket: " + ex.getMessage());
        }
    }

    public Short getPacketType() {
        return PacketType.FinalGameState;
    }

    public String toString() {
        return "FinalGameStateDataPacket: gameId=" + ((Object)this.gameId).toString() + "; " + "GameStateString=" + this.gameStateStr + "; " + "ScoreInfo=" + this.scoreInfo.toString();
    }
}

