/*
 * Decompiled with CFR 0.152.
 */
package gs.common.utils;

import gs.common.Constants;
import gs.common.gsid.GSHashId;
import gs.common.gsid.GSLongId;
import gs.common.gsid.GSStringId;
import gs.common.gsid.IGSId;
import gs.common.utils.CollectionUtil;
import gs.exceptions.GSException;
import java.util.Vector;

public class GSIdUtil {
    public static String getTypePrefix(IGSId id) throws GSException {
        if (id instanceof GSLongId) {
            return "L";
        }
        if (id instanceof GSHashId) {
            return Constants.GS_HASH_ID_TYPE_PREFIX;
        }
        if (id instanceof GSStringId) {
            return Constants.GS_STRING_ID_TYPE_PREFIX;
        }
        throw new GSException("GSIdUtil: unkonown GSId type");
    }

    public static IGSId parseFromString(String str) {
        IGSId result = GSIdUtil.parseGSLongId(str);
        if (result != null) {
            return result;
        }
        result = GSIdUtil.parseGSHashId(str);
        if (result != null) {
            return result;
        }
        result = GSIdUtil.parseGSStringId(str);
        if (result != null) {
            return result;
        }
        return null;
    }

    private static GSLongId parseGSLongId(String str) {
        if (!str.startsWith("L")) {
            return null;
        }
        try {
            Vector split = CollectionUtil.splitString(str, "L");
            return new GSLongId(Long.parseLong((String)split.elementAt(1)));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static GSHashId parseGSHashId(String str) {
        if (!str.startsWith(Constants.GS_HASH_ID_TYPE_PREFIX)) {
            return null;
        }
        try {
            Vector split = CollectionUtil.splitString(str, Constants.GS_HASH_ID_TYPE_PREFIX);
            return new GSHashId(Integer.parseInt((String)split.elementAt(1)));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static GSStringId parseGSStringId(String str) {
        if (!str.startsWith(Constants.GS_STRING_ID_TYPE_PREFIX)) {
            return null;
        }
        try {
            return new GSStringId(str.substring(1));
        }
        catch (Exception e) {
            return null;
        }
    }
}

