/*
 * Decompiled with CFR 0.152.
 */
package gs.ompg;

import framework.Globals;
import framework.Texts;
import gs.client.ClientInterfaceME;
import gs.common.BoundedString;
import gs.common.datapackets.subpackets.PlayerInfo;
import gs.common.datapackets.subpackets.RankingInfo;
import gs.common.enumerations.MobileIdPolicy;
import gs.common.gsid.IGSId;
import gs.common.info.IGameInstanceInfo;
import gs.common.info.IInfoBoardMessageInfo;
import gs.common.info.IMessageInfo;
import gs.common.info.IPlayerInfo;
import gs.common.info.IRankingInfo;
import gs.common.info.IRoomInfo;
import gs.common.info.IScoreInfo;
import gs.common.utils.GSIdUtil;
import gs.exceptions.GSException;
import gs.ompg.ConnectThread;
import gs.ompg.IMsgReceiver;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import root.RMSSettings;
import root.TanksMIDlet;

public class ClientInterface
extends ClientInterfaceME {
    private static ClientInterface instance;
    public IMsgReceiver msgReceiver;
    private boolean isConnected = false;
    private Vector gameRooms = new Vector();
    private Vector roomPlayers = new Vector();
    public Vector roomGames = new Vector();
    private Vector gamePlayers = new Vector();
    private Vector infoBoardMessages = new Vector();
    public Vector placesFromLastGameRankingQuery;
    public Vector gameRoomsNames = new Vector();
    private Vector roomGamesNames = new Vector();
    private Vector playerRankings = new Vector();
    private Vector gameRankings = new Vector();
    public String msisdn = "null";
    public String updateUrl = "www.nourl.com";
    public String smsMessage = "";
    public String smsNumber = "";
    public Short smsType;
    public int playerPlace = 1;
    private IPlayerInfo invPInfo;
    private IGameInstanceInfo invGInfo;
    boolean authentificated = false;
    boolean guest = false;
    private boolean isGameHosted;
    Thread connectThread;
    RankingInfo myPlayerRanking;
    RankingInfo enemyPlayerRanking;
    public String _queryResponseType = "";

    public boolean isGuest() {
        return this.guest;
    }

    public void setGuest(boolean guest) {
        this.guest = guest;
    }

    public boolean isAuthentificated() {
        return this.authentificated;
    }

    public void setAuthentificated(boolean authentificated) {
        this.authentificated = authentificated;
    }

    public Vector GetGameRooms() {
        return this.gameRoomsNames;
    }

    public Vector GetRoomGames() {
        return this.roomGamesNames;
    }

    public Vector getPlayerRankings() {
        return this.playerRankings;
    }

    public Vector getRankings() {
        return this.gameRankings;
    }

    public int getPlayerPlace() {
        return this.playerPlace;
    }

    public Vector getInfoBoardMessages() {
        return this.infoBoardMessages;
    }

    public static ClientInterface GetInstance() {
        return instance;
    }

    public ClientInterface() {
        instance = this;
    }

    public ClientInterface(Short gameType, String serverIp, int serverPort) {
        super(gameType, serverIp, serverPort, TanksMIDlet.version);
        System.out.println("Customer creation version: " + TanksMIDlet.version);
        instance = this;
        this.setMobileIdPolicy(MobileIdPolicy.OrangeMobileIdPolicy);
    }

    public void Connect() {
        this.connectThread = new Thread(new ConnectThread(this));
        this.connectThread.start();
    }

    public boolean IsConnected() {
        return this.isConnected;
    }

    public void notifyConnected(boolean value) {
        if (value) {
            this.msgReceiver.OnMessage(45);
        } else {
            this.msgReceiver.OnMessage(46);
        }
        this.isConnected = value;
    }

    public void Disconnect() {
        this.notifyConnected(false);
        try {
            this.closeConnection();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        this.connectThread = null;
        this.setAuthentificated(false);
        this.isConnected = false;
    }

    public void resetConnection() {
        try {
            super.reset();
        }
        catch (GSException ex) {
            ex.printStackTrace();
        }
    }

    public String myGetName() {
        return this.myInfo.getName().toString();
    }

    public String oppGetName() {
        for (int i = 0; i < this.gamePlayers.size(); ++i) {
            if (((IPlayerInfo)this.gamePlayers.elementAt(i)).getName().toString().equals(this.myInfo.getName().toString())) continue;
            return ((IPlayerInfo)this.gamePlayers.elementAt(i)).getName().toString();
        }
        return new String("noname");
    }

    public void sendFailed(String exception) {
    }

    public void notifyGamePlayerStateChanged(IPlayerInfo iPlayerInfo) {
        Vector players = this.gamePlayers;
        for (int i = 0; i < players.size(); ++i) {
            PlayerInfo player = (PlayerInfo)players.elementAt(i);
            if (!((Object)player.getId()).equals(iPlayerInfo.getId())) continue;
            players.removeElementAt(i);
            players.insertElementAt(iPlayerInfo, i);
        }
        this.loadGamePlayers(players);
    }

    public void notifyGamePlayerDisconnected(IPlayerInfo playerInfo) {
        this.notifyGamePlayerStateChanged(playerInfo);
    }

    public void notifyInvitationAccept(Vector players) {
        this.loadGamePlayers(players);
    }

    public void GetRooms() {
        try {
            this.serverListRooms(this.getGameType());
        }
        catch (Exception e) {
            System.out.println("Command action failed: " + e.getMessage());
        }
    }

    public void EnterGamesRoom(int nr) {
        try {
            this.roomEnter(((IRoomInfo)this.gameRooms.elementAt(nr)).getNumber());
        }
        catch (Exception e) {
            System.out.println("Command action failed: " + e.getMessage());
        }
    }

    public void EnterGame(int nr) {
        try {
            this.gameJoin(((IGameInstanceInfo)this.roomGames.elementAt(nr)).getId());
            this.isGameHosted = false;
        }
        catch (Exception e) {
            System.out.println("Command action failed: " + e.getMessage());
        }
    }

    public void HostGame() {
        try {
            this.gameHost(new BoundedString("gra " + this.meGetName()));
            this.isGameHosted = true;
        }
        catch (Exception e) {
            System.out.println("Command action failed: " + e.getMessage());
        }
    }

    public void GameReady() {
        try {
            this.gameReady();
        }
        catch (Exception e) {
            System.out.println("Command action failed: " + e.getMessage());
        }
    }

    public void deinitialize() {
        try {
            this.closeConnection();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadGameRooms(Vector rooms) {
        this.gameRooms = rooms;
        this.gameRoomsNames.removeAllElements();
        Enumeration elems = this.gameRooms.elements();
        int count = 0;
        while (elems.hasMoreElements()) {
            IRoomInfo info = (IRoomInfo)elems.nextElement();
            this.gameRoomsNames.addElement(info.getName().toString());
            ++count;
        }
    }

    private void loadRoomPlayers(Vector players) {
        this.roomPlayers = players;
        Enumeration elems = this.roomPlayers.elements();
        int count = 0;
        while (elems.hasMoreElements()) {
            IPlayerInfo info = (IPlayerInfo)elems.nextElement();
            ++count;
        }
    }

    private void loadRoomGames(Vector games) {
        this.roomGames = games;
        this.roomGamesNames.removeAllElements();
        Enumeration elems = this.roomGames.elements();
        int count = 0;
        Globals.activeGamesCount = games.size();
        Globals.activeGamesCountText = new StringBuffer("number of active games:" + Globals.activeGamesCount);
        while (elems.hasMoreElements()) {
            IGameInstanceInfo info = (IGameInstanceInfo)elems.nextElement();
            if (!info.getStatus().equals(new Short(0)) || !info.getFreeSlots().equals(new Integer(1))) continue;
            ++count;
            this.roomGamesNames.addElement(info);
        }
        this.msgReceiver.OnMessage(2);
    }

    void roomGameTerminated(IGSId gameId) {
        for (int i = 0; i < this.roomGames.size(); ++i) {
            IGameInstanceInfo info = (IGameInstanceInfo)this.roomGames.elementAt(i);
            if (!((Object)info.getId()).equals(gameId)) continue;
            this.roomGames.removeElementAt(i);
            --Globals.activeGamesCount;
        }
        this.loadRoomGames(this.roomGames);
        try {
            if (((Object)this.meGetGameId()).equals(gameId)) {
                this.roomLeave();
                this.msgReceiver.OnMessage(117);
            } else {
                this.msgReceiver.OnMessage(11);
            }
        }
        catch (GSException ex) {
            ex.printStackTrace();
        }
    }

    public void loadGamePlayers(Vector players) {
        this.gamePlayers = players;
        Enumeration elems = this.gamePlayers.elements();
        int count = 0;
        while (elems.hasMoreElements()) {
            IPlayerInfo info = (IPlayerInfo)elems.nextElement();
            ++count;
        }
    }

    public void addGamePlayer(IPlayerInfo player) {
        this.gamePlayers.addElement(player);
        this.loadGamePlayers(this.gamePlayers);
    }

    public void addRoomPlayer(IPlayerInfo player) {
        this.roomPlayers.addElement(player);
        this.loadRoomPlayers(this.roomPlayers);
        this.msgReceiver.OnMessage(3);
    }

    void ownerChanged(IPlayerInfo owner) {
        for (int i = 0; i < this.gamePlayers.size(); ++i) {
            IPlayerInfo info = (IPlayerInfo)this.gamePlayers.elementAt(i);
            if (!((Object)info.getId()).equals(owner.getId())) continue;
            this.gamePlayers.removeElementAt(i);
            this.gamePlayers.insertElementAt(owner, i);
        }
        this.loadGamePlayers(this.gamePlayers);
    }

    void playerLeftGame(IGSId playerId) {
        for (int i = 0; i < this.gamePlayers.size(); ++i) {
            IPlayerInfo info = (IPlayerInfo)this.gamePlayers.elementAt(i);
            if (!((Object)info.getId()).equals(playerId)) continue;
            this.gamePlayers.removeElementAt(i);
            break;
        }
    }

    void playerLeftRoom(IGSId playerId) {
        for (int i = 0; i < this.roomPlayers.size(); ++i) {
            IPlayerInfo info = (IPlayerInfo)this.roomPlayers.elementAt(i);
            if (!((Object)info.getId()).equals(playerId)) continue;
            this.roomPlayers.removeElementAt(i);
            break;
        }
        this.loadRoomPlayers(this.roomPlayers);
    }

    void addGame(IGameInstanceInfo gameInfo) {
        this.roomGames.addElement(gameInfo);
        this.loadRoomGames(this.roomGames);
    }

    public boolean isGameHosted() {
        return this.isGameHosted;
    }

    public void SetMsgReceiver(IMsgReceiver msgReceiver) {
        this.msgReceiver = msgReceiver;
    }

    public void notifyServerListRooms(Vector rooms) {
        this.responseQueue.dequeue();
        this.loadGameRooms(rooms);
        this.msgReceiver.OnMessage(1);
    }

    public void notifyServerListBuddies(Vector buddies) {
        this.responseQueue.dequeue();
        this.msgReceiver.OnMessage(12);
    }

    public void notifyInvitationSend() {
        this.msgReceiver.OnMessage(13);
    }

    public void notifyInvitationAccept() {
        this.msgReceiver.OnMessage(14);
    }

    public void notifyRoomEnter() {
        this.responseQueue.dequeue();
        this.msgReceiver.OnMessage(5);
        try {
            this.roomListGames();
            this.roomListPlayers();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void notifyRoomLeave() {
        this.responseQueue.dequeue();
        this.msgReceiver.OnMessage(10);
    }

    public void notifyRoomListGames(Vector games) {
        this.responseQueue.dequeue();
        this.loadRoomGames(games);
    }

    public void notifyRoomSwitch() {
        this.msgReceiver.OnMessage(15);
    }

    public void notifyRoomListPlayers(Vector players) {
        this.responseQueue.dequeue();
        this.loadRoomPlayers(players);
        this.msgReceiver.OnMessage(3);
    }

    public void notifyGameJoin(Vector players) {
        this.loadGamePlayers(players);
        this.msgReceiver.OnMessage(8);
    }

    public void notifyGameHost(IGameInstanceInfo gameInfo, IPlayerInfo myInfo) {
        Vector<IPlayerInfo> players = new Vector<IPlayerInfo>();
        players.addElement(myInfo);
        this.loadGamePlayers(players);
        this.msgReceiver.OnMessage(9);
    }

    public void notifyGameAutoJoin(IGameInstanceInfo info, Vector players) {
        this.msgReceiver.OnMessage(16);
    }

    public void notifyGameLeave() {
        this.msgReceiver.OnMessage(17);
    }

    public void notifyGameReady() {
        Vector players = this.gamePlayers;
        Vector<IPlayerInfo> newPlayers = new Vector<IPlayerInfo>();
        for (int i = 0; i < players.size(); ++i) {
            PlayerInfo player = (PlayerInfo)players.elementAt(i);
            if (((Object)player.getId()).equals(this.myInfo.getId())) {
                newPlayers.addElement(this.myInfo);
                continue;
            }
            newPlayers.addElement((IPlayerInfo)players.elementAt(i));
        }
        this.loadGamePlayers(newPlayers);
        this.msgReceiver.OnMessage(18);
    }

    public void notifyGameKickPlayer() {
        this.msgReceiver.OnMessage(19);
    }

    public void notifyBuddyAdd() {
        this.msgReceiver.OnMessage(20);
    }

    public void notifyBuddyDelete() {
        this.msgReceiver.OnMessage(21);
    }

    public void notifyBuddyFind(IPlayerInfo playerInfo) {
        this.msgReceiver.OnMessage(22);
    }

    public void notifyMeUpdateState() {
        try {
            this.serverListRooms(this.getGameType());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.msgReceiver.OnMessage(23);
    }

    public void notifyMeSetName() {
        this.msgReceiver.OnMessage(24);
    }

    public void notifyMeSetGameOwner() {
        this.msgReceiver.OnMessage(25);
    }

    public void notifyRoomPlayerJoined(IPlayerInfo playerInfo) {
        this.addRoomPlayer(playerInfo);
        this.msgReceiver.OnMessage(26);
    }

    public void notifyRoomPlayerLeft(IGSId playerId) {
        this.playerLeftRoom(playerId);
        this.msgReceiver.OnMessage(27);
    }

    public void notifyRoomGameCreated(IGameInstanceInfo gameInfo) {
        this.addGame(gameInfo);
        this.msgReceiver.OnMessage(28);
    }

    public void notifyRoomGameTerminated(IGSId gameId) {
        this.roomGameTerminated(gameId);
        this.msgReceiver.OnMessage(11);
    }

    public void notifyRoomGameStatusChanged(IGameInstanceInfo gameInfo) {
        for (int i = 0; i < this.roomGames.size(); ++i) {
            IGameInstanceInfo info = (IGameInstanceInfo)this.roomGames.elementAt(i);
            if (!((Object)info.getId()).equals(gameInfo.getId())) continue;
            this.roomGames.setElementAt(gameInfo, i);
            this.loadRoomGames(this.roomGames);
        }
        this.msgReceiver.OnMessage(29);
    }

    public void notifyGamePlayerJoined(IPlayerInfo playerInfo) {
        Vector players = this.gamePlayers;
        players.addElement(playerInfo);
        this.loadGamePlayers(players);
        this.msgReceiver.OnMessage(30);
    }

    public void notifyGamePlayerLeft(IGSId playerId) {
        this.playerLeftGame(playerId);
        Vector players = this.gamePlayers;
        this.loadGamePlayers(players);
        this.msgReceiver.OnMessage(32);
    }

    public void notifyGamePlayerKicked(IGSId playerId) {
        for (int i = 0; i < this.gamePlayers.size(); ++i) {
            if (!((Object)((IPlayerInfo)this.gamePlayers.elementAt(i)).getId()).equals(playerId)) continue;
            this.msgReceiver.OnMessage(33);
        }
    }

    public void notifyGamePlayerReady(IPlayerInfo pInfo) {
        Vector players = this.gamePlayers;
        Vector<IPlayerInfo> newPlayers = new Vector<IPlayerInfo>();
        for (int i = 0; i < players.size(); ++i) {
            PlayerInfo player = (PlayerInfo)players.elementAt(i);
            if (((Object)player.getId()).equals(pInfo.getId())) {
                newPlayers.addElement(pInfo);
                continue;
            }
            newPlayers.addElement((IPlayerInfo)players.elementAt(i));
        }
        this.loadGamePlayers(newPlayers);
        this.msgReceiver.OnMessage(34);
    }

    public void notifyGameOwnerChanged(IPlayerInfo owner) {
        if (((Object)owner.getId()).equals(this.myInfo.getId())) {
            this.myInfo = owner;
        }
        this.ownerChanged(owner);
        this.msgReceiver.OnMessage(35);
    }

    public void notifyGameStarted() {
        this.msgReceiver.OnMessage(6);
    }

    public void notifyGameEnded(IScoreInfo scoreInfo) {
        for (int i = 0; i < scoreInfo.getRankingInfo().size(); ++i) {
            if (Globals.playerNickname.toString().equals(((RankingInfo)scoreInfo.getRankingInfo().elementAt(i)).getPlayerName().toString())) {
                this.myPlayerRanking = (RankingInfo)scoreInfo.getRankingInfo().elementAt(i);
                continue;
            }
            if (!Globals.enemyNickname.toString().equals(((RankingInfo)scoreInfo.getRankingInfo().elementAt(i)).getPlayerName().toString())) continue;
            this.enemyPlayerRanking = (RankingInfo)scoreInfo.getRankingInfo().elementAt(i);
        }
        Globals.playerPoints = new StringBuffer(this.myPlayerRanking.getScore().toString());
        Globals.enemyPoints = new StringBuffer(this.enemyPlayerRanking.getScore().toString());
        Globals.pointsDiffPlayer = new StringBuffer(this.myPlayerRanking.getScoreDif().toString());
        Globals.pointsDiffEnemy = new StringBuffer(this.enemyPlayerRanking.getScoreDif().toString());
        Globals.endGameType = this.getIntegerParameter(this.myPlayerRanking.getAdditionalInfo().toString());
        this.msgReceiver.OnMessage(7);
    }

    public int getIntegerParameter(String parameter) {
        int result;
        try {
            result = Integer.parseInt(parameter);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("parameter " + parameter + " is not integer");
        }
        return result;
    }

    public void notifyGameStateArrived(String gameStateString) {
        this.msgReceiver.OnMessage(gameStateString);
    }

    public void notifyInvitationArrived(IPlayerInfo playerInfo, IGameInstanceInfo gameInfo) {
        this.msgReceiver.OnMessage(36);
    }

    public void notifyInvitationAccepted(IGSId playerId) {
        this.msgReceiver.OnMessage(37);
    }

    public void notifyMessageArrived(IMessageInfo msgInfo) {
        this.msgReceiver.OnMessage(38);
    }

    public void notifyBuddyJoined(IPlayerInfo playerInfo) {
        this.msgReceiver.OnMessage(39);
    }

    public void notifyBuddyLeft(IGSId playerId) {
        this.msgReceiver.OnMessage(40);
    }

    public void notifyBuddyStateChanged(IPlayerInfo playerInfo) {
        this.msgReceiver.OnMessage(41);
    }

    public void connectionTerminated() {
        this.setAuthentificated(false);
        this.isConnected = false;
        this.msgReceiver.OnMessage(90);
    }

    public void notifyQueryFailed(Short queryResponseType, String message) {
        this._queryResponseType = queryResponseType + " contents: " + message.toString();
        this.responseQueue.dequeue();
        if ("Invalid mobile Id".equals(message)) {
            this.msgReceiver.OnMessage(124);
        } else if ("Invalid login or password".equals(message)) {
            this.msgReceiver.OnMessage(102);
        } else if ("MobileId was recently changed".equals(message)) {
            this.msgReceiver.OnMessage(101);
        } else if ("Not allowed to login as guest".equals(message)) {
            this.msgReceiver.OnMessage(126);
        } else if ("Tried to change to already registered mobile id".equals(message)) {
            this.msgReceiver.OnMessage(131);
        } else if ("Application update required".equals(message)) {
            this.msgReceiver.OnMessage(112);
        } else if ("The user payment period has expired".equals(message)) {
            this.msgReceiver.OnMessage(111);
        } else if ("The user trial period has expired".equals(message)) {
            this.msgReceiver.OnMessage(110);
        } else if ("User is already logged in".equals(message)) {
            this.msgReceiver.OnMessage(106);
        } else if ("Authorization error".equals(message)) {
            this.msgReceiver.OnMessage(127);
        } else if ("no active contest".equals(message)) {
            this.msgReceiver.OnMessage(104);
        } else if ("User already exists".equals(message)) {
            this.msgReceiver.OnMessage(108);
        } else if ("Game is full".equals(message)) {
            this.msgReceiver.OnMessage(142);
        } else if ("Player is not in this game".equals(message)) {
            this.msgReceiver.OnMessage(141);
        } else if ("Password doesn't match".equals(message)) {
            this.msgReceiver.OnMessage(109);
        } else if ("MSISDN already exist".equals(message)) {
            this.msgReceiver.OnMessage(132);
        } else if ("Subscription already deactive".equals(message)) {
            Globals.SUBSCRIPTION_ACTIVATED = false;
            this.msgReceiver.OnMessage(135);
        } else if ("Subscription already active".equals(message)) {
            Globals.SUBSCRIPTION_ACTIVATED = true;
            this.msgReceiver.OnMessage(136);
        } else if ("Login for password recovery invalid".equals(message)) {
            this.msgReceiver.OnMessage(138);
        } else if ("Failed to recover password".equals(message)) {
            this.msgReceiver.OnMessage(139);
        } else if (queryResponseType.equals(new Short(5))) {
            this.msgReceiver.OnMessage(140);
        } else if (queryResponseType != null) {
            this.msgReceiver.OnMessage(200);
        }
    }

    public void notifyRoomPlayerStateChanged(IPlayerInfo iPlayerInfo) {
        Vector players = this.roomPlayers;
        for (int i = 0; i < players.size(); ++i) {
            PlayerInfo player = (PlayerInfo)players.elementAt(i);
            if (!((Object)player.getId()).equals(iPlayerInfo.getId())) continue;
            players.removeElementAt(i);
            players.insertElementAt(iPlayerInfo, i);
        }
        this.loadRoomPlayers(players);
        this.msgReceiver.OnMessage(3);
    }

    public void login(boolean guest) {
        try {
            if (guest) {
                this.authenticate(BoundedString.empty(), BoundedString.empty());
            } else {
                String login = Texts.PLAYER_NAME.toString().toUpperCase();
                String password = Texts.PLAYER_PASSWORD.toString().toUpperCase();
                this.authenticate(new BoundedString(login), new BoundedString(password));
            }
            this.setGuest(guest);
        }
        catch (GSException e) {
            if (e.getMessage().equals("Mobile id not retreived")) {
                ClientInterface.GetInstance().msisdn = "null";
                RMSSettings.saveRecords();
                this.msgReceiver.OnMessage(120);
            } else {
                this._queryResponseType = "B\u0142\u0105d: " + e.getMessage();
                this.msgReceiver.OnMessage(200);
            }
            System.out.println("failed to send login query: " + e.getMessage());
        }
    }

    public void register() {
        String error = "password and confirmation does not match";
        try {
            String login = Texts.PLAYER_NAME.toString().toUpperCase();
            String password = Texts.PLAYER_PASSWORD.toString().toUpperCase();
            String password2 = Texts.PLAYER_PASSWORD2.toString().toUpperCase();
            String email = Texts.PLAYER_EMAIL.toString();
            if (!password.equals(password2)) {
                throw new GSException(error);
            }
            this.register(new BoundedString(login), new BoundedString(password), new BoundedString(email));
        }
        catch (GSException e) {
            if (e.getMessage().equals(error)) {
                this.msgReceiver.OnMessage(129);
            } else {
                this.msgReceiver.OnMessage(96);
            }
            System.out.println("failed to send register query: " + e.getMessage());
        }
    }

    public void setMSISDN(String val) {
        this.msisdn = val;
    }

    public void queryUserForMobileId() {
    }

    public void retreiveMobileId() {
        try {
            super.retreiveMobileId();
        }
        catch (GSException ex) {
            ex.printStackTrace();
        }
    }

    public void notifyAuthenticate() {
        System.out.println("authentication successfull");
        this.setAuthentificated(true);
        this.msgReceiver.OnMessage(94);
    }

    public void notifyRetreiveMobileId(IGSId mobileId) {
        if (mobileId != null) {
            super.notifyRetreiveMobileId(mobileId);
            this.setMSISDN(((Object)mobileId).toString());
            RMSSettings.saveRecords();
            this.msgReceiver.OnMessage(123);
        } else {
            this.msgReceiver.OnMessage(122);
        }
    }

    public void superNotifyRetreiveMobileId() {
        super.notifyRetreiveMobileId(GSIdUtil.parseFromString(this.msisdn));
    }

    public void notifyRegister() {
        this.msgReceiver.OnMessage(95);
    }

    public void notifyRecoverPassword() {
        this.msgReceiver.OnMessage(99);
    }

    public void notifyChangePassword() {
        this.msgReceiver.OnMessage(98);
    }

    public void notifyServerGetRanking(Vector rankings) {
        this.gameRankings.removeAllElements();
        this.gameRankings = rankings;
        this.msgReceiver.OnMessage(100);
    }

    public void notifyServerGetRankingForPlayer(IRankingInfo ranking, Integer place) {
        this.playerRankings.removeAllElements();
        this.playerRankings.addElement(ranking);
        this.playerPlace = place;
    }

    public void rankingRetreived(Vector ranking, Vector places) {
        Enumeration elems = ranking.elements();
        int count = 0;
        while (elems.hasMoreElements()) {
            IRankingInfo info = (IRankingInfo)elems.nextElement();
            ++count;
        }
    }

    public void notifyServerGetRankingSize(Integer size) {
    }

    public void notifyServerChangeMobileid() {
        this.msgReceiver.OnMessage(97);
    }

    public void notifyGamePlayerReconnected(IPlayerInfo playerInfo) {
        this.notifyGamePlayerStateChanged(playerInfo);
    }

    public void notifyGameListPlayers(Vector players) {
        this.loadGamePlayers(players);
    }

    public void notifyServerGetInfoBoradMessages() {
        this.msgReceiver.OnMessage(103);
    }

    public void notifyServerDeleteInfoBoardMessage() {
    }

    public void notifyServerGetInfoBoardMessageCount(Integer count) {
    }

    public void notifyInfoBoardMessageArrived(IInfoBoardMessageInfo message) {
        this.infoBoardQueue.dequeue();
        this.infoBoardMessages.addElement(message);
    }

    public void notifyAccountActivate() {
        this.msgReceiver.OnMessage(133);
    }

    public void notifyAccountDeactivate() {
        this.msgReceiver.OnMessage(134);
    }

    public void notifyServerGetNewAppVersionUrl(String url) {
        this.updateUrl = url;
        this.msgReceiver.OnMessage(113);
    }

    public void notifyTellFriendAboutOMPG() {
    }

    private String outputDateUsingCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        int day = calendar.get(5);
        sb.append(this.numberToString(day));
        sb.append(".");
        int month = calendar.get(2) + 1;
        sb.append(this.numberToString(month));
        sb.append(".");
        sb.append(calendar.get(1));
        return sb.toString();
    }

    private String numberToString(int value) {
        String valStr = Integer.toString(value);
        return value < 10 ? "0" + valStr : valStr;
    }

    public void notifyAccountIsActive(Boolean isActive, Date date) {
        Globals.SUBSCRIPTION_ACTIVATED = isActive;
        Globals.SUBSCRIPTION_EXPIRY_DATE = this.outputDateUsingCalendar(date);
        this.msgReceiver.OnMessage(137);
    }

    public void notifyServerGetTime(Date arg0) {
    }

    public void serverGetTextMessageData(Short type) {
        try {
            this.serverGetTextMessageInfo(type);
            this.smsType = type;
            System.out.println("Ustawiam type:" + type);
        }
        catch (Exception ex) {
            System.out.println("blad w server getTextMessageInfo: " + ex);
        }
    }

    public void notifyServerGetTextMessageInfo(BoundedString arg0, String arg1) {
        this.smsNumber = arg0.toString();
        this.smsMessage = arg1;
        this.msgReceiver.OnMessage(114);
    }

    public void notifyUserSingleCharged() {
    }
}

