/*
 * Decompiled with CFR 0.152.
 */
package menu;

import framework.AppState;
import framework.Globals;
import framework.MainGameCanvas;
import framework.Texts;
import framework.graphics.SimpleSprite;
import framework.graphics.TextRenderer;
import framework.menu.MenuForm;
import framework.sound.Music;
import gs.common.BoundedString;
import gs.ompg.ClientInterface;
import gs.ompg.IMsgReceiver;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import menu.MenuBackground;
import root.TanksCanvas;
import root.TanksMIDlet;

public class MainMenu
extends AppState
implements IMsgReceiver {
    private MenuForm menu;
    private MenuForm mainMenu;
    private MenuForm settingsMenu;
    private MenuForm forgotPasswordMenu;
    private MenuForm recoverySuccessMenu;
    private MenuForm helpMenu;
    private MenuForm aboutMenu;
    private MenuForm rulesMenu;
    private MenuForm controlsMenu;
    private MenuForm scoreMenu;
    private MenuForm waitingMenu;
    private MenuForm feedbackMenu;
    private MenuForm serverConnectionFailedInfo;
    private MenuForm mobileIdNotRetreivedInfo;
    private MenuForm retreivingPhoneIdMenu;
    private MenuForm universalScroolBoxInfo;
    private MenuForm nextMenuAfterUniversalScroolBox;
    private MenuForm previousMenuFromUniversalScroolBox;
    int universalScroolBoxID;
    private int currentFaqIndex = 0;
    private int trainingID;
    private int settingsID;
    private int helpID;
    private int aboutID;
    private int exitID;
    private int music2ID;
    private int moreGamesID;
    private int sound2ID;
    private int vibrations2ID;
    private TanksMIDlet midlet;
    private int forgotPasswordEditID;
    private int mentionID;
    private int forgotPasswordID;
    private int zasadyID;
    private int sterowanieID;
    private int wynikiID;
    private int upArrowID;
    private int downArrowID;
    private int aboutMenuId;
    private int feedbackID;
    private int faqID;
    Image bowl;
    private SimpleSprite smDownArrow;
    private SimpleSprite smUpArrow;
    int fontSize;
    int fontSize2;
    public static boolean wasPayInfoShown = false;

    public MainMenu(String stateName, MainGameCanvas mainGameCanvas, TanksMIDlet midlet) {
        super(stateName, mainGameCanvas);
        this.midlet = midlet;
    }

    public void createMainMenu() {
        this.fontSize = TextRenderer.getInstance().getStringHeight(1);
        this.fontSize2 = TextRenderer.getInstance().getStringHeight(9);
        int[] cols = new int[]{0, 0, -1};
        int[] rows = new int[]{this.fontSize * 4, this.fontSize * 5, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, this.fontSize + 2, -1};
        this.mainMenu = MenuForm.createMenuForm(5, rows, cols, 240, 320, (byte)1, (byte)0);
        this.trainingID = this.mainMenu.createControl(4, 0, 4, 1, null, Texts.MENU_TRAINING);
        this.settingsID = this.mainMenu.createControl(4, 1, 5, 1, null, Texts.MENU_SETTINGS);
        this.helpID = this.mainMenu.createControl(4, 2, 6, 1, null, Texts.MENU_HELP);
        this.aboutID = this.mainMenu.createControl(4, 3, 7, 1, null, Texts.MENU_ABOUT);
        this.exitID = this.mainMenu.createControl(4, 4, 8, 1, null, Texts.MENU_END);
        this.settingsMenu = MenuForm.createMenuForm(3, rows, cols, 240, 320, (byte)1, (byte)0);
        this.music2ID = Music.isMusic ? this.settingsMenu.createControl(4, 0, 5, 1, null, new StringBuffer().append((Object)Texts.OPTIONS_MUSIC).append(" ").append((Object)Texts.ON)) : this.settingsMenu.createControl(4, 0, 5, 1, null, new StringBuffer().append((Object)Texts.OPTIONS_MUSIC).append(" ").append((Object)Texts.OFF));
        this.sound2ID = Music.isSound ? this.settingsMenu.createControl(4, 1, 6, 1, null, new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.ON)) : this.settingsMenu.createControl(4, 1, 6, 1, null, new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.OFF));
        this.vibrations2ID = Music.isVibration ? this.settingsMenu.createControl(4, 2, 7, 1, null, new StringBuffer().append((Object)Texts.OPTIONS_VIBRATIONS).append(" ").append((Object)Texts.ON)) : this.settingsMenu.createControl(4, 2, 7, 1, null, new StringBuffer().append((Object)Texts.OPTIONS_VIBRATIONS).append(" ").append((Object)Texts.OFF));
        this.forgotPasswordMenu = MenuForm.createMenuForm(3, rows, cols, 240, 320, (byte)1, (byte)0);
        this.forgotPasswordMenu.createControl(2, -1, 4, 1, null, Texts.FORGOT_PASSWORD_LABEL);
        this.forgotPasswordEditID = this.forgotPasswordMenu.createEditableControl(7, 0, 6, 1, Texts.MENU_LOGIN_LABEL, Texts.FORGOT_PASSWORD_LOGIN);
        this.mentionID = this.forgotPasswordMenu.createControl(4, 1, 9, 1, null, Texts.MENU_MENTION);
        this.helpMenu = MenuForm.createMenuForm(2, rows, cols, 240, 320, (byte)1, (byte)0);
        this.zasadyID = this.helpMenu.createControl(4, 0, 5, 1, null, Texts.MENU_RULEZ);
        this.sterowanieID = this.helpMenu.createControl(4, 1, 6, 1, null, Texts.MENU_CONTROLS);
        this.rulesMenu = MenuForm.createMenuForm(3, rows, cols, 240, 320, (byte)1, (byte)0);
        this.rulesMenu.createScrollBox(168, this.fontSize2, -1, 4, 1, 10, 10, Texts.RULES_INFO, 0);
        this.upArrowID = this.rulesMenu.createControl(5, this.smUpArrow.getFrameWidth(), this.smUpArrow.getFrameHeight(), -1, 1, 0, 10, 0, this.smUpArrow, null, 0, 0);
        this.downArrowID = this.rulesMenu.createControl(5, this.smDownArrow.getFrameWidth(), this.smDownArrow.getFrameHeight(), -1, 1, 0, 34, 0, this.smDownArrow, null, 0, 0);
        this.rulesMenu.getControlByID((int)this.downArrowID).pozX = Globals.upAndDownArrowOffsetX;
        this.rulesMenu.getControlByID((int)this.downArrowID).pozY = Globals.downArrowOffsetY;
        this.rulesMenu.getControlByID((int)this.upArrowID).pozX = Globals.upAndDownArrowOffsetX;
        this.rulesMenu.getControlByID((int)this.upArrowID).pozY = Globals.upArrowOffsetY;
        this.aboutMenu = MenuForm.createMenuForm(3, rows, cols, 240, 320, (byte)1, (byte)0);
        Texts.ABOUT_INFO = new StringBuffer("Statki \nv." + TanksMIDlet.version + "\n" + Texts.ABOUT_EMPTY_INFO.toString());
        this.aboutMenu.createScrollBox(168, this.fontSize2, -1, 3, 1, 10, 10, Texts.ABOUT_INFO, 0);
        this.upArrowID = this.aboutMenu.createControl(5, this.smUpArrow.getFrameWidth(), this.smUpArrow.getFrameHeight(), -1, 1, 0, 10, 0, this.smUpArrow, null, 0, 0);
        this.downArrowID = this.aboutMenu.createControl(5, this.smDownArrow.getFrameWidth(), this.smDownArrow.getFrameHeight(), -1, 1, 0, 34, 0, this.smDownArrow, null, 0, 0);
        this.aboutMenu.getControlByID((int)this.downArrowID).pozX = Globals.upAndDownArrowOffsetX;
        this.aboutMenu.getControlByID((int)this.downArrowID).pozY = Globals.downArrowOffsetY;
        this.aboutMenu.getControlByID((int)this.upArrowID).pozX = Globals.upAndDownArrowOffsetX;
        this.aboutMenu.getControlByID((int)this.upArrowID).pozY = Globals.upArrowOffsetY;
        this.controlsMenu = MenuForm.createMenuForm(3, rows, cols, 240, 320, (byte)1, (byte)0);
        this.controlsMenu.createScrollBox(168, this.fontSize2, -1, 4, 1, 10, 10, Texts.MENU_CONTROLS_INFO, 0);
        this.upArrowID = this.controlsMenu.createControl(5, this.smUpArrow.getFrameWidth(), this.smUpArrow.getFrameHeight(), -1, 1, 0, 10, 0, this.smUpArrow, null, 0, 0);
        this.downArrowID = this.controlsMenu.createControl(5, this.smDownArrow.getFrameWidth(), this.smDownArrow.getFrameHeight(), -1, 1, 0, 34, 0, this.smDownArrow, null, 0, 0);
        this.controlsMenu.getControlByID((int)this.downArrowID).pozX = Globals.upAndDownArrowOffsetX;
        this.controlsMenu.getControlByID((int)this.downArrowID).pozY = Globals.downArrowOffsetY;
        this.controlsMenu.getControlByID((int)this.upArrowID).pozX = Globals.upAndDownArrowOffsetX;
        this.controlsMenu.getControlByID((int)this.upArrowID).pozY = Globals.upArrowOffsetY;
        this.feedbackMenu = MenuForm.createMenuForm(1, rows, cols, 240, 320, (byte)1, (byte)0);
        this.feedbackMenu.createScrollBox(168, this.fontSize2, -1, 4, 1, 10, 10, Texts.FEEDBACK, 0);
        this.scoreMenu = MenuForm.createMenuForm(3, rows, cols, 240, 320, (byte)1, (byte)0);
        this.scoreMenu.createScrollBox(168, this.fontSize2, -1, 4, 1, 10, 10, Texts.MENU_SCORE_INFO, 0);
        this.upArrowID = this.scoreMenu.createControl(5, this.smUpArrow.getFrameWidth(), this.smUpArrow.getFrameHeight(), -1, 1, 0, 10, 0, this.smUpArrow, null, 0, 0);
        this.downArrowID = this.scoreMenu.createControl(5, this.smDownArrow.getFrameWidth(), this.smDownArrow.getFrameHeight(), -1, 1, 0, 34, 0, this.smDownArrow, null, 0, 0);
        this.scoreMenu.getControlByID((int)this.downArrowID).pozX = Globals.upAndDownArrowOffsetX;
        this.scoreMenu.getControlByID((int)this.downArrowID).pozY = Globals.downArrowOffsetY;
        this.scoreMenu.getControlByID((int)this.upArrowID).pozX = Globals.upAndDownArrowOffsetX;
        this.scoreMenu.getControlByID((int)this.upArrowID).pozY = Globals.upArrowOffsetY;
        this.waitingMenu = MenuForm.createMenuForm(1, rows, cols, 240, 320, (byte)1, (byte)0);
        this.waitingMenu.createControl(4, -1, 6, 1, null, Texts.CONNECTING);
        this.serverConnectionFailedInfo = MenuForm.createMenuForm(1, rows, cols, 240, 320, (byte)1, (byte)0);
        this.serverConnectionFailedInfo.createScrollBox(168, 224, -1, 6, 1, 10, 10, Texts.SERVER_CONNECTION_FAILED_ERROR_TEXT, 0);
        this.mobileIdNotRetreivedInfo = MenuForm.createMenuForm(1, rows, cols, 240, 320, (byte)1, (byte)0);
        this.mobileIdNotRetreivedInfo.createScrollBox(168, 224, -1, 6, 1, 10, 10, Texts.MOBILE_ID_NOT_RETREIVED_TEXT, 0);
        this.recoverySuccessMenu = MenuForm.createMenuForm(1, rows, cols, 240, 320, (byte)1, (byte)0);
        this.recoverySuccessMenu.createScrollBox(168, 224, -1, 6, 1, 10, 10, Texts.PASS_RECOVERY_SUCCESS, 0);
        this.retreivingPhoneIdMenu = MenuForm.createMenuForm(1, rows, cols, 240, 320, (byte)1, (byte)0);
        this.retreivingPhoneIdMenu.createScrollBox(168, 224, -1, 6, 1, 10, 10, Texts.RETREIVING_PHONE_ID_TEXT, 0);
        int[] rows2 = new int[]{160 - this.fontSize * 3, this.fontSize + 2, -1};
        this.universalScroolBoxInfo = MenuForm.createMenuForm(3, rows2, cols, 240, 320, (byte)1, (byte)0);
        this.universalScroolBoxID = this.universalScroolBoxInfo.createScrollBox(Globals.scroolboxOnMenuBackgroundWidth, Globals.scroolboxOnMenuBackgroundHeight, -1, 1, 1, 10, 10, new StringBuffer(" "), 0);
        this.upArrowID = this.universalScroolBoxInfo.createControl(5, this.smUpArrow.getFrameWidth(), this.smUpArrow.getFrameHeight(), -1, 1, 0, 10, 0, this.smUpArrow, null, 0, 0);
        this.downArrowID = this.universalScroolBoxInfo.createControl(5, this.smDownArrow.getFrameWidth(), this.smDownArrow.getFrameHeight(), -1, 1, 0, 34, 0, this.smDownArrow, null, 0, 0);
        this.universalScroolBoxInfo.getControlByID((int)this.downArrowID).pozX = Globals.upAndDownArrowOffsetX;
        this.universalScroolBoxInfo.getControlByID((int)this.downArrowID).pozY = Globals.downArrowOffsetY;
        this.universalScroolBoxInfo.getControlByID((int)this.upArrowID).pozX = Globals.upAndDownArrowOffsetX;
        this.universalScroolBoxInfo.getControlByID((int)this.upArrowID).pozY = Globals.upArrowOffsetY;
    }

    public void setUniversalScroolBoxMenu(StringBuffer text, int displayType, MenuForm previousMenu, MenuForm nextMenu) {
        if (this.universalScroolBoxInfo != null) {
            this.universalScroolBoxInfo.getControlByID(this.universalScroolBoxID).setText(text);
            this.universalScroolBoxInfo.recalculateScrollBox(this.universalScroolBoxID);
            this.menu = this.universalScroolBoxInfo;
            this.universalScroolBoxInfo.setDisplayType(displayType);
            this.previousMenuFromUniversalScroolBox = previousMenu;
            this.nextMenuAfterUniversalScroolBox = nextMenu;
        }
    }

    public void notifyKeypressed(int formID, int controlID) {
    }

    public void notifyKeypressed2(int formID, int controlID) {
        if (formID == this.mainMenu.id) {
            if (controlID == this.trainingID) {
                TanksCanvas cfr_ignored_0 = this.midlet.canvas;
                TanksCanvas.isTraining = true;
                this.midlet.canvas.startGame();
            } else if (controlID == this.settingsID) {
                this.menu = this.settingsMenu;
            } else if (controlID == this.helpID) {
                this.menu = this.helpMenu;
            } else if (controlID == this.aboutID) {
                this.menu = this.aboutMenu;
            } else if (controlID == this.moreGamesID) {
                this.mainGameCanvas.requestAppStateChange("MoreGamesMenu");
            } else if (controlID == this.exitID) {
                Music.stopMusic();
                TextRenderer.getInstance().destroy();
                this.midlet.destroyApp(false);
            }
        } else if (formID == this.settingsMenu.id) {
            if (controlID == this.music2ID) {
                this.changeMusic();
            } else if (controlID == this.sound2ID) {
                this.changeSound();
            } else if (controlID == this.vibrations2ID) {
                this.changeVibrations();
            } else if (controlID == this.forgotPasswordID) {
                this.menu = this.forgotPasswordMenu;
            }
        } else if (formID == this.forgotPasswordMenu.id) {
            if (controlID == this.forgotPasswordEditID) {
                this.forgotPasswordMenu.handleEdit();
            } else if (controlID == this.mentionID) {
                try {
                    ClientInterface.GetInstance().recoverPassword(new BoundedString(Texts.FORGOT_PASSWORD_LOGIN.toString()));
                    this.menu = this.waitingMenu;
                }
                catch (Exception ex) {
                    System.out.println("blad w recoverPassword: " + ex);
                    this.recoverySuccessMenu.getControlByID(0).setText(Texts.PASS_RECOVERY_FAIL);
                    this.menu = this.recoverySuccessMenu;
                }
            }
        } else if (formID == this.helpMenu.id) {
            if (controlID == this.zasadyID) {
                this.menu = this.rulesMenu;
            }
            if (controlID == this.sterowanieID) {
                this.menu = this.controlsMenu;
            }
        } else if (this.menu == this.universalScroolBoxInfo) {
            StringBuffer scroolboxText = this.universalScroolBoxInfo.getControlByID(this.universalScroolBoxID).getText();
            if (this.nextMenuAfterUniversalScroolBox != null) {
                this.menu = this.nextMenuAfterUniversalScroolBox;
            }
        }
    }

    public void clearTextInForgotPasswordLoginField() {
        this.forgotPasswordMenu.getControlByID((int)this.forgotPasswordEditID).editableText = Texts.FORGOT_PASSWORD_LOGIN = new StringBuffer("");
        this.forgotPasswordMenu.getControlByID((int)this.forgotPasswordEditID).cursorPosition = Texts.FORGOT_PASSWORD_LOGIN.length();
    }

    public void keyRepeated(int keyCode) {
        if (this.menu != null) {
            this.menu.keyRepeated(keyCode);
        }
    }

    public void keyReleased(int keyCode) {
        if (this.menu != null) {
            this.menu.keyReleased(keyCode);
        }
    }

    public void keyPressed(int keyCode) {
        if (this.menu != null) {
            if (!this.menu.blockKeysInHandleInput) {
                if (keyCode == -6 || keyCode == -5 || keyCode == 53) {
                    this.notifyKeypressed2(this.menu.id, this.menu.focusedID);
                }
                if (keyCode == -7) {
                    if (this.menu == this.settingsMenu || this.menu == this.helpMenu || this.menu == this.aboutMenu || this.menu == this.waitingMenu) {
                        this.menu = this.mainMenu;
                    } else if (this.menu == this.controlsMenu || this.menu == this.scoreMenu || this.menu == this.rulesMenu || this.menu == this.feedbackMenu) {
                        this.menu = this.helpMenu;
                    } else if (this.menu == this.mainMenu) {
                        this.mainMenu.getControlByID((int)this.mainMenu.focusedID).state = 0;
                        this.mainMenu.focusedID = this.exitID;
                        this.mainMenu.getControlByID((int)this.mainMenu.focusedID).state = 1;
                    } else if (this.menu == this.forgotPasswordMenu) {
                        this.menu = this.settingsMenu;
                    } else if (this.menu == this.recoverySuccessMenu) {
                        this.menu = this.settingsMenu;
                    } else if (this.menu == this.serverConnectionFailedInfo) {
                        this.menu = this.mainMenu;
                    } else if (this.menu == this.mobileIdNotRetreivedInfo) {
                        this.menu = this.mainMenu;
                    } else if (this.menu == this.universalScroolBoxInfo) {
                        StringBuffer scroolboxText = this.universalScroolBoxInfo.getControlByID(this.universalScroolBoxID).getText();
                        if (this.previousMenuFromUniversalScroolBox != null) {
                            this.menu = this.previousMenuFromUniversalScroolBox;
                        }
                    }
                }
                if ((keyCode == 51 || keyCode == -4) && this.menu == this.universalScroolBoxInfo) {
                    if (this.currentFaqIndex < Texts.FAQ_TEXT_TAB.length - 1) {
                        ++this.currentFaqIndex;
                    }
                    this.setUniversalScroolBoxMenu(Texts.FAQ_TEXT_TAB[this.currentFaqIndex], 2, this.mainMenu, null);
                }
                if ((keyCode == 49 || keyCode == -3) && this.menu == this.universalScroolBoxInfo) {
                    if (this.currentFaqIndex > 0) {
                        --this.currentFaqIndex;
                    }
                    this.setUniversalScroolBoxMenu(Texts.FAQ_TEXT_TAB[this.currentFaqIndex], 2, this.mainMenu, null);
                }
                if (!(keyCode != -2 && keyCode != 56 || this.menu != this.aboutMenu && this.menu != this.scoreMenu && this.menu != this.universalScroolBoxInfo && this.menu != this.controlsMenu && this.menu != this.rulesMenu)) {
                    ++this.menu.getControlByID((int)0).currentLine;
                }
                if (!(keyCode != -1 && keyCode != 50 || this.menu != this.aboutMenu && this.menu != this.scoreMenu && this.menu != this.universalScroolBoxInfo && this.menu != this.controlsMenu && this.menu != this.rulesMenu)) {
                    --this.menu.getControlByID((int)0).currentLine;
                }
            } else {
                this.menu.keyPressed(keyCode);
            }
        }
    }

    public void handleInput() {
        this.menu.handleInput(this.mainGameCanvas.getKeyStates());
    }

    public boolean initialize(Object param) {
        try {
            this.bowl = Image.createImage((String)"/small_arrow_up.png");
            this.smUpArrow = new SimpleSprite(this.bowl, this.bowl.getWidth() / 2, this.bowl.getHeight());
            this.bowl = Image.createImage((String)"/small_arrow_down.png");
            this.smDownArrow = new SimpleSprite(this.bowl, this.bowl.getWidth() / 2, this.bowl.getHeight());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.createMainMenu();
        this.menu = this.mainMenu;
        Music.playMusic(TanksMIDlet.menuMusicId);
        this.updateSettings();
        ClientInterface.GetInstance().SetMsgReceiver(this);
        return true;
    }

    public void deinitialize() {
        this.bowl = null;
        this.smDownArrow = null;
        this.smUpArrow = null;
        this.menu = null;
        this.mainMenu = null;
        this.settingsMenu = null;
        this.forgotPasswordMenu = null;
        this.recoverySuccessMenu = null;
        this.helpMenu = null;
        this.aboutMenu = null;
        this.controlsMenu = null;
        this.scoreMenu = null;
        this.waitingMenu = null;
        this.serverConnectionFailedInfo = null;
        this.mobileIdNotRetreivedInfo = null;
        this.retreivingPhoneIdMenu = null;
        this.universalScroolBoxInfo = null;
        this.nextMenuAfterUniversalScroolBox = null;
        this.previousMenuFromUniversalScroolBox = null;
        System.gc();
    }

    public void updateSettings() {
        System.out.println("update settiang music: " + Music.isMusic);
        this.settingsMenu.getControlByID((int)this.music2ID).text = Music.isMusic ? new StringBuffer().append((Object)Texts.OPTIONS_MUSIC).append(" ").append((Object)Texts.ON) : new StringBuffer().append((Object)Texts.OPTIONS_MUSIC).append(" ").append((Object)Texts.OFF);
        this.settingsMenu.getControlByID((int)this.sound2ID).text = Music.isSound ? new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.ON) : new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.OFF);
        this.settingsMenu.getControlByID((int)this.vibrations2ID).text = Music.isVibration ? new StringBuffer().append((Object)Texts.OPTIONS_VIBRATIONS).append(" ").append((Object)Texts.ON) : new StringBuffer().append((Object)Texts.OPTIONS_VIBRATIONS).append(" ").append((Object)Texts.OFF);
    }

    public void render(Graphics g) {
        g.setColor(0x303030);
        g.fillRect(0, 0, 240, 320);
        if (this.menu == this.mainMenu) {
            MenuBackground.GetInstance().Draw(g, 5);
        } else if (this.menu == this.aboutMenu || this.menu == this.rulesMenu || this.menu == this.controlsMenu || this.menu == this.scoreMenu || this.menu == this.recoverySuccessMenu || this.menu == this.waitingMenu || this.menu == this.serverConnectionFailedInfo || this.menu == this.mobileIdNotRetreivedInfo || this.menu == this.feedbackMenu) {
            MenuBackground.GetInstance().Draw(g, 2);
        } else if (this.menu == this.retreivingPhoneIdMenu) {
            MenuBackground.GetInstance().Draw(g);
        } else if (this.menu == this.universalScroolBoxInfo) {
            MenuBackground.GetInstance().Draw(g, this.menu.getDisplayType());
        } else {
            MenuBackground.GetInstance().Draw(g, 4);
        }
        if (!this.mainGameCanvas.isTerrainLoading) {
            this.menu.drawMenu(g);
        } else {
            TextRenderer.getInstance().renderText(g, 120 - TextRenderer.getInstance().getStringWidth(Texts.MENU_LOADING_TERRAIN.length() / 2), 160, Texts.MENU_LOADING_TERRAIN);
        }
    }

    public void update(int deltaTime) {
        this.menu.update(deltaTime);
        if (this.menu == this.aboutMenu || this.menu == this.universalScroolBoxInfo || this.menu == this.scoreMenu || this.menu == this.controlsMenu || this.menu == this.rulesMenu) {
            if (this.menu.getControlByID((int)0).currentLine > 0) {
                this.menu.getControlByID(this.upArrowID).setVisible(true);
                this.menu.getControlByID((int)this.upArrowID).state = 1;
            } else {
                this.menu.getControlByID(this.upArrowID).setVisible(false);
            }
            if (this.menu.getControlByID((int)0).currentLine < this.menu.getControlByID((int)0).lineCount - this.menu.getControlByID((int)0).visibleLines) {
                this.menu.getControlByID(this.downArrowID).setVisible(true);
                this.menu.getControlByID((int)this.downArrowID).state = 1;
            } else {
                this.menu.getControlByID(this.downArrowID).setVisible(false);
            }
        }
    }

    public void changeMusic() {
        if (!Music.isMusic) {
            Music.isMusic = true;
            this.settingsMenu.getControlByID((int)this.music2ID).text = new StringBuffer().append((Object)Texts.OPTIONS_MUSIC).append(" ").append((Object)Texts.ON);
            if (Music.isSound) {
                this.changeSound();
            }
            TanksMIDlet tanksMIDlet = this.midlet;
            tanksMIDlet.rec.saveRecords();
            Music.playMusic(TanksMIDlet.menuMusicId);
        } else {
            Music.isMusic = false;
            this.settingsMenu.getControlByID((int)this.music2ID).text = new StringBuffer().append((Object)Texts.OPTIONS_MUSIC).append(" ").append((Object)Texts.OFF);
            Music.stopMusic();
            TanksMIDlet tanksMIDlet = this.midlet;
            tanksMIDlet.rec.saveRecords();
        }
    }

    public void changeSound() {
        if (!Music.isSound) {
            Music.isSound = true;
            this.settingsMenu.getControlByID((int)this.sound2ID).text = new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.ON);
            if (Music.isMusic) {
                this.changeMusic();
            } else {
                TanksMIDlet tanksMIDlet = this.midlet;
                tanksMIDlet.rec.saveRecords();
            }
        } else {
            Music.isSound = false;
            TanksMIDlet tanksMIDlet = this.midlet;
            tanksMIDlet.rec.saveRecords();
            this.settingsMenu.getControlByID((int)this.sound2ID).text = new StringBuffer().append((Object)Texts.OPTIONS_SOUND).append(" ").append((Object)Texts.OFF);
        }
    }

    public void changeVibrations() {
        if (!Music.isVibration) {
            Music.isVibration = true;
            this.settingsMenu.getControlByID((int)this.vibrations2ID).text = new StringBuffer().append((Object)Texts.OPTIONS_VIBRATIONS).append(" ").append((Object)Texts.ON);
            TanksMIDlet tanksMIDlet = this.midlet;
            tanksMIDlet.rec.saveRecords();
        } else {
            Music.isVibration = false;
            this.settingsMenu.getControlByID((int)this.vibrations2ID).text = new StringBuffer().append((Object)Texts.OPTIONS_VIBRATIONS).append(" ").append((Object)Texts.OFF);
            TanksMIDlet tanksMIDlet = this.midlet;
            tanksMIDlet.rec.saveRecords();
        }
    }

    public void OnMessage(int msg) {
        switch (msg) {
            case 45: {
                this.mainGameCanvas.requestAppStateChange("MultiplayerMenu");
                break;
            }
            case 99: {
                this.menu = this.recoverySuccessMenu;
                break;
            }
            case 121: {
                this.menu = this.serverConnectionFailedInfo;
                break;
            }
            case 122: {
                this.menu = this.mobileIdNotRetreivedInfo;
                break;
            }
            case 123: {
                if (!ClientInterface.GetInstance().isAuthentificated() && !ClientInterface.GetInstance().IsConnected()) {
                    ClientInterface.GetInstance().Connect();
                    this.menu = this.waitingMenu;
                    break;
                }
                this.mainGameCanvas.requestAppStateChange("MultiplayerMenu");
            }
        }
    }

    public void OnMessage(String msg) {
    }
}

