/*
 * Decompiled with CFR 0.152.
 */
package root;

import framework.AppState;
import framework.MainGameCanvas;
import framework.Texts;
import framework.graphics.TextRenderer;
import framework.menu.IMenuFormListener;
import framework.menu.MenuForm;
import javax.microedition.lcdui.Graphics;
import root.TanksMIDlet;

public class MainMenuAppState
extends AppState
implements IMenuFormListener {
    private MenuForm mainMenuForm;
    private int exitButtonId;
    private int option1ButtonId;
    private int option2ButtonId;
    private int textBoxId;
    private boolean exitFlag = false;
    private boolean isSelected = false;
    public static final int KEY_SLEEP = 200;
    protected String name;
    public TanksMIDlet midlet;
    protected MainGameCanvas mainGameCanvas;
    private MainGameCanvas gameCanvas = null;

    MainMenuAppState(String name, MainGameCanvas gameCanvas, TanksMIDlet midlet) {
        super(name, gameCanvas);
        this.gameCanvas = gameCanvas;
        this.midlet = midlet;
        this.createMenu();
    }

    private void createMenu() {
        try {
            int[] rowsSizes = new int[]{-1, 5, 5, 5, 5, -1, 12};
            int[] columnsSizes = new int[]{10, -1, 10};
            this.mainMenuForm = MenuForm.createMenuForm(3, rowsSizes, columnsSizes, 240, 320, (byte)0, (byte)0);
            this.mainMenuForm.listener = this;
            this.option1ButtonId = this.mainMenuForm.createControl(4, 0, 1, 1, null, Texts.TEXT_OPCJA1);
            this.option2ButtonId = this.mainMenuForm.createControl(4, 1, 2, 1, null, Texts.TEXT_OPCJA2);
            this.exitButtonId = this.mainMenuForm.createControl(4, 100, 10, -1, 6, 0, 17, 17, null, Texts.TEXT_SELECT, 0, 5);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public boolean initialize(Object param) {
        return true;
    }

    public void deinitialize() {
    }

    public void handleInput() {
        if (!this.isSelected) {
            int keyStates = this.gameCanvas.getKeyStates();
            this.mainMenuForm.handleInput(keyStates);
        }
    }

    public void update(int deltaTime) {
        this.mainMenuForm.update(deltaTime);
    }

    public void render(Graphics g) {
        TextRenderer.getInstance().setCurrentFont("FONT_NORMAL");
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        if (!this.isSelected) {
            this.mainMenuForm.drawMenu(g);
        } else if (this.midlet.isGameHost) {
            TanksMIDlet.textRenderer.renderText(g, 120 - TanksMIDlet.textRenderer.getStringWidth(9), 160, new StringBuffer("waiting for player"));
        } else {
            TanksMIDlet.textRenderer.renderText(g, 120 - TanksMIDlet.textRenderer.getStringWidth(6), 160, new StringBuffer("joining game"));
        }
    }

    public void notifyKeypressed(int formID, int controlID) {
        if (controlID == this.option1ButtonId) {
            this.isSelected = true;
        }
        if (controlID == this.option2ButtonId) {
            this.isSelected = true;
        }
    }

    public void keyPressed(int keyCode) {
        this.mainMenuForm.keyPressed(keyCode);
    }

    public void keyReleased(int keyCode) {
    }

    public void pauseStateChanged(boolean paused) {
    }

    public void applicationDestroyed() {
    }
}

