/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.AppState;
import framework.MainGameCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SplashScreenAppState
extends AppState {
    public static final int TRANSPARENT_COLOR = -65281;
    protected Image[] images;
    private int[] backColors;
    private int[] delays;
    private String nextStateName;
    protected int currentImageIndex;
    private int splashTime;
    private boolean firstRun = true;
    private boolean allowSkipping;
    private Object mutex = new Object();
    private boolean proceeded = false;

    public SplashScreenAppState(String name, MainGameCanvas mainGameCanvas, Image[] images, int[] backColors, int[] delays, String nextStateName, boolean allowSkipping, byte fadeStyle, int fadeColor) {
        super(name, mainGameCanvas, fadeStyle, fadeColor);
        this.images = images;
        this.backColors = backColors;
        this.delays = delays;
        this.nextStateName = nextStateName;
        this.allowSkipping = allowSkipping;
        if (images == null || backColors == null || images.length == 0) {
            throw new RuntimeException("Neither images nor backColors can be null!");
        }
    }

    public SplashScreenAppState(String name, MainGameCanvas mainGameCanvas, Image[] images, int[] backColors, int[] delays, String nextStateName, boolean allowSkipping) {
        this(name, mainGameCanvas, images, backColors, delays, nextStateName, allowSkipping, 0, 0);
    }

    public SplashScreenAppState(String name, MainGameCanvas mainGameCanvas, String[] imageFiles, int[] backColors, int[] delays, String nextStateName, boolean allowSkipping, byte fadeStyle, int fadeColor) {
        super(name, mainGameCanvas, fadeStyle, fadeColor);
        try {
            this.images = new Image[imageFiles.length];
            for (int i = 0; i < imageFiles.length; ++i) {
                this.images[i] = Image.createImage((String)imageFiles[i]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error when loading splash screen images!");
        }
        this.backColors = backColors;
        this.delays = delays;
        this.nextStateName = nextStateName;
        this.allowSkipping = allowSkipping;
        if (this.images == null || backColors == null || this.images.length == 0) {
            throw new RuntimeException("Neither images nor backColors can be null!");
        }
    }

    public SplashScreenAppState(String name, MainGameCanvas mainGameCanvas, String[] imageFiles, int[] backColors, int[] delays, String nextStateName, boolean allowSkipping) {
        this(name, mainGameCanvas, imageFiles, backColors, delays, nextStateName, allowSkipping, 0, 0);
    }

    public boolean initialize() {
        if (!this.firstRun) {
            throw new RuntimeException("Can't enable state " + this.name + ": resources has been released!");
        }
        this.splashTime = 0;
        this.currentImageIndex = 0;
        this.firstRun = false;
        return true;
    }

    public void deinitialize() {
        this.images = null;
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(int keyCode) {
        if (!this.allowSkipping) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.currentImageIndex < this.delays.length) {
                this.splashTime = this.delays[this.currentImageIndex];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int deltaTime) {
        Object object = this.mutex;
        synchronized (object) {
            this.splashTime += deltaTime;
            if (this.currentImageIndex < this.delays.length && this.splashTime >= this.delays[this.currentImageIndex]) {
                ++this.currentImageIndex;
                this.splashTime = 0;
            }
        }
        if (this.currentImageIndex >= this.images.length) {
            this.proceedToTheNextState();
        }
    }

    public void render(Graphics g) {
        if (this.currentImageIndex < this.images.length) {
            if (this.images[this.currentImageIndex] == null) {
                throw new RuntimeException("There's no image at index " + this.currentImageIndex + ".");
            }
            if (this.backColors[this.currentImageIndex] != -65281) {
                g.setColor(this.backColors[this.currentImageIndex]);
                g.fillRect(0, 0, 240, 320);
            }
            Image currentImage = this.images[this.currentImageIndex];
            int currentImageX = 120 - currentImage.getWidth() / 2;
            int currentImageY = 160 - currentImage.getHeight() / 2;
            g.drawImage(currentImage, currentImageX, currentImageY, 0);
        } else if (this.backColors[this.images.length - 1] != -65281) {
            g.setColor(this.backColors[this.images.length - 1]);
            g.fillRect(0, 0, 240, 320);
        }
    }

    protected void proceedToTheNextState() {
        if (!this.proceeded) {
            this.mainGameCanvas.requestAppStateChange(this.nextStateName);
            this.proceeded = true;
        }
    }
}

