/*
 * Decompiled with CFR 0.152.
 */
package gs.common.datapackets;

import gs.common.datapackets.IDataStringConvertible;
import gs.common.enumerations.PacketType;
import gs.common.enumerations.QueryType;
import gs.common.info.IQueryResponseInfo;
import gs.common.utils.CollectionUtil;
import gs.common.utils.DataPacketUtil;
import gs.common.utils.ObjectUtil;
import gs.exceptions.PacketConversionException;
import java.util.Vector;

public class QueryResponseDataPacket
implements IDataStringConvertible,
IQueryResponseInfo {
    private static final int NUMPACKETFIELDS = 3;
    private Short responseType;
    private Boolean querySucceded;
    private Vector responseParams;

    public QueryResponseDataPacket() {
        this.responseType = QueryType.Invalid;
        this.responseParams = new Vector();
        this.querySucceded = Boolean.TRUE;
    }

    public QueryResponseDataPacket(Short responseType, Vector params) {
        this.responseType = responseType;
        this.responseParams = params;
        this.querySucceded = Boolean.TRUE;
    }

    public QueryResponseDataPacket(Short responseType, Boolean success, Vector params) {
        this.responseType = responseType;
        this.responseParams = params;
        this.querySucceded = success;
    }

    public Short getResponseType() {
        return this.responseType;
    }

    public Boolean getQuerySucceded() {
        return this.querySucceded;
    }

    public Vector getParams() {
        return this.responseParams;
    }

    public String toDataString() throws PacketConversionException {
        if (this.responseType.equals(QueryType.Invalid) || this.responseParams == null) {
            throw new PacketConversionException("QueryResponseDatapacket to data string: packet not initialized");
        }
        String result = DataPacketUtil.objectToDataString(this.getPacketType());
        result = result + DataPacketUtil.mainDPSeperator();
        result = result + DataPacketUtil.objectToDataString(this.responseType);
        result = result + DataPacketUtil.mainDPSeperator();
        result = result + DataPacketUtil.objectToDataString(this.querySucceded);
        result = result + DataPacketUtil.mainDPSeperator();
        for (int i = 0; i < this.responseParams.size(); ++i) {
            Object o = this.responseParams.elementAt(i);
            result = result + DataPacketUtil.objectToDataString(o);
            if (i >= this.responseParams.size() - 1) continue;
            result = result + DataPacketUtil.paramDPSeperator();
        }
        return result;
    }

    public void parseDataString(String dataStr) throws PacketConversionException {
        Vector mainsplit = CollectionUtil.splitString(dataStr, DataPacketUtil.mainDPSeperator());
        try {
            if (!PacketType.QueryResponse.equals(ObjectUtil.shortFromString((String)mainsplit.elementAt(0)))) {
                throw new PacketConversionException("parsing MessageDataPacket: invalid packet type");
            }
            this.responseType = ObjectUtil.shortFromString((String)mainsplit.elementAt(1));
            this.querySucceded = ObjectUtil.booleanFromString((String)mainsplit.elementAt(2));
            if (mainsplit.size() > 2) {
                Vector pSplit = CollectionUtil.splitString((String)mainsplit.elementAt(3), DataPacketUtil.paramDPSeperator());
                if (Boolean.TRUE.equals(this.querySucceded)) {
                    this.responseParams = DataPacketUtil.parseQueryResponseParams(pSplit, this.responseType);
                } else {
                    this.responseParams = new Vector();
                    this.responseParams.addElement((String)pSplit.elementAt(0));
                }
            }
        }
        catch (Exception e) {
            throw new PacketConversionException("error while parsing QueryResponseDataPacket: " + e.getMessage());
        }
    }

    public Short getPacketType() {
        return PacketType.QueryResponse;
    }

    public String toString() {
        return "QueryResponseDataPacket: responseType=" + QueryType.queryTypeToString(this.responseType) + "; " + "querySucceded=" + this.querySucceded.toString() + "; " + "responseParams=" + CollectionUtil.vectorToString(this.responseParams);
    }
}

