/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Stage {
    public Plataforma[] plataforma = new Plataforma[5];
    public Elements[] elements;
    public Minas minas;
    public int xIni = 60;
    public boolean isFinishScroll = false;
    private boolean isCrash = false;
    private byte timer = 0;
    private byte intensity = 0;
    private byte vibrationX = 0;
    public Sprite spPla;
    private byte timerPla = 0;
    private int[][] type;
    private int[][] cuadros;
    private byte longCuadros = 0;
    private static final int[][] POS_ELEMENTS = new int[][]{{0, 3}, {0, 4}, {1, 2}, {3, 4}, {0, 1}, {2, 3}, {0, 2}, {1, 3}};
    private static final int[] POS_MINAS = new int[]{0, 0, 4, 3, 4, 4, 3, 2};
    private int[] yPosition;

    public Stage() {
        this.plataforma[0] = new Plataforma();
        this.plataforma[1] = new Plataforma();
        this.plataforma[2] = new Plataforma();
        this.plataforma[3] = new Plataforma();
        this.plataforma[4] = new Plataforma();
        this.setCuadros();
        this.elements = new Elements[2];
        Image img = null;
        Image imgCol = null;
        Image imgMinas = null;
        try {
            img = Image.createImage((String)"/iconos.png");
            imgCol = Image.createImage((String)"/columnas.png");
            imgMinas = Image.createImage((String)"/minas.png");
        }
        catch (IOException e) {
            System.out.println("no se cargo la imagen");
        }
        for (int n = 0; n < this.elements.length; ++n) {
            this.elements[n] = new Elements(this.cuadros.length, img);
        }
        this.minas = new Minas(this.cuadros.length, imgMinas);
        this.yPosition = new int[this.plataforma.length];
        this.spPla = new Sprite(imgCol, imgCol.getWidth() / 7, imgCol.getHeight());
        int[] sequence = new int[]{0, 1, 2, 3, 4, 5, 6};
        this.spPla.setFrameSequence(sequence);
        this.spPla.setVisible(true);
        this.load();
    }

    public void init() {
        for (int n = 0; n < this.elements.length; ++n) {
            this.elements[n].resetAll(n);
        }
        this.minas.resetAll(0);
        this.reset();
        this.isFinishScroll = false;
    }

    public void reset() {
        int n;
        this.setCuadros();
        int[] xPosition = new int[this.plataforma.length];
        if (Interface.level != 3) {
            this.yPosition[0] = Interface.SCREEN_H - 65;
            this.yPosition[1] = Interface.SCREEN_H - 110;
            this.yPosition[2] = Interface.SCREEN_H - 100;
            this.yPosition[3] = Interface.SCREEN_H - 135;
            this.yPosition[4] = Interface.SCREEN_H - 150;
            this.yPosition[0] = Interface.SCREEN_H - 45;
            this.yPosition[1] = Interface.SCREEN_H - 55;
            this.yPosition[2] = Interface.SCREEN_H - 100;
            this.yPosition[3] = Interface.SCREEN_H - 140;
            this.yPosition[4] = Interface.SCREEN_H - 160;
            this.yPosition[0] = Interface.SCREEN_H - 45;
            this.yPosition[1] = Interface.SCREEN_H - 55;
            this.yPosition[2] = Interface.SCREEN_H - 100;
            this.yPosition[3] = Interface.SCREEN_H - 150;
            this.yPosition[4] = Interface.SCREEN_H - 200;
            xPosition[0] = 100;
            xPosition[1] = -100;
            xPosition[2] = 60;
            xPosition[3] = 140;
            xPosition[4] = -60;
        } else {
            this.yPosition[0] = Interface.SCREEN_H - 30;
            this.yPosition[1] = Interface.SCREEN_H - 70;
            this.yPosition[2] = Interface.SCREEN_H - 90;
            this.yPosition[3] = Interface.SCREEN_H - 130;
            this.yPosition[4] = Interface.SCREEN_H - 130;
            xPosition[0] = 100;
            xPosition[1] = -60;
            xPosition[2] = 35;
            xPosition[3] = 100;
            xPosition[4] = -40;
        }
        if (Interface.level == 2 || Interface.level == 6) {
            this.yPosition[0] = 180;
            this.yPosition[1] = 170;
            this.yPosition[2] = 120;
            this.yPosition[3] = 60;
            this.yPosition[4] = 50;
            xPosition[0] = 100;
            xPosition[1] = -100;
            xPosition[2] = 60;
            xPosition[3] = 140;
            xPosition[4] = -60;
        }
        for (n = 0; n < this.plataforma.length; ++n) {
            this.plataforma[n].init();
            this.plataforma[n].reset(xPosition[n], this.yPosition[n], this.type[0][n], this.cuadros[0][n], n);
        }
        this.xIni = this.plataforma[0].x;
        for (n = 0; n < this.elements.length; ++n) {
            this.elements[n].reset(this.plataforma[POS_ELEMENTS[Interface.level][n]]);
        }
        this.minas.reset(this.plataforma[POS_MINAS[Interface.level]]);
    }

    public void move(int incX, int incY) {
        if (!this.isFinishScroll) {
            int n;
            if (this.plataforma[1].level >= this.cuadros.length - 1 && this.plataforma[1].x < 0) {
                this.isFinishScroll = true;
            }
            for (n = 0; n < this.plataforma.length; ++n) {
                int auxX;
                this.plataforma[n].move(incX, incY);
                if (incX < 0) {
                    if (this.plataforma[n].x + this.plataforma[n].w >= 0) continue;
                    if (!this.isFinishScroll) {
                        ++this.plataforma[n].level;
                    }
                    auxX = this.plataforma[n].x + 400;
                    this.plataforma[n].reset(auxX, this.yPosition[n], this.type[this.plataforma[n].level][n], this.cuadros[this.plataforma[n].level][n], n);
                    this.resetElements(n);
                    continue;
                }
                if (incX <= 0 || this.plataforma[n].x <= 240) continue;
                if (!this.isFinishScroll) {
                    --this.plataforma[n].level;
                }
                auxX = this.plataforma[n].x - 400;
                this.plataforma[n].reset(auxX, this.yPosition[n], this.type[this.plataforma[n].level][n], this.cuadros[this.plataforma[n].level][n], n);
                this.resetElements(n);
            }
            for (n = 0; n < this.elements.length; ++n) {
                this.elements[n].move(incX, incY);
            }
            this.minas.move(incX, incY);
        }
    }

    public void resetElements(int index) {
        for (int n = 0; n < this.elements.length; ++n) {
            if (POS_ELEMENTS[Interface.level][n] != index) continue;
            this.elements[n].reset(this.plataforma[index]);
        }
        if (POS_MINAS[Interface.level] == index) {
            this.minas.reset(this.plataforma[index]);
        }
    }

    public void resetPlataforma(int index) {
        this.plataforma[index].y = this.yPosition[index];
    }

    public int collision(Sprite sprite) {
        for (int n = 0; n < this.elements.length; ++n) {
            int aux = this.elements[n].collision(sprite, this.plataforma[Stage.POS_ELEMENTS[Interface.level][n]].level);
            if (aux < 0) continue;
            return aux;
        }
        return -1;
    }

    public boolean collisionPlataforma(Sprite sprite) {
        for (int n = 0; n < this.plataforma.length; ++n) {
            if (!this.plataforma[n].collision(sprite)) continue;
            return true;
        }
        return false;
    }

    public void draw(Graphics g) {
        block6: {
            int n;
            for (n = this.plataforma.length - 1; n >= 0; --n) {
                this.plataforma[n].draw(g, this.spPla);
            }
            for (n = 0; n < this.elements.length; ++n) {
                this.elements[n].draw(g, this.plataforma[Stage.POS_ELEMENTS[Interface.level][n]].level);
            }
            this.minas.draw(g, this.plataforma[Stage.POS_MINAS[Interface.level]].level);
            if (!this.isCrash) break block6;
            Random rand = new Random();
            int aux = Math.abs(rand.nextInt() % this.intensity);
            this.vibrationX = (byte)aux;
            this.timer = (byte)(this.timer - 1);
            if (this.timer <= 0) {
                this.isCrash = false;
                this.vibrationX = 0;
                for (int n2 = 0; n2 < this.plataforma.length; ++n2) {
                    if (this.plataforma[n2].frame <= 0) continue;
                    this.plataforma[n2].y = this.yPosition[n2];
                }
            } else {
                for (int n3 = 0; n3 < this.plataforma.length; ++n3) {
                    if (this.plataforma[n3].frame <= 0) continue;
                    this.plataforma[n3].y = this.yPosition[n3] + this.vibrationX;
                }
            }
        }
    }

    protected void downPlataforma(int index) {
        if (this.plataforma[index].frame > 0 && (this.plataforma[index].frame == 4 || this.plataforma[index].frame == 11)) {
            if (this.plataforma[index].frame == 4) {
                if (this.timerPla < 10) {
                    this.timerPla = (byte)(this.timerPla + 1);
                    Random rand = new Random();
                    int aux = Math.abs(rand.nextInt() % 4) - 2;
                    this.plataforma[index].y += aux;
                } else {
                    this.plataforma[index].y += 8;
                }
            } else if (this.plataforma[index].y < this.yPosition[index] + 20) {
                ++this.plataforma[index].y;
            }
        }
    }

    protected void upPlataforma(int index) {
        if (this.plataforma[index].frame > 0 && (this.plataforma[index].frame == 4 || this.plataforma[index].frame == 1)) {
            if (this.plataforma[index].frame == 4) {
                if (this.plataforma[index].y > this.yPosition[index]) {
                    this.plataforma[index].y -= 2;
                }
            } else if (this.plataforma[index].y > this.yPosition[index]) {
                this.plataforma[index].y -= 2;
            }
            this.timerPla = 0;
        }
    }

    private void setCuadros() {
        if (Interface.level == 0) {
            this.type = new int[][]{{4, 4, 4, 4, 4}, {4, 1, 6, 6, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {4, 4, 4, 4, 4}, {4, 1, 1, 4, 4}, {1, 1, 1, 1, 1}, {4, 4, 4, 4, 4}, {1, 1, 1, 1, 1}};
            this.type = new int[][]{{5, 5, 5, 5, 5}, {5, 2, 6, 6, 2}, {2, 2, 2, 2, 2}, {2, 2, 2, 2, 2}, {5, 5, 5, 5, 5}, {5, 2, 2, 5, 5}, {2, 2, 2, 2, 2}, {5, 5, 5, 5, 5}, {2, 2, 2, 2, 2}};
            this.cuadros = new int[][]{{2, 1, 4, 4, 1}, {2, 4, 2, 4, 3}, {4, 3, 1, 1, 2}, {4, 4, 4, 4, 1}, {3, 4, 2, 4, 4}, {4, 1, 2, 4, 4}, {4, 4, 4, 4, 4}, {1, 1, 1, 1, 1}, {0, 10, 3, 1, 2}};
        } else if (Interface.level == 1) {
            this.type = new int[][]{{2, 1, 2, 2, 5}, {2, 2, 2, 5, 2}, {2, 5, 5, 5, 5}, {2, 2, 2, 2, 2}, {2, 5, 2, 5, 2}, {2, 5, 5, 2, 2}};
            this.cuadros = new int[][]{{4, 1, 3, 2, 1}, {4, 4, 1, 4, 2}, {4, 4, 1, 4, 2}, {4, 4, 3, 4, 2}, {4, 4, 3, 4, 2}, {0, 10, 4, 0, 3}};
        } else if (Interface.level == 2) {
            this.type = new int[][]{{3, 3, 3, 3, 3}, {0, 3, 3, 3, 3}, {0, 3, 3, 3, 3}, {0, 3, 3, 3, 3}, {0, 3, 3, 3, 3}, {0, 0, 3, 3, 0}};
            this.cuadros = new int[][]{{2, 1, 2, 4, 1}, {1, 4, 4, 4, 1}, {1, 4, 2, 4, 4}, {1, 4, 4, 4, 1}, {15, 3, 2, 4, 2}, {1, 1, 0, 0, 1}};
        } else if (Interface.level == 3) {
            this.type = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}};
            this.cuadros = new int[][]{{2, 1, 2, 4, 1}, {4, 3, 1, 4, 2}, {3, 3, 2, 2, 1}, {2, 3, 2, 3, 2}, {4, 4, 4, 3, 5}, {2, 5, 0, 3, 0}};
        } else if (Interface.level == 4) {
            this.type = new int[][]{{1, 1, 1, 1, 1}, {1, 1, 4, 4, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}};
            this.cuadros = new int[][]{{3, 1, 3, 4, 1}, {1, 4, 1, 2, 2}, {4, 4, 3, 3, 4}, {3, 3, 1, 3, 1}, {3, 3, 2, 4, 3}, {0, 4, 4, 2, 0}};
        } else if (Interface.level == 5) {
            this.type = new int[][]{{1, 1, 4, 4, 2}, {1, 4, 4, 4, 4}, {4, 4, 4, 4, 4}, {4, 4, 4, 4, 4}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}};
            this.cuadros = new int[][]{{4, 2, 3, 2, 1}, {4, 4, 2, 4, 4}, {4, 2, 3, 4, 3}, {4, 3, 4, 4, 2}, {15, 3, 0, 4, 3}, {1, 1, 0, 0, 2}};
        } else if (Interface.level == 6) {
            this.type = new int[][]{{1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}, {1, 1, 1, 1, 1}};
            this.cuadros = new int[][]{{0, 1, 3, 4, 1}, {4, 4, 4, 4, 1}, {2, 4, 2, 4, 4}, {4, 4, 4, 4, 1}, {15, 4, 2, 4, 4}, {1, 1, 1, 1, 2}};
        } else if (Interface.level == 7) {
            this.type = new int[][]{{2, 2, 2, 2, 2}, {0, 1, 0, 0, 1}, {2, 1, 2, 2, 1}, {2, 1, 2, 2, 1}, {1, 1, 2, 2, 0}, {0, 0, 0, 0, 0}};
            this.cuadros = new int[][]{{4, 1, 3, 2, 1}, {4, 2, 2, 4, 3}, {3, 3, 3, 3, 2}, {3, 2, 3, 2, 2}, {15, 3, 2, 3, 3}, {1, 3, 3, 2, 3}};
        }
        this.longCuadros = (byte)this.cuadros.length;
    }

    public int getNumCuadros() {
        return this.longCuadros;
    }

    public void crash(int intensity, int timer) {
        this.isCrash = true;
        this.intensity = (byte)intensity;
        if (intensity > 4) {
            intensity = 4;
        }
        this.timer = (byte)timer;
    }

    private void load() {
        JarFileReader read = new JarFileReader();
        String datos = read.load();
        int count = 0;
        String value = "";
        String[] property = new String[10];
        if (datos != "") {
            for (int n = 0; n < datos.length(); ++n) {
                if (datos.substring(n, n + 1).compareTo(";") == 0) {
                    property[count] = value;
                    ++count;
                    value = "";
                    continue;
                }
                value = value + datos.substring(n, n + 1);
            }
            Menu.load(property[2], property[3]);
            Interface.name = property[1];
            Interface.titleGame = property[0];
            Interface.colorTitle = this.getColor(property[4]);
            Interface.colorAutor = this.getColor(property[5]);
            Interface.colorMenuOn = this.getColor(property[6]);
            Interface.colorMenuOff = this.getColor(property[7]);
            Interface.colorTextGame = this.getColor(property[8]);
        }
    }

    private int[] getColor(String value) {
        int[] aux = new int[]{0, 0, 0};
        String cad = "";
        int cont = 0;
        for (int n = 0; n < value.length(); ++n) {
            if (value.substring(n, n + 1).compareTo(",") == 0) {
                aux[cont] = Integer.parseInt(cad);
                ++cont;
                cad = "";
                continue;
            }
            cad = cad + value.substring(n, n + 1);
        }
        aux[cont] = Integer.parseInt(cad);
        return aux;
    }
}

