/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class LevelManager {
    private int currentLevel;
    private final Vector levelList;

    public LevelManager(byte[] levels, int startingLevel) {
        String allLevels = new String(levels);
        this.currentLevel = startingLevel;
        this.levelList = new Vector();
        int nextLevel = allLevels.indexOf("\n\n");
        if (nextLevel == -1 && allLevels.trim().length() != 0) {
            nextLevel = allLevels.length();
        }
        while (nextLevel != -1) {
            String currentLevel = allLevels.substring(0, nextLevel).trim();
            this.levelList.addElement(this.getLevel(currentLevel));
            allLevels = allLevels.substring(nextLevel).trim();
            if (allLevels.length() == 0) {
                nextLevel = -1;
                continue;
            }
            nextLevel = allLevels.indexOf("\n\n");
            if (nextLevel != -1) continue;
            nextLevel = allLevels.length();
        }
        if (this.currentLevel >= this.levelList.size()) {
            this.currentLevel = 0;
        }
    }

    private byte[][] getLevel(String data) {
        byte[][] temp = new byte[12][8];
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 8; ++j) {
                temp[i][j] = -1;
            }
        }
        int tempX = 0;
        int tempY = 0;
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) >= '0' && data.charAt(i) <= '7') {
                temp[tempX][tempY] = (byte)(data.charAt(i) - 48);
                ++tempY;
            } else if (data.charAt(i) == '-') {
                temp[tempX][tempY] = -1;
                ++tempY;
            }
            if (tempY != 8) continue;
            if (++tempX == 12) {
                return temp;
            }
            tempY = tempX % 2;
        }
        return temp;
    }

    public byte[][] getCurrentLevel(int level) {
        this.currentLevel = level;
        if (this.currentLevel < this.levelList.size()) {
            return (byte[][])this.levelList.elementAt(this.currentLevel);
        }
        return null;
    }

    public void goToNextLevel() {
        ++this.currentLevel;
        if (this.currentLevel >= this.levelList.size()) {
            this.currentLevel = 0;
        }
    }

    public void goToFirstLevel() {
        this.currentLevel = 0;
    }

    public int getLevelIndex() {
        return this.currentLevel;
    }
}

