/*
 * Decompiled with CFR 0.152.
 */
package sheet;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import sheet.Cell;
import sheet.CellContainer;
import sheet.Sheet;

final class Table
implements CellContainer {
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int DB_VERSION_1 = 1;
    public static final int DB_LAST_VERSION = 1;
    public static final int MD_NORMAL = 0;
    public static final int MD_CELLSIZE = 1;
    private String name;
    private Cell[][] cells;
    private short[] rows;
    private short[] cols;
    private boolean dataChanged;
    private short szX;
    private short szY;
    private byte cursorX;
    private byte cursorY;
    private short tblLeft;
    private short tblTop;
    private short tblRight;
    private short tblBottom;

    public Table(short nofHor, short nofVer, short defWidth, short defHeight) {
        this.cells = new Cell[nofHor][nofVer];
        this.rows = new short[nofVer];
        this.cols = new short[nofHor];
        this.szX = nofHor;
        this.szY = nofVer;
        int i = 0;
        while (i < nofHor) {
            this.cols[i] = defWidth;
            ++i;
        }
        int i2 = 0;
        while (i2 < nofVer) {
            this.rows[i2] = defHeight;
            ++i2;
        }
        this.name = "noname";
    }

    public void moveCursor(int dir) {
        switch (dir) {
            case 3: {
                if (this.cursorX > 0) {
                    this.cursorX = (byte)(this.cursorX - 1);
                    if (this.cursorX >= this.tblLeft) break;
                    this.tblLeft = (short)(this.tblLeft - 1);
                    break;
                }
                Sheet.ported.CannotMoveSignal();
                break;
            }
            case 4: {
                if (this.cursorX < this.szX - 1) {
                    this.cursorX = (byte)(this.cursorX + 1);
                    if (this.cursorX < this.tblRight) break;
                    this.tblLeft = (short)(this.tblLeft + 1);
                    break;
                }
                Sheet.ported.CannotMoveSignal();
                break;
            }
            case 1: {
                if (this.cursorY > 0) {
                    this.cursorY = (byte)(this.cursorY - 1);
                    if (this.cursorY >= this.tblTop) break;
                    this.tblTop = (short)(this.tblTop - 1);
                    break;
                }
                Sheet.ported.CannotMoveSignal();
                break;
            }
            case 2: {
                if (this.cursorY < this.szY - 1) {
                    this.cursorY = (byte)(this.cursorY + 1);
                    if (this.cursorY < this.tblBottom) break;
                    this.tblTop = (short)(this.tblTop + 1);
                    break;
                }
                Sheet.ported.CannotMoveSignal();
            }
        }
    }

    public short getColumnWidth(int col) {
        return this.cols[col];
    }

    public short getRowHeight(int row) {
        return this.rows[row];
    }

    public void setRowHeight(int row, short height) {
        this.rows[row] = height;
        int i = 0;
        while (i < this.szX) {
            Cell cell = this.cells[i][row];
            if (cell != null) {
                cell.render();
            }
            ++i;
        }
        this.notifyChanged();
    }

    public void setColumnWidth(int col, short width) {
        this.cols[col] = width;
        int i = 0;
        while (i < this.szY) {
            Cell cell = this.cells[col][i];
            if (cell != null) {
                cell.render();
            }
            ++i;
        }
        this.notifyChanged();
    }

    public void paint(Graphics g, int width, int height, int mode) {
        Font hdrFont = Font.getFont((int)64, (int)0, (int)8);
        int hdrH = hdrFont.getHeight() + 1;
        int hdrW = hdrFont.stringWidth("10") + 2;
        g.setColor(0);
        g.setFont(hdrFont);
        short i = this.tblLeft;
        int maxX = hdrW;
        while (maxX < width && i < this.szX) {
            short w = this.getColumnWidth(i);
            char rn = (char)(65 + i);
            g.drawString(String.valueOf(rn), maxX + 1 + w / 2, 1, 17);
            maxX += w + 1;
            i = (short)(i + 1);
        }
        this.tblRight = (short)(i - 1);
        g.drawLine(0, hdrH, maxX, hdrH);
        i = this.tblTop;
        int maxY = hdrH;
        while (maxY < height && i < this.szY) {
            short h = this.getRowHeight(i);
            int x = hdrW;
            boolean isCurRow = i == this.cursorY;
            g.drawString(String.valueOf(i + 1), hdrW - 1, maxY + h - hdrH + 2, 24);
            int j = this.tblLeft;
            while (j <= this.tblRight) {
                Cell c = this.cells[j][i];
                short w = this.getColumnWidth(j);
                int cursorColor = 0;
                if (c != null) {
                    cursorColor = c.paint(g, x + 1, maxY + 1);
                }
                if (j == this.cursorX && isCurRow) {
                    g.setColor(cursorColor);
                    g.drawRect(x + 1, maxY + 1, w - 1, h - 1);
                    g.setColor(0);
                }
                if (c != null && !c.isCalculated()) {
                    int xe = x + w;
                    int ye = maxY + h;
                    g.drawLine(x + 1, maxY + 1, xe, ye);
                    g.drawLine(x + 1, ye, xe, maxY + 1);
                }
                x += w + 1;
                ++j;
            }
            maxY += h + 1;
            if (mode == 1 && isCurRow) {
                g.setStrokeStyle(1);
                g.drawLine(0, maxY, maxX, maxY);
                g.setStrokeStyle(0);
            } else {
                g.drawLine(0, maxY, maxX, maxY);
            }
            i = (short)(i + 1);
        }
        this.tblBottom = (short)(i - 1);
        g.drawLine(hdrW, 0, hdrW, maxY);
        int ix = this.tblLeft;
        int cx = hdrW;
        while (ix <= this.tblRight) {
            short w = this.getColumnWidth(ix);
            cx += w + 1;
            if (mode == 1 && ix == this.cursorX) {
                g.setStrokeStyle(1);
                g.drawLine(cx, 0, cx, maxY);
                g.setStrokeStyle(0);
            } else {
                g.drawLine(cx, 0, cx, maxY);
            }
            ++ix;
        }
        if (this.dataChanged) {
            int crossX = hdrW / 2;
            int crossY = hdrH / 2;
            g.drawLine(crossX - 1, crossY - 1, crossX + 1, crossY + 1);
            g.drawLine(crossX + 1, crossY - 1, crossX - 1, crossY + 1);
        }
    }

    public Cell getByName(String name) throws IllegalArgumentException {
        try {
            int col = name.charAt(0) - 65;
            if (col >= this.szX) {
                col = name.charAt(0) - 97;
            }
            int row = Integer.parseInt(name.substring(1, name.length())) - 1;
            return this.cells[col][row];
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Wrong cell name '" + name + "'");
        }
    }

    public void notifyChanged() {
        this.dataChanged = true;
    }

    public boolean isChanged() {
        return this.dataChanged;
    }

    public void calculate() {
        int prevNotCalc = 0;
        int notCalc = -1;
        int ix = 0;
        while (ix < this.szX) {
            int iy = 0;
            while (iy < this.szY) {
                if (this.cells[ix][iy] != null) {
                    this.cells[ix][iy].notCalculated();
                }
                ++iy;
            }
            ++ix;
        }
        while (notCalc != 0 && prevNotCalc != notCalc) {
            prevNotCalc = notCalc;
            notCalc = 0;
            int ix2 = 0;
            while (ix2 < this.szX) {
                int iy = 0;
                while (iy < this.szY) {
                    Cell cell = this.cells[ix2][iy];
                    if (cell != null && !cell.isCalculated() && !cell.calculate()) {
                        ++notCalc;
                    }
                    ++iy;
                }
                ++ix2;
            }
        }
    }

    public Cell getCurrentCell(boolean fCreate) {
        Cell curCell = this.cells[this.cursorX][this.cursorY];
        if (curCell == null && fCreate) {
            this.cells[this.cursorX][this.cursorY] = curCell = new Cell(this, this.cursorX, this.cursorY);
        }
        return curCell;
    }

    public void clearCurrentCell() {
        if (this.cells[this.cursorX][this.cursorY] != null) {
            this.cells[this.cursorX][this.cursorY] = null;
            this.notifyChanged();
        }
    }

    public int getCurrentColumn() {
        return this.cursorX;
    }

    public int getCurrentRow() {
        return this.cursorY;
    }

    public String getName() {
        return this.name;
    }

    public void save(String fname) throws IllegalArgumentException {
        this.name = fname;
        try {
            RecordStore.deleteRecordStore((String)fname);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            RecordStore rs = RecordStore.openRecordStore((String)fname, (boolean)true);
            byte[] header = new byte[(this.szX + 1) * 2 + (this.szY + 1) * 2 + 3];
            header[0] = 1;
            header[1] = (byte)this.szX;
            header[2] = (byte)this.szY;
            int iwr = 3;
            int ic = 0;
            while (ic < this.szX) {
                short w = this.getColumnWidth(ic);
                header[iwr] = (byte)w;
                header[iwr + 1] = (byte)(w >>> 8);
                iwr += 2;
                ++ic;
            }
            int ir = 0;
            while (ir < this.szY) {
                short h = this.getRowHeight(ir);
                header[iwr] = (byte)h;
                header[iwr + 1] = (byte)(h >>> 8);
                iwr += 2;
                ++ir;
            }
            rs.addRecord(header, 0, header.length);
            int ix = 0;
            while (ix < this.szX) {
                int iy = 0;
                while (iy < this.szY) {
                    byte[] data;
                    Cell cell = this.cells[ix][iy];
                    if (cell != null && (data = cell.serialize(1)) != null) {
                        rs.addRecord(data, 0, data.length);
                    }
                    ++iy;
                }
                ++ix;
            }
            rs.closeRecordStore();
            this.dataChanged = false;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("'" + fname + "' can't be saved");
        }
    }

    public static Table load(String fname) throws IllegalArgumentException {
        Table table;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)fname, (boolean)true);
            int nofrecs = rs.getNumRecords();
            byte[] header = rs.getRecord(1);
            byte version = header[0];
            if (version != 1) {
                throw new IllegalArgumentException();
            }
            int szx = header[1];
            int szy = header[2];
            int ird = 3;
            table = new Table((short)szx, (short)szy, 0, 0);
            table.name = fname;
            int ic = 0;
            while (ic < szx) {
                short w = (short)(header[ird] + (header[ird + 1] << 8));
                ird += 2;
                table.setColumnWidth(ic, w);
                ++ic;
            }
            int ir = 0;
            while (ir < szy) {
                short h = (short)(header[ird] + (header[ird + 1] << 8));
                ird += 2;
                table.setRowHeight(ir, h);
                ++ir;
            }
            int i = 2;
            while (i <= nofrecs) {
                byte[] data = rs.getRecord(i);
                Cell cell = Cell.deserialize(data, table, version);
                if (cell != null) {
                    table.cells[cell.getColumn()][cell.getRow()] = cell;
                }
                ++i;
            }
            rs.closeRecordStore();
            table.dataChanged = false;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("'" + fname + "' can't be read");
        }
        return table;
    }
}

