/*
 * Decompiled with CFR 0.152.
 */
package com.george.games.menus;

import com.george.games.Drawable;
import com.george.games.Tasks;
import com.george.headfall.Game;
import com.george.headfall.Main;
import com.george.headfall.Setting;
import com.george.headfall.SoundsPlayer;
import com.george.headfall.Viewport;
import com.george.headfall.res.ResMenu;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class PauseMenu
implements Drawable {
    private Game game;
    private Sprite play;
    private Sprite sound;
    private Sprite mainMenu;
    private Vector vecSprites;
    private Sprite pointer;
    private Setting setting = Setting.getInstance();
    private int selectedIndex;

    public PauseMenu(Game game) {
        this.pointer = new Sprite(Image.createImage((int)5, (int)5));
        this.pointer.setPosition(-5, -5);
        this.vecSprites = new Vector();
        this.game = game;
        this.play = ResMenu.PLAY;
        this.sound = this.setting.isSound() ? ResMenu.soundOff : ResMenu.soundOn;
        this.mainMenu = ResMenu.MAIN_MENU;
        this.sound.setFrame(0);
        this.mainMenu.setFrame(0);
        this.mainMenu.setPosition(27, 126);
        this.sound.setPosition(27, this.mainMenu.getY() + this.mainMenu.getHeight() + 2);
        this.play.setPosition(133, 138);
        this.vecSprites.addElement(this.play);
        this.vecSprites.addElement(this.mainMenu);
        this.vecSprites.addElement(this.sound);
    }

    public void cycle() {
    }

    public void draw(Graphics g) {
        g.drawImage(ResMenu.PAUSE_BACK, Viewport.WIDTH / 2 - ResMenu.PAUSE_BACK.getWidth() / 2, Viewport.HEIGHT / 2 - ResMenu.PAUSE_BACK.getHeight() / 2, 0);
        this.mainMenu.paint(g);
        this.sound.paint(g);
        this.play.paint(g);
        this.drawSelected(g);
    }

    public void pointerPressed(int x, int y) {
        this.pointer.setPosition(x, y);
        Sprite sprite = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            sprite = (Sprite)this.vecSprites.elementAt(j);
            if (this.pointer.collidesWith(sprite, false)) {
                sprite.setFrame(1 % sprite.getFrameSequenceLength());
                continue;
            }
            sprite.setFrame(0);
        }
        this.pointer.setPosition(-5, -5);
    }

    public void pointerReleased(int x, int y) {
        this.pointer.setPosition(x, y);
        if (this.pointer.collidesWith(this.mainMenu, false)) {
            this.game.setEndTask(Tasks.ViewMainMenu());
            this.game.stop();
        } else if (this.pointer.collidesWith(this.sound, false)) {
            int index = this.vecSprites.indexOf(this.sound);
            this.vecSprites.removeElement(this.sound);
            this.setting.changeSound();
            this.setting.save();
            if (this.setting.isSound()) {
                SoundsPlayer.getInstance().restart();
                ResMenu.soundOff.setPosition(this.sound.getX(), this.sound.getY());
                this.sound = ResMenu.soundOff;
            } else {
                SoundsPlayer.getInstance().pause();
                ResMenu.soundOn.setPosition(this.sound.getX(), this.sound.getY());
                this.sound = ResMenu.soundOn;
            }
            this.vecSprites.insertElementAt(this.sound, index);
            this.resetAll();
        } else if (this.pointer.collidesWith(this.play, false)) {
            this.game.continueCurrent();
        }
        this.pointer.setPosition(-5, -5);
        this.resetAll();
    }

    public void pointerDragged(int x, int y) {
        this.pointer.setPosition(x, y);
        Sprite sprite = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            sprite = (Sprite)this.vecSprites.elementAt(j);
            if (this.pointer.collidesWith(sprite, true)) {
                sprite.setFrame(1 % sprite.getFrameSequenceLength());
                continue;
            }
            sprite.setFrame(0);
        }
        this.pointer.setPosition(-5, -5);
    }

    private void resetAll() {
        Sprite sprite = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            sprite = (Sprite)this.vecSprites.elementAt(j);
            sprite.setFrame(0);
        }
    }

    public void keyPressed(int keyCode) {
        int k = Main.container.getGameAction(keyCode);
        if (k == 6) {
            this.selectedIndex = (this.selectedIndex + 1) % this.vecSprites.size();
        } else if (k == 1) {
            --this.selectedIndex;
            if (this.selectedIndex < 0) {
                this.selectedIndex = this.vecSprites.size() - 1;
            }
        } else if (k == 8) {
            Sprite sp = (Sprite)this.vecSprites.elementAt(this.selectedIndex);
            this.pointerReleased(sp.getX(), sp.getY());
        }
        Main.container.repaint();
    }

    public void input(int keyStates) {
    }

    private void drawSelected(Graphics g) {
        if (Main.TOUCH_SUPPORT) {
            return;
        }
        Sprite sp = (Sprite)this.vecSprites.elementAt(this.selectedIndex);
        g.setColor(16253967);
        g.drawRect(sp.getX(), sp.getY(), sp.getWidth() - 2, sp.getHeight() - 2);
        g.drawRect(sp.getX() + 1, sp.getY() + 1, sp.getWidth() - 4, sp.getHeight() - 4);
    }
}

