/*
 * Decompiled with CFR 0.152.
 */
package com.george.games.menus;

import com.george.games.Drawable;
import com.george.games.Tasks;
import com.george.games.menus.ADSScreen;
import com.george.headfall.Game;
import com.george.headfall.Main;
import com.george.headfall.Setting;
import com.george.headfall.SoundsPlayer;
import com.george.headfall.objects.Player;
import com.george.headfall.res.ResMenu;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class SuccessMenu
implements Drawable {
    private Sprite pointer;
    private Sprite sound;
    private Sprite continueGame;
    private Sprite mainMenu;
    private Sprite exit;
    private Vector vecSprites;
    private int menuX = 35;
    private int menuY = 5;
    private Game game;
    private Setting setting = Setting.getInstance();
    private Player player = Player.getInstance();
    private int selectedIndex;

    public SuccessMenu(Game game) {
        this.setting.setLevel(game.getLevelNumber() + 1);
        this.setting.save();
        this.game = game;
        this.pointer = new Sprite(Image.createImage((int)5, (int)5));
        this.pointer.setPosition(-5, -5);
        this.sound = this.setting.isSound() ? ResMenu.soundOff : ResMenu.soundOn;
        this.continueGame = ResMenu.continueGame;
        this.mainMenu = ResMenu.MAIN_MENU;
        this.exit = ResMenu.exit;
        this.sound.setFrame(0);
        this.continueGame.setFrame(0);
        this.mainMenu.setFrame(0);
        this.exit.setFrame(0);
        this.continueGame.setPosition(this.menuX, this.menuY);
        this.sound.setPosition(this.menuX, this.menuY + this.continueGame.getHeight() + 3);
        this.mainMenu.setPosition(this.menuX, this.menuY + 2 * this.continueGame.getHeight() + 6);
        this.exit.setPosition(93, 260);
        this.vecSprites = new Vector();
        this.vecSprites.addElement(this.continueGame);
        this.vecSprites.addElement(this.sound);
        this.vecSprites.addElement(this.mainMenu);
        this.vecSprites.addElement(this.exit);
        if (Player.getInstance().getScore() > this.setting.getTopScore()) {
            this.setting.setTopScore(this.player.getScore());
        }
        this.setting.setPlayerScore(Player.getInstance().getScore());
        this.setting.save();
    }

    public void cycle() {
    }

    public void draw(Graphics g) {
        g.drawImage(ResMenu.MainBack, 0, 0, 0);
        this.continueGame.paint(g);
        this.mainMenu.paint(g);
        this.sound.paint(g);
        this.exit.paint(g);
        this.drawSelected(g);
    }

    public void pointerPressed(int x, int y) {
        this.pointer.setPosition(x, y);
        Sprite sprite = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            sprite = (Sprite)this.vecSprites.elementAt(j);
            if (this.pointer.collidesWith(sprite, false)) {
                sprite.setFrame(1 % sprite.getFrameSequenceLength());
                continue;
            }
            sprite.setFrame(0);
        }
        this.pointer.setPosition(-5, -5);
    }

    public void pointerReleased(int x, int y) {
        this.pointer.setPosition(x, y);
        if (this.pointer.collidesWith(this.continueGame, false)) {
            Tasks t = new Tasks(){

                public void execute() {
                    SuccessMenu.this.game.setEndTask(Tasks.loadLevel(SuccessMenu.this.game.getLevelNumber() + 1));
                    SuccessMenu.this.game.stop();
                }
            };
            ADSScreen screen = ADSScreen.getADSScreen(t);
            if (screen == null) {
                t.execute();
            } else {
                this.game.setDrawable(screen);
            }
        } else if (this.pointer.collidesWith(this.sound, false)) {
            int index = this.vecSprites.indexOf(this.sound);
            this.vecSprites.removeElement(this.sound);
            this.setting.changeSound();
            this.setting.save();
            if (this.setting.isSound()) {
                SoundsPlayer.getInstance().restart();
                ResMenu.soundOff.setPosition(this.sound.getX(), this.sound.getY());
                this.sound = ResMenu.soundOff;
            } else {
                SoundsPlayer.getInstance().pause();
                ResMenu.soundOn.setPosition(this.sound.getX(), this.sound.getY());
                this.sound = ResMenu.soundOn;
            }
            this.vecSprites.insertElementAt(this.sound, index);
            this.resetAll();
        } else if (this.pointer.collidesWith(this.mainMenu, false)) {
            Tasks t = new Tasks(){

                public void execute() {
                    SuccessMenu.this.game.setEndTask(Tasks.ViewMainMenu());
                    SuccessMenu.this.game.stop();
                }
            };
            ADSScreen screen = ADSScreen.getADSScreen(t);
            if (screen == null) {
                t.execute();
            } else {
                this.game.setDrawable(screen);
            }
        } else if (this.pointer.collidesWith(this.exit, false)) {
            Main.exit();
        }
        this.pointer.setPosition(-5, -5);
        this.resetAll();
    }

    public void pointerDragged(int x, int y) {
        this.pointer.setPosition(x, y);
        Sprite sprite = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            sprite = (Sprite)this.vecSprites.elementAt(j);
            if (this.pointer.collidesWith(sprite, false)) {
                sprite.setFrame(1 % sprite.getFrameSequenceLength());
                continue;
            }
            sprite.setFrame(0);
        }
        this.pointer.setPosition(-5, -5);
    }

    private void resetAll() {
        Sprite sprite = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            sprite = (Sprite)this.vecSprites.elementAt(j);
            sprite.setFrame(0);
        }
    }

    public void keyPressed(int keyCode) {
        int k = Main.container.getGameAction(keyCode);
        if (k == 6) {
            this.selectedIndex = (this.selectedIndex + 1) % this.vecSprites.size();
        } else if (k == 1) {
            --this.selectedIndex;
            if (this.selectedIndex < 0) {
                this.selectedIndex = this.vecSprites.size() - 1;
            }
        } else if (k == 8) {
            Sprite sp = (Sprite)this.vecSprites.elementAt(this.selectedIndex);
            this.pointerReleased(sp.getX(), sp.getY());
        }
        Main.container.repaint();
    }

    public void input(int keyStates) {
    }

    private void drawSelected(Graphics g) {
        if (Main.TOUCH_SUPPORT) {
            return;
        }
        Sprite sp = (Sprite)this.vecSprites.elementAt(this.selectedIndex);
        g.setColor(16253967);
        g.drawRect(sp.getX(), sp.getY(), sp.getWidth() - 2, sp.getHeight() - 2);
        g.drawRect(sp.getX() + 1, sp.getY() + 1, sp.getWidth() - 4, sp.getHeight() - 4);
    }
}

