/*
 * Decompiled with CFR 0.152.
 */
package com.george.headfall;

import com.george.headfall.Bar;
import com.george.headfall.Game;
import com.george.headfall.HeadFallRes;
import com.george.headfall.Main;
import com.george.headfall.Viewport;
import com.george.headfall.objects.BackGround;
import com.george.headfall.objects.Clouds;
import com.george.headfall.objects.Controller;
import com.george.headfall.objects.Effect;
import com.george.headfall.objects.Player;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Level
extends Game {
    private Image offline = Image.createImage((int)Viewport.WIDTH, (int)Viewport.HEIGHT);

    public Level(int number) {
        super(number);
        this.create();
        switch (this.levelNumber) {
            case 0: {
                this.controller.OBJECTS_TIME = 15;
                break;
            }
            case 1: {
                this.controller.OBJECTS_TIME = 13;
                break;
            }
            case 2: {
                this.controller.OBJECTS_TIME = 12;
                break;
            }
            case 3: {
                this.controller.OBJECTS_TIME = 10;
                break;
            }
            case 4: {
                this.controller.OBJECTS_TIME = 9;
                break;
            }
            case 5: {
                this.controller.OBJECTS_TIME = 8;
                break;
            }
            case 6: {
                this.controller.OBJECTS_TIME = 7;
                break;
            }
            case 7: {
                this.controller.OBJECTS_TIME = 6;
                break;
            }
            case 8: {
                this.controller.OBJECTS_TIME = 5;
                break;
            }
            default: {
                this.controller.OBJECTS_TIME = 5;
            }
        }
    }

    public void cycle() {
        this.backGround.cycle();
        this.player.cycle();
        this.controller.cycle();
        this.effect.cycle();
        this.bar.cycle();
        this.clouds.cycle();
    }

    public void draw(Graphics gg) {
        Graphics g = this.offline.getGraphics();
        g.drawImage(HeadFallRes.L1BG, 0, 0, 0);
        this.clouds.draw(g);
        if (this.isSuccess() && this.controller.getNumberOfObjects() == 0) {
            g.drawImage(HeadFallRes.RFLAG, Viewport.WIDTH / 2 - HeadFallRes.RFLAG.getWidth() / 2, 63, 0);
        }
        this.controller.drawCactus(g);
        this.backGround.draw(g);
        this.player.paint(g);
        this.controller.draw(g);
        this.effect.draw(g);
        this.bar.draw(g);
        if (this.drawable != null) {
            this.drawable.draw(g);
        }
        g.drawString(Game.debug, -150, 150, 0);
        if (Main.container.getWidth() < Main.container.getHeight()) {
            gg.drawImage(this.offline, 0, 0, 0);
        } else {
            gg.drawImage(Image.createImage((Image)this.offline, (int)0, (int)0, (int)Viewport.WIDTH, (int)Viewport.HEIGHT, (int)6), 0, 0, 0);
        }
    }

    public void clean() {
        this.clouds = null;
        this.controller = null;
        this.backGround = null;
        this.player = null;
        this.effect = null;
        this.bar = null;
    }

    public void create() {
        Player.create(this);
        this.clouds = new Clouds(this);
        this.player = Player.getInstance();
        this.backGround = new BackGround(this);
        this.controller = new Controller(this);
        this.effect = new Effect();
        this.bar = new Bar(this);
    }
}

