/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.math;

import net.phys2d.math.Matrix2f;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;

public strictfp final class MathUtil {
    private MathUtil() {
    }

    public static Vector2f scale(ROVector2f a, float scale) {
        Vector2f temp = new Vector2f(a);
        temp.scale(scale);
        return temp;
    }

    public static Vector2f sub(ROVector2f a, ROVector2f b) {
        Vector2f temp = new Vector2f(a);
        temp.sub(b);
        return temp;
    }

    public static float sign(float x) {
        return x < 0.0f ? -1.0f : 1.0f;
    }

    public static Vector2f mul(Matrix2f A, ROVector2f v) {
        return new Vector2f(A.col1.x * v.getX() + A.col2.x * v.getY(), A.col1.y * v.getX() + A.col2.y * v.getY());
    }

    public static Matrix2f mul(Matrix2f A, Matrix2f B) {
        return new Matrix2f(MathUtil.mul(A, B.col1), MathUtil.mul(A, B.col2));
    }

    public static Matrix2f abs(Matrix2f A) {
        return new Matrix2f(MathUtil.abs(A.col1), MathUtil.abs(A.col2));
    }

    public static Vector2f abs(Vector2f a) {
        return new Vector2f(Math.abs(a.x), Math.abs(a.y));
    }

    public static Matrix2f add(Matrix2f A, Matrix2f B) {
        Vector2f temp1 = new Vector2f(A.col1);
        temp1.add(B.col1);
        Vector2f temp2 = new Vector2f(A.col2);
        temp2.add(B.col2);
        return new Matrix2f(temp1, temp2);
    }

    public static float cross(Vector2f a, Vector2f b) {
        return a.x * b.y - a.y * b.x;
    }

    public static Vector2f cross(float s, Vector2f a) {
        return new Vector2f(-s * a.y, s * a.x);
    }

    public static Vector2f cross(Vector2f a, float s) {
        return new Vector2f(s * a.y, -s * a.x);
    }

    public static float clamp(float a, float low, float high) {
        return Math.max(low, Math.min(a, high));
    }

    public static Vector2f getNormal(ROVector2f x, ROVector2f y) {
        Vector2f normal = new Vector2f(y);
        normal.sub(x);
        normal = new Vector2f(normal.y, -normal.x);
        normal.normalise();
        return normal;
    }

    public static float validateFloat(float value) {
        if (Float.isNaN(value)) {
            return 0.0f;
        }
        return value;
    }
}

