/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.dymix;

import javax.microedition.lcdui.Graphics;

public class ImplicitGrid {
    private int TILE_SIZE_SHIFT = -1;
    private int width;
    private int height;
    private int numChunksPerCell;
    private int maxObjects;
    private static final int CHUNK_SIZE_SHIFT = 6;
    private long[] cols;
    private long[] rows;
    private int[] neighbours;
    private int[] visibles;

    public ImplicitGrid(int pTileSizeShift, int pWorldWidth, int pWorldHeight, int pMaxObjects) {
        this.TILE_SIZE_SHIFT = pTileSizeShift;
        this.width = pWorldWidth >> this.TILE_SIZE_SHIFT;
        this.height = pWorldHeight >> this.TILE_SIZE_SHIFT;
        if (pWorldWidth % (1 << this.TILE_SIZE_SHIFT) != 0) {
            ++this.width;
        }
        if (pWorldHeight % (1 << this.TILE_SIZE_SHIFT) != 0) {
            ++this.height;
        }
        this.numChunksPerCell = pMaxObjects >> 6;
        this.maxObjects = this.numChunksPerCell << 6;
        this.cols = new long[this.width * this.numChunksPerCell];
        this.rows = new long[this.height * this.numChunksPerCell];
        this.neighbours = new int[this.maxObjects + 1];
        this.visibles = new int[this.maxObjects + 1];
    }

    private void resize(int pID) {
        int newChunksPreCell = (pID >> 6) + 1;
        long[] newCols = new long[newChunksPreCell * this.width];
        long[] newRows = new long[newChunksPreCell * this.height];
        int i = 0;
        int ox = 0;
        int nx = 0;
        while (i < this.width) {
            System.arraycopy(this.cols, ox, newCols, nx, this.numChunksPerCell);
            ++i;
            ox += this.numChunksPerCell;
            nx += newChunksPreCell;
        }
        i = 0;
        ox = 0;
        nx = 0;
        while (i < this.height) {
            System.arraycopy(this.rows, ox, newRows, nx, this.numChunksPerCell);
            ++i;
            ox += this.numChunksPerCell;
            nx += newChunksPreCell;
        }
        this.cols = null;
        this.rows = null;
        this.neighbours = null;
        this.visibles = null;
        this.cols = newCols;
        this.rows = newRows;
        this.numChunksPerCell = newChunksPreCell;
        this.maxObjects = this.numChunksPerCell << 6;
        this.neighbours = new int[this.maxObjects + 1];
        this.visibles = new int[this.maxObjects + 1];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTileSizeShift() {
        return this.TILE_SIZE_SHIFT;
    }

    public int[] queryArea(int pMyID, int pNumObjects, int[] pArea) {
        int j;
        int myIDRelative;
        if (pNumObjects == 0 || this.numChunksPerCell == 0) {
            this.neighbours[0] = 0;
            return this.neighbours;
        }
        int minX = pArea[0] >> this.TILE_SIZE_SHIFT;
        int minY = pArea[1] >> this.TILE_SIZE_SHIFT;
        int maxX = pArea[2] >> this.TILE_SIZE_SHIFT;
        int maxY = pArea[3] >> this.TILE_SIZE_SHIFT;
        minX = minX < 0 ? 0 : minX;
        minY = minY < 0 ? 0 : minY;
        maxX = maxX < 0 ? 0 : maxX;
        maxY = maxY < 0 ? 0 : maxY;
        minX = minX >= this.width ? this.width - 1 : minX;
        minY = minY >= this.height ? this.height - 1 : minY;
        maxX = maxX >= this.width ? this.width - 1 : maxX;
        maxY = maxY >= this.height ? this.height - 1 : maxY;
        minX *= this.numChunksPerCell;
        minY *= this.numChunksPerCell;
        maxX *= this.numChunksPerCell;
        maxY *= this.numChunksPerCell;
        int neighboursLen = 0;
        int myIDChunk = pMyID >> 6;
        int n = myIDRelative = pMyID == -1 ? -1 : pMyID - (myIDChunk << 6);
        long myIDRelativeMask = pMyID == -1 ? 0L : (myIDRelative == 63 ? -1L : (1L << myIDRelative + 1) - 1L);
        int n2 = j = pMyID == -1 ? 0 : myIDChunk;
        while (j != this.numChunksPerCell) {
            long chunkCols = 0L;
            long chunk = 0L;
            for (int x = minX; x <= maxX; x += this.numChunksPerCell) {
                chunkCols |= this.cols[x + j];
            }
            for (int y = minY; y <= maxY; y += this.numChunksPerCell) {
                chunk |= this.rows[y + j];
            }
            chunk &= chunkCols;
            while (chunk != 0L) {
                long bitmask = chunk & -chunk;
                if ((bitmask & myIDRelativeMask) == 0L || j != myIDChunk) {
                    int shift = 0;
                    if ((bitmask & 0xFFFFFFFFL << shift) == 0L) {
                        shift += 32;
                    }
                    if ((bitmask & 65535L << shift) == 0L) {
                        shift += 16;
                    }
                    if ((bitmask & 255L << shift) == 0L) {
                        shift += 8;
                    }
                    if ((bitmask & 15L << shift) == 0L) {
                        shift += 4;
                    }
                    if ((bitmask & 3L << shift) == 0L) {
                        shift += 2;
                    }
                    if ((bitmask & 1L << shift) == 0L) {
                        ++shift;
                    }
                    this.neighbours[++neighboursLen] = shift + (j << 6);
                }
                chunk ^= bitmask;
            }
            ++j;
        }
        this.neighbours[0] = neighboursLen;
        return this.neighbours;
    }

    public int[] queryCell(int pMyID, int pNumObjects, int pX, int pY) {
        int j;
        int myIDRelative;
        if (pNumObjects == 0 || this.numChunksPerCell == 0 || pX < 0 || pY < 0 || pX >= this.cols.length || pY >= this.rows.length) {
            this.neighbours[0] = 0;
            return this.neighbours;
        }
        pX *= this.numChunksPerCell;
        pY *= this.numChunksPerCell;
        int neighboursLen = 0;
        int myIDChunk = pMyID >> 6;
        int n = myIDRelative = pMyID == -1 ? -1 : pMyID - (myIDChunk << 6);
        long myIDRelativeMask = pMyID == -1 ? 0L : (myIDRelative == 63 ? -1L : (1L << myIDRelative + 1) - 1L);
        int n2 = j = pMyID == -1 ? 0 : myIDChunk;
        while (j != this.numChunksPerCell) {
            long bitmask;
            for (long chunk = this.cols[pX + j] & this.rows[pY + j]; chunk != 0L; chunk ^= bitmask) {
                bitmask = chunk & -chunk;
                if ((bitmask & myIDRelativeMask) != 0L && j == myIDChunk) continue;
                int shift = 0;
                if ((bitmask & 0xFFFFFFFFL << shift) == 0L) {
                    shift += 32;
                }
                if ((bitmask & 65535L << shift) == 0L) {
                    shift += 16;
                }
                if ((bitmask & 255L << shift) == 0L) {
                    shift += 8;
                }
                if ((bitmask & 15L << shift) == 0L) {
                    shift += 4;
                }
                if ((bitmask & 3L << shift) == 0L) {
                    shift += 2;
                }
                if ((bitmask & 1L << shift) == 0L) {
                    ++shift;
                }
                this.neighbours[++neighboursLen] = shift + (j << 6);
            }
            ++j;
        }
        this.neighbours[0] = neighboursLen;
        return this.neighbours;
    }

    public int[] queryAreas(int pMyID, int pNumObjects, int[][] pArea) {
        int j;
        int myIDRelative;
        if (pNumObjects == 0 || this.numChunksPerCell == 0) {
            this.visibles[0] = 0;
            return this.visibles;
        }
        int numAreas = pArea.length;
        int[] minX = new int[numAreas];
        int[] minY = new int[numAreas];
        int[] maxX = new int[numAreas];
        int[] maxY = new int[numAreas];
        int i = 0;
        while (i < numAreas) {
            if (pArea[i] == null) {
                minX[i] = 0;
                minY[i] = 0;
                maxX[i] = this.width - 1;
                maxY[i] = this.height - 1;
            } else {
                minX[i] = pArea[i][0] >> this.TILE_SIZE_SHIFT;
                minY[i] = pArea[i][1] >> this.TILE_SIZE_SHIFT;
                maxX[i] = pArea[i][2] >> this.TILE_SIZE_SHIFT;
                maxY[i] = pArea[i][3] >> this.TILE_SIZE_SHIFT;
                minX[i] = minX[i] < 0 ? 0 : minX[i];
                minY[i] = minY[i] < 0 ? 0 : minY[i];
                maxX[i] = maxX[i] < 0 ? 0 : maxX[i];
                maxY[i] = maxY[i] < 0 ? 0 : maxY[i];
                minX[i] = minX[i] >= this.width ? this.width - 1 : minX[i];
                minY[i] = minY[i] >= this.height ? this.height - 1 : minY[i];
                maxX[i] = maxX[i] >= this.width ? this.width - 1 : maxX[i];
                maxY[i] = maxY[i] >= this.height ? this.height - 1 : maxY[i];
            }
            int n = i;
            minX[n] = minX[n] * this.numChunksPerCell;
            int n2 = i;
            minY[n2] = minY[n2] * this.numChunksPerCell;
            int n3 = i;
            maxX[n3] = maxX[n3] * this.numChunksPerCell;
            int n4 = i++;
            maxY[n4] = maxY[n4] * this.numChunksPerCell;
        }
        int visiblesLen = 0;
        int myIDChunk = pMyID >> 6;
        int n = myIDRelative = pMyID == -1 ? -1 : pMyID - (myIDChunk << 6);
        long myIDRelativeMask = pMyID == -1 ? 0L : (myIDRelative == 63 ? -1L : (1L << myIDRelative + 1) - 1L);
        int n5 = j = pMyID == -1 ? 0 : myIDChunk;
        while (j != this.numChunksPerCell) {
            long chunk = 0L;
            for (int l = 0; l < numAreas; ++l) {
                long chunkCols = 0L;
                long areaChunk = 0L;
                for (int x = minX[l]; x <= maxX[l]; x += this.numChunksPerCell) {
                    chunkCols |= this.cols[x + j];
                }
                for (int y = minY[l]; y <= maxY[l]; y += this.numChunksPerCell) {
                    areaChunk |= this.rows[y + j];
                }
                chunk |= areaChunk & chunkCols;
            }
            while (chunk != 0L) {
                long bitmask = chunk & -chunk;
                if ((bitmask & myIDRelativeMask) == 0L || j != myIDChunk) {
                    int shift = 0;
                    if ((bitmask & 0xFFFFFFFFL << shift) == 0L) {
                        shift += 32;
                    }
                    if ((bitmask & 65535L << shift) == 0L) {
                        shift += 16;
                    }
                    if ((bitmask & 255L << shift) == 0L) {
                        shift += 8;
                    }
                    if ((bitmask & 15L << shift) == 0L) {
                        shift += 4;
                    }
                    if ((bitmask & 3L << shift) == 0L) {
                        shift += 2;
                    }
                    if ((bitmask & 1L << shift) == 0L) {
                        ++shift;
                    }
                    this.visibles[++visiblesLen] = shift + (j << 6);
                }
                chunk ^= bitmask;
            }
            ++j;
        }
        this.visibles[0] = visiblesLen;
        return this.visibles;
    }

    public void clear() {
        int i;
        for (i = 0; i < this.cols.length; ++i) {
            this.cols[i] = 0L;
        }
        for (i = 0; i < this.rows.length; ++i) {
            this.rows[i] = 0L;
        }
    }

    public void updateObject(int pID, int minX1, int minY1, int maxX1, int maxY1, int minX2, int minY2, int maxX2, int maxY2) {
        if ((minX1 >>= this.TILE_SIZE_SHIFT) != (minX2 >>= this.TILE_SIZE_SHIFT) || (minY1 >>= this.TILE_SIZE_SHIFT) != (minY2 >>= this.TILE_SIZE_SHIFT) || (maxX1 >>= this.TILE_SIZE_SHIFT) != (maxX2 >>= this.TILE_SIZE_SHIFT) || (maxY1 >>= this.TILE_SIZE_SHIFT) != (maxY2 >>= this.TILE_SIZE_SHIFT)) {
            this.unsetObject(pID, minX1, minY1, maxX1, maxY1);
            this.setObject(pID, minX2, minY2, maxX2, maxY2);
        } else if (pID >= this.maxObjects) {
            this.resize(pID);
        }
    }

    public void updateObject(int pID, int[] pOldAABB, int[] pAABB) {
        int minX1 = pOldAABB[0] >> this.TILE_SIZE_SHIFT;
        int minY1 = pOldAABB[1] >> this.TILE_SIZE_SHIFT;
        int maxX1 = pOldAABB[2] >> this.TILE_SIZE_SHIFT;
        int maxY1 = pOldAABB[3] >> this.TILE_SIZE_SHIFT;
        int minX2 = pAABB[0] >> this.TILE_SIZE_SHIFT;
        int minY2 = pAABB[1] >> this.TILE_SIZE_SHIFT;
        int maxX2 = pAABB[2] >> this.TILE_SIZE_SHIFT;
        int maxY2 = pAABB[3] >> this.TILE_SIZE_SHIFT;
        if (minX1 != minX2 || minY1 != minY2 || maxX1 != maxX2 || maxY1 != maxY2) {
            this.unsetObject(pID, minX1, minY1, maxX1, maxY1);
            this.setObject(pID, minX2, minY2, maxX2, maxY2);
        } else if (pID >= this.maxObjects) {
            this.resize(pID);
        }
    }

    public void setObject(int pID, int[] pAABB) {
        this.setObject(pID, pAABB[0] >> this.TILE_SIZE_SHIFT, pAABB[1] >> this.TILE_SIZE_SHIFT, pAABB[2] >> this.TILE_SIZE_SHIFT, pAABB[3] >> this.TILE_SIZE_SHIFT);
    }

    public void unsetObject(int pID, int[] pAABB) {
        this.unsetObject(pID, pAABB[0] >> this.TILE_SIZE_SHIFT, pAABB[1] >> this.TILE_SIZE_SHIFT, pAABB[2] >> this.TILE_SIZE_SHIFT, pAABB[3] >> this.TILE_SIZE_SHIFT);
    }

    private void setObject(int pID, int pMinTileX, int pMinTileY, int pMaxTileX, int pMaxTileY) {
        if (pID >= this.maxObjects) {
            this.resize(pID);
        }
        pMinTileX = pMinTileX < 0 ? 0 : pMinTileX;
        pMinTileY = pMinTileY < 0 ? 0 : pMinTileY;
        pMaxTileX = pMaxTileX < 0 ? 0 : pMaxTileX;
        pMaxTileY = pMaxTileY < 0 ? 0 : pMaxTileY;
        pMinTileX = pMinTileX >= this.width ? this.width - 1 : pMinTileX;
        pMinTileY = pMinTileY >= this.height ? this.height - 1 : pMinTileY;
        pMaxTileX = pMaxTileX >= this.width ? this.width - 1 : pMaxTileX;
        pMaxTileY = pMaxTileY >= this.height ? this.height - 1 : pMaxTileY;
        int px = pMinTileX * this.numChunksPerCell;
        int py = pMinTileY * this.numChunksPerCell;
        int chunk = pID >> 6;
        long mask = 1L << (pID -= chunk << 6);
        while (pMinTileX <= pMaxTileX) {
            int n = px + chunk;
            this.cols[n] = this.cols[n] | mask;
            ++pMinTileX;
            px += this.numChunksPerCell;
        }
        while (pMinTileY <= pMaxTileY) {
            int n = py + chunk;
            this.rows[n] = this.rows[n] | mask;
            ++pMinTileY;
            py += this.numChunksPerCell;
        }
    }

    private void unsetObject(int pID, int pMinTileX, int pMinTileY, int pMaxTileX, int pMaxTileY) {
        if (pID >= this.maxObjects) {
            this.resize(pID);
        }
        pMinTileX = pMinTileX < 0 ? 0 : pMinTileX;
        pMinTileY = pMinTileY < 0 ? 0 : pMinTileY;
        pMaxTileX = pMaxTileX < 0 ? 0 : pMaxTileX;
        pMaxTileY = pMaxTileY < 0 ? 0 : pMaxTileY;
        pMinTileX = pMinTileX >= this.width ? this.width - 1 : pMinTileX;
        pMinTileY = pMinTileY >= this.height ? this.height - 1 : pMinTileY;
        pMaxTileX = pMaxTileX >= this.width ? this.width - 1 : pMaxTileX;
        pMaxTileY = pMaxTileY >= this.height ? this.height - 1 : pMaxTileY;
        int px = pMinTileX * this.numChunksPerCell;
        int py = pMinTileY * this.numChunksPerCell;
        int chunk = pID >> 6;
        long mask = 1L << (pID -= chunk << 6) ^ 0xFFFFFFFFFFFFFFFFL;
        while (pMinTileX <= pMaxTileX) {
            int n = px + chunk;
            this.cols[n] = this.cols[n] & mask;
            ++pMinTileX;
            px += this.numChunksPerCell;
        }
        while (pMinTileY <= pMaxTileY) {
            int n = py + chunk;
            this.rows[n] = this.rows[n] & mask;
            ++pMinTileY;
            py += this.numChunksPerCell;
        }
    }

    public void d_draw(Graphics pGraph, int[] camAABB) {
        int minX = Integer.MIN_VALUE;
        int minY = Integer.MIN_VALUE;
        int maxX = Integer.MAX_VALUE;
        int maxY = Integer.MAX_VALUE;
        if (camAABB != null) {
            minX = camAABB[0] >> this.TILE_SIZE_SHIFT;
            minY = camAABB[1] >> this.TILE_SIZE_SHIFT;
            maxX = camAABB[2] >> this.TILE_SIZE_SHIFT;
            maxY = camAABB[3] >> this.TILE_SIZE_SHIFT;
        }
        minX = minX < 0 ? 0 : minX;
        minY = minY < 0 ? 0 : minY;
        maxX = maxX < 0 ? 0 : maxX;
        maxY = maxY < 0 ? 0 : maxY;
        minX = minX >= this.width ? this.width - 1 : minX;
        minY = minY >= this.height ? this.height - 1 : minY;
        maxX = maxX >= this.width ? this.width - 1 : maxX;
        maxY = maxY >= this.height ? this.height - 1 : maxY;
        int oMinX = minX;
        int oMinY = minY;
        minY *= this.numChunksPerCell;
        maxX *= this.numChunksPerCell;
        maxY *= this.numChunksPerCell;
        int x = minX *= this.numChunksPerCell;
        int ox = oMinX;
        while (x <= maxX) {
            int y = minY;
            int oy = oMinY;
            while (y <= maxY) {
                boolean found = false;
                for (int j = 0; j < this.numChunksPerCell; ++j) {
                    if ((this.cols[x + j] & this.rows[y + j]) == 0L) continue;
                    found = true;
                    break;
                }
                if (found) {
                    pGraph.fillRect(ox << this.TILE_SIZE_SHIFT - 10, oy << this.TILE_SIZE_SHIFT - 10, 1 << this.TILE_SIZE_SHIFT - 10, 1 << this.TILE_SIZE_SHIFT - 10);
                }
                y += this.numChunksPerCell;
                ++oy;
            }
            x += this.numChunksPerCell;
            ++ox;
        }
    }
}

