/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.text;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.text.EFont;
import com.jarbull.efw.text.TextWriter;
import javax.microedition.lcdui.Graphics;

class HexWriter {
    private static final HexWriter INSTANCE = new HexWriter();

    HexWriter() {
    }

    public static HexWriter getInstance() {
        return INSTANCE;
    }

    void drawText(Graphics g, String text, int x, int y, int anchor, EFont font) {
        String[] textArray = this.textToStringArray(text);
        int targetPoint = 0;
        for (int i = 0; i < textArray.length; ++i) {
            int[] arr = (int[])font.getMappingHash().get(textArray[i]);
            if (arr == null) {
                arr = (int[])font.getMappingHash().get("?");
            }
            int xToDraw = x;
            int yToDraw = y;
            switch (TextWriter.getInstance().getOrientation()) {
                case 0: {
                    xToDraw += targetPoint;
                    targetPoint += arr[2];
                    break;
                }
                case 5: {
                    yToDraw += targetPoint;
                    targetPoint += arr[2];
                    break;
                }
                case 3: {
                    xToDraw += TextWriter.getInstance().getTextWidth(text) - (targetPoint += arr[2]);
                    break;
                }
                case 6: {
                    yToDraw += TextWriter.getInstance().getTextHeight(text) - (targetPoint += arr[2]);
                }
            }
            if (ImageHandler.getInstance().getImage(font.getFontImagePath()) == null) {
                ImageHandler.getInstance().load(font.getFontImagePath());
            }
            g.drawRegion(ImageHandler.getInstance().getImage(font.getFontImagePath()), arr[0], arr[1], arr[2], arr[3], TextWriter.getInstance().getOrientation(), xToDraw, yToDraw, anchor);
        }
    }

    private String[] textToStringArray(String text) {
        String[] textArray = new String[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            textArray[i] = text.substring(i, i + 1);
        }
        return textArray;
    }

    private int getTextSize(String text, EFont font, boolean isWidth) {
        String[] textArray = this.textToStringArray(text);
        int returnValue = 0;
        block4: for (int i = 0; i < textArray.length; ++i) {
            int[] arr = (int[])font.getMappingHash().get(textArray[i]);
            if (arr == null) {
                arr = (int[])font.getMappingHash().get("?");
            }
            switch (TextWriter.getInstance().getOrientation()) {
                case 0: 
                case 3: {
                    if (isWidth) {
                        returnValue += arr[2];
                        continue block4;
                    }
                    if (arr[3] <= returnValue) continue block4;
                    returnValue = arr[3];
                    continue block4;
                }
                case 5: 
                case 6: {
                    if (isWidth) {
                        if (arr[3] <= returnValue) continue block4;
                        returnValue = arr[3];
                        continue block4;
                    }
                    returnValue += arr[2];
                }
            }
        }
        return returnValue;
    }

    int getTextWidth(String text, EFont font) {
        return this.getTextSize(text, font, true);
    }

    int getTextHeight(String text, EFont font) {
        return this.getTextSize(text, font, false);
    }
}

