/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.platform.domain;

import com.hardwire.dymix.CollisionProxy;
import com.hardwire.dymix.DynamicWorld;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.dymix.PhysicsException;
import com.hardwire.dymix.StaticObject;
import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Vector2;
import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.platform.domain.PhysicObject;
import com.jarbull.platform.domain.Player;
import com.jarbull.platform.domain.PlayersManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Smoke
extends StaticObject
implements PhysicObject {
    private Image[] fireImage;
    private boolean isActive;
    private boolean enabled;
    private int height;
    private int uniqueId;
    private int frame;
    private int tickCounter;
    private boolean despawn;

    public Smoke(DynamicWorld world, int x, int y, int id) {
        try {
            int width = 9;
            this.height = 13;
            this.isActive = true;
            this.despawn = false;
            this.enabled = false;
            this.uniqueId = id;
            this.frame = 0;
            this.tickCounter = 0;
            this.fireImage = new Image[7];
            for (int i = 0; i < this.fireImage.length; ++i) {
                this.fireImage[i] = i <= 4 ? ImageHandler.getInstance().getImage("/res/game/images/objects/difficulty" + (i + 18) + ".png") : ImageHandler.getInstance().getImage("/res/game/images/objects/difficulty" + (i + 39) + ".png");
            }
            Vector2[] baseData = MathUtils.createBlock(width, this.height);
            this.initBody(world, new CollisionProxy(baseData, false), 512, 0);
            this.spawnBody(new Vector2(x + width / 2, y + this.height / 2).shiftLeft(), 0);
        }
        catch (PhysicsException ex) {
            ex.printStackTrace();
        }
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void draw(Graphics pGraph) {
        pGraph.drawImage(this.fireImage[this.frame], this.getPosition_shiftedRight().x - 4, this.getPosition_shiftedRight().y - 6, 0);
    }

    protected void notifyAfterCollisionResponse(PhysicalObject pOther, int[][] pCollPoints1, int[][] pCollPoints2, int pNumPoints, int pNormal_x, int pNormal_y, int pMTD) {
        for (int j = 0; j < PlayersManager.getInstance().playersObjList.size(); ++j) {
            if (!pOther.equals(PlayersManager.getInstance().playersObjList.elementAt(j))) continue;
            if (pCollPoints1 == null) {
                return;
            }
            for (int i = 0; i < pCollPoints1.length; ++i) {
                if (pCollPoints1[i] == null || MathUtils.shiftRight(pCollPoints1[i][1] - this.getPosition().y) == this.height / 2) continue;
                ((Player)PlayersManager.getInstance().playersObjList.elementAt((int)j)).alive = false;
                return;
            }
        }
    }

    public void tick() {
        if (this.enabled) {
            if (this.tickCounter % 2 == 0) {
                if (this.frame >= 5 && this.frame < 6) {
                    ++this.frame;
                } else if (this.frame < 5) {
                    this.frame = 5;
                } else if (this.frame >= 6) {
                    this.despawn = true;
                }
            }
        } else if (this.tickCounter % 3 == 0) {
            if (this.frame >= 0 && this.frame < 4) {
                ++this.frame;
            } else if (this.frame < 0 || this.frame >= 4) {
                this.frame = 0;
            }
        }
        ++this.tickCounter;
    }

    public boolean isDespawn() {
        return this.despawn;
    }
}

