/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import mynotes.FileDescriptor;
import mynotes.MyDisplayable;
import mynotes.MyNotes;
import mynotes.Note;
import mynotes.ResourceBundle;
import mynotes.TextViewer;
import mynotes.Utils;

public class FileProperties
implements MyDisplayable {
    RecordStore rs = null;
    String info = "";

    public void prepare(FileDescriptor f) {
        if (f == null) {
            return;
        }
        this.info = ResourceBundle.getString("fp-name") + ": " + f.name + "\n";
        String type = "";
        type = f.isDirectory ? ResourceBundle.getString("fp-dir") : ((f.type & 0x100) == 0 ? ResourceBundle.getString("fp-file") : ResourceBundle.getString("fp-checklist"));
        this.info = this.info + ResourceBundle.getString("fp-type") + ": " + type + "\n";
        this.info = this.info + ResourceBundle.getString("fp-crdate") + ": " + Utils.dateAsString(f.date) + "\n";
        if (f.isDirectory) {
            try {
                this.rs = RecordStore.openRecordStore((String)("dir" + f.id), (boolean)false);
                if (this.rs != null) {
                    this.info = this.info + ResourceBundle.getString("fp-size") + ": " + this.rs.getSize() + "\n";
                    this.info = this.info + ResourceBundle.getString("fp-avail") + ": " + this.rs.getSizeAvailable() + "\n";
                    this.info = this.info + ResourceBundle.getString("fp-numrecords") + ": " + this.rs.getNumRecords() + "\n";
                    this.info = this.info + ResourceBundle.getString("fp-modifdate") + ": " + Utils.dateAsString(this.rs.getLastModified()) + "\n";
                    this.info = this.info + ResourceBundle.getString("fp-version") + ": " + this.rs.getVersion() + "\n";
                    this.rs.closeRecordStore();
                }
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        } else {
            this.info = this.info + ResourceBundle.getString("fp-size") + ": " + f.size + "\n";
            this.info = this.info + ResourceBundle.getString("fp-fsrecno") + ": " + f.dirRecordId + "\n";
        }
        this.info = this.info + ResourceBundle.getString("fp-dsrecno") + ": " + f.recordId + "\n";
        this.info = this.info + ResourceBundle.getString("fp-id") + ": " + f.id + "\n";
        this.info = this.info + ResourceBundle.getString("fp-parent") + ": " + f.parentDirId + "\n";
        if ((f.type & 0x100) != 0) {
            Note note = MyNotes.fs.getNote(f.id);
            int nlPosition = 0;
            int prevNlPosition = -1;
            int linesCount = 0;
            int checkedCount = 0;
            String text = "";
            while ((nlPosition = note.text.indexOf(10, prevNlPosition + 1)) != -1) {
                text = note.text.substring(prevNlPosition + 1, nlPosition);
                ++linesCount;
                if (text.substring(0, 1).equals("@")) {
                    ++checkedCount;
                }
                prevNlPosition = nlPosition;
            }
            this.info = linesCount == 0 ? this.info + ResourceBundle.getString("fp-checked") + ": 0" : this.info + ResourceBundle.getString("fp-checked") + ": " + checkedCount + "/" + linesCount + " (" + checkedCount * 100 / linesCount + "%)";
        }
    }

    public void activate() {
        TextViewer viewer = new TextViewer();
        viewer.start(ResourceBundle.getString("fp-title"), this.info, MyNotes.notesBrowser, null);
    }
}

