/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

class Property {
    public static final int PT_NOTHING = -1;
    public static final int PT_BYTE = 1;
    public static final int PT_SHORT = 2;
    public static final int PT_INT = 3;
    public static final int PT_LONG = 4;
    public static final int PT_CHAR = 5;
    public static final int PT_FLOAT = 6;
    public static final int PT_DOUBLE = 7;
    public static final int PT_BOOLEAN = 8;
    public static final int PT_STRING = 9;
    String key = null;
    Object value = null;
    int type = -1;
    protected int rsId;

    public boolean fromByteArray(byte[] data) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data, 0, data.length);
            DataInputStream dis = new DataInputStream(bais);
            this.type = dis.readInt();
            this.key = dis.readUTF();
            switch (this.type) {
                case 1: {
                    this.value = new Byte(dis.readByte());
                    break;
                }
                case 2: {
                    this.value = new Short(dis.readShort());
                    break;
                }
                case 3: {
                    this.value = new Integer(dis.readInt());
                    break;
                }
                case 4: {
                    this.value = new Long(dis.readLong());
                    break;
                }
                case 5: {
                    this.value = new Character(dis.readChar());
                    break;
                }
                case 6: {
                    this.value = new Float(dis.readFloat());
                    break;
                }
                case 7: {
                    this.value = new Double(dis.readDouble());
                    break;
                }
                case 8: {
                    this.value = new Boolean(dis.readBoolean());
                    break;
                }
                case 9: {
                    this.value = new String(dis.readUTF());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public byte[] toByteArray() {
        byte[] data = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream das = new DataOutputStream(baos);
            das.writeInt(this.type);
            das.writeUTF(this.key);
            switch (this.type) {
                case 1: {
                    das.writeByte((Integer)this.value);
                    break;
                }
                case 2: {
                    das.writeShort((Integer)this.value);
                    break;
                }
                case 3: {
                    das.writeInt((Integer)this.value);
                    break;
                }
                case 4: {
                    das.writeLong(((Integer)this.value).intValue());
                    break;
                }
                case 5: {
                    das.writeChar((Integer)this.value);
                    break;
                }
                case 6: {
                    das.writeFloat(((Float)this.value).floatValue());
                    break;
                }
                case 7: {
                    das.writeDouble((Double)this.value);
                    break;
                }
                case 8: {
                    das.writeBoolean((Boolean)this.value);
                    break;
                }
                case 9: {
                    das.writeUTF((String)this.value);
                }
            }
            data = baos.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return data;
    }
}

