/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import mynotes.Commands;
import mynotes.MyDisplayable;
import mynotes.MyNotes;
import mynotes.ResourceBundle;
import mynotes.TextViewer;
import mynotes.Utils;

public class TextEditor
implements CommandListener {
    public static final int BACK = 0;
    public static final int OK = 1;
    public static final int TYPE_TEXTFIELD = 1;
    public static final int TYPE_TEXTBOX = 2;
    private Form tfForm = new Form("MyNotes");
    private TextField tf = new TextField("", "", 100, 0x200000);
    private TextBox tb;
    private static Command okCommand = new Command(ResourceBundle.getString("cmd-ok"), 4, 1);
    private static Command newLineCommand = new Command(ResourceBundle.getString("cmd-newline"), 1, 1);
    private static Command saveCommand = new Command(ResourceBundle.getString("cmd-save"), 1, 2);
    private static Command insertDateCommand = new Command(ResourceBundle.getString("cmd-insdate"), 1, 3);
    private int status;
    private String text;
    private String saveText;
    private int type;
    private MyDisplayable back;
    private TextViewer viewer = null;
    private Alert saveModified;

    public String getText() {
        return this.text;
    }

    public int getStatus() {
        int saveStatus = this.status;
        this.status = 0;
        return saveStatus;
    }

    public TextEditor() {
        this.tfForm.append((Item)this.tf);
        this.tfForm.addCommand(Commands.BACK);
        this.tfForm.addCommand(okCommand);
        this.tfForm.addCommand(insertDateCommand);
        this.tfForm.setCommandListener((CommandListener)this);
        this.tb = new TextBox("MyNotes", "", 5000, 0x200000);
        this.tb.addCommand(newLineCommand);
        this.tb.addCommand(saveCommand);
        this.tb.addCommand(Commands.BACK);
        this.tb.addCommand(insertDateCommand);
        this.tb.setCommandListener((CommandListener)this);
        this.status = 0;
        this.saveModified = new Alert("MyNotes", ResourceBundle.getString("nb-saveconfirm"), null, AlertType.CONFIRMATION);
        this.saveModified.addCommand(Commands.YES);
        this.saveModified.addCommand(Commands.NO);
        this.saveModified.addCommand(Commands.CANCEL);
        this.saveModified.setCommandListener((CommandListener)this);
        this.saveModified.setTimeout(-2);
    }

    public void start(int type, String header, String init, MyDisplayable back, TextViewer viewer) {
        this.back = back;
        this.type = type;
        this.viewer = viewer;
        switch (type) {
            case 1: {
                this.tf.setString(init);
                this.tf.setLabel(header);
                MyNotes.display.setCurrent((Displayable)this.tfForm);
                break;
            }
            case 2: {
                this.tb.setString(init);
                this.tb.setTitle(header);
                this.saveText = init;
                MyNotes.display.setCurrent((Displayable)this.tb);
            }
        }
    }

    public static String removeChar(String s, char c) {
        String r = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            r = r + s.charAt(i);
        }
        return r;
    }

    public void commandAction(Command c, Displayable d) {
        if (d == this.saveModified) {
            if (c == Commands.CANCEL) {
                MyNotes.display.setCurrent((Displayable)this.tb);
            }
            if (c == Commands.YES) {
                this.commandAction(saveCommand, (Displayable)this.tb);
            }
            if (c == Commands.NO) {
                this.back.activate();
            }
            return;
        }
        if (c == Commands.BACK) {
            this.status = 0;
            if (d == this.tb) {
                if (!this.tb.getString().equals(this.saveText)) {
                    MyNotes.display.setCurrent((Displayable)this.saveModified);
                } else {
                    this.viewer.start(this.tb.getTitle(), this.saveText, this.back, this);
                }
            } else {
                this.back.activate();
            }
        }
        if (c == newLineCommand) {
            String nl = "\n";
            this.tb.insert(nl, this.tb.getCaretPosition());
        }
        if (c == okCommand) {
            this.status = 1;
            this.text = TextEditor.removeChar(this.tf.getString(), '\n');
            this.back.activate();
        }
        if (c == saveCommand && d == this.tb) {
            this.status = 1;
            this.text = this.tb.getString();
            this.viewer.start(this.tb.getTitle(), this.tb.getString(), this.back, this);
        }
        if (c == insertDateCommand) {
            long dt = System.currentTimeMillis();
            String date = Utils.dateAsString(dt);
            if (this.type == 1) {
                this.tf.insert(date, this.tf.getCaretPosition());
            } else if (this.type == 2) {
                this.tb.insert(date, this.tb.getCaretPosition());
            }
        }
    }
}

