/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import mynotes.Utils;

public class FileDescriptor {
    static final int T_NORMAL = 1;
    static final int T_ENCRYPTED = 16;
    static final int T_CHECKLIST = 256;
    static final int T_BROKEN = 1;
    static final int T_DELETED = 1;
    int id;
    int parentDirId;
    int dirRecordId;
    int type;
    int size;
    long date;
    boolean isDirectory;
    String name;
    int recordId;

    byte[] toByteArray() {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.id);
            dataOutputStream.writeInt(this.parentDirId);
            dataOutputStream.writeInt(this.dirRecordId);
            dataOutputStream.writeInt(this.type);
            dataOutputStream.writeInt(this.size);
            dataOutputStream.writeLong(this.date);
            dataOutputStream.writeBoolean(this.isDirectory);
            dataOutputStream.writeUTF(this.name);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Utils.encrypt(byArray);
        return byArray;
    }

    public boolean fromByteArray(byte[] byArray) {
        Utils.encrypt(byArray);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, byArray.length);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.id = dataInputStream.readInt();
            this.parentDirId = dataInputStream.readInt();
            this.dirRecordId = dataInputStream.readInt();
            this.type = dataInputStream.readInt();
            this.size = dataInputStream.readInt();
            this.date = dataInputStream.readLong();
            this.isDirectory = dataInputStream.readBoolean();
            this.name = dataInputStream.readUTF();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public int compareTo(Object object) {
        FileDescriptor fileDescriptor = (FileDescriptor)object;
        return this.name.compareTo(fileDescriptor.name);
    }

    public FileDescriptor clone() {
        FileDescriptor fileDescriptor = new FileDescriptor();
        fileDescriptor.id = this.id;
        fileDescriptor.parentDirId = this.parentDirId;
        fileDescriptor.dirRecordId = this.dirRecordId;
        fileDescriptor.type = this.type;
        fileDescriptor.size = this.size;
        fileDescriptor.date = this.date;
        fileDescriptor.isDirectory = this.isDirectory;
        fileDescriptor.name = this.name;
        fileDescriptor.recordId = this.recordId;
        return fileDescriptor;
    }
}

