/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import mynotes.Commands;
import mynotes.FileDescriptor;
import mynotes.MyDisplayable;
import mynotes.MyList;
import mynotes.MyNotes;
import mynotes.Note;
import mynotes.ResourceBundle;
import mynotes.TextEditor;
import mynotes.Utils;

public class CheckListEditor
implements CommandListener,
MyDisplayable {
    FileDescriptor startFd;
    private static MyList list;
    public Vector itemCheckedStatuses;
    public Vector itemNames;
    public MyDisplayable back;
    public static Image checkedIcon;
    public static Image uncheckedIcon;
    private TextEditor textEditor;
    int cursor;
    int savePos;
    private final int ACTION_NOTHING;
    private final int ACTION_NEW_ITEM;
    private final int ACTION_RENAME;
    private final int ACTION_DELETE;
    int lastAction;
    private Alert saveModified;
    String initialText;

    public CheckListEditor() {
        this.ACTION_NOTHING = 0;
        this.ACTION_NEW_ITEM = 1;
        this.ACTION_RENAME = 2;
        this.ACTION_DELETE = 3;
        try {
            checkedIcon = Image.createImage((String)"/res/checked.png");
            uncheckedIcon = Image.createImage((String)"/res/unchecked.png");
        }
        catch (Exception exception) {
            checkedIcon = null;
            uncheckedIcon = null;
            exception.printStackTrace();
        }
        list = new MyList("");
        this.itemCheckedStatuses = new Vector();
        this.itemNames = new Vector();
        list.deleteCommands();
        list.addCommand(Commands.SELECT, 8);
        list.addCommand(Commands.BACK, 5);
        list.addCommand(Commands.NEWITEM, 2);
        list.addCommand(Commands.SAVE, 2);
        list.addCommand(Commands.RENAME, 2);
        list.addCommand(Commands.MOVEUP, 2);
        list.addCommand(Commands.MOVEDOWN, 2);
        list.addCommand(Commands.DELETE, 2);
        list.setCommandListener(this);
        this.textEditor = new TextEditor();
        this.saveModified = new Alert("MyNotes", ResourceBundle.getString("nb-saveconfirm"), null, AlertType.CONFIRMATION);
        this.saveModified.addCommand(Commands.YES);
        this.saveModified.addCommand(Commands.NO);
        this.saveModified.addCommand(Commands.CANCEL);
        this.saveModified.setCommandListener((CommandListener)this);
        this.saveModified.setTimeout(-2);
    }

    public void load(FileDescriptor fileDescriptor) {
        list.deleteAll();
        this.itemCheckedStatuses.removeAllElements();
        this.itemNames.removeAllElements();
        list.setTitle(fileDescriptor.name);
        if (fileDescriptor.isDirectory) {
            return;
        }
        if ((fileDescriptor.type & 0x100) == 0) {
            return;
        }
        Note note = MyNotes.fs.getNote(fileDescriptor.id);
        this.initialText = note.text;
        if (note.text.length() == 0) {
            return;
        }
        int n = 0;
        int n2 = -1;
        String string = "";
        while ((n = note.text.indexOf(10, n2 + 1)) != -1) {
            string = note.text.substring(n2 + 1, n);
            this.itemCheckedStatuses.addElement(new Boolean(string.substring(0, 1).equals("@")));
            this.itemNames.addElement(string.substring(1, string.length()));
            n2 = n;
        }
        this.updateList();
        list.setSelectedIndex(0);
    }

    public String getString() {
        String string = "";
        for (int i = 0; i < this.itemNames.size(); ++i) {
            boolean bl = (Boolean)this.itemCheckedStatuses.elementAt(i);
            string = string + (bl ? "@" : "#") + (String)this.itemNames.elementAt(i) + "\n";
        }
        return string;
    }

    public void save(FileDescriptor fileDescriptor) {
        if (fileDescriptor.isDirectory) {
            return;
        }
        if ((fileDescriptor.type & 0x100) == 0) {
            return;
        }
        Note note = new Note();
        note.id = fileDescriptor.id;
        note.text = this.getString();
        MyNotes.fs.setNote(note.id, note);
    }

    public void updateList() {
        list.deleteAll();
        for (int i = 0; i < this.itemNames.size(); ++i) {
            if (((Boolean)this.itemCheckedStatuses.elementAt(i)).booleanValue()) {
                list.append((String)this.itemNames.elementAt(i), checkedIcon);
                continue;
            }
            list.append((String)this.itemNames.elementAt(i), uncheckedIcon);
        }
    }

    public void activate() {
        int n = this.textEditor.getStatus();
        if (n == 0) {
            this.cursor = this.savePos;
        }
        if (n == 1) {
            if (this.lastAction == 1) {
                this.itemCheckedStatuses.addElement(new Boolean(false));
                this.itemNames.addElement(this.textEditor.getText());
                list.append(this.textEditor.getText(), uncheckedIcon);
                this.cursor = list.size() - 1;
            }
            if (this.lastAction == 2) {
                this.cursor = this.savePos;
                this.itemNames.setElementAt(this.textEditor.getText(), this.cursor);
                list.set(this.cursor, this.textEditor.getText(), CheckListEditor.list.images[this.cursor]);
            }
        }
        this.lastAction = 0;
        list.setSelectedIndex(this.cursor);
        list.activate();
    }

    public void start(FileDescriptor fileDescriptor, MyDisplayable myDisplayable) {
        this.back = myDisplayable;
        this.savePos = 0;
        this.startFd = fileDescriptor;
        this.load(fileDescriptor);
        this.activate();
    }

    public void commandAction(Command command, Displayable displayable) {
        boolean bl;
        int n = list.getSelectedIndex();
        boolean bl2 = bl = list.size() == 0;
        if (displayable == this.saveModified) {
            if (command == Commands.CANCEL) {
                list.activate();
            }
            if (command == Commands.YES) {
                this.commandAction(Commands.SAVE, null);
            }
            if (command == Commands.NO) {
                this.back.activate();
            }
            return;
        }
        if (command == Commands.BACK) {
            if (this.back == null) {
                return;
            }
            if (!this.getString().equals(this.initialText)) {
                MyNotes.display.setCurrent((Displayable)this.saveModified);
            } else {
                this.back.activate();
            }
            return;
        }
        if (command == Commands.SELECT) {
            if (bl) {
                return;
            }
            boolean bl3 = (Boolean)this.itemCheckedStatuses.elementAt(n);
            this.itemCheckedStatuses.setElementAt(bl3 ? Boolean.FALSE : Boolean.TRUE, n);
            CheckListEditor.list.images[n] = bl3 ? uncheckedIcon : checkedIcon;
            list.repaint();
            return;
        }
        if (command == Commands.NEWITEM) {
            this.savePos = n;
            this.lastAction = 1;
            this.textEditor.start(1, ResourceBundle.getString("ce-itemname"), "", this, null);
            return;
        }
        if (command == Commands.RENAME) {
            this.savePos = n;
            this.lastAction = 2;
            this.textEditor.start(1, ResourceBundle.getString("ce-itemname"), (String)this.itemNames.elementAt(n), this, null);
            return;
        }
        if (command == Commands.MOVEUP) {
            if (n == 0) {
                return;
            }
            Utils.swapVectorElements(this.itemNames, n, n - 1);
            Utils.swapVectorElements(this.itemCheckedStatuses, n, n - 1);
            list.set(n, (String)this.itemNames.elementAt(n), CheckListEditor.list.images[n]);
            list.set(n - 1, (String)this.itemNames.elementAt(n - 1), CheckListEditor.list.images[n - 1]);
            list.setSelectedIndex(n - 1);
            list.repaint();
            return;
        }
        if (command == Commands.MOVEDOWN) {
            if (n == list.size() - 9) {
                return;
            }
            Utils.swapVectorElements(this.itemNames, n, n + 1);
            Utils.swapVectorElements(this.itemCheckedStatuses, n, n + 1);
            list.set(n, (String)this.itemNames.elementAt(n), CheckListEditor.list.images[n]);
            list.set(n + 1, (String)this.itemNames.elementAt(n + 1), CheckListEditor.list.images[n + 1]);
            list.setSelectedIndex(n + 1);
            list.repaint();
            return;
        }
        if (command == Commands.DELETE) {
            if (bl) {
                return;
            }
            this.itemNames.removeElementAt(n);
            this.itemCheckedStatuses.removeElementAt(n);
            this.updateList();
            this.cursor = list.size() != 0 ? (n >= list.size() ? list.size() - 1 : n) : 0;
            list.setSelectedIndex(this.cursor);
            return;
        }
        if (command == Commands.SAVE) {
            this.save(this.startFd);
            this.back.activate();
            return;
        }
    }
}

