/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Gauge;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import mynotes.Commands;
import mynotes.FileDescriptor;
import mynotes.MainMenu;
import mynotes.MyDisplayable;
import mynotes.MyList;
import mynotes.MyNotes;
import mynotes.Note;
import mynotes.NotesFileSystem;
import mynotes.ResourceBundle;
import mynotes.Utils;

public class Import
implements MyDisplayable,
CommandListener {
    private static RecordStore rs;
    private static Alert jsr75NotSupported;
    private static Alert importError;
    private static Alert importComplete;
    private static MyList filesToImportFrom;
    private static Alert waitImport;
    private static Gauge gauge;
    private boolean importFinished;
    private boolean errors;

    public Import() {
        if (System.getProperty("microedition.io.file.FileConnection.version") == null) {
            jsr75NotSupported = new Alert("MyNotes", ResourceBundle.getString("ex-nojsr75"), null, AlertType.WARNING);
            jsr75NotSupported.setTimeout(-2);
            MyNotes.display.setCurrent(jsr75NotSupported, MainMenu.menu.getDisplayable());
            return;
        }
        filesToImportFrom = new MyList(ResourceBundle.getString("im-title"));
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)System.getProperty("fileconn.dir.photos"));
            Enumeration enumeration = fileConnection.list("*.mn1", true);
            while (enumeration.hasMoreElements()) {
                filesToImportFrom.append((String)enumeration.nextElement(), null);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        filesToImportFrom.setSelectedIndex(0);
        filesToImportFrom.addCommand(Commands.BACK, 5);
        filesToImportFrom.addCommand(Commands.OK, 8);
        filesToImportFrom.setCommandListener(this);
    }

    public void activate() {
        filesToImportFrom.activate();
    }

    public void updateGauge() {
        if (gauge == null) {
            return;
        }
        int n = gauge.getValue() + 1;
        if (n < gauge.getMaxValue()) {
            gauge.setValue(gauge.getValue() + 1);
        }
    }

    public void import_(InputStream inputStream) {
        try {
            byte[] byArray;
            FileDescriptor fileDescriptor;
            int n;
            MyNotes.fs.deleteAllData();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n2 = dataInputStream.readInt();
            Vector<FileDescriptor> vector = new Vector<FileDescriptor>();
            vector.setSize(n2);
            for (n = 0; n < n2; ++n) {
                fileDescriptor = new FileDescriptor();
                int n3 = dataInputStream.readInt();
                byArray = new byte[n3];
                dataInputStream.read(byArray, 0, n3);
                fileDescriptor.fromByteArray(byArray);
                vector.setElementAt(fileDescriptor, n);
            }
            for (n = 0; n < n2; ++n) {
                fileDescriptor = (FileDescriptor)vector.elementAt(n);
                if (!fileDescriptor.isDirectory) continue;
                this.updateGauge();
                NotesFileSystem.openDirStorage(fileDescriptor.id);
                NotesFileSystem.closeStorage();
            }
            n = dataInputStream.readInt();
            block14: for (int i = 0; i < n; ++i) {
                this.updateGauge();
                try {
                    int n4 = dataInputStream.readInt();
                    if (n4 == 0) continue;
                    byArray = new byte[n4];
                    dataInputStream.read(byArray, 0, n4);
                    Note note = new Note();
                    note.fromByteArray(byArray);
                    for (int j = 0; j < n2; ++j) {
                        FileDescriptor fileDescriptor2 = (FileDescriptor)vector.elementAt(j);
                        if (fileDescriptor2.id != note.id) continue;
                        try {
                            rs = RecordStore.openRecordStore((String)("dir" + new Integer(fileDescriptor2.parentDirId)), (boolean)true);
                            Utils.encrypt(byArray);
                            fileDescriptor2.dirRecordId = rs.addRecord(byArray, 0, n4);
                            rs.closeRecordStore();
                        }
                        catch (RecordStoreException recordStoreException) {
                            recordStoreException.printStackTrace();
                        }
                        continue block14;
                    }
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            try {
                rs = RecordStore.openRecordStore((String)"fs", (boolean)true);
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
            try {
                for (int i = 0; i < n2; ++i) {
                    FileDescriptor fileDescriptor3 = (FileDescriptor)vector.elementAt(i);
                    byArray = fileDescriptor3.toByteArray();
                    rs.addRecord(byArray, 0, byArray.length);
                }
                rs.closeRecordStore();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            dataInputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            MyNotes.fs.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == filesToImportFrom) {
            if (command == Commands.OK) {
                try {
                    if (filesToImportFrom.size() == 0) {
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    String string = System.getProperty("fileconn.dir.photos") + filesToImportFrom.getString(filesToImportFrom.getSelectedIndex());
                    FileConnection fileConnection = (FileConnection)Connector.open((String)string, (int)1);
                    if (!fileConnection.exists()) {
                        return;
                    }
                    final InputStream inputStream = fileConnection.openInputStream();
                    int n = MyNotes.fs.files.size();
                    gauge = new Gauge(null, false, n, 0);
                    waitImport = new Alert("MyNotes", ResourceBundle.getString("im-wait"), null, AlertType.INFO);
                    waitImport.addCommand(Commands.DUMMY);
                    waitImport.setTimeout(-2);
                    waitImport.setIndicator(gauge);
                    waitImport.setCommandListener((CommandListener)this);
                    MyNotes.display.setCurrent((Displayable)waitImport);
                    new Thread(new Runnable(){

                        public void run() {
                            try {
                                Import.this.importFinished = false;
                                Import.this.import_(inputStream);
                                Import.this.importFinished = true;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }).start();
                }
                catch (Exception exception) {
                    this.errors = true;
                    exception.printStackTrace();
                }
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            while (!Import.this.importFinished) {
                                Thread.sleep(100L);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (Import.this.errors) {
                            importError = new Alert("MyNotes", ResourceBundle.getString("im-errors"), null, AlertType.ERROR);
                            importError.setTimeout(2000);
                            MyNotes.display.setCurrent(importError, MainMenu.menu.getDisplayable());
                        } else {
                            importComplete = new Alert("MyNotes", ResourceBundle.getString("im-ok"), null, AlertType.INFO);
                            importComplete.setTimeout(2000);
                            MyNotes.display.setCurrent(importComplete, MainMenu.menu.getDisplayable());
                        }
                    }
                }).start();
            }
            if (command == Commands.BACK) {
                MyNotes.menu.activate();
            }
        }
    }
}

