/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import mynotes.FileDescriptor;
import mynotes.MyNotes;
import mynotes.Note;
import mynotes.QuickSort;
import mynotes.ResourceBundle;
import mynotes.Utils;

public class NotesFileSystem {
    static final int NOTHING = -1;
    static final int ROOT_DIR = 0;
    static final String RS_FDNAME = "fs";
    static final String RS_DIRNAME = "dir";
    static final int NOT_FOUND = -1;
    private int lastId;
    public Vector files;
    private static RecordStore rs;
    private Vector toDelete;

    public FileDescriptor getDescriptorById(int n) {
        FileDescriptor fileDescriptor = null;
        boolean bl = false;
        for (int i = 0; i < this.files.size(); ++i) {
            fileDescriptor = (FileDescriptor)this.files.elementAt(i);
            if (n != fileDescriptor.id) continue;
            bl = true;
            break;
        }
        return bl ? fileDescriptor : null;
    }

    private int getFilesIndexById(int n) {
        int n2 = -1;
        FileDescriptor fileDescriptor = null;
        for (int i = 0; i < this.files.size(); ++i) {
            fileDescriptor = (FileDescriptor)this.files.elementAt(i);
            if (fileDescriptor == null || n != fileDescriptor.id) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public static boolean openFDStorage() {
        try {
            rs = RecordStore.openRecordStore((String)RS_FDNAME, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean openDirStorage(int n) {
        try {
            rs = RecordStore.openRecordStore((String)(RS_DIRNAME + n), (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean closeStorage() {
        if (rs != null) {
            try {
                rs.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                return false;
            }
        }
        return true;
    }

    public int init() {
        rs = null;
        this.toDelete = new Vector();
        this.files = new Vector();
        try {
            NotesFileSystem.openFDStorage();
            if (rs.getNumRecords() == 0) {
                this.lastId = this.makeDir(".", -1);
            } else {
                FileDescriptor fileDescriptor = new FileDescriptor();
                RecordEnumeration recordEnumeration = rs.enumerateRecords(null, null, false);
                this.lastId = 0;
                while (recordEnumeration.hasNextElement()) {
                    int n = recordEnumeration.nextRecordId();
                    byte[] byArray = rs.getRecord(n);
                    fileDescriptor.fromByteArray(byArray);
                    fileDescriptor.recordId = n;
                    if (fileDescriptor.id > this.lastId) {
                        this.lastId = fileDescriptor.id;
                    }
                    this.files.addElement(fileDescriptor.clone());
                }
            }
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        NotesFileSystem.closeStorage();
        return this.files.size();
    }

    public int makeDir(String string, int n) {
        try {
            FileDescriptor fileDescriptor = new FileDescriptor();
            fileDescriptor.isDirectory = true;
            fileDescriptor.type = 17;
            fileDescriptor.name = string;
            fileDescriptor.size = 0;
            fileDescriptor.date = System.currentTimeMillis();
            if (n == -1) {
                fileDescriptor.id = 0;
                fileDescriptor.parentDirId = n;
                if (this.files != null) {
                    this.files.removeAllElements();
                }
            } else {
                fileDescriptor.id = this.nextId();
                fileDescriptor.parentDirId = n;
            }
            byte[] byArray = fileDescriptor.toByteArray();
            NotesFileSystem.openFDStorage();
            fileDescriptor.recordId = rs.addRecord(byArray, 0, byArray.length);
            NotesFileSystem.closeStorage();
            if (this.files == null) {
                this.files = new Vector();
            }
            this.files.addElement(fileDescriptor);
            NotesFileSystem.openDirStorage(fileDescriptor.id);
            NotesFileSystem.closeStorage();
            return fileDescriptor.id;
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
            return -1;
        }
    }

    public boolean rename(int n, String string) {
        int n2 = this.getFilesIndexById(n);
        if (n2 == -1) {
            return false;
        }
        FileDescriptor fileDescriptor = (FileDescriptor)this.files.elementAt(n2);
        try {
            fileDescriptor.name = string;
            this.files.setElementAt(fileDescriptor, n2);
            byte[] byArray = fileDescriptor.toByteArray();
            NotesFileSystem.openFDStorage();
            rs.setRecord(fileDescriptor.recordId, byArray, 0, byArray.length);
            NotesFileSystem.closeStorage();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        return true;
    }

    public boolean delete(int n) {
        int n2;
        this.toDelete.removeAllElements();
        this.delete0(n);
        for (int i = 0; i < this.toDelete.size(); ++i) {
            n2 = (Integer)this.toDelete.elementAt(i);
            int n3 = this.getFilesIndexById(n2);
            this.files.setElementAt(null, n3);
        }
        Vector<FileDescriptor> vector = new Vector<FileDescriptor>();
        for (n2 = 0; n2 < this.files.size(); ++n2) {
            Object e = this.files.elementAt(n2);
            if (e == null) continue;
            vector.addElement(((FileDescriptor)this.files.elementAt(n2)).clone());
        }
        this.files.removeAllElements();
        this.files = vector;
        return true;
    }

    private boolean deleteNote(FileDescriptor fileDescriptor) {
        try {
            NotesFileSystem.openDirStorage(fileDescriptor.parentDirId);
            if (fileDescriptor.dirRecordId != -1) {
                rs.deleteRecord(fileDescriptor.dirRecordId);
            }
            NotesFileSystem.closeStorage();
            NotesFileSystem.openFDStorage();
            rs.deleteRecord(fileDescriptor.recordId);
            NotesFileSystem.closeStorage();
            this.toDelete.addElement(new Integer(fileDescriptor.id));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    private boolean deleteEmptyDir(int n, int n2) {
        try {
            NotesFileSystem.openFDStorage();
            rs.deleteRecord(n2);
            NotesFileSystem.closeStorage();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        try {
            RecordStore.deleteRecordStore((String)(RS_DIRNAME + new Integer(n).toString()));
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        this.toDelete.addElement(new Integer(n));
        return true;
    }

    private boolean delete0(int n) {
        if (n == 0) {
            return false;
        }
        FileDescriptor fileDescriptor = this.getDescriptorById(n);
        if (fileDescriptor == null) {
            return false;
        }
        if (!fileDescriptor.isDirectory) {
            this.deleteNote(fileDescriptor);
        } else {
            FileDescriptor fileDescriptor2;
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < this.files.size(); ++n2) {
                fileDescriptor2 = (FileDescriptor)this.files.elementAt(n2);
                if (fileDescriptor2.parentDirId != n) continue;
                ++n3;
            }
            if (n3 == 0) {
                this.deleteEmptyDir(n, fileDescriptor.recordId);
                return true;
            }
            for (n2 = 0; n2 < this.files.size(); ++n2) {
                fileDescriptor2 = (FileDescriptor)this.files.elementAt(n2);
                if (fileDescriptor2.parentDirId != n) continue;
                this.delete0(fileDescriptor2.id);
            }
            this.deleteEmptyDir(n, fileDescriptor.recordId);
        }
        return true;
    }

    public int makeNote(String string, int n, int n2) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        fileDescriptor.name = string;
        fileDescriptor.date = System.currentTimeMillis();
        fileDescriptor.id = this.nextId();
        fileDescriptor.size = 0;
        fileDescriptor.type = n2;
        fileDescriptor.isDirectory = false;
        fileDescriptor.dirRecordId = -1;
        fileDescriptor.parentDirId = n;
        try {
            byte[] byArray = fileDescriptor.toByteArray();
            if (!NotesFileSystem.openFDStorage()) {
                return -1;
            }
            fileDescriptor.recordId = rs.addRecord(byArray, 0, byArray.length);
            NotesFileSystem.closeStorage();
            this.files.addElement(fileDescriptor);
        }
        catch (RecordStoreException recordStoreException) {
            fileDescriptor.recordId = -1;
        }
        return fileDescriptor.id;
    }

    public synchronized int setNote(int n, Note note) {
        int n2 = this.getFilesIndexById(n);
        if (n2 == -1) {
            return -1;
        }
        FileDescriptor fileDescriptor = (FileDescriptor)this.files.elementAt(n2);
        if (fileDescriptor.isDirectory) {
            return -1;
        }
        try {
            NotesFileSystem.openDirStorage(fileDescriptor.parentDirId);
            byte[] byArray = note.toByteArray();
            if (fileDescriptor.dirRecordId == -1) {
                fileDescriptor.dirRecordId = rs.getNextRecordID();
                fileDescriptor.dirRecordId = rs.addRecord(byArray, 0, byArray.length);
                this.files.setElementAt(fileDescriptor, n2);
            } else {
                rs.setRecord(fileDescriptor.dirRecordId, byArray, 0, byArray.length);
            }
            NotesFileSystem.closeStorage();
            NotesFileSystem.openFDStorage();
            fileDescriptor.size = byArray.length;
            byArray = fileDescriptor.toByteArray();
            rs.setRecord(fileDescriptor.recordId, byArray, 0, byArray.length);
            NotesFileSystem.closeStorage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
        return fileDescriptor.dirRecordId;
    }

    public synchronized Note getNote(int n) {
        FileDescriptor fileDescriptor = this.getDescriptorById(n);
        Note note = null;
        if (fileDescriptor == null) {
            return null;
        }
        if (fileDescriptor.dirRecordId == -1) {
            note = new Note();
            note.id = n;
            note.text = "";
            return note;
        }
        try {
            if (!NotesFileSystem.openDirStorage(fileDescriptor.parentDirId)) {
                return null;
            }
            byte[] byArray = rs.getRecord(fileDescriptor.dirRecordId);
            NotesFileSystem.closeStorage();
            if (byArray == null) {
                return null;
            }
            note = new Note();
            note.fromByteArray(byArray);
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        return note;
    }

    public Vector getDirectoryListing(int n, int n2) {
        int n3;
        FileDescriptor fileDescriptor;
        Vector<FileDescriptor> vector = new Vector<FileDescriptor>();
        Vector<FileDescriptor> vector2 = new Vector<FileDescriptor>();
        for (int i = 0; i < this.files.size(); ++i) {
            fileDescriptor = (FileDescriptor)this.files.elementAt(i);
            if (fileDescriptor.parentDirId != n) continue;
            if (fileDescriptor.isDirectory) {
                vector2.addElement(fileDescriptor);
                continue;
            }
            vector.addElement(fileDescriptor);
        }
        QuickSort.quicksort(vector);
        QuickSort.quicksort(vector2);
        Vector<FileDescriptor> vector3 = new Vector<FileDescriptor>();
        if (n != 0) {
            fileDescriptor = this.getDescriptorById(n).clone();
            fileDescriptor.name = "..";
            vector3.addElement(fileDescriptor);
        }
        for (n3 = 0; n3 < vector2.size(); ++n3) {
            vector3.addElement((FileDescriptor)vector2.elementAt(n3));
        }
        for (n3 = 0; n3 < vector.size(); ++n3) {
            vector3.addElement((FileDescriptor)vector.elementAt(n3));
        }
        return vector3;
    }

    public Vector getListingByName(String string, boolean bl) {
        Vector<FileDescriptor> vector = new Vector<FileDescriptor>();
        for (int i = 0; i < this.files.size(); ++i) {
            FileDescriptor fileDescriptor = (FileDescriptor)this.files.elementAt(i);
            MyNotes.find.updateGauge();
            if (fileDescriptor.isDirectory) continue;
            boolean bl2 = false;
            String string2 = string;
            String string3 = fileDescriptor.name;
            if (!bl) {
                string2.toUpperCase();
                string3.toUpperCase();
            }
            if (string3.indexOf(string2) != -1) {
                bl2 = true;
            }
            if (!bl2) continue;
            vector.addElement(fileDescriptor);
        }
        QuickSort.quicksort(vector);
        return vector;
    }

    public Vector getListingByContent(String string, boolean bl) {
        Vector<FileDescriptor> vector = new Vector<FileDescriptor>();
        String string2 = string;
        if (!bl) {
            string2 = string2.toUpperCase();
        }
        for (int i = 0; i < this.files.size(); ++i) {
            FileDescriptor fileDescriptor = (FileDescriptor)this.files.elementAt(i);
            MyNotes.find.updateGauge();
            if (fileDescriptor.isDirectory) continue;
            boolean bl2 = false;
            Note note = MyNotes.fs.getNote(fileDescriptor.id);
            String string3 = "";
            if (note != null) {
                string3 = note.text;
            }
            if (!bl) {
                string3 = string3.toUpperCase();
            }
            if (string3.indexOf(string2) != -1) {
                bl2 = true;
            }
            if (!bl2) continue;
            vector.addElement(fileDescriptor);
        }
        QuickSort.quicksort(vector);
        return vector;
    }

    private int nextId() {
        return ++this.lastId;
    }

    public int getLastId() {
        return this.lastId;
    }

    public int makeCopy(int n, int n2, boolean bl) {
        int n3 = -1;
        FileDescriptor fileDescriptor = this.getDescriptorById(n);
        if (fileDescriptor == null) {
            return n3;
        }
        if (fileDescriptor.isDirectory) {
            n3 = bl ? this.moveDir(fileDescriptor, n2) : this.makeCopyOfDir(fileDescriptor, n2);
        } else {
            n3 = this.makeCopyOfNote(fileDescriptor, n2);
            if (bl) {
                this.delete(fileDescriptor.id);
            }
        }
        return n3;
    }

    private int makeCopyOfNote(FileDescriptor fileDescriptor, int n) {
        if (fileDescriptor.isDirectory) {
            return -1;
        }
        String string = n == fileDescriptor.parentDirId ? ResourceBundle.getString("nb-copyof") : "";
        string = string + fileDescriptor.name;
        int n2 = this.makeNote(string, n, fileDescriptor.type);
        Note note = this.getNote(fileDescriptor.id);
        note.id = n2;
        this.setNote(n2, note);
        return n2;
    }

    private int makeCopyOfDir(FileDescriptor fileDescriptor, int n) {
        Object object;
        if (!fileDescriptor.isDirectory) {
            return -1;
        }
        int n2 = n;
        while (n2 != 0) {
            if (fileDescriptor.id == n2) {
                return -1;
            }
            object = this.getDescriptorById(n2);
            n2 = ((FileDescriptor)object).parentDirId;
        }
        object = n == fileDescriptor.parentDirId ? ResourceBundle.getString("nb-copyof") : "";
        object = (String)object + fileDescriptor.name;
        int n3 = this.makeDir((String)object, n);
        Vector vector = this.getDirectoryListing(fileDescriptor.id, 0);
        for (int i = 0; i < vector.size(); ++i) {
            FileDescriptor fileDescriptor2 = (FileDescriptor)vector.elementAt(i);
            if (fileDescriptor2.name.equals("..")) continue;
            this.makeCopy(fileDescriptor2.id, n3, false);
        }
        return n3;
    }

    private int moveDir(FileDescriptor fileDescriptor, int n) {
        if (!fileDescriptor.isDirectory) {
            return -1;
        }
        int n2 = n;
        while (n2 != 0) {
            if (fileDescriptor.id == n2) {
                return -1;
            }
            FileDescriptor fileDescriptor2 = this.getDescriptorById(n2);
            n2 = fileDescriptor2.parentDirId;
        }
        fileDescriptor.parentDirId = n;
        this.files.setElementAt(fileDescriptor, this.getFilesIndexById(fileDescriptor.id));
        this.rename(fileDescriptor.id, fileDescriptor.name);
        return 0;
    }

    public int getAllDataSize() {
        Object object;
        FileDescriptor fileDescriptor;
        int n;
        int n2 = 0;
        n2 += 4;
        int n3 = 0;
        for (n = 0; n < this.files.size(); ++n) {
            fileDescriptor = (FileDescriptor)this.files.elementAt(n);
            object = fileDescriptor.toByteArray();
            n2 += 4 + ((byte[])object).length;
            if (fileDescriptor.isDirectory) continue;
            ++n3;
        }
        n2 += 4;
        for (n = 0; n < this.files.size(); ++n) {
            fileDescriptor = (FileDescriptor)this.files.elementAt(n);
            if (fileDescriptor.isDirectory || (object = (Object)MyNotes.fs.getNote(fileDescriptor.id)) == null) continue;
            byte[] byArray = ((Note)object).toByteArray();
            n2 += 4 + byArray.length;
        }
        return n2;
    }

    public static void encodeEverythigOnce() {
        Object object;
        int n;
        Object object2;
        Vector<FileDescriptor> vector = new Vector<FileDescriptor>();
        try {
            if (MyNotes.properties.getStringValue("encrypted") != null) {
                return;
            }
            NotesFileSystem.openFDStorage();
            object2 = rs.enumerateRecords(null, null, false);
            while (object2.hasNextElement()) {
                n = object2.nextRecordId();
                object = rs.getRecord(n);
                Utils.encrypt((byte[])object);
                FileDescriptor fileDescriptor = new FileDescriptor();
                fileDescriptor.fromByteArray((byte[])object);
                fileDescriptor.recordId = n;
                vector.addElement(fileDescriptor.clone());
            }
            NotesFileSystem.closeStorage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (n = 0; n < vector.size(); ++n) {
            object = (FileDescriptor)vector.elementAt(n);
            try {
                if (!((FileDescriptor)object).isDirectory && ((FileDescriptor)object).dirRecordId != -1) {
                    NotesFileSystem.openDirStorage(((FileDescriptor)object).parentDirId);
                    object2 = rs.getRecord(((FileDescriptor)object).dirRecordId);
                    Utils.encrypt((byte[])object2);
                    rs.setRecord(((FileDescriptor)object).dirRecordId, (byte[])object2, 0, ((RecordEnumeration)object2).length);
                    NotesFileSystem.closeStorage();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                NotesFileSystem.closeStorage();
            }
            try {
                NotesFileSystem.openFDStorage();
                ((FileDescriptor)object).type |= 0x10;
                object2 = ((FileDescriptor)object).toByteArray();
                rs.setRecord(((FileDescriptor)object).recordId, (byte[])object2, 0, ((RecordEnumeration)object2).length);
                NotesFileSystem.closeStorage();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        MyNotes.properties.addPair("encrypted", "y", 9);
    }

    public void deleteAllData() {
        String[] stringArray = RecordStore.listRecordStores();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("settings")) continue;
            try {
                RecordStore.deleteRecordStore((String)stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.files.removeAllElements();
    }
}

