/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Random;
import java.util.Vector;
import mynotes.FileDescriptor;

public class QuickSort {
    private static long comparisons = 0L;
    private static long exchanges = 0L;

    public static void quicksort(Vector vector) {
        QuickSort.shuffle(vector);
        QuickSort.quicksort(vector, 0, vector.size() - 1);
    }

    public static void quicksort(Vector vector, int n, int n2) {
        if (n2 <= n) {
            return;
        }
        int n3 = QuickSort.partition(vector, n, n2);
        QuickSort.quicksort(vector, n, n3 - 1);
        QuickSort.quicksort(vector, n3 + 1, n2);
    }

    private static int partition(Vector vector, int n, int n2) {
        int n3 = n - 1;
        int n4 = n2;
        while (true) {
            if (QuickSort.less(vector.elementAt(++n3), vector.elementAt(n2))) {
                continue;
            }
            while (QuickSort.less(vector.elementAt(n2), vector.elementAt(--n4)) && n4 != n) {
            }
            if (n3 >= n4) break;
            QuickSort.exch(vector, n3, n4);
        }
        QuickSort.exch(vector, n3, n2);
        return n3;
    }

    private static boolean less(Object object, Object object2) {
        ++comparisons;
        return ((FileDescriptor)object).compareTo(object2) < 0;
    }

    private static void exch(Vector vector, int n, int n2) {
        ++exchanges;
        Object e = vector.elementAt(n);
        vector.setElementAt(vector.elementAt(n2), n);
        vector.setElementAt(e, n2);
    }

    private static void shuffle(Vector vector) {
        Random random = new Random();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            int n2 = i + Math.abs(random.nextInt()) % (n - i);
            QuickSort.exch(vector, i, n2);
        }
    }
}

